/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.opennlp;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.lucene.analysis.TokenFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.opennlp.OpenNLPTokenizer;
import org.apache.lucene.analysis.opennlp.tools.NLPLemmatizerOp;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.analysis.tokenattributes.FlagsAttribute;
import org.apache.lucene.analysis.tokenattributes.KeywordAttribute;
import org.apache.lucene.analysis.tokenattributes.TypeAttribute;
import org.apache.lucene.util.AttributeSource;

public class OpenNLPLemmatizerFilter
extends TokenFilter {
    private final NLPLemmatizerOp lemmatizerOp;
    private final CharTermAttribute termAtt = (CharTermAttribute)this.addAttribute(CharTermAttribute.class);
    private final TypeAttribute typeAtt = (TypeAttribute)this.addAttribute(TypeAttribute.class);
    private final KeywordAttribute keywordAtt = (KeywordAttribute)this.addAttribute(KeywordAttribute.class);
    private final FlagsAttribute flagsAtt = (FlagsAttribute)this.addAttribute(FlagsAttribute.class);
    private List<AttributeSource> sentenceTokenAttrs = new ArrayList<AttributeSource>();
    private Iterator<AttributeSource> sentenceTokenAttrsIter = null;
    private boolean moreTokensAvailable = true;
    private String[] sentenceTokens = null;
    private String[] sentenceTokenTypes = null;
    private String[] lemmas = null;
    private int lemmaNum = 0;

    public OpenNLPLemmatizerFilter(TokenStream input, NLPLemmatizerOp lemmatizerOp) {
        super(input);
        this.lemmatizerOp = lemmatizerOp;
    }

    public final boolean incrementToken() throws IOException {
        if (!this.moreTokensAvailable) {
            this.clear();
            return false;
        }
        if (this.sentenceTokenAttrsIter == null || !this.sentenceTokenAttrsIter.hasNext()) {
            this.nextSentence();
            if (this.sentenceTokens == null) {
                this.clear();
                return false;
            }
            this.lemmas = this.lemmatizerOp.lemmatize(this.sentenceTokens, this.sentenceTokenTypes);
            this.lemmaNum = 0;
            this.sentenceTokenAttrsIter = this.sentenceTokenAttrs.iterator();
        }
        this.clearAttributes();
        this.sentenceTokenAttrsIter.next().copyTo((AttributeSource)this);
        if (!this.keywordAtt.isKeyword()) {
            this.termAtt.setEmpty().append(this.lemmas[this.lemmaNum++]);
        }
        return true;
    }

    private void nextSentence() throws IOException {
        ArrayList<String> tokenList = new ArrayList<String>();
        ArrayList<String> typeList = new ArrayList<String>();
        this.sentenceTokenAttrs.clear();
        boolean endOfSentence = false;
        while (!endOfSentence && (this.moreTokensAvailable = this.input.incrementToken())) {
            if (!this.keywordAtt.isKeyword()) {
                tokenList.add(this.termAtt.toString());
                typeList.add(this.typeAtt.type());
            }
            endOfSentence = 0 != (this.flagsAtt.getFlags() & OpenNLPTokenizer.EOS_FLAG_BIT);
            this.sentenceTokenAttrs.add(this.input.cloneAttributes());
        }
        this.sentenceTokens = tokenList.size() > 0 ? tokenList.toArray(new String[tokenList.size()]) : null;
        this.sentenceTokenTypes = typeList.size() > 0 ? typeList.toArray(new String[typeList.size()]) : null;
    }

    public void reset() throws IOException {
        super.reset();
        this.moreTokensAvailable = true;
        this.clear();
    }

    private void clear() {
        this.sentenceTokenAttrs.clear();
        this.sentenceTokenAttrsIter = null;
        this.sentenceTokens = null;
        this.sentenceTokenTypes = null;
        this.lemmas = null;
        this.lemmaNum = 0;
    }
}

