/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.start;

import java.io.IOException;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.regex.Matcher;
import org.eclipse.jetty.start.BaseHome;
import org.eclipse.jetty.start.Module;
import org.eclipse.jetty.start.Props;
import org.eclipse.jetty.start.StartLog;
import org.eclipse.jetty.start.TextFile;

public class StartIni
extends TextFile {
    private Path basedir;

    public StartIni(Path file) throws IOException {
        super(file);
    }

    @Override
    public void addUniqueLine(String line) {
        if (line.startsWith("--module=")) {
            int idx = line.indexOf(61);
            String value = line.substring(idx + 1);
            for (String part : value.split(",")) {
                super.addUniqueLine("--module=" + this.expandBaseDir(part));
            }
        } else {
            super.addUniqueLine(this.expandBaseDir(line));
        }
    }

    private String expandBaseDir(String line) {
        if (line == null) {
            return line;
        }
        return line.replace("${start.basedir}", this.basedir.toString());
    }

    @Override
    public void init() {
        try {
            this.basedir = this.getFile().getParent().toRealPath(new LinkOption[0]);
        }
        catch (IOException e) {
            this.basedir = this.getFile().getParent().normalize().toAbsolutePath();
        }
    }

    public Path getBaseDir() {
        return this.basedir;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void update(BaseHome baseHome, Props props) throws IOException {
        String update = this.getFile().getFileName().toString();
        update = update.substring(0, update.lastIndexOf("."));
        String source = baseHome.toShortForm(this.getFile());
        PrintWriter writer = null;
        try {
            for (String line : this.getAllLines()) {
                Matcher m = Module.SET_PROPERTY.matcher(line);
                if (m.matches() && m.groupCount() == 3) {
                    String name = m.group(2);
                    String value = m.group(3);
                    Props.Prop p = props.getProp(name);
                    if (!(p == null || p.source != null && p.source.endsWith("?=") || !"#".equals(m.group(1)) && value.equals(p.value))) {
                        if (writer == null) {
                            writer = new PrintWriter(Files.newBufferedWriter(this.getFile(), StandardCharsets.UTF_8, StandardOpenOption.TRUNCATE_EXISTING, StandardOpenOption.CREATE));
                            for (String l : this.getAllLines()) {
                                if (line.equals(l)) break;
                                writer.println(l);
                            }
                        }
                        StartLog.info("%-15s property updated %s=%s", update, name, p.value);
                        writer.printf("%s=%s%n", name, p.value);
                        continue;
                    }
                    if (writer == null) continue;
                    writer.println(line);
                    continue;
                }
                if (writer == null) continue;
                writer.println(line);
            }
            if (writer == null) return;
        }
        catch (Throwable throwable) {
            if (writer == null) throw throwable;
            StartLog.info("%-15s updated %s", update, source);
            writer.close();
            throw throwable;
        }
        StartLog.info("%-15s updated %s", update, source);
        writer.close();
    }
}

