/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.sql;

import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Aggregate;
import org.apache.calcite.rel.core.AggregateCall;
import org.apache.calcite.sql.SqlAggFunction;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.util.ImmutableBitSet;
import org.apache.calcite.util.Pair;
import org.apache.solr.handler.sql.SolrRel;
import org.apache.solr.handler.sql.SolrRules;

class SolrAggregate
extends Aggregate
implements SolrRel {
    private static final List<SqlAggFunction> SUPPORTED_AGGREGATIONS = Arrays.asList(SqlStdOperatorTable.COUNT, SqlStdOperatorTable.SUM, SqlStdOperatorTable.SUM0, SqlStdOperatorTable.MIN, SqlStdOperatorTable.MAX, SqlStdOperatorTable.AVG);

    SolrAggregate(RelOptCluster cluster, RelTraitSet traitSet, RelNode child, boolean indicator, ImmutableBitSet groupSet, List<ImmutableBitSet> groupSets, List<AggregateCall> aggCalls) {
        super(cluster, traitSet, child, indicator, groupSet, groupSets, aggCalls);
        assert (this.getConvention() == SolrRel.CONVENTION);
        assert (this.getConvention() == child.getConvention());
    }

    public Aggregate copy(RelTraitSet traitSet, RelNode input, boolean indicator, ImmutableBitSet groupSet, List<ImmutableBitSet> groupSets, List<AggregateCall> aggCalls) {
        return new SolrAggregate(this.getCluster(), traitSet, input, indicator, groupSet, groupSets, aggCalls);
    }

    @Override
    public void implement(SolrRel.Implementor implementor) {
        implementor.visitChild(0, this.getInput());
        List<String> inNames = SolrRules.solrFieldNames(this.getInput().getRowType());
        for (Pair namedAggCall : this.getNamedAggCalls()) {
            AggregateCall aggCall = (AggregateCall)namedAggCall.getKey();
            Pair<String, String> metric = this.toSolrMetric(implementor, aggCall, inNames);
            implementor.addReverseAggMapping((String)namedAggCall.getValue(), ((String)metric.getKey()).toLowerCase(Locale.ROOT) + "(" + (String)metric.getValue() + ")");
            implementor.addMetricPair((String)namedAggCall.getValue(), (String)metric.getKey(), (String)metric.getValue());
        }
        Iterator iterator = this.getGroupSet().iterator();
        while (iterator.hasNext()) {
            int group = (Integer)iterator.next();
            String inName = inNames.get(group);
            implementor.addBucket(inName);
        }
    }

    private Pair<String, String> toSolrMetric(SolrRel.Implementor implementor, AggregateCall aggCall, List<String> inNames) {
        SqlAggFunction aggregation = aggCall.getAggregation();
        List args = aggCall.getArgList();
        switch (args.size()) {
            case 0: {
                if (aggregation.equals((Object)SqlStdOperatorTable.COUNT)) {
                    return new Pair((Object)aggregation.getName(), (Object)"*");
                }
            }
            case 1: {
                String inName = inNames.get((Integer)args.get(0));
                String name = implementor.fieldMappings.getOrDefault(inName, inName);
                if (!SUPPORTED_AGGREGATIONS.contains(aggregation)) break;
                return new Pair((Object)aggregation.getName(), (Object)name);
            }
        }
        throw new AssertionError((Object)("Invalid aggregation " + aggregation + " with args " + args + " with names" + inNames));
    }
}

