/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search;

import java.lang.invoke.MethodHandles;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.LongAdder;
import java.util.function.Function;
import org.apache.lucene.util.Accountable;
import org.apache.lucene.util.Accountables;
import org.apache.lucene.util.RamUsageEstimator;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.util.TimeSource;
import org.apache.solr.metrics.MetricsMap;
import org.apache.solr.metrics.SolrMetricsContext;
import org.apache.solr.search.CacheRegenerator;
import org.apache.solr.search.SolrCache;
import org.apache.solr.search.SolrCacheBase;
import org.apache.solr.search.SolrIndexSearcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LRUCache<K, V>
extends SolrCacheBase
implements SolrCache<K, V>,
Accountable {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    static final long BASE_RAM_BYTES_USED = RamUsageEstimator.shallowSizeOfInstance(LRUCache.class);
    private CumulativeStats stats;
    private long lookups;
    private long hits;
    private long inserts;
    private long evictions;
    private long evictionsRamUsage;
    private long evictionsIdleTime;
    private long warmupTime = 0L;
    private Map<K, CacheValue<V>> map;
    private String description = "LRU Cache";
    private MetricsMap cacheMap;
    private Set<String> metricNames = ConcurrentHashMap.newKeySet();
    private SolrMetricsContext solrMetricsContext;
    private int maxSize;
    private int initialSize;
    private long maxRamBytes = Long.MAX_VALUE;
    private long maxIdleTimeNs;
    private final TimeSource timeSource = TimeSource.NANO_TIME;
    private long oldestEntry = 0L;
    private boolean syntheticEntries = false;
    private long ramBytesUsed = 0L;

    @Override
    public Object init(Map args, Object persistence, CacheRegenerator regenerator) {
        int maxIdleTime;
        super.init(args, regenerator);
        String str = (String)args.get("size");
        this.maxSize = str == null ? 1024 : Integer.parseInt(str);
        str = (String)args.get("initialSize");
        this.initialSize = Math.min(str == null ? 1024 : Integer.parseInt(str), this.maxSize);
        str = (String)args.get("maxRamMB");
        this.maxRamBytes = str == null ? Long.MAX_VALUE : (long)(Double.parseDouble(str) * 1024.0 * 1024.0);
        str = (String)args.get("maxIdleTime");
        this.maxIdleTimeNs = str == null ? Long.MAX_VALUE : ((maxIdleTime = Integer.parseInt(str)) > 0 ? TimeUnit.NANOSECONDS.convert(Integer.parseInt(str), TimeUnit.SECONDS) : Long.MAX_VALUE);
        this.description = this.generateDescription();
        this.map = new LinkedHashMap<K, CacheValue<V>>(this.initialSize, 0.75f, true){

            @Override
            protected boolean removeEldestEntry(Map.Entry eldest) {
                long bytesToDecrement;
                if (LRUCache.this.maxIdleTimeNs != Long.MAX_VALUE) {
                    long idleCutoff = LRUCache.this.timeSource.getEpochTimeNs() - LRUCache.this.maxIdleTimeNs;
                    if (LRUCache.this.oldestEntry < idleCutoff) {
                        long currentOldestEntry = Long.MAX_VALUE;
                        Iterator iterator = this.entrySet().iterator();
                        while (iterator.hasNext()) {
                            Map.Entry entry = iterator.next();
                            if (((CacheValue)entry.getValue()).createTime < idleCutoff) {
                                long bytesToDecrement2 = RamUsageEstimator.sizeOfObject(entry.getKey(), (long)1024L);
                                bytesToDecrement2 += RamUsageEstimator.sizeOfObject(entry.getValue(), (long)1024L);
                                LRUCache.this.ramBytesUsed = LRUCache.this.ramBytesUsed - (bytesToDecrement2 += RamUsageEstimator.LINKED_HASHTABLE_RAM_BYTES_PER_ENTRY);
                                iterator.remove();
                                LRUCache.this.evictions++;
                                LRUCache.this.evictionsIdleTime++;
                                ((LRUCache)LRUCache.this).stats.evictionsIdleTime.increment();
                                ((LRUCache)LRUCache.this).stats.evictions.increment();
                                continue;
                            }
                            if (LRUCache.this.syntheticEntries) {
                                if (currentOldestEntry <= ((CacheValue)entry.getValue()).createTime) continue;
                                currentOldestEntry = ((CacheValue)entry.getValue()).createTime;
                                continue;
                            }
                            currentOldestEntry = ((CacheValue)entry.getValue()).createTime;
                            break;
                        }
                        if (currentOldestEntry != Long.MAX_VALUE) {
                            LRUCache.this.oldestEntry = currentOldestEntry;
                        }
                    }
                }
                if (LRUCache.this.ramBytesUsed > LRUCache.this.getMaxRamBytes()) {
                    Iterator iterator = this.entrySet().iterator();
                    do {
                        Map.Entry entry = iterator.next();
                        bytesToDecrement = RamUsageEstimator.sizeOfObject(entry.getKey(), (long)1024L);
                        bytesToDecrement += RamUsageEstimator.sizeOfObject(entry.getValue(), (long)1024L);
                        LRUCache.this.ramBytesUsed = LRUCache.this.ramBytesUsed - (bytesToDecrement += RamUsageEstimator.LINKED_HASHTABLE_RAM_BYTES_PER_ENTRY);
                        iterator.remove();
                        LRUCache.this.evictions++;
                        LRUCache.this.evictionsRamUsage++;
                        ((LRUCache)LRUCache.this).stats.evictions.increment();
                        ((LRUCache)LRUCache.this).stats.evictionsRamUsage.increment();
                    } while (iterator.hasNext() && LRUCache.this.ramBytesUsed > LRUCache.this.getMaxRamBytes());
                } else if (this.size() > LRUCache.this.getMaxSize()) {
                    Iterator iterator = this.entrySet().iterator();
                    do {
                        Map.Entry entry = iterator.next();
                        bytesToDecrement = RamUsageEstimator.sizeOfObject(entry.getKey(), (long)1024L);
                        bytesToDecrement += RamUsageEstimator.sizeOfObject(entry.getValue(), (long)1024L);
                        LRUCache.this.ramBytesUsed = LRUCache.this.ramBytesUsed - (bytesToDecrement += RamUsageEstimator.LINKED_HASHTABLE_RAM_BYTES_PER_ENTRY);
                        iterator.remove();
                        LRUCache.this.evictions++;
                        ((LRUCache)LRUCache.this).stats.evictions.increment();
                    } while (iterator.hasNext() && this.size() > LRUCache.this.getMaxSize());
                }
                return false;
            }
        };
        if (persistence == null) {
            persistence = new CumulativeStats();
        }
        this.stats = (CumulativeStats)persistence;
        return persistence;
    }

    public void setSyntheticEntries(boolean syntheticEntries) {
        this.syntheticEntries = syntheticEntries;
    }

    public long getMaxRamBytes() {
        return this.maxRamBytes;
    }

    private String generateDescription() {
        String description = "LRU Cache(maxSize=" + this.getMaxSize() + ", initialSize=" + this.initialSize;
        if (this.isAutowarmingOn()) {
            description = description + ", " + this.getAutowarmDescription();
        }
        if (this.getMaxRamBytes() != Long.MAX_VALUE) {
            description = description + ", maxRamMB=" + this.getMaxRamBytes() / 1024L / 1024L;
        }
        if (this.maxIdleTimeNs != Long.MAX_VALUE) {
            description = description + ", maxIdleTime=" + TimeUnit.SECONDS.convert(this.maxIdleTimeNs, TimeUnit.NANOSECONDS);
        }
        description = description + ')';
        return description;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int size() {
        Map<K, CacheValue<V>> map = this.map;
        synchronized (map) {
            return this.map.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V computeIfAbsent(K key, Function<? super K, ? extends V> mappingFunction) {
        Map<K, CacheValue<V>> map = this.map;
        synchronized (map) {
            if (this.getState() == SolrCache.State.LIVE) {
                ++this.lookups;
                this.stats.lookups.increment();
            }
            AtomicBoolean newEntry = new AtomicBoolean();
            CacheValue entry = this.map.computeIfAbsent(key, k -> {
                Object value = mappingFunction.apply((K)k);
                if (value == null) {
                    return null;
                }
                CacheValue cacheValue = new CacheValue(value, this.timeSource.getEpochTimeNs());
                if (this.getState() == SolrCache.State.LIVE) {
                    this.stats.inserts.increment();
                }
                if (this.syntheticEntries && cacheValue.createTime < this.oldestEntry) {
                    this.oldestEntry = cacheValue.createTime;
                }
                ++this.inserts;
                long keySize = RamUsageEstimator.sizeOfObject((Object)key, (long)1024L);
                long valueSize = RamUsageEstimator.sizeOfObject(cacheValue, (long)1024L);
                this.ramBytesUsed += keySize + valueSize + RamUsageEstimator.LINKED_HASHTABLE_RAM_BYTES_PER_ENTRY;
                newEntry.set(true);
                return cacheValue;
            });
            if (!newEntry.get() && this.getState() == SolrCache.State.LIVE) {
                ++this.hits;
                this.stats.hits.increment();
            }
            return entry != null ? (V)entry.value : null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V remove(K key) {
        Map<K, CacheValue<V>> map = this.map;
        synchronized (map) {
            CacheValue<V> entry = this.map.remove(key);
            if (entry != null) {
                long delta = RamUsageEstimator.sizeOfObject(key, (long)1024L) + RamUsageEstimator.sizeOfObject(entry, (long)1024L) + RamUsageEstimator.LINKED_HASHTABLE_RAM_BYTES_PER_ENTRY;
                this.ramBytesUsed -= delta;
                return entry.value;
            }
            return null;
        }
    }

    @Override
    public V put(K key, V value) {
        if (this.maxSize == Integer.MAX_VALUE && this.maxRamBytes == Long.MAX_VALUE) {
            throw new IllegalStateException("Cache: " + this.getName() + " has neither size nor RAM limit!");
        }
        CacheValue<V> cacheValue = new CacheValue<V>(value, this.timeSource.getEpochTimeNs());
        return this.putCacheValue(key, cacheValue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V putCacheValue(K key, CacheValue<V> cacheValue) {
        Map<K, CacheValue<V>> map = this.map;
        synchronized (map) {
            if (this.getState() == SolrCache.State.LIVE) {
                this.stats.inserts.increment();
            }
            if (this.syntheticEntries && cacheValue.createTime < this.oldestEntry) {
                this.oldestEntry = cacheValue.createTime;
            }
            ++this.inserts;
            long keySize = RamUsageEstimator.sizeOfObject(key, (long)1024L);
            long valueSize = RamUsageEstimator.sizeOfObject(cacheValue, (long)1024L);
            this.ramBytesUsed += keySize + valueSize + RamUsageEstimator.LINKED_HASHTABLE_RAM_BYTES_PER_ENTRY;
            CacheValue<V> old = this.map.put(key, cacheValue);
            if (old != null) {
                long bytesToDecrement = RamUsageEstimator.sizeOfObject(old, (long)1024L);
                bytesToDecrement += RamUsageEstimator.LINKED_HASHTABLE_RAM_BYTES_PER_ENTRY;
                this.ramBytesUsed -= (bytesToDecrement += RamUsageEstimator.sizeOfObject(key, (long)1024L));
            }
            return old == null ? null : (V)old.value;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V get(K key) {
        Map<K, CacheValue<V>> map = this.map;
        synchronized (map) {
            CacheValue<V> val = this.map.get(key);
            if (this.getState() == SolrCache.State.LIVE) {
                ++this.lookups;
                this.stats.lookups.increment();
                if (val != null) {
                    ++this.hits;
                    this.stats.hits.increment();
                }
            }
            return val == null ? null : (V)val.value;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        Map<K, CacheValue<V>> map = this.map;
        synchronized (map) {
            this.map.clear();
            this.ramBytesUsed = 0L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void warm(SolrIndexSearcher searcher, SolrCache<K, V> old) {
        if (this.regenerator == null) {
            return;
        }
        long warmingStartTime = System.nanoTime();
        LRUCache other = (LRUCache)old;
        if (this.isAutowarmingOn()) {
            Object[] keys;
            Object[] vals = null;
            Map<K, CacheValue<V>> map = other.map;
            synchronized (map) {
                int i;
                int sz = this.autowarm.getWarmCount(other.map.size());
                keys = new Object[sz];
                vals = new Object[sz];
                Iterator<Map.Entry<K, CacheValue<V>>> iter = other.map.entrySet().iterator();
                int skip = other.map.size() - sz;
                for (i = 0; i < skip; ++i) {
                    iter.next();
                }
                for (i = 0; i < sz; ++i) {
                    Map.Entry<K, CacheValue<V>> entry = iter.next();
                    keys[i] = entry.getKey();
                    vals[i] = entry.getValue().value;
                }
            }
            for (int i = 0; i < keys.length; ++i) {
                try {
                    boolean continueRegen = this.regenerator.regenerateItem(searcher, this, old, keys[i], vals[i]);
                    if (continueRegen) continue;
                    break;
                }
                catch (Exception e) {
                    SolrException.log((Logger)log, (String)("Error during auto-warming of key:" + keys[i]), (Throwable)e);
                }
            }
        }
        this.warmupTime = TimeUnit.MILLISECONDS.convert(System.nanoTime() - warmingStartTime, TimeUnit.NANOSECONDS);
    }

    @Override
    public String getName() {
        return LRUCache.class.getName();
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public Set<String> getMetricNames() {
        return this.metricNames;
    }

    @Override
    public SolrMetricsContext getSolrMetricsContext() {
        return this.solrMetricsContext;
    }

    @Override
    public void initializeMetrics(SolrMetricsContext parentContext, String scope) {
        this.solrMetricsContext = parentContext.getChildContext(this);
        this.cacheMap = new MetricsMap((detailed, res) -> {
            Map<K, CacheValue<V>> map = this.map;
            synchronized (map) {
                res.put("lookups", this.lookups);
                res.put("hits", this.hits);
                res.put("hitratio", Float.valueOf(LRUCache.calcHitRatio(this.lookups, this.hits)));
                res.put("inserts", this.inserts);
                res.put("evictions", this.evictions);
                res.put("size", this.map.size());
                res.put("ramBytesUsed", this.ramBytesUsed());
                res.put("maxRamMB", this.getMaxRamMB());
                res.put("maxSize", this.maxSize);
                res.put("maxIdleTime", this.maxIdleTimeNs != Long.MAX_VALUE ? TimeUnit.SECONDS.convert(this.maxIdleTimeNs, TimeUnit.NANOSECONDS) : -1L);
                res.put("evictionsRamUsage", this.evictionsRamUsage);
                res.put("evictionsIdleTime", this.evictionsIdleTime);
            }
            res.put("warmupTime", this.warmupTime);
            long clookups = this.stats.lookups.longValue();
            long chits = this.stats.hits.longValue();
            res.put("cumulative_lookups", clookups);
            res.put("cumulative_hits", chits);
            res.put("cumulative_hitratio", Float.valueOf(LRUCache.calcHitRatio(clookups, chits)));
            res.put("cumulative_inserts", this.stats.inserts.longValue());
            res.put("cumulative_evictions", this.stats.evictions.longValue());
            res.put("cumulative_evictionsRamUsage", this.stats.evictionsRamUsage.longValue());
            res.put("cumulative_evictionsIdleTime", this.stats.evictionsIdleTime.longValue());
        });
        this.solrMetricsContext.gauge(this, this.cacheMap, true, scope, this.getCategory().toString());
    }

    MetricsMap getMetricsMap() {
        return this.cacheMap;
    }

    public String toString() {
        return this.name() + (this.cacheMap != null ? this.cacheMap.getValue().toString() : "");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long ramBytesUsed() {
        Map<K, CacheValue<V>> map = this.map;
        synchronized (map) {
            return BASE_RAM_BYTES_USED + this.ramBytesUsed;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<Accountable> getChildResources() {
        Map<K, CacheValue<V>> map = this.map;
        synchronized (map) {
            return Accountables.namedAccountables((String)this.getName(), this.map);
        }
    }

    @Override
    public int getMaxSize() {
        return this.maxSize != Integer.MAX_VALUE ? this.maxSize : -1;
    }

    @Override
    public void setMaxSize(int maxSize) {
        this.maxSize = maxSize > 0 ? maxSize : Integer.MAX_VALUE;
        this.description = this.generateDescription();
    }

    @Override
    public int getMaxRamMB() {
        return this.maxRamBytes != Long.MAX_VALUE ? (int)(this.maxRamBytes / 1024L / 1024L) : -1;
    }

    @Override
    public void setMaxRamMB(int maxRamMB) {
        this.maxRamBytes = maxRamMB > 0 ? (long)maxRamMB * 1024L * 1024L : Long.MAX_VALUE;
        this.description = this.generateDescription();
    }

    public static final class CacheValue<V>
    implements Accountable {
        public static final long BASE_RAM_BYTES_USED = RamUsageEstimator.shallowSizeOfInstance(CacheValue.class);
        final long ramBytesUsed;
        public final long createTime;
        public final V value;

        public CacheValue(V value, long createTime) {
            this.value = value;
            this.createTime = createTime;
            this.ramBytesUsed = BASE_RAM_BYTES_USED + RamUsageEstimator.sizeOfObject(value, (long)1024L);
        }

        public long ramBytesUsed() {
            return this.ramBytesUsed;
        }
    }

    private static class CumulativeStats {
        LongAdder lookups = new LongAdder();
        LongAdder hits = new LongAdder();
        LongAdder inserts = new LongAdder();
        LongAdder evictions = new LongAdder();
        LongAdder evictionsRamUsage = new LongAdder();
        LongAdder evictionsIdleTime = new LongAdder();

        private CumulativeStats() {
        }
    }
}

