/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.util.Map;
import java.util.Objects;
import org.apache.lucene.index.DocValuesType;
import org.apache.lucene.index.IndexOptions;

public final class FieldInfo {
    public final String name;
    public final int number;
    private DocValuesType docValuesType = DocValuesType.NONE;
    private boolean storeTermVector;
    private boolean omitNorms;
    private IndexOptions indexOptions = IndexOptions.NONE;
    private boolean storePayloads;
    private final Map<String, String> attributes;
    private long dvGen;
    private int pointDimensionCount;
    private int pointIndexDimensionCount;
    private int pointNumBytes;
    private final boolean softDeletesField;

    public FieldInfo(String name, int number, boolean storeTermVector, boolean omitNorms, boolean storePayloads, IndexOptions indexOptions, DocValuesType docValues, long dvGen, Map<String, String> attributes, int pointDimensionCount, int pointIndexDimensionCount, int pointNumBytes, boolean softDeletesField) {
        this.name = Objects.requireNonNull(name);
        this.number = number;
        this.docValuesType = Objects.requireNonNull(docValues, "DocValuesType must not be null (field: \"" + name + "\")");
        this.indexOptions = Objects.requireNonNull(indexOptions, "IndexOptions must not be null (field: \"" + name + "\")");
        if (indexOptions != IndexOptions.NONE) {
            this.storeTermVector = storeTermVector;
            this.storePayloads = storePayloads;
            this.omitNorms = omitNorms;
        } else {
            this.storeTermVector = false;
            this.storePayloads = false;
            this.omitNorms = false;
        }
        this.dvGen = dvGen;
        this.attributes = Objects.requireNonNull(attributes);
        this.pointDimensionCount = pointDimensionCount;
        this.pointIndexDimensionCount = pointIndexDimensionCount;
        this.pointNumBytes = pointNumBytes;
        this.softDeletesField = softDeletesField;
        this.checkConsistency();
    }

    public boolean checkConsistency() {
        if (this.indexOptions != IndexOptions.NONE) {
            if (this.indexOptions.compareTo(IndexOptions.DOCS_AND_FREQS_AND_POSITIONS) < 0 && this.storePayloads) {
                throw new IllegalStateException("indexed field '" + this.name + "' cannot have payloads without positions");
            }
        } else {
            if (this.storeTermVector) {
                throw new IllegalStateException("non-indexed field '" + this.name + "' cannot store term vectors");
            }
            if (this.storePayloads) {
                throw new IllegalStateException("non-indexed field '" + this.name + "' cannot store payloads");
            }
            if (this.omitNorms) {
                throw new IllegalStateException("non-indexed field '" + this.name + "' cannot omit norms");
            }
        }
        if (this.pointDimensionCount < 0) {
            throw new IllegalStateException("pointDimensionCount must be >= 0; got " + this.pointDimensionCount);
        }
        if (this.pointIndexDimensionCount < 0) {
            throw new IllegalStateException("pointIndexDimensionCount must be >= 0; got " + this.pointIndexDimensionCount);
        }
        if (this.pointNumBytes < 0) {
            throw new IllegalStateException("pointNumBytes must be >= 0; got " + this.pointNumBytes);
        }
        if (this.pointDimensionCount != 0 && this.pointNumBytes == 0) {
            throw new IllegalStateException("pointNumBytes must be > 0 when pointDimensionCount=" + this.pointDimensionCount);
        }
        if (this.pointIndexDimensionCount != 0 && this.pointDimensionCount == 0) {
            throw new IllegalStateException("pointIndexDimensionCount must be 0 when pointDimensionCount=0");
        }
        if (this.pointNumBytes != 0 && this.pointDimensionCount == 0) {
            throw new IllegalStateException("pointDimensionCount must be > 0 when pointNumBytes=" + this.pointNumBytes);
        }
        if (this.dvGen != -1L && this.docValuesType == DocValuesType.NONE) {
            throw new IllegalStateException("field '" + this.name + "' cannot have a docvalues update generation without having docvalues");
        }
        return true;
    }

    void update(boolean storeTermVector, boolean omitNorms, boolean storePayloads, IndexOptions indexOptions, Map<String, String> attributes, int dimensionCount, int indexDimensionCount, int dimensionNumBytes) {
        if (indexOptions == null) {
            throw new NullPointerException("IndexOptions must not be null (field: \"" + this.name + "\")");
        }
        if (this.indexOptions != indexOptions) {
            if (this.indexOptions == IndexOptions.NONE) {
                this.indexOptions = indexOptions;
            } else if (indexOptions != IndexOptions.NONE) {
                throw new IllegalArgumentException("cannot change field \"" + this.name + "\" from index options=" + (Object)((Object)this.indexOptions) + " to inconsistent index options=" + (Object)((Object)indexOptions));
            }
        }
        if (this.pointDimensionCount == 0 && dimensionCount != 0) {
            this.pointDimensionCount = dimensionCount;
            this.pointIndexDimensionCount = indexDimensionCount;
            this.pointNumBytes = dimensionNumBytes;
        } else if (dimensionCount != 0 && (this.pointDimensionCount != dimensionCount || this.pointIndexDimensionCount != indexDimensionCount || this.pointNumBytes != dimensionNumBytes)) {
            throw new IllegalArgumentException("cannot change field \"" + this.name + "\" from points dimensionCount=" + this.pointDimensionCount + ", indexDimensionCount=" + this.pointIndexDimensionCount + ", numBytes=" + this.pointNumBytes + " to inconsistent dimensionCount=" + dimensionCount + ", indexDimensionCount=" + indexDimensionCount + ", numBytes=" + dimensionNumBytes);
        }
        if (this.indexOptions != IndexOptions.NONE) {
            this.storeTermVector |= storeTermVector;
            this.storePayloads |= storePayloads;
            if (indexOptions != IndexOptions.NONE && this.omitNorms != omitNorms) {
                this.omitNorms = true;
            }
        }
        if (this.indexOptions == IndexOptions.NONE || this.indexOptions.compareTo(IndexOptions.DOCS_AND_FREQS_AND_POSITIONS) < 0) {
            this.storePayloads = false;
        }
        if (attributes != null) {
            this.attributes.putAll(attributes);
        }
        this.checkConsistency();
    }

    public void setPointDimensions(int dimensionCount, int indexDimensionCount, int numBytes) {
        if (dimensionCount <= 0) {
            throw new IllegalArgumentException("point dimension count must be >= 0; got " + dimensionCount + " for field=\"" + this.name + "\"");
        }
        if (indexDimensionCount > 8) {
            throw new IllegalArgumentException("point index dimension count must be < PointValues.MAX_INDEX_DIMENSIONS (= 8); got " + indexDimensionCount + " for field=\"" + this.name + "\"");
        }
        if (indexDimensionCount > dimensionCount) {
            throw new IllegalArgumentException("point index dimension count must be <= point dimension count (= " + dimensionCount + "); got " + indexDimensionCount + " for field=\"" + this.name + "\"");
        }
        if (numBytes <= 0) {
            throw new IllegalArgumentException("point numBytes must be >= 0; got " + numBytes + " for field=\"" + this.name + "\"");
        }
        if (numBytes > 16) {
            throw new IllegalArgumentException("point numBytes must be <= PointValues.MAX_NUM_BYTES (= 16); got " + numBytes + " for field=\"" + this.name + "\"");
        }
        if (this.pointDimensionCount != 0 && this.pointDimensionCount != dimensionCount) {
            throw new IllegalArgumentException("cannot change point dimension count from " + this.pointDimensionCount + " to " + dimensionCount + " for field=\"" + this.name + "\"");
        }
        if (this.pointIndexDimensionCount != 0 && this.pointIndexDimensionCount != indexDimensionCount) {
            throw new IllegalArgumentException("cannot change point index dimension count from " + this.pointIndexDimensionCount + " to " + indexDimensionCount + " for field=\"" + this.name + "\"");
        }
        if (this.pointNumBytes != 0 && this.pointNumBytes != numBytes) {
            throw new IllegalArgumentException("cannot change point numBytes from " + this.pointNumBytes + " to " + numBytes + " for field=\"" + this.name + "\"");
        }
        this.pointDimensionCount = dimensionCount;
        this.pointIndexDimensionCount = indexDimensionCount;
        this.pointNumBytes = numBytes;
        this.checkConsistency();
    }

    public int getPointDimensionCount() {
        return this.pointDimensionCount;
    }

    public int getPointIndexDimensionCount() {
        return this.pointIndexDimensionCount;
    }

    public int getPointNumBytes() {
        return this.pointNumBytes;
    }

    public void setDocValuesType(DocValuesType type) {
        if (type == null) {
            throw new NullPointerException("DocValuesType must not be null (field: \"" + this.name + "\")");
        }
        if (this.docValuesType != DocValuesType.NONE && type != DocValuesType.NONE && this.docValuesType != type) {
            throw new IllegalArgumentException("cannot change DocValues type from " + (Object)((Object)this.docValuesType) + " to " + (Object)((Object)type) + " for field \"" + this.name + "\"");
        }
        this.docValuesType = type;
        this.checkConsistency();
    }

    public IndexOptions getIndexOptions() {
        return this.indexOptions;
    }

    public void setIndexOptions(IndexOptions newIndexOptions) {
        if (this.indexOptions != newIndexOptions) {
            if (this.indexOptions == IndexOptions.NONE) {
                this.indexOptions = newIndexOptions;
            } else if (newIndexOptions != IndexOptions.NONE) {
                throw new IllegalArgumentException("cannot change field \"" + this.name + "\" from index options=" + (Object)((Object)this.indexOptions) + " to inconsistent index options=" + (Object)((Object)newIndexOptions));
            }
        }
        if (this.indexOptions == IndexOptions.NONE || this.indexOptions.compareTo(IndexOptions.DOCS_AND_FREQS_AND_POSITIONS) < 0) {
            this.storePayloads = false;
        }
        this.checkConsistency();
    }

    public DocValuesType getDocValuesType() {
        return this.docValuesType;
    }

    void setDocValuesGen(long dvGen) {
        this.dvGen = dvGen;
        this.checkConsistency();
    }

    public long getDocValuesGen() {
        return this.dvGen;
    }

    void setStoreTermVectors() {
        this.storeTermVector = true;
        this.checkConsistency();
    }

    void setStorePayloads() {
        if (this.indexOptions != IndexOptions.NONE && this.indexOptions.compareTo(IndexOptions.DOCS_AND_FREQS_AND_POSITIONS) >= 0) {
            this.storePayloads = true;
        }
        this.checkConsistency();
    }

    public boolean omitsNorms() {
        return this.omitNorms;
    }

    public void setOmitsNorms() {
        if (this.indexOptions == IndexOptions.NONE) {
            throw new IllegalStateException("cannot omit norms: this field is not indexed");
        }
        this.omitNorms = true;
        this.checkConsistency();
    }

    public boolean hasNorms() {
        return this.indexOptions != IndexOptions.NONE && !this.omitNorms;
    }

    public boolean hasPayloads() {
        return this.storePayloads;
    }

    public boolean hasVectors() {
        return this.storeTermVector;
    }

    public String getAttribute(String key) {
        return this.attributes.get(key);
    }

    public String putAttribute(String key, String value) {
        return this.attributes.put(key, value);
    }

    public Map<String, String> attributes() {
        return this.attributes;
    }

    public boolean isSoftDeletesField() {
        return this.softDeletesField;
    }
}

