/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hslf.usermodel;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import org.apache.poi.common.usermodel.GenericRecord;
import org.apache.poi.hslf.record.ExOleObjStg;
import org.apache.poi.sl.usermodel.ObjectData;
import org.apache.poi.util.POILogFactory;
import org.apache.poi.util.POILogger;

public class HSLFObjectData
implements ObjectData,
GenericRecord {
    private static final POILogger LOG = POILogFactory.getLogger(HSLFObjectData.class);
    private ExOleObjStg storage;

    public HSLFObjectData(ExOleObjStg storage) {
        this.storage = storage;
    }

    public InputStream getInputStream() {
        return this.storage.getData();
    }

    public OutputStream getOutputStream() throws IOException {
        return new ByteArrayOutputStream(100000){

            @Override
            public void close() throws IOException {
                HSLFObjectData.this.setData(HSLFObjectData.this.getBytes());
            }
        };
    }

    public void setData(byte[] data) throws IOException {
        this.storage.setData(data);
    }

    public ExOleObjStg getExOleObjStg() {
        return this.storage;
    }

    public String getOLE2ClassName() {
        return null;
    }

    public String getFileName() {
        return null;
    }

    public Map<String, Supplier<?>> getGenericProperties() {
        return null;
    }

    public List<? extends GenericRecord> getGenericChildren() {
        return Collections.singletonList(this.getExOleObjStg());
    }
}

