/*
 * Decompiled with CFR 0.152.
 */
package org.apache.velocity.util.introspection;

import java.lang.reflect.Method;
import org.apache.velocity.util.introspection.AbstractChainableUberspector;
import org.apache.velocity.util.introspection.Info;
import org.apache.velocity.util.introspection.Introspector;
import org.apache.velocity.util.introspection.Uberspect;
import org.apache.velocity.util.introspection.VelMethod;
import org.apache.velocity.util.introspection.VelPropertyGet;
import org.apache.velocity.util.introspection.VelPropertySet;

public class DeprecatedCheckUberspector
extends AbstractChainableUberspector
implements Uberspect {
    @Override
    public void init() {
        super.init();
        this.introspector = new Introspector(this.log);
    }

    @Override
    public VelMethod getMethod(Object object, String string, Object[] objectArray, Info info) {
        Method method;
        VelMethod velMethod = super.getMethod(object, string, objectArray, info);
        if (velMethod != null && (method = this.introspector.getMethod(object.getClass(), velMethod.getMethodName(), objectArray)) != null && (method.isAnnotationPresent(Deprecated.class) || method.getDeclaringClass().isAnnotationPresent(Deprecated.class) || object.getClass().isAnnotationPresent(Deprecated.class))) {
            this.logWarning("method", object, velMethod.getMethodName(), info);
        }
        return velMethod;
    }

    @Override
    public VelPropertyGet getPropertyGet(Object object, String string, Info info) {
        Method method;
        VelPropertyGet velPropertyGet = super.getPropertyGet(object, string, info);
        if (velPropertyGet != null && (method = this.introspector.getMethod(object.getClass(), velPropertyGet.getMethodName(), new Object[0])) != null && (method.isAnnotationPresent(Deprecated.class) || method.getDeclaringClass().isAnnotationPresent(Deprecated.class) || object.getClass().isAnnotationPresent(Deprecated.class))) {
            this.logWarning("getter", object, velPropertyGet.getMethodName(), info);
        }
        return velPropertyGet;
    }

    @Override
    public VelPropertySet getPropertySet(Object object, String string, Object object2, Info info) {
        Method method;
        VelPropertySet velPropertySet = super.getPropertySet(object, string, object2, info);
        if (velPropertySet != null && (method = this.introspector.getMethod(object.getClass(), velPropertySet.getMethodName(), new Object[]{object2})) != null && (method.isAnnotationPresent(Deprecated.class) || method.getDeclaringClass().isAnnotationPresent(Deprecated.class) || object.getClass().isAnnotationPresent(Deprecated.class))) {
            this.logWarning("setter", object, velPropertySet.getMethodName(), info);
        }
        return velPropertySet;
    }

    private void logWarning(String string, Object object, String string2, Info info) {
        this.log.warn("Deprecated usage of {} [{}] in {}@{},{}", new Object[]{string, object.getClass().getCanonicalName() + "." + string2, info.getTemplateName(), info.getLine(), info.getColumn()});
    }
}

