/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.store.raw.data;

import java.security.AccessController;
import java.security.PrivilegedAction;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.store.raw.ContainerKey;
import org.apache.derby.iapi.store.raw.LockingPolicy;
import org.apache.derby.iapi.store.raw.data.RawContainerHandle;
import org.apache.derby.iapi.store.raw.xact.RawTransaction;
import org.apache.derby.iapi.util.ReuseFactory;
import org.apache.derby.impl.store.raw.data.BaseDataFileFactory;
import org.apache.derby.impl.store.raw.data.EncryptContainerOperation;
import org.apache.derby.io.StorageFactory;
import org.apache.derby.io.StorageFile;

public class EncryptData
implements PrivilegedAction {
    private BaseDataFileFactory dataFactory;
    private StorageFactory storageFactory;
    private StorageFile[] oldFiles;
    private int noOldFiles = 0;
    private static final int STORAGE_FILE_EXISTS_ACTION = 1;
    private static final int STORAGE_FILE_DELETE_ACTION = 2;
    private static final int STORAGE_FILE_RENAME_ACTION = 3;
    private int actionCode;
    private StorageFile actionStorageFile;
    private StorageFile actionDestStorageFile;

    public EncryptData(BaseDataFileFactory baseDataFileFactory) {
        this.dataFactory = baseDataFileFactory;
        this.storageFactory = baseDataFileFactory.getStorageFactory();
    }

    public void encryptAllContainers(RawTransaction rawTransaction) throws StandardException {
        String[] stringArray = this.dataFactory.getContainerNames();
        if (stringArray != null) {
            this.oldFiles = new StorageFile[stringArray.length];
            this.noOldFiles = 0;
            long l = 0L;
            for (int i = stringArray.length - 1; i >= 0; --i) {
                long l2;
                try {
                    l2 = Long.parseLong(stringArray[i].substring(1, stringArray[i].length() - 4), 16);
                }
                catch (Throwable throwable) {
                    continue;
                }
                ContainerKey containerKey = new ContainerKey(l, l2);
                this.oldFiles[this.noOldFiles++] = this.encryptContainer(rawTransaction, containerKey);
            }
        }
    }

    private StorageFile encryptContainer(RawTransaction rawTransaction, ContainerKey containerKey) throws StandardException {
        StorageFile storageFile;
        StorageFile storageFile2;
        LockingPolicy lockingPolicy = rawTransaction.newLockingPolicy(2, 5, true);
        RawContainerHandle rawContainerHandle = (RawContainerHandle)rawTransaction.openContainer(containerKey, lockingPolicy, 4);
        EncryptContainerOperation encryptContainerOperation = new EncryptContainerOperation(rawContainerHandle);
        rawTransaction.logAndDo(encryptContainerOperation);
        this.dataFactory.flush(rawTransaction.getLastLogInstant());
        String string = this.getFilePath(containerKey, false);
        StorageFile storageFile3 = this.storageFactory.newStorageFile(string);
        rawContainerHandle.encryptContainer(string);
        rawContainerHandle.close();
        if (!this.dataFactory.getPageCache().discard(containerKey)) {
            // empty if block
        }
        if (!this.dataFactory.getContainerCache().discard(containerKey)) {
            // empty if block
        }
        if (!this.privRename(storageFile2 = this.dataFactory.getContainerPath(containerKey, false), storageFile = this.getFile(containerKey, true))) {
            throw StandardException.newException("XSRS4.S", (Object)storageFile2, (Object)storageFile);
        }
        if (!this.privRename(storageFile3, storageFile2)) {
            throw StandardException.newException("XSRS4.S", (Object)storageFile3, (Object)storageFile2);
        }
        return storageFile;
    }

    private StorageFile getFile(ContainerKey containerKey, boolean bl) {
        String string = this.getFilePath(containerKey, bl);
        return this.storageFactory.newStorageFile(this.getFilePath(containerKey, bl));
    }

    private String getFilePath(ContainerKey containerKey, boolean bl) {
        StringBuffer stringBuffer = new StringBuffer("seg");
        stringBuffer.append(containerKey.getSegmentId());
        stringBuffer.append(this.storageFactory.getSeparator());
        stringBuffer.append(bl ? (char)'o' : 'n');
        stringBuffer.append(Long.toHexString(containerKey.getContainerId()));
        stringBuffer.append(".dat");
        return stringBuffer.toString();
    }

    private boolean isOldContainerFile(String string) {
        return string.startsWith("o") && string.endsWith(".dat");
    }

    private StorageFile getFile(String string) {
        long l = 0L;
        StringBuffer stringBuffer = new StringBuffer("seg");
        stringBuffer.append(l);
        stringBuffer.append(this.storageFactory.getSeparator());
        stringBuffer.append(string);
        return this.storageFactory.newStorageFile(stringBuffer.toString());
    }

    void restoreContainer(ContainerKey containerKey) throws StandardException {
        if (!this.dataFactory.getContainerCache().discard(containerKey)) {
            // empty if block
        }
        StorageFile storageFile = this.dataFactory.getContainerPath(containerKey, false);
        StorageFile storageFile2 = this.getFile(containerKey, true);
        StorageFile storageFile3 = this.getFile(containerKey, false);
        if (this.privExists(storageFile2)) {
            if (this.privExists(storageFile) && !this.privRename(storageFile, storageFile3)) {
                throw StandardException.newException("XSRS4.S", (Object)storageFile, (Object)storageFile3);
            }
            if (!this.privRename(storageFile2, storageFile)) {
                throw StandardException.newException("XSRS4.S", (Object)storageFile2, (Object)storageFile);
            }
        }
        if (this.privExists(storageFile3) && !this.privDelete(storageFile3)) {
            throw StandardException.newException("XBM0R.D", storageFile3);
        }
    }

    public void removeOldVersionOfContainers(boolean bl) throws StandardException {
        block3: {
            block2: {
                if (!bl) break block2;
                String[] stringArray = this.dataFactory.getContainerNames();
                if (stringArray == null) break block3;
                for (int i = stringArray.length - 1; i >= 0; --i) {
                    StorageFile storageFile;
                    if (!this.isOldContainerFile(stringArray[i]) || this.privDelete(storageFile = this.getFile(stringArray[i]))) continue;
                    throw StandardException.newException("XSDF4.S", storageFile);
                }
                break block3;
            }
            for (int i = 0; i < this.noOldFiles; ++i) {
                if (this.privDelete(this.oldFiles[i])) continue;
                throw StandardException.newException("XSDF4.S", this.oldFiles[i]);
            }
        }
    }

    private synchronized boolean privExists(StorageFile storageFile) {
        this.actionCode = 1;
        this.actionStorageFile = storageFile;
        Object t = AccessController.doPrivileged(this);
        this.actionStorageFile = null;
        return (Boolean)t;
    }

    private synchronized boolean privDelete(StorageFile storageFile) {
        this.actionCode = 2;
        this.actionStorageFile = storageFile;
        Object t = AccessController.doPrivileged(this);
        this.actionStorageFile = null;
        return (Boolean)t;
    }

    private synchronized boolean privRename(StorageFile storageFile, StorageFile storageFile2) {
        this.actionCode = 3;
        this.actionStorageFile = storageFile;
        this.actionDestStorageFile = storageFile2;
        Object t = AccessController.doPrivileged(this);
        this.actionStorageFile = null;
        this.actionDestStorageFile = null;
        return (Boolean)t;
    }

    public Object run() {
        switch (this.actionCode) {
            case 1: {
                return ReuseFactory.getBoolean(this.actionStorageFile.exists());
            }
            case 2: {
                return ReuseFactory.getBoolean(this.actionStorageFile.delete());
            }
            case 3: {
                return ReuseFactory.getBoolean(this.actionStorageFile.renameTo(this.actionDestStorageFile));
            }
        }
        return null;
    }
}

