/*
 * Decompiled with CFR 0.152.
 */
package org.rrd4j.core;

import java.io.IOException;
import org.rrd4j.core.RrdPrimitive;
import org.rrd4j.core.RrdUpdater;
import org.rrd4j.core.Util;

class RrdDouble<U extends RrdUpdater<U>>
extends RrdPrimitive<U> {
    private double cache;
    private boolean cached = false;

    RrdDouble(RrdUpdater<U> updater, boolean isConstant) throws IOException {
        super(updater, 2, isConstant);
    }

    RrdDouble(RrdUpdater<U> updater) throws IOException {
        super(updater, 2, false);
    }

    void set(double value) throws IOException {
        if (!this.isCachingAllowed()) {
            this.writeDouble(value);
        } else if (!this.cached || !Util.equal(this.cache, value)) {
            this.cache = value;
            this.writeDouble(this.cache);
            this.cached = true;
        }
    }

    double get() throws IOException {
        if (!this.isCachingAllowed()) {
            return this.readDouble();
        }
        if (!this.cached) {
            this.cache = this.readDouble();
            this.cached = true;
        }
        return this.cache;
    }
}

