/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.dataimport;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.solr.common.SolrInputDocument;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.StrUtils;

public class DebugInfo {
    public List<SolrInputDocument> debugDocuments = new ChildRollupDocs();
    public NamedList<String> debugVerboseOutput = null;
    public boolean verbose;

    public DebugInfo(Map<String, Object> requestParams) {
        this.verbose = StrUtils.parseBool((String)((String)requestParams.get("verbose")), (boolean)false);
        this.debugVerboseOutput = new NamedList();
    }

    private static final class ChildRollupDocs
    extends AbstractList<SolrInputDocument> {
        private List<SolrInputDocument> delegate = new ArrayList<SolrInputDocument>();

        private ChildRollupDocs() {
        }

        @Override
        public SolrInputDocument get(int index) {
            return this.delegate.get(index);
        }

        @Override
        public int size() {
            return this.delegate.size();
        }

        @Override
        public boolean add(SolrInputDocument e) {
            SolrInputDocument transformed = e.deepCopy();
            if (transformed.hasChildDocuments()) {
                ChildRollupDocs childList = new ChildRollupDocs();
                childList.addAll(transformed.getChildDocuments());
                transformed.addField("_childDocuments_", (Object)childList);
                transformed.getChildDocuments().clear();
            }
            return this.delegate.add(transformed);
        }
    }
}

