/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.execution;

import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.HashMap;
import java.util.Hashtable;
import org.netbeans.core.execution.AccController;
import org.netbeans.core.execution.IOPermissionCollection;
import org.netbeans.core.execution.IOThreadIfc;
import org.netbeans.core.execution.TaskIO;
import org.openide.windows.IOProvider;
import org.openide.windows.InputOutput;
import org.openide.windows.TopComponent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class IOTable
extends Hashtable<InputOutput, TaskIO> {
    static final long serialVersionUID = 9096333712401558521L;
    private ThreadGroup base;
    private TaskIO systemIO;
    private HashMap<String, TaskIO> freeTaskIOs;
    private boolean searchingIO = false;

    public IOTable(ThreadGroup threadGroup, TaskIO taskIO) {
        this.base = threadGroup;
        this.systemIO = taskIO;
        this.freeTaskIOs = new HashMap(16);
    }

    ThreadGroup findGroup() {
        ThreadGroup threadGroup;
        ThreadGroup threadGroup2 = null;
        for (threadGroup = Thread.currentThread().getThreadGroup(); threadGroup != null && threadGroup != this.base; threadGroup = threadGroup.getParent()) {
            threadGroup2 = threadGroup;
        }
        return threadGroup == null ? null : threadGroup2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized TaskIO getIO() {
        TaskIO taskIO;
        String string;
        if (this.searchingIO) {
            return this.systemIO;
        }
        InputOutput inputOutput = null;
        if (Thread.currentThread() instanceof IOThreadIfc) {
            inputOutput = ((IOThreadIfc)((Object)Thread.currentThread())).getInputOutput();
        }
        IOPermissionCollection iOPermissionCollection = null;
        if (inputOutput == null) {
            try {
                this.searchingIO = true;
                iOPermissionCollection = AccController.getIOPermissionCollection();
                string = null;
                this.searchingIO = false;
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                this.searchingIO = false;
                throw throwable;
            }
            if (iOPermissionCollection == null) {
                return this.systemIO;
            }
            inputOutput = iOPermissionCollection.getIO();
        }
        if ((taskIO = (TaskIO)this.get(inputOutput)) == null) {
            if (inputOutput instanceof TopComponent) {
                string = ((TopComponent)inputOutput).getName();
                taskIO = this.getTaskIO(string);
                if (taskIO == null) {
                    inputOutput = IOProvider.getDefault().getIO(string, true);
                    taskIO = new TaskIO(inputOutput, string);
                } else {
                    inputOutput = taskIO.getInout();
                }
                inputOutput.select();
                inputOutput.setFocusTaken(true);
                if (iOPermissionCollection != null) {
                    iOPermissionCollection.setIO(inputOutput);
                }
                this.put(inputOutput, taskIO);
            } else {
                return new TaskIO(inputOutput);
            }
        }
        return taskIO;
    }

    synchronized TaskIO getTaskIO(String string) {
        TaskIO taskIO;
        if (this.reuseTaskIO() && (taskIO = this.getFreeTaskIO(string)) != null) {
            return taskIO;
        }
        return null;
    }

    private boolean reuseTaskIO() {
        return true;
    }

    private boolean clearTaskIO() {
        return true;
    }

    private TaskIO getFreeTaskIO(String string) {
        TaskIO taskIO = this.freeTaskIOs.get(string);
        if (taskIO == null) {
            return null;
        }
        if (this.clearTaskIO()) {
            try {
                taskIO.getInout().getOut().reset();
                taskIO.getInout().getErr().reset();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        taskIO.in = null;
        taskIO.getInout().flushReader();
        this.freeTaskIOs.remove(string);
        return taskIO;
    }

    synchronized void free(ThreadGroup threadGroup, InputOutput inputOutput) {
        TaskIO taskIO = (TaskIO)this.get(inputOutput);
        if (taskIO == null) {
            return;
        }
        if (taskIO.foreign) {
            return;
        }
        if (taskIO.getName() != "noname" && (taskIO = this.freeTaskIOs.put(taskIO.getName(), taskIO)) != null) {
            taskIO.getInout().closeInputOutput();
        }
        this.remove(inputOutput);
    }

    public Reader getIn() {
        TaskIO taskIO = this.getIO();
        if (taskIO.in == null) {
            taskIO.initIn();
        }
        return taskIO.in;
    }

    public Writer getOut() {
        TaskIO taskIO = this.getIO();
        if (taskIO.out == null) {
            taskIO.initOut();
        }
        return taskIO.out;
    }

    public Writer getErr() {
        TaskIO taskIO = this.getIO();
        if (taskIO.err == null) {
            taskIO.initErr();
        }
        return taskIO.err;
    }
}

