/*
 * Decompiled with CFR 0.152.
 */
package tr.extract.clean;

import java.util.logging.Logger;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;

public class ExtractCleanPrefs {
    private static final Logger LOG = Logger.getLogger("tr.extract.clean");
    private static final Preferences prefs = Preferences.userRoot().node("ThinkingRock/2.2.1/extract");
    private static final String KEY_CLEAN_LAST_DATE_MS = "clean.last.date.ms";
    private static final long DEF_CLEAN_LAST_DATE_MS = 0L;
    public static final int CLEAN_INTERVAL_STARTUP = 0;
    public static final int CLEAN_INTERVAL_NEVER = Integer.MAX_VALUE;
    private static final String KEY_CLEAN_INTERVAL_DAYS = "clean.interval.days";
    private static final int DEF_CLEAN_INTERVAL_DAYS = 0;
    private static final String KEY_CLEAN_AGE_DAYS = "clean.age.days";
    private static final int DEF_CLEAN_AGE_DAYS = 0;

    public static final long getCleanLastDateMS() {
        return prefs.getLong(KEY_CLEAN_LAST_DATE_MS, 0L);
    }

    public static final void setCleanLastDateMS(long value) {
        prefs.putLong(KEY_CLEAN_LAST_DATE_MS, value);
        ExtractCleanPrefs.flush();
    }

    public static final int getCleanIntervalDays() {
        return prefs.getInt(KEY_CLEAN_INTERVAL_DAYS, 0);
    }

    public static final void setCleanIntervalDays(int value) {
        prefs.putInt(KEY_CLEAN_INTERVAL_DAYS, value);
        ExtractCleanPrefs.flush();
    }

    public static final int getCleanAgeDays() {
        return prefs.getInt(KEY_CLEAN_AGE_DAYS, 0);
    }

    public static final void setCleanAgeDays(int value) {
        prefs.putInt(KEY_CLEAN_AGE_DAYS, value);
        ExtractCleanPrefs.flush();
    }

    private static void flush() {
        try {
            prefs.flush();
        }
        catch (BackingStoreException ex) {
            LOG.severe("Extract clean preferences error. " + ex.getMessage());
        }
    }
}

