/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.xstream.core;

import com.thoughtworks.xstream.converters.ConversionException;
import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.ConverterLookup;
import com.thoughtworks.xstream.core.TreeMarshaller;
import com.thoughtworks.xstream.core.util.ObjectIdDictionary;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import com.thoughtworks.xstream.io.path.Path;
import com.thoughtworks.xstream.io.path.PathTracker;
import com.thoughtworks.xstream.io.path.PathTrackingWriter;
import com.thoughtworks.xstream.mapper.Mapper;
import java.util.HashSet;
import java.util.Set;

public abstract class AbstractReferenceMarshaller
extends TreeMarshaller {
    private ObjectIdDictionary references = new ObjectIdDictionary();
    private PathTracker pathTracker = new PathTracker();
    private Path lastPath;
    private Set implicitElements = new HashSet();

    public AbstractReferenceMarshaller(HierarchicalStreamWriter writer, ConverterLookup converterLookup, Mapper mapper) {
        super(writer, converterLookup, mapper);
        this.writer = new PathTrackingWriter(writer, this.pathTracker);
    }

    public void convert(Object item, Converter converter) {
        if (this.getMapper().isImmutableValueType(item.getClass())) {
            converter.marshal(item, this.writer, this);
        } else {
            Path currentPath = this.pathTracker.getPath();
            Object existingReferenceKey = this.references.lookupId(item);
            if (existingReferenceKey != null) {
                if (this.implicitElements.contains(existingReferenceKey)) {
                    throw new ReferencedImplicitElementException("Cannot reference implicit element: " + item.toString());
                }
                this.writer.addAttribute(this.getMapper().aliasForAttribute("reference"), this.createReference(currentPath, existingReferenceKey));
            } else {
                Object newReferenceKey = this.createReferenceKey(currentPath);
                if (this.lastPath == null || !currentPath.isAncestor(this.lastPath)) {
                    this.fireValidReference(newReferenceKey);
                    this.lastPath = currentPath;
                } else {
                    this.implicitElements.add(newReferenceKey);
                }
                this.references.associateId(item, newReferenceKey);
                converter.marshal(item, this.writer, this);
            }
        }
    }

    protected abstract String createReference(Path var1, Object var2);

    protected abstract Object createReferenceKey(Path var1);

    protected abstract void fireValidReference(Object var1);

    public static class ReferencedImplicitElementException
    extends ConversionException {
        public ReferencedImplicitElementException(String msg) {
            super(msg);
        }
    }
}

