/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.startup;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.netbeans.Util;
import org.openide.filesystems.FileUtil;
import org.openide.modules.InstalledFileLocator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class InstalledFileLocatorImpl
extends InstalledFileLocator {
    private static final File[] dirs;
    private static Map<String, Map<File, Set<String>>> fileCache;

    private static void addDir(List<File> list, String string) {
        File file;
        if (string != null && (file = new File(string).getAbsoluteFile()).isDirectory()) {
            list.add(FileUtil.normalizeFile((File)file));
        }
    }

    public static synchronized void prepareCache() {
        assert (fileCache == null);
        fileCache = new HashMap<String, Map<File, Set<String>>>();
    }

    public static synchronized void discardCache() {
        assert (fileCache != null);
        fileCache = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File locate(String string, String string2, boolean bl) {
        String string3;
        String string4;
        if (string.length() == 0) {
            throw new IllegalArgumentException("Cannot look up \"\" in InstalledFileLocator.locate");
        }
        if (string.charAt(0) == '/') {
            throw new IllegalArgumentException("Paths passed to InstalledFileLocator.locate should not start with '/': " + string);
        }
        int n = string.lastIndexOf(47);
        if (n == string.length() - 1) {
            throw new IllegalArgumentException("Paths passed to InstalledFileLocator.locate should not end in '/': " + string);
        }
        if (n != -1) {
            string4 = string.substring(0, n + 1);
            string3 = string.substring(n + 1);
            assert (string3.length() > 0);
        } else {
            string4 = "";
            string3 = string;
        }
        Class<InstalledFileLocatorImpl> clazz = InstalledFileLocatorImpl.class;
        synchronized (InstalledFileLocatorImpl.class) {
            if (bl) {
                String string5;
                String string6;
                int n2 = string3.lastIndexOf(46);
                if (n2 == -1) {
                    string6 = string3;
                    string5 = "";
                } else {
                    string6 = string3.substring(0, n2);
                    string5 = string3.substring(n2);
                }
                String[] stringArray = Util.getLocalizingSuffixesFast();
                for (int i = 0; i < stringArray.length; ++i) {
                    String string7 = string6 + stringArray[i] + string5;
                    File file = InstalledFileLocatorImpl.locateExactPath(string4, string7);
                    if (file == null) continue;
                    // ** MonitorExit[var7_7] (shouldn't be in output)
                    return file;
                }
                // ** MonitorExit[var7_7] (shouldn't be in output)
                return null;
            }
            // ** MonitorExit[var7_7] (shouldn't be in output)
            return InstalledFileLocatorImpl.locateExactPath(string4, string3);
        }
    }

    private static File locateExactPath(String string, String string2) {
        assert (Thread.holdsLock(InstalledFileLocatorImpl.class));
        if (fileCache != null) {
            Set<String> set;
            int n;
            Map<File, Set<String>> map = fileCache.get(string);
            if (map == null) {
                map = new HashMap<File, Set<String>>(dirs.length * 2);
                for (n = 0; n < dirs.length; ++n) {
                    Set<String> set2;
                    set = dirs[n];
                    if (string.length() > 0) {
                        assert (string.charAt(string.length() - 1) == '/');
                        set2 = new File((File)((Object)set), string.substring(0, string.length() - 1).replace('/', File.separatorChar));
                    } else {
                        set2 = set;
                    }
                    if (!((File)((Object)set2)).isDirectory()) continue;
                    String[] stringArray = ((File)((Object)set2)).list();
                    if (stringArray != null) {
                        map.put((File)((Object)set), new HashSet<String>(Arrays.asList(stringArray)));
                        continue;
                    }
                    Util.err.warning("could not read files in " + set2);
                }
                fileCache.put(string, map);
            }
            for (n = 0; n < dirs.length; ++n) {
                set = map.get(dirs[n]);
                if (set == null || !set.contains(string2)) continue;
                return InstalledFileLocatorImpl.makeFile(dirs[n], string, string2);
            }
        } else {
            for (int i = 0; i < dirs.length; ++i) {
                File file = InstalledFileLocatorImpl.makeFile(dirs[i], string, string2);
                if (!file.exists()) continue;
                return file;
            }
        }
        return null;
    }

    private static File makeFile(File file, String string, String string2) {
        return new File(file, string.replace('/', File.separatorChar) + string2);
    }

    static {
        ArrayList<File> arrayList = new ArrayList<File>();
        InstalledFileLocatorImpl.addDir(arrayList, System.getProperty("netbeans.user"));
        String string = System.getProperty("netbeans.dirs");
        if (string != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, File.pathSeparator);
            while (stringTokenizer.hasMoreTokens()) {
                InstalledFileLocatorImpl.addDir(arrayList, stringTokenizer.nextToken());
            }
        }
        InstalledFileLocatorImpl.addDir(arrayList, System.getProperty("netbeans.home"));
        dirs = arrayList.toArray(new File[arrayList.size()]);
        fileCache = null;
    }
}

