/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.swing.plaf.aqua;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.image.BufferedImage;
import java.util.HashMap;
import java.util.Map;
import javax.imageio.ImageIO;
import javax.swing.border.Border;

public class FakeDropShadowBorder
implements Border {
    private static final int WIDTH = 17;
    private static final int HEIGHT = 17;
    public static final int ARC = 12;
    private final Color xpar = new Color(255, 255, 255, 0);
    private static final String upLeft = "upLeft.png";
    private static final String downRight = "downRight.png";
    private static final String downLeft = "upRight.png";
    private static final String upRight = "downLeft.png";
    private static final String bottom = "bottom.png";
    private static final String leftEdge = "leftEdge.png";
    private static final String rightEdge = "rightEdge.png";
    private static final String top = "top.png";
    private static Map<String, BufferedImage> imgs = new HashMap<String, BufferedImage>();

    public Insets getBorderInsets(Component component) {
        return new Insets(1, 13, 25, 13);
    }

    public void fillBackground(Component component, Graphics2D graphics2D, int n, int n2, int n3, int n4) {
        Shape shape = graphics2D.getClip();
        graphics2D.setColor(Color.WHITE);
        Insets insets = this.getBorderInsets(component);
        int n5 = n4 - insets.bottom + 6;
        int n6 = n5 - 20;
        int n7 = insets.top + 3;
        int n8 = insets.left - 2;
        int n9 = n7 + 16;
        int n10 = n9 + 9;
        int n11 = n + n3 - 34;
        int n12 = n11 + 24;
        GeneralPath generalPath = new GeneralPath();
        generalPath.moveTo(n8, n6);
        generalPath.lineTo(n8, n10);
        generalPath.curveTo(n8, n9, n8 + 6, n9, n8 + 8, n9 + 1);
        generalPath.curveTo(n8 + 11, n7, n8 + 19, n7 + 1, n8 + 25, n7);
        generalPath.lineTo(n11, n7);
        generalPath.curveTo(n11 + 6, n7, n11 + 17, n7 + 5, n11 + 16, n9);
        generalPath.curveTo(n12 - 4, n9 + 1, n12, n9, n12, n9 + 9);
        generalPath.lineTo(n12, n6);
        generalPath.curveTo(n12 + 1, n5, n12 - 1, n5 + 1, n12 - 12, n5);
        generalPath.lineTo(n8 + 14, n5);
        generalPath.curveTo(n8 + 1, n5, n8 - 1, n5, n8, n6);
        generalPath.closePath();
        graphics2D.fill(generalPath);
    }

    public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        this.fillBackground(component, graphics2D, n, n2, n3, n4);
        BufferedImage bufferedImage = FakeDropShadowBorder.getImage(upLeft);
        int n5 = bufferedImage.getHeight();
        int n6 = bufferedImage.getWidth();
        this.draw(graphics2D, bufferedImage, n, n2);
        bufferedImage = FakeDropShadowBorder.getImage(downRight);
        this.draw(graphics2D, bufferedImage, n + n3 - bufferedImage.getWidth(), n2 + n4 - bufferedImage.getHeight());
        int n7 = bufferedImage.getWidth();
        bufferedImage = FakeDropShadowBorder.getImage(upRight);
        this.draw(graphics2D, bufferedImage, n + n3 - bufferedImage.getWidth(), n2);
        int n8 = bufferedImage.getWidth();
        bufferedImage = FakeDropShadowBorder.getImage(downLeft);
        int n9 = bufferedImage.getHeight();
        int n10 = bufferedImage.getWidth();
        this.draw(graphics2D, bufferedImage, n, n2 + n4 - bufferedImage.getHeight());
        bufferedImage = FakeDropShadowBorder.getImage(leftEdge);
        this.tileVertical(n, n2, n5, n9, n4, bufferedImage, graphics2D);
        bufferedImage = FakeDropShadowBorder.getImage(rightEdge);
        this.tileVertical(n + n3 - bufferedImage.getWidth(), n2, n5, n9, n4, bufferedImage, graphics2D);
        bufferedImage = FakeDropShadowBorder.getImage(bottom);
        this.tileHorizontal(n, n2 + n4 - (bufferedImage.getHeight() + 0), n10, n7, n3, bufferedImage, graphics2D);
        bufferedImage = FakeDropShadowBorder.getImage(top);
        this.tileHorizontal(n, n2, n10, n7, n3, bufferedImage, graphics2D);
    }

    private void draw(Graphics2D graphics2D, BufferedImage bufferedImage, int n, int n2) {
        graphics2D.setColor(this.xpar);
        graphics2D.fillRect(n, n2, bufferedImage.getWidth(), bufferedImage.getHeight());
        graphics2D.drawRenderedImage(bufferedImage, AffineTransform.getTranslateInstance(n, n2));
    }

    private void tileVertical(int n, int n2, int n3, int n4, int n5, BufferedImage bufferedImage, Graphics2D graphics2D) {
        int n6 = (n5 -= n4 + n3) / bufferedImage.getHeight();
        int n7 = n5 % bufferedImage.getHeight();
        n2 += n3;
        for (int i = 0; i < n6; ++i) {
            graphics2D.drawRenderedImage(bufferedImage, AffineTransform.getTranslateInstance(n, n2));
            n2 += bufferedImage.getHeight();
        }
        if (n7 > 0) {
            bufferedImage = bufferedImage.getSubimage(0, 0, bufferedImage.getWidth(), n7);
            graphics2D.drawRenderedImage(bufferedImage, AffineTransform.getTranslateInstance(n, n2));
        }
    }

    private void tileHorizontal(int n, int n2, int n3, int n4, int n5, BufferedImage bufferedImage, Graphics2D graphics2D) {
        int n6 = (n5 -= n4 + n3) / bufferedImage.getWidth();
        int n7 = n5 % bufferedImage.getWidth();
        n += n3;
        for (int i = 0; i < n6; ++i) {
            this.draw(graphics2D, bufferedImage, n, n2);
            n += bufferedImage.getWidth();
        }
        if (n7 > 0) {
            bufferedImage = bufferedImage.getSubimage(0, 0, n7, bufferedImage.getHeight());
            this.draw(graphics2D, bufferedImage, n, n2);
        }
    }

    public boolean isBorderOpaque() {
        return false;
    }

    private static BufferedImage getImage(String string) {
        BufferedImage bufferedImage = imgs.get(string);
        if (bufferedImage == null) {
            Exception exception = null;
            try {
                bufferedImage = ImageIO.read(FakeDropShadowBorder.class.getResourceAsStream(string));
            }
            catch (Exception exception2) {
                bufferedImage = new BufferedImage(1, 1, 2);
                exception = exception2;
            }
            imgs.put(string, bufferedImage);
            if (exception != null) {
                throw new IllegalStateException(exception);
            }
        }
        return bufferedImage;
    }
}

