/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.autoupdate;

import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.netbeans.api.autoupdate.InstallSupport;
import org.netbeans.api.autoupdate.OperationSupport;
import org.netbeans.api.autoupdate.UpdateElement;
import org.netbeans.api.autoupdate.UpdateUnit;
import org.netbeans.modules.autoupdate.services.OperationContainerImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class OperationContainer<Support> {
    OperationContainerImpl<Support> impl;
    private Support support;
    private boolean upToDate = false;

    public static OperationContainer<InstallSupport> createForInstall() {
        OperationContainer<InstallSupport> operationContainer = new OperationContainer<InstallSupport>(OperationContainerImpl.createForInstall(), new InstallSupport());
        operationContainer.getSupportInner().setContainer(operationContainer);
        return operationContainer;
    }

    public static OperationContainer<OperationSupport> createForDirectInstall() {
        OperationContainer<OperationSupport> operationContainer = new OperationContainer<OperationSupport>(OperationContainerImpl.createForDirectInstall(), new OperationSupport());
        operationContainer.getSupportInner().setContainer(operationContainer);
        return operationContainer;
    }

    public static OperationContainer<InstallSupport> createForUpdate() {
        OperationContainer<InstallSupport> operationContainer = new OperationContainer<InstallSupport>(OperationContainerImpl.createForUpdate(), new InstallSupport());
        operationContainer.getSupportInner().setContainer(operationContainer);
        return operationContainer;
    }

    public static OperationContainer<OperationSupport> createForDirectUpdate() {
        OperationContainer<OperationSupport> operationContainer = new OperationContainer<OperationSupport>(OperationContainerImpl.createForDirectUpdate(), new OperationSupport());
        operationContainer.getSupportInner().setContainer(operationContainer);
        return operationContainer;
    }

    public static OperationContainer<OperationSupport> createForUninstall() {
        OperationContainer<OperationSupport> operationContainer = new OperationContainer<OperationSupport>(OperationContainerImpl.createForUninstall(), new OperationSupport());
        operationContainer.getSupportInner().setContainer(operationContainer);
        return operationContainer;
    }

    public static OperationContainer<OperationSupport> createForDirectUninstall() {
        OperationContainer<OperationSupport> operationContainer = new OperationContainer<OperationSupport>(OperationContainerImpl.createForDirectUninstall(), new OperationSupport());
        operationContainer.getSupportInner().setContainer(operationContainer);
        return operationContainer;
    }

    public static OperationContainer<OperationSupport> createForEnable() {
        OperationContainer<OperationSupport> operationContainer = new OperationContainer<OperationSupport>(OperationContainerImpl.createForEnable(), new OperationSupport());
        operationContainer.getSupportInner().setContainer(operationContainer);
        return operationContainer;
    }

    public static OperationContainer<OperationSupport> createForDisable() {
        OperationContainer<OperationSupport> operationContainer = new OperationContainer<OperationSupport>(OperationContainerImpl.createForDisable(), new OperationSupport());
        operationContainer.getSupportInner().setContainer(operationContainer);
        return operationContainer;
    }

    public static OperationContainer<OperationSupport> createForDirectDisable() {
        OperationContainer<OperationSupport> operationContainer = new OperationContainer<OperationSupport>(OperationContainerImpl.createForDirectDisable(), new OperationSupport());
        operationContainer.getSupportInner().setContainer(operationContainer);
        return operationContainer;
    }

    public static OperationContainer<OperationSupport> createForCustomInstallComponent() {
        OperationContainer<OperationSupport> operationContainer = new OperationContainer<OperationSupport>(OperationContainerImpl.createForInstallNativeComponent(), new OperationSupport());
        operationContainer.getSupportInner().setContainer(operationContainer);
        return operationContainer;
    }

    public static OperationContainer<OperationSupport> createForCustomUninstallComponent() {
        OperationContainer<OperationSupport> operationContainer = new OperationContainer<OperationSupport>(OperationContainerImpl.createForUninstallNativeComponent(), new OperationSupport());
        operationContainer.getSupportInner().setContainer(operationContainer);
        return operationContainer;
    }

    public Support getSupport() {
        if (this.upToDate) {
            return this.support;
        }
        if (this.listAll().size() > 0 && this.listInvalid().size() == 0) {
            this.upToDate = true;
            return this.support;
        }
        return null;
    }

    Support getSupportInner() {
        return this.support;
    }

    public boolean canBeAdded(UpdateUnit updateUnit, UpdateElement updateElement) {
        return this.impl.isValid(updateUnit, updateElement);
    }

    public void add(Collection<UpdateElement> collection) {
        if (collection == null) {
            throw new IllegalArgumentException("Cannot add null value.");
        }
        for (UpdateElement updateElement : collection) {
            this.add(updateElement);
        }
    }

    public void add(Map<UpdateUnit, UpdateElement> map) {
        if (map == null) {
            throw new IllegalArgumentException("Cannot add null value.");
        }
        for (Map.Entry<UpdateUnit, UpdateElement> entry : map.entrySet()) {
            this.add(entry.getKey(), entry.getValue());
        }
    }

    public OperationInfo<Support> add(UpdateUnit updateUnit, UpdateElement updateElement) {
        this.upToDate = false;
        return this.impl.add(updateUnit, updateElement);
    }

    public OperationInfo<Support> add(UpdateElement updateElement) {
        this.upToDate = false;
        UpdateUnit updateUnit = updateElement.getUpdateUnit();
        return this.add(updateUnit, updateElement);
    }

    public void remove(Collection<UpdateElement> collection) {
        if (collection == null) {
            throw new IllegalArgumentException("Cannot add null value.");
        }
        for (UpdateElement updateElement : collection) {
            this.remove(updateElement);
        }
    }

    public boolean remove(UpdateElement updateElement) {
        this.upToDate = false;
        return this.impl.remove(updateElement);
    }

    public boolean contains(UpdateElement updateElement) {
        return this.impl.contains(updateElement);
    }

    public List<OperationInfo<Support>> listAll() {
        return this.impl.listAllWithPossibleEager();
    }

    public List<OperationInfo<Support>> listInvalid() {
        return this.impl.listInvalid();
    }

    public void remove(OperationInfo<Support> operationInfo) {
        this.upToDate = false;
        this.impl.remove(operationInfo);
    }

    public void removeAll() {
        this.upToDate = false;
        this.impl.removeAll();
    }

    private OperationContainer(OperationContainerImpl<Support> operationContainerImpl, Support Support) {
        this.impl = operationContainerImpl;
        this.support = Support;
        operationContainerImpl.setOperationContainer(this);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class OperationInfo<Support> {
        OperationContainerImpl.OperationInfoImpl<Support> impl;

        OperationInfo(OperationContainerImpl.OperationInfoImpl<Support> operationInfoImpl) {
            this.impl = operationInfoImpl;
        }

        public UpdateElement getUpdateElement() {
            return this.impl.getUpdateElement();
        }

        public UpdateUnit getUpdateUnit() {
            return this.impl.getUpdateUnit();
        }

        public Set<UpdateElement> getRequiredElements() {
            return new LinkedHashSet<UpdateElement>(this.impl.getRequiredElements());
        }

        public Set<String> getBrokenDependencies() {
            return this.impl.getBrokenDependencies();
        }

        public String toString() {
            return "OperationInfo: " + this.impl.getUpdateElement().toString();
        }
    }
}

