/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.autoupdate.services;

import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.Module;
import org.netbeans.api.autoupdate.UpdateManager;
import org.netbeans.modules.autoupdate.services.UpdateElementImpl;
import org.netbeans.modules.autoupdate.services.UpdateUnitFactory;
import org.netbeans.modules.autoupdate.services.Utilities;
import org.netbeans.modules.autoupdate.updateprovider.InstallInfo;
import org.netbeans.modules.autoupdate.updateprovider.InstalledModuleItem;
import org.netbeans.modules.autoupdate.updateprovider.ModuleItem;
import org.openide.modules.ModuleInfo;
import org.openide.modules.SpecificationVersion;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModuleUpdateElementImpl
extends UpdateElementImpl {
    private String codeName;
    private String displayName;
    private SpecificationVersion specVersion;
    private String description;
    private String source;
    private String author;
    private String homepage;
    private int downloadSize;
    private String category;
    private InstallInfo installInfo;
    private Logger log = null;
    private ModuleInfo moduleInfo;
    private ModuleItem item;
    private String providerName;
    private String date;
    private boolean isEager;
    private boolean isAutoload;

    public ModuleUpdateElementImpl(ModuleItem moduleItem, String string) {
        super(moduleItem, string);
        this.moduleInfo = moduleItem.getModuleInfo();
        this.item = moduleItem;
        this.providerName = string;
        this.codeName = moduleItem.getCodeName();
        this.specVersion = moduleItem.getSpecificationVersion() == null ? null : new SpecificationVersion(moduleItem.getSpecificationVersion());
        this.installInfo = new InstallInfo(moduleItem);
        this.author = moduleItem.getAuthor();
        this.downloadSize = moduleItem.getDownloadSize();
        this.homepage = moduleItem.getHomepage();
        this.date = moduleItem.getDate();
        this.isEager = moduleItem.isEager();
        this.isAutoload = moduleItem.isAutoload();
    }

    @Override
    public String getCodeName() {
        return this.codeName;
    }

    @Override
    public String getDisplayName() {
        if (this.displayName == null) {
            String string = this.moduleInfo.getDisplayName();
            assert (string != null) : "Module " + this.codeName + " doesn't provider display name. Value of \"OpenIDE-Module-Name\" cannot be null.";
            if (string == null) {
                this.getLogger().log(Level.WARNING, "Module " + this.codeName + " doesn't provider display name. Value of \"OpenIDE-Module-Name\" cannot be null.");
            }
            this.displayName = string == null ? this.codeName : string;
        }
        return this.displayName;
    }

    @Override
    public SpecificationVersion getSpecificationVersion() {
        return this.specVersion;
    }

    @Override
    public String getDescription() {
        if (this.description == null) {
            this.description = (String)this.moduleInfo.getLocalizedAttribute("OpenIDE-Module-Long-Description");
        }
        return this.description;
    }

    @Override
    public String getNotification() {
        String string = this.item.getModuleNotification();
        if (string != null) {
            string = string.trim();
        }
        return string;
    }

    @Override
    public String getAuthor() {
        return this.author;
    }

    @Override
    public String getHomepage() {
        return this.homepage;
    }

    @Override
    public int getDownloadSize() {
        return this.downloadSize;
    }

    @Override
    public String getSource() {
        if (this.source == null) {
            String string = this.source = this.item instanceof InstalledModuleItem ? ((InstalledModuleItem)this.item).getSource() : this.providerName;
            if (this.source == null) {
                this.source = Utilities.getProductVersion();
            }
        }
        return this.source;
    }

    @Override
    public String getDate() {
        return this.date;
    }

    @Override
    public String getCategory() {
        if (this.category == null) {
            this.category = this.item.getCategory();
            if (this.category == null) {
                this.category = (String)this.moduleInfo.getLocalizedAttribute("OpenIDE-Module-Display-Category");
            }
            if (this.isAutoload() || this.isFixed()) {
                this.category = UpdateUnitFactory.LIBRARIES_CATEGORY;
            } else if (this.isEager()) {
                this.category = UpdateUnitFactory.BRIDGES_CATEGORY;
            } else if (this.category == null || this.category.length() == 0) {
                this.category = UpdateUnitFactory.UNSORTED_CATEGORY;
            }
        }
        return this.category;
    }

    @Override
    public String getLicence() {
        return this.item.getAgreement();
    }

    @Override
    public InstallInfo getInstallInfo() {
        return this.installInfo;
    }

    @Override
    public List<ModuleInfo> getModuleInfos() {
        return Collections.singletonList(this.getModuleInfo());
    }

    public ModuleInfo getModuleInfo() {
        assert (this.moduleInfo != null) : "Each ModuleUpdateElementImpl has ModuleInfo, but " + this;
        Module module = Utilities.toModule(this.moduleInfo);
        this.moduleInfo = module != null ? module : this.item.getModuleInfo();
        return this.moduleInfo;
    }

    @Override
    public UpdateManager.TYPE getType() {
        return UpdateManager.TYPE.MODULE;
    }

    @Override
    public boolean isEnabled() {
        return this.getModuleInfo().isEnabled();
    }

    @Override
    public boolean isAutoload() {
        return this.isAutoload;
    }

    @Override
    public boolean isEager() {
        return this.isEager;
    }

    @Override
    public boolean isFixed() {
        return Utilities.toModule(this.getCodeName(), null) == null ? false : Utilities.toModule(this.getCodeName(), null).isFixed();
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        ModuleUpdateElementImpl moduleUpdateElementImpl = (ModuleUpdateElementImpl)object;
        if (!(this.specVersion == moduleUpdateElementImpl.specVersion || this.specVersion != null && this.specVersion.equals((Object)moduleUpdateElementImpl.specVersion))) {
            return false;
        }
        return this.codeName == moduleUpdateElementImpl.codeName || this.codeName != null && this.codeName.equals(moduleUpdateElementImpl.codeName);
    }

    public int hashCode() {
        int n = 5;
        n = 61 * n + (this.codeName != null ? this.codeName.hashCode() : 0);
        n = 61 * n + (this.specVersion != null ? this.specVersion.hashCode() : 0);
        return n;
    }

    public String toString() {
        return "Impl[" + this.getUpdateElement() + "]";
    }

    private Logger getLogger() {
        if (this.log == null) {
            this.log = Logger.getLogger(ModuleUpdateElementImpl.class.getName());
        }
        return this.log;
    }
}

