/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.bridge;

import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.color.ICC_Profile;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Rectangle2D;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import org.apache.batik.bridge.AbstractGraphicsNodeBridge;
import org.apache.batik.bridge.Bridge;
import org.apache.batik.bridge.BridgeContext;
import org.apache.batik.bridge.BridgeException;
import org.apache.batik.bridge.CSSUtilities;
import org.apache.batik.bridge.DocumentLoader;
import org.apache.batik.bridge.SVGBrokenLinkProvider;
import org.apache.batik.bridge.SVGColorProfileElementBridge;
import org.apache.batik.bridge.UnitProcessor;
import org.apache.batik.bridge.UserAgent;
import org.apache.batik.bridge.ViewBox;
import org.apache.batik.css.engine.CSSEngine;
import org.apache.batik.dom.svg.SVGOMDocument;
import org.apache.batik.dom.svg.SVGOMElement;
import org.apache.batik.dom.svg.XMLBaseSupport;
import org.apache.batik.dom.util.XLinkSupport;
import org.apache.batik.ext.awt.color.ICCColorSpaceExt;
import org.apache.batik.ext.awt.image.renderable.ClipRable8Bit;
import org.apache.batik.ext.awt.image.renderable.Filter;
import org.apache.batik.ext.awt.image.spi.ImageTagRegistry;
import org.apache.batik.gvt.CanvasGraphicsNode;
import org.apache.batik.gvt.CompositeGraphicsNode;
import org.apache.batik.gvt.GraphicsNode;
import org.apache.batik.gvt.ImageNode;
import org.apache.batik.gvt.RasterImageNode;
import org.apache.batik.gvt.ShapeNode;
import org.apache.batik.parser.UnitProcessor;
import org.apache.batik.util.MimeTypeConstants;
import org.apache.batik.util.ParsedURL;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.events.DocumentEvent;
import org.w3c.dom.events.Event;
import org.w3c.dom.events.EventListener;
import org.w3c.dom.events.EventTarget;
import org.w3c.dom.events.MouseEvent;
import org.w3c.dom.events.MutationEvent;
import org.w3c.dom.svg.SVGDocument;
import org.w3c.dom.svg.SVGSVGElement;

public class SVGImageElementBridge
extends AbstractGraphicsNodeBridge {
    protected SVGDocument imgDocument;
    protected EventListener listener = null;
    protected BridgeContext subCtx = null;
    protected boolean hitCheckChildren = false;
    static SVGBrokenLinkProvider brokenLinkProvider = new SVGBrokenLinkProvider();

    public String getLocalName() {
        return "image";
    }

    public Bridge getInstance() {
        return new SVGImageElementBridge();
    }

    public GraphicsNode createGraphicsNode(BridgeContext bridgeContext, Element element) {
        ImageNode imageNode = (ImageNode)super.createGraphicsNode(bridgeContext, element);
        if (imageNode == null) {
            return null;
        }
        this.hitCheckChildren = false;
        GraphicsNode graphicsNode = this.buildImageGraphicsNode(bridgeContext, element);
        if (graphicsNode == null) {
            String string = XLinkSupport.getXLinkHref(element);
            throw new BridgeException(element, "uri.image.invalid", new Object[]{string});
        }
        imageNode.setImage(graphicsNode);
        imageNode.setHitCheckChildren(this.hitCheckChildren);
        RenderingHints renderingHints = null;
        renderingHints = CSSUtilities.convertImageRendering(element, renderingHints);
        renderingHints = CSSUtilities.convertColorRendering(element, renderingHints);
        if (renderingHints != null) {
            imageNode.setRenderingHints(renderingHints);
        }
        return imageNode;
    }

    protected GraphicsNode buildImageGraphicsNode(BridgeContext bridgeContext, Element element) {
        String string = XLinkSupport.getXLinkHref(element);
        if (string.length() == 0) {
            throw new BridgeException(element, "attribute.missing", new Object[]{"xlink:href"});
        }
        if (string.indexOf(35) != -1) {
            throw new BridgeException(element, "attribute.malformed", new Object[]{"xlink:href", string});
        }
        String string2 = XMLBaseSupport.getCascadedXMLBase(element);
        ParsedURL parsedURL = string2 == null ? new ParsedURL(string) : new ParsedURL(string2, string);
        return this.createImageGraphicsNode(bridgeContext, element, parsedURL);
    }

    protected GraphicsNode createImageGraphicsNode(BridgeContext bridgeContext, Element element, ParsedURL parsedURL) {
        Object object;
        Rectangle2D rectangle2D = SVGImageElementBridge.getImageBounds(bridgeContext, element);
        if (rectangle2D.getWidth() == 0.0 || rectangle2D.getHeight() == 0.0) {
            ShapeNode shapeNode = new ShapeNode();
            shapeNode.setShape(rectangle2D);
            return shapeNode;
        }
        SVGDocument sVGDocument = (SVGDocument)element.getOwnerDocument();
        String string = sVGDocument.getURL();
        ParsedURL parsedURL2 = null;
        if (string != null) {
            parsedURL2 = new ParsedURL(string);
        }
        UserAgent userAgent = bridgeContext.getUserAgent();
        try {
            userAgent.checkLoadExternalResource(parsedURL, parsedURL2);
        }
        catch (SecurityException securityException) {
            throw new BridgeException(element, "uri.unsecure", new Object[]{parsedURL});
        }
        DocumentLoader documentLoader = bridgeContext.getDocumentLoader();
        ImageTagRegistry imageTagRegistry = ImageTagRegistry.getRegistry();
        ICCColorSpaceExt iCCColorSpaceExt = SVGImageElementBridge.extractColorSpace(element, bridgeContext);
        try {
            object = documentLoader.checkCache(parsedURL.toString());
            if (object != null) {
                this.imgDocument = (SVGDocument)object;
                return this.createSVGImageNode(bridgeContext, element, this.imgDocument);
            }
        }
        catch (BridgeException bridgeException) {
            throw bridgeException;
        }
        catch (Exception exception) {
            // empty catch block
        }
        object = imageTagRegistry.checkCache(parsedURL, iCCColorSpaceExt);
        if (object != null) {
            return this.createRasterImageNode(bridgeContext, element, (Filter)object);
        }
        object = null;
        try {
            object = this.openStream(element, parsedURL);
        }
        catch (SecurityException securityException) {
            throw new BridgeException(element, "uri.unsecure", new Object[]{parsedURL});
        }
        catch (IOException iOException) {
            return this.createBrokenImageNode(bridgeContext, element, parsedURL.toString());
        }
        Object object2 = imageTagRegistry.readURL((InputStream)object, parsedURL, iCCColorSpaceExt, false, false);
        if (object2 != null) {
            return this.createRasterImageNode(bridgeContext, element, (Filter)object2);
        }
        try {
            ((ProtectedStream)object).retry();
        }
        catch (IOException iOException) {
            try {
                object = this.openStream(element, parsedURL);
            }
            catch (IOException iOException2) {
                return this.createBrokenImageNode(bridgeContext, element, parsedURL.toString());
            }
        }
        try {
            object2 = documentLoader.loadDocument(parsedURL.toString(), (InputStream)object);
            this.imgDocument = (SVGDocument)object2;
            return this.createSVGImageNode(bridgeContext, element, this.imgDocument);
        }
        catch (BridgeException bridgeException) {
            throw bridgeException;
        }
        catch (SecurityException securityException) {
            throw new BridgeException(element, "uri.unsecure", new Object[]{parsedURL});
        }
        catch (Exception exception) {
            try {
                ((ProtectedStream)object).retry();
            }
            catch (IOException iOException) {
                try {
                    object = this.openStream(element, parsedURL);
                }
                catch (IOException iOException3) {
                    return this.createBrokenImageNode(bridgeContext, element, parsedURL.toString());
                }
            }
            try {
                object2 = imageTagRegistry.readURL((InputStream)object, parsedURL, iCCColorSpaceExt, true, true);
                if (object2 != null) {
                    GraphicsNode graphicsNode = this.createRasterImageNode(bridgeContext, element, (Filter)object2);
                    Object var17_28 = null;
                    ((ProtectedStream)object).release();
                    return graphicsNode;
                }
                Object var17_29 = null;
                ((ProtectedStream)object).release();
            }
            catch (Throwable throwable) {
                Object var17_30 = null;
                ((ProtectedStream)object).release();
                throw throwable;
            }
            return null;
        }
    }

    protected ProtectedStream openStream(Element element, ParsedURL parsedURL) throws IOException {
        ArrayList<String[]> arrayList = new ArrayList<String[]>(ImageTagRegistry.getRegistry().getRegisteredMimeTypes());
        arrayList.add(MimeTypeConstants.MIME_TYPES_SVG);
        InputStream inputStream = parsedURL.openStream(arrayList.iterator());
        return new ProtectedStream(inputStream);
    }

    protected GraphicsNode instantiateGraphicsNode() {
        return new ImageNode();
    }

    public boolean isComposite() {
        return false;
    }

    protected void initializeDynamicSupport(BridgeContext bridgeContext, Element element, GraphicsNode graphicsNode) {
        if (!bridgeContext.isInteractive()) {
            return;
        }
        ImageNode imageNode = (ImageNode)graphicsNode;
        bridgeContext.bind(element, graphicsNode);
        if (bridgeContext.isDynamic()) {
            this.e = element;
            this.node = graphicsNode;
            this.ctx = bridgeContext;
            ((SVGOMElement)element).setSVGContext(this);
        }
    }

    public void handleDOMAttrModifiedEvent(MutationEvent mutationEvent) {
        String string = mutationEvent.getAttrName();
        Node node = mutationEvent.getRelatedNode();
        if (string.equals("x") || string.equals("y") || string.equals("preserveAspectRatio")) {
            this.updateImageBounds();
        } else if ("http://www.w3.org/1999/xlink".equals(node.getNamespaceURI()) && "href".equals(node.getLocalName())) {
            this.rebuildImageNode();
        } else if (string.equals("width") || string.equals("height")) {
            float f = 0.0f;
            float f2 = 0.0f;
            String string2 = mutationEvent.getPrevValue();
            UnitProcessor.Context context = UnitProcessor.createContext(this.ctx, this.e);
            if (string2.length() != 0) {
                f = UnitProcessor.svgHorizontalCoordinateToUserSpace(string2, string, context);
            }
            if ((string2 = mutationEvent.getNewValue()).length() != 0) {
                f2 = UnitProcessor.svgHorizontalCoordinateToUserSpace(string2, string, context);
            }
            if (f == f2) {
                return;
            }
            if (f == 0.0f || f2 == 0.0f) {
                this.rebuildImageNode();
            } else {
                this.updateImageBounds();
            }
        } else {
            super.handleDOMAttrModifiedEvent(mutationEvent);
        }
    }

    protected void updateImageBounds() {
        Rectangle2D rectangle2D = SVGImageElementBridge.getImageBounds(this.ctx, this.e);
        GraphicsNode graphicsNode = ((ImageNode)this.node).getImage();
        float[] fArray = null;
        if (graphicsNode instanceof RasterImageNode) {
            Rectangle2D rectangle2D2 = ((RasterImageNode)graphicsNode).getImageBounds();
            fArray = new float[]{0.0f, 0.0f, (float)rectangle2D2.getWidth(), (float)rectangle2D2.getHeight()};
        } else if (this.imgDocument != null) {
            SVGSVGElement sVGSVGElement = this.imgDocument.getRootElement();
            String string = sVGSVGElement.getAttributeNS(null, "viewBox");
            fArray = ViewBox.parseViewBoxAttribute(this.e, string);
        }
        if (graphicsNode != null) {
            SVGImageElementBridge.initializeViewport(this.ctx, this.e, graphicsNode, fArray, rectangle2D);
        }
    }

    protected void rebuildImageNode() {
        Object object;
        if (this.imgDocument != null && this.listener != null) {
            object = this.imgDocument.getRootElement();
            object.removeEventListener("click", this.listener, false);
            object.removeEventListener("keydown", this.listener, false);
            object.removeEventListener("keypress", this.listener, false);
            object.removeEventListener("keyup", this.listener, false);
            object.removeEventListener("mousedown", this.listener, false);
            object.removeEventListener("mousemove", this.listener, false);
            object.removeEventListener("mouseout", this.listener, false);
            object.removeEventListener("mouseover", this.listener, false);
            object.removeEventListener("mouseup", this.listener, false);
            this.listener = null;
        }
        if (this.imgDocument != null) {
            object = this.imgDocument.getRootElement();
            AbstractGraphicsNodeBridge.disposeTree((Node)object);
        }
        this.imgDocument = null;
        this.subCtx = null;
        object = this.buildImageGraphicsNode(this.ctx, this.e);
        ImageNode imageNode = (ImageNode)this.node;
        imageNode.setImage((GraphicsNode)object);
        if (object == null) {
            String string = XLinkSupport.getXLinkHref(this.e);
            throw new BridgeException(this.e, "uri.image.invalid", new Object[]{string});
        }
    }

    protected void handleCSSPropertyChanged(int n) {
        switch (n) {
            case 6: 
            case 30: {
                RenderingHints renderingHints = CSSUtilities.convertImageRendering(this.e, null);
                renderingHints = CSSUtilities.convertColorRendering(this.e, renderingHints);
                if (renderingHints == null) break;
                this.node.setRenderingHints(renderingHints);
                break;
            }
            default: {
                super.handleCSSPropertyChanged(n);
            }
        }
    }

    protected GraphicsNode createRasterImageNode(BridgeContext bridgeContext, Element element, Filter filter) {
        Rectangle2D rectangle2D = SVGImageElementBridge.getImageBounds(bridgeContext, element);
        if (rectangle2D.getWidth() == 0.0 || rectangle2D.getHeight() == 0.0) {
            ShapeNode shapeNode = new ShapeNode();
            shapeNode.setShape(rectangle2D);
            return shapeNode;
        }
        Object object = filter.getProperty("org.apache.batik.bridge.BrokenLinkDocument");
        if (object != null && object instanceof SVGDocument) {
            SVGOMDocument sVGOMDocument = (SVGOMDocument)object;
            return this.createSVGImageNode(bridgeContext, element, sVGOMDocument);
        }
        RasterImageNode rasterImageNode = new RasterImageNode();
        rasterImageNode.setImage(filter);
        Rectangle2D rectangle2D2 = filter.getBounds2D();
        float[] fArray = new float[]{0.0f, 0.0f, (float)rectangle2D2.getWidth(), (float)rectangle2D2.getHeight()};
        SVGImageElementBridge.initializeViewport(bridgeContext, element, rasterImageNode, fArray, rectangle2D);
        return rasterImageNode;
    }

    protected GraphicsNode createSVGImageNode(BridgeContext bridgeContext, Element element, SVGDocument sVGDocument) {
        CSSEngine cSSEngine = ((SVGOMDocument)sVGDocument).getCSSEngine();
        if (cSSEngine != null) {
            this.subCtx = (BridgeContext)cSSEngine.getCSSContext();
        } else {
            this.subCtx = new BridgeContext(bridgeContext.getUserAgent(), bridgeContext.getDocumentLoader());
            this.subCtx.setGVTBuilder(bridgeContext.getGVTBuilder());
            this.subCtx.setDocument(sVGDocument);
            this.subCtx.initializeDocument(sVGDocument);
        }
        CompositeGraphicsNode compositeGraphicsNode = new CompositeGraphicsNode();
        Rectangle2D rectangle2D = SVGImageElementBridge.getImageBounds(bridgeContext, element);
        if (rectangle2D.getWidth() == 0.0 || rectangle2D.getHeight() == 0.0) {
            ShapeNode shapeNode = new ShapeNode();
            shapeNode.setShape(rectangle2D);
            compositeGraphicsNode.getChildren().add(shapeNode);
            return compositeGraphicsNode;
        }
        Rectangle2D rectangle2D2 = CSSUtilities.convertEnableBackground(element);
        if (rectangle2D2 != null) {
            compositeGraphicsNode.setBackgroundEnable(rectangle2D2);
        }
        SVGSVGElement sVGSVGElement = sVGDocument.getRootElement();
        CanvasGraphicsNode canvasGraphicsNode = (CanvasGraphicsNode)this.subCtx.getGVTBuilder().build(this.subCtx, sVGSVGElement);
        if (cSSEngine == null) {
            this.subCtx.addUIEventListeners(sVGDocument);
        }
        canvasGraphicsNode.setClip(null);
        canvasGraphicsNode.setViewingTransform(new AffineTransform());
        compositeGraphicsNode.getChildren().add(canvasGraphicsNode);
        String string = sVGSVGElement.getAttributeNS(null, "viewBox");
        float[] fArray = ViewBox.parseViewBoxAttribute(element, string);
        SVGImageElementBridge.initializeViewport(bridgeContext, element, compositeGraphicsNode, fArray, rectangle2D);
        if (bridgeContext.isInteractive()) {
            this.listener = new ForwardEventListener(sVGSVGElement, element);
            SVGSVGElement sVGSVGElement2 = sVGSVGElement;
            sVGSVGElement2.addEventListener("click", this.listener, false);
            this.subCtx.storeEventListener(sVGSVGElement2, "click", this.listener, false);
            sVGSVGElement2.addEventListener("keydown", this.listener, false);
            this.subCtx.storeEventListener(sVGSVGElement2, "keydown", this.listener, false);
            sVGSVGElement2.addEventListener("keypress", this.listener, false);
            this.subCtx.storeEventListener(sVGSVGElement2, "keypress", this.listener, false);
            sVGSVGElement2.addEventListener("keyup", this.listener, false);
            this.subCtx.storeEventListener(sVGSVGElement2, "keyup", this.listener, false);
            sVGSVGElement2.addEventListener("mousedown", this.listener, false);
            this.subCtx.storeEventListener(sVGSVGElement2, "mousedown", this.listener, false);
            sVGSVGElement2.addEventListener("mousemove", this.listener, false);
            this.subCtx.storeEventListener(sVGSVGElement2, "mousemove", this.listener, false);
            sVGSVGElement2.addEventListener("mouseout", this.listener, false);
            this.subCtx.storeEventListener(sVGSVGElement2, "mouseout", this.listener, false);
            sVGSVGElement2.addEventListener("mouseover", this.listener, false);
            this.subCtx.storeEventListener(sVGSVGElement2, "mouseover", this.listener, false);
            sVGSVGElement2.addEventListener("mouseup", this.listener, false);
            this.subCtx.storeEventListener(sVGSVGElement2, "mouseup", this.listener, false);
        }
        return compositeGraphicsNode;
    }

    public void dispose() {
        SVGSVGElement sVGSVGElement;
        if (this.imgDocument != null && this.listener != null) {
            sVGSVGElement = this.imgDocument.getRootElement();
            sVGSVGElement.removeEventListener("click", this.listener, false);
            sVGSVGElement.removeEventListener("keydown", this.listener, false);
            sVGSVGElement.removeEventListener("keypress", this.listener, false);
            sVGSVGElement.removeEventListener("keyup", this.listener, false);
            sVGSVGElement.removeEventListener("mousedown", this.listener, false);
            sVGSVGElement.removeEventListener("mousemove", this.listener, false);
            sVGSVGElement.removeEventListener("mouseout", this.listener, false);
            sVGSVGElement.removeEventListener("mouseover", this.listener, false);
            sVGSVGElement.removeEventListener("mouseup", this.listener, false);
            this.listener = null;
        }
        if (this.imgDocument != null) {
            sVGSVGElement = this.imgDocument.getRootElement();
            AbstractGraphicsNodeBridge.disposeTree(sVGSVGElement);
            this.imgDocument = null;
            this.subCtx = null;
        }
        super.dispose();
    }

    protected static void initializeViewport(BridgeContext bridgeContext, Element element, GraphicsNode graphicsNode, float[] fArray, Rectangle2D rectangle2D) {
        Object object;
        float f = (float)rectangle2D.getX();
        float f2 = (float)rectangle2D.getY();
        float f3 = (float)rectangle2D.getWidth();
        float f4 = (float)rectangle2D.getHeight();
        AffineTransform affineTransform = ViewBox.getPreserveAspectRatioTransform(element, fArray, f3, f4);
        affineTransform.preConcatenate(AffineTransform.getTranslateInstance(f, f2));
        graphicsNode.setTransform(affineTransform);
        Shape shape = null;
        if (CSSUtilities.convertOverflow(element)) {
            object = CSSUtilities.convertClip(element);
            shape = object == null ? new Rectangle2D.Float(f, f2, f3, f4) : new Rectangle2D.Float(f + object[3], f2 + object[0], f3 - object[1] - object[3], f4 - object[2] - object[0]);
        }
        if (shape != null) {
            try {
                affineTransform = affineTransform.createInverse();
                object = graphicsNode.getGraphicsNodeRable(true);
                shape = affineTransform.createTransformedShape(shape);
                graphicsNode.setClip(new ClipRable8Bit((Filter)object, shape));
            }
            catch (NoninvertibleTransformException noninvertibleTransformException) {
                // empty catch block
            }
        }
    }

    protected static ICCColorSpaceExt extractColorSpace(Element element, BridgeContext bridgeContext) {
        SVGColorProfileElementBridge sVGColorProfileElementBridge;
        String string = CSSUtilities.getComputedStyle(element, 8).getStringValue();
        ICCColorSpaceExt iCCColorSpaceExt = null;
        if ("srgb".equalsIgnoreCase(string)) {
            iCCColorSpaceExt = new ICCColorSpaceExt(ICC_Profile.getInstance(1000), 4);
        } else if (!"auto".equalsIgnoreCase(string) && !"".equalsIgnoreCase(string) && (sVGColorProfileElementBridge = (SVGColorProfileElementBridge)bridgeContext.getBridge("http://www.w3.org/2000/svg", "color-profile")) != null) {
            iCCColorSpaceExt = sVGColorProfileElementBridge.createICCColorSpaceExt(bridgeContext, element, string);
        }
        return iCCColorSpaceExt;
    }

    protected static Rectangle2D getImageBounds(BridgeContext bridgeContext, Element element) {
        UnitProcessor.Context context = UnitProcessor.createContext(bridgeContext, element);
        String string = element.getAttributeNS(null, "x");
        float f = 0.0f;
        if (string.length() != 0) {
            f = UnitProcessor.svgHorizontalCoordinateToUserSpace(string, "x", context);
        }
        string = element.getAttributeNS(null, "y");
        float f2 = 0.0f;
        if (string.length() != 0) {
            f2 = UnitProcessor.svgVerticalCoordinateToUserSpace(string, "y", context);
        }
        if ((string = element.getAttributeNS(null, "width")).length() == 0) {
            throw new BridgeException(element, "attribute.missing", new Object[]{"width"});
        }
        float f3 = UnitProcessor.svgHorizontalLengthToUserSpace(string, "width", context);
        string = element.getAttributeNS(null, "height");
        if (string.length() == 0) {
            throw new BridgeException(element, "attribute.missing", new Object[]{"height"});
        }
        float f4 = UnitProcessor.svgVerticalLengthToUserSpace(string, "height", context);
        return new Rectangle2D.Float(f, f2, f3, f4);
    }

    GraphicsNode createBrokenImageNode(BridgeContext bridgeContext, Element element, String string) {
        String string2 = "<Unknown Element>";
        SVGDocument sVGDocument = null;
        if (element != null) {
            sVGDocument = (SVGDocument)element.getOwnerDocument();
            string2 = element.getLocalName();
        }
        String string3 = sVGDocument == null ? "<Unknown Document>" : sVGDocument.getURL();
        int n = bridgeContext.getDocumentLoader().getLineNumber(element);
        Object[] objectArray = new Object[]{string3, new Integer(n), string2, string};
        SVGDocument sVGDocument2 = brokenLinkProvider.getBrokenLinkDocument(this, "uri.io", objectArray);
        this.hitCheckChildren = true;
        return this.createSVGImageNode(bridgeContext, element, sVGDocument2);
    }

    static {
        ImageTagRegistry.setBrokenLinkProvider(brokenLinkProvider);
    }

    protected static class ForwardEventListener
    implements EventListener {
        protected Element svgElement;
        protected Element imgElement;

        public ForwardEventListener(Element element, Element element2) {
            this.svgElement = element;
            this.imgElement = element2;
        }

        public void handleEvent(Event event) {
            MouseEvent mouseEvent = (MouseEvent)event;
            MouseEvent mouseEvent2 = (MouseEvent)((DocumentEvent)((Object)this.imgElement.getOwnerDocument())).createEvent("MouseEvents");
            mouseEvent2.initMouseEvent(mouseEvent.getType(), mouseEvent.getBubbles(), mouseEvent.getCancelable(), mouseEvent.getView(), mouseEvent.getDetail(), mouseEvent.getScreenX(), mouseEvent.getScreenY(), mouseEvent.getClientX(), mouseEvent.getClientY(), mouseEvent.getCtrlKey(), mouseEvent.getAltKey(), mouseEvent.getShiftKey(), mouseEvent.getMetaKey(), mouseEvent.getButton(), (EventTarget)((Object)this.imgElement));
            ((EventTarget)((Object)this.imgElement)).dispatchEvent(mouseEvent2);
        }
    }

    public static class ProtectedStream
    extends BufferedInputStream {
        static final int BUFFER_SIZE = 8192;

        ProtectedStream(InputStream inputStream) {
            super(inputStream, 8192);
            super.mark(8192);
        }

        ProtectedStream(InputStream inputStream, int n) {
            super(inputStream, n);
            super.mark(n);
        }

        public boolean markSupported() {
            return false;
        }

        public void mark(int n) {
        }

        public void reset() throws IOException {
            throw new IOException("Reset unsupported");
        }

        public void retry() throws IOException {
            super.reset();
        }

        public void close() throws IOException {
        }

        public void release() {
            try {
                super.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

