/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.extension.svg;

import java.awt.geom.AffineTransform;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.renderable.RenderContext;
import org.apache.batik.ext.awt.image.LinearTransfer;
import org.apache.batik.ext.awt.image.TransferFunction;
import org.apache.batik.ext.awt.image.renderable.AbstractColorInterpolationRable;
import org.apache.batik.ext.awt.image.renderable.Filter;
import org.apache.batik.ext.awt.image.rendered.ComponentTransferRed;
import org.apache.batik.extension.svg.BatikHistogramNormalizationFilter;
import org.apache.batik.extension.svg.HistogramRed;

public class BatikHistogramNormalizationFilter8Bit
extends AbstractColorInterpolationRable
implements BatikHistogramNormalizationFilter {
    private float trim = 0.01f;
    protected int[] histo = null;
    protected float slope;
    protected float intercept;

    public void setSource(Filter filter) {
        this.init(filter, null);
    }

    public Filter getSource() {
        return (Filter)this.getSources().get(0);
    }

    public float getTrim() {
        return this.trim;
    }

    public void setTrim(float f) {
        this.trim = f;
        this.touch();
    }

    public BatikHistogramNormalizationFilter8Bit(Filter filter, float f) {
        this.setSource(filter);
        this.setTrim(f);
    }

    public void computeHistogram(RenderContext renderContext) {
        float f;
        if (this.histo != null) {
            return;
        }
        Filter filter = this.getSource();
        float f2 = 100.0f / filter.getWidth();
        if (f2 > (f = 100.0f / filter.getHeight())) {
            f2 = f;
        }
        AffineTransform affineTransform = AffineTransform.getScaleInstance(f2, f2);
        renderContext = new RenderContext(affineTransform, renderContext.getRenderingHints());
        RenderedImage renderedImage = this.getSource().createRendering(renderContext);
        this.histo = new HistogramRed(this.convertSourceCS(renderedImage)).getHistogram();
        int n = (int)((double)((float)(renderedImage.getWidth() * renderedImage.getHeight()) * this.trim) + 0.5);
        int n2 = 0;
        int n3 = 0;
        while (n3 < 255) {
            if ((n2 += this.histo[n3]) >= n) break;
            ++n3;
        }
        int n4 = n3;
        n2 = 0;
        n3 = 255;
        while (n3 > 0) {
            if ((n2 += this.histo[n3]) >= n) break;
            --n3;
        }
        int n5 = n3;
        this.slope = 255.0f / (float)(n5 - n4);
        this.intercept = this.slope * (float)(-n4) / 255.0f;
    }

    public RenderedImage createRendering(RenderContext renderContext) {
        RenderedImage renderedImage = this.getSource().createRendering(renderContext);
        if (renderedImage == null) {
            return null;
        }
        this.computeHistogram(renderContext);
        SampleModel sampleModel = renderedImage.getSampleModel();
        int n = sampleModel.getNumBands();
        TransferFunction[] transferFunctionArray = new TransferFunction[n];
        LinearTransfer linearTransfer = new LinearTransfer(this.slope, this.intercept);
        int n2 = 0;
        while (n2 < transferFunctionArray.length) {
            transferFunctionArray[n2] = linearTransfer;
            ++n2;
        }
        return new ComponentTransferRed(this.convertSourceCS(renderedImage), transferFunctionArray, null);
    }
}

