/*
 * Decompiled with CFR 0.152.
 */
package org.openide.explorer.propertysheet;

import java.beans.FeatureDescriptor;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyEditor;
import java.lang.reflect.InvocationTargetException;
import org.openide.explorer.propertysheet.ExPropertyModel;
import org.openide.explorer.propertysheet.PropUtils;
import org.openide.explorer.propertysheet.ProxyNode;
import org.openide.nodes.Node;

class NodePropertyModel
implements ExPropertyModel {
    private Node.Property prop;
    private Object[] beans;
    private PropertyChangeSupport sup = new PropertyChangeSupport(this);
    String beanName = null;

    public NodePropertyModel(Node.Property property, Object[] objectArray) {
        this.prop = property;
        this.beans = objectArray;
    }

    String getBeanName() {
        if (this.beans != null && this.beans.length == 1 && this.beans[0] instanceof Node.Property) {
            return ((Node.Property)this.beans[0]).getDisplayName();
        }
        return null;
    }

    public Object getValue() throws InvocationTargetException {
        try {
            return this.prop.getValue();
        }
        catch (IllegalAccessException illegalAccessException) {
            throw this.annotateException(illegalAccessException);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw this.annotateException(invocationTargetException);
        }
        catch (ProxyNode.DifferentValuesException differentValuesException) {
            return null;
        }
    }

    public void setValue(Object object) throws InvocationTargetException {
        try {
            this.prop.setValue(object);
            this.sup.firePropertyChange("value", null, null);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw this.annotateException(illegalAccessException);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw this.annotateException(illegalArgumentException);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw this.annotateException(invocationTargetException);
        }
    }

    private InvocationTargetException annotateException(Exception exception) {
        if (exception instanceof InvocationTargetException) {
            return (InvocationTargetException)exception;
        }
        return new InvocationTargetException(exception);
    }

    public Class getPropertyType() {
        return this.prop.getValueType();
    }

    public Class getPropertyEditorClass() {
        PropertyEditor propertyEditor = this.prop.getPropertyEditor();
        if (propertyEditor != null) {
            return propertyEditor.getClass();
        }
        return null;
    }

    public PropertyEditor getPropertyEditor() {
        return PropUtils.getPropertyEditor(this.prop);
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.sup.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.sup.removePropertyChangeListener(propertyChangeListener);
    }

    public Object[] getBeans() {
        return this.beans;
    }

    public FeatureDescriptor getFeatureDescriptor() {
        return this.prop;
    }

    void fireValueChanged() {
        this.sup.firePropertyChange("value", null, null);
    }

    Node.Property getProperty() {
        return this.prop;
    }
}

