/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.mimelookup.impl;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Logger;
import org.openide.filesystems.FileAttributeEvent;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.MultiFileSystem;
import org.openide.filesystems.Repository;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CompoundFolderChildren
implements FileChangeListener {
    public static final String PROP_CHILDREN = "FolderChildren.PROP_CHILDREN";
    private static final String HIDDEN_ATTR_NAME = "hidden";
    private static final Logger LOG = Logger.getLogger(CompoundFolderChildren.class.getName());
    private final String LOCK = new String("CompoundFolderChildren.LOCK");
    private final List<String> prefixes;
    private final boolean includeSubfolders;
    private List<FileObject> children;
    private FileObject mergedLayers;
    private final FileChangeListener weakFCL = FileUtil.weakFileChangeListener((FileChangeListener)this, null);
    private PropertyChangeSupport pcs = new PropertyChangeSupport(this);

    public CompoundFolderChildren(String[] stringArray) {
        this(stringArray, true);
    }

    public CompoundFolderChildren(String[] stringArray, boolean bl) {
        this.prefixes = new ArrayList<String>();
        for (String string : stringArray) {
            this.prefixes.add(string.endsWith("/") ? string : string + "/");
        }
        this.includeSubfolders = bl;
        this.rebuild();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<FileObject> getChildren() {
        String string = this.LOCK;
        synchronized (string) {
            return this.children;
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.pcs.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.pcs.removePropertyChangeListener(propertyChangeListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void rebuild() {
        PropertyChangeEvent propertyChangeEvent = null;
        String string = this.LOCK;
        synchronized (string) {
            Object object2;
            ArrayList<FileObject> arrayList = new ArrayList<FileObject>(this.prefixes.size());
            ArrayList<1> arrayList2 = new ArrayList<1>(this.prefixes.size());
            FileSystem fileSystem = Repository.getDefault().getDefaultFileSystem();
            for (final String object22 : this.prefixes) {
                FileObject fileObject = fileSystem.findResource(object22);
                if (fileObject != null && fileObject.isFolder()) {
                    arrayList.add(fileObject);
                    arrayList2.add(new MultiFileSystem(new FileSystem[]{fileSystem}){

                        protected FileObject findResourceOn(FileSystem fileSystem, String string) {
                            return fileSystem.findResource(object22 + string);
                        }
                    });
                    continue;
                }
                String string2 = object22;
                do {
                    assert (string2.length() > 0);
                } while ((object2 = fileSystem.findResource(string2 = string2.substring(0, Math.max(0, string2.lastIndexOf(47))))) == null);
                object2.removeFileChangeListener(this.weakFCL);
                object2.addFileChangeListener(this.weakFCL);
            }
            this.mergedLayers = new MultiFileSystem(arrayList2.toArray(new FileSystem[arrayList2.size()])).getRoot();
            this.mergedLayers.addFileChangeListener((FileChangeListener)this);
            ArrayList arrayList3 = new ArrayList();
            for (Object object2 : this.mergedLayers.getChildren()) {
                if (!this.includeSubfolders && !object2.isData() || Boolean.TRUE.equals(object2.getAttribute(HIDDEN_ATTR_NAME))) continue;
                object2.addFileChangeListener((FileChangeListener)this);
                arrayList3.add(object2);
            }
            ArrayList<FileObject> arrayList4 = new ArrayList<FileObject>(arrayList3.size());
            for (FileObject fileObject : FileUtil.getOrder((Collection)arrayList3, (boolean)true)) {
                FileObject fileObject2;
                object2 = fileObject.getNameExt();
                FileObject fileObject3 = null;
                Iterator iterator = arrayList.iterator();
                while (iterator.hasNext() && (fileObject3 = (fileObject2 = (FileObject)iterator.next()).getFileObject((String)object2)) == null) {
                }
                assert (fileObject3 != null) : "Should have equivalent to " + (String)object2 + " among " + arrayList;
                arrayList4.add(fileObject3);
            }
            if (this.children != null && !((Object)arrayList4).equals(this.children)) {
                propertyChangeEvent = new PropertyChangeEvent(this, PROP_CHILDREN, this.children, arrayList4);
            }
            this.children = arrayList4;
        }
        if (propertyChangeEvent != null) {
            this.pcs.firePropertyChange(propertyChangeEvent);
        }
    }

    public void fileFolderCreated(FileEvent fileEvent) {
        this.rebuild();
    }

    public void fileDataCreated(FileEvent fileEvent) {
        this.rebuild();
    }

    public void fileChanged(FileEvent fileEvent) {
        this.pcs.firePropertyChange(PROP_CHILDREN, null, null);
    }

    public void fileDeleted(FileEvent fileEvent) {
        this.rebuild();
    }

    public void fileRenamed(FileRenameEvent fileRenameEvent) {
        this.rebuild();
    }

    public void fileAttributeChanged(FileAttributeEvent fileAttributeEvent) {
        if (FileUtil.affectsOrder((FileAttributeEvent)fileAttributeEvent)) {
            this.rebuild();
        }
    }
}

