/*
 * Decompiled with CFR 0.152.
 */
package tr.prefs.gui;

import au.com.trgtd.tr.appl.InitialAction;
import au.com.trgtd.tr.appl.InitialActionLookup;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import java.util.Collections;
import java.util.Vector;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import net.miginfocom.swing.MigLayout;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import tr.prefs.gui.GUIOptionsPanelController;
import tr.prefs.gui.GUIPrefs;

final class GUIOptionsPanel
extends JPanel {
    private final GUIOptionsPanelController controller;
    private static final Class clazz = GUIOptionsPanel.class;
    private static final String INITIAL_NONE = NbBundle.getMessage((Class)clazz, (String)"LBL_InitialWindowNone");
    private static final String TOP = NbBundle.getMessage((Class)clazz, (String)"LBL_Top");
    private static final String BOTTOM = NbBundle.getMessage((Class)clazz, (String)"LBL_Bottom");
    private static final String LEFT = NbBundle.getMessage((Class)clazz, (String)"LBL_Left");
    private static final String RIGHT = NbBundle.getMessage((Class)clazz, (String)"LBL_Right");
    private static Vector<ComboItem> actions;
    private static Vector<ComboItem> positions;
    private JComboBox buttonsPositionCombo;
    private JLabel buttonsPositionLabel;
    private JComboBox initialActionCombo;
    private JLabel initialActionLabel;

    GUIOptionsPanel(GUIOptionsPanelController controller) {
        this.controller = controller;
        this.initComponents();
        this.add((Component)this.getView(), "Center");
    }

    private JComponent getView() {
        this.initActions();
        this.initialActionLabel = new JLabel(this.getMsg("LBL_InitialWindow"));
        this.initialActionCombo = new JComboBox<ComboItem>(new DefaultComboBoxModel<ComboItem>(actions));
        this.initialActionCombo.setMaximumRowCount(actions.size());
        this.initialActionCombo.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                GUIOptionsPanel.this.controller.changed();
            }
        });
        this.initPositions();
        this.buttonsPositionLabel = new JLabel(this.getMsg("LBL_ButtonsPosition"));
        this.buttonsPositionCombo = new JComboBox<ComboItem>(new DefaultComboBoxModel<ComboItem>(positions));
        this.buttonsPositionCombo.setMaximumRowCount(positions.size());
        this.buttonsPositionCombo.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                GUIOptionsPanel.this.controller.changed();
            }
        });
        JPanel panel = new JPanel((LayoutManager)new MigLayout("", "0[]2[]0", "0[]2[]0"));
        panel.add((Component)this.initialActionLabel, "align right");
        panel.add((Component)this.initialActionCombo, "align left, wrap");
        panel.add((Component)this.buttonsPositionLabel, "align right");
        panel.add((Component)this.buttonsPositionCombo, "align left, wrap");
        JScrollPane scrollPane = new JScrollPane(panel);
        scrollPane.setBorder(new EmptyBorder(0, 0, 0, 0));
        return scrollPane;
    }

    private String getMsg(String key) {
        return NbBundle.getMessage(this.getClass(), (String)key);
    }

    void load() {
        if (SwingUtilities.isEventDispatchThread()) {
            this.doLoad();
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    GUIOptionsPanel.this.doLoad();
                }
            });
        }
    }

    private void doLoad() {
        this.initialActionCombo.setSelectedItem(this.getActionItem(GUIPrefs.getInitialActionID()));
        this.buttonsPositionCombo.setSelectedItem(this.getPositionItem(GUIPrefs.getButtonsPosition()));
    }

    private void initActions() {
        actions = new Vector();
        actions.add(new ComboItem(INITIAL_NONE, "none"));
        Lookup.Result r = InitialActionLookup.instance().lookup(new Lookup.Template(InitialAction.class));
        Collection c = r.allInstances();
        for (InitialAction action : c) {
            actions.add(new ComboItem(action.getName(), action.getID()));
        }
        Collections.sort(actions);
    }

    private void initPositions() {
        positions = new Vector();
        positions.add(new ComboItem(TOP, "top"));
        positions.add(new ComboItem(BOTTOM, "bottom"));
        positions.add(new ComboItem(LEFT, "left"));
        positions.add(new ComboItem(RIGHT, "right"));
    }

    void store() {
        ComboItem positionItem;
        ComboItem actionItem = (ComboItem)this.initialActionCombo.getSelectedItem();
        if (actionItem != null) {
            GUIPrefs.setInitialWindowID(actionItem.value);
        }
        if ((positionItem = (ComboItem)this.buttonsPositionCombo.getSelectedItem()) != null) {
            GUIPrefs.setButtonsPosition(positionItem.value);
        }
    }

    boolean valid() {
        return true;
    }

    private ComboItem getActionItem(String value) {
        for (ComboItem item : actions) {
            if (!item.value.equals(value)) continue;
            return item;
        }
        return actions.get(0);
    }

    private ComboItem getPositionItem(String value) {
        for (ComboItem item : positions) {
            if (!item.value.equals(value)) continue;
            return item;
        }
        return positions.get(0);
    }

    private void initComponents() {
        this.setMinimumSize(new Dimension(0, 0));
        this.setLayout(new BorderLayout());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class ComboItem
    implements Comparable<ComboItem> {
        public String label;
        public String value;

        public ComboItem(String label, String value) {
            this.label = label;
            this.value = value;
        }

        public String toString() {
            return this.label;
        }

        @Override
        public int compareTo(ComboItem item) {
            if (this.value.equals("none")) {
                return -1;
            }
            return this.toString().compareToIgnoreCase(item.toString());
        }
    }
}

