/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.quicksearch;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.FontMetrics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.lang.ref.WeakReference;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.modules.quicksearch.CategoryResult;
import org.netbeans.modules.quicksearch.CommandEvaluator;
import org.netbeans.modules.quicksearch.ProviderModel;
import org.netbeans.modules.quicksearch.QuickSearchPopup;
import org.netbeans.modules.quicksearch.ResultsModel;
import org.netbeans.modules.quicksearch.SearchResultRender;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import org.openide.windows.TopComponent;

public class QuickSearchComboBar
extends JPanel
implements ActionListener {
    private static final String CATEGORY = "cat";
    QuickSearchPopup displayer = new QuickSearchPopup(this);
    WeakReference<TopComponent> caller;
    Color origForeground;
    private KeyStroke keyStroke;
    private JTextArea command;
    private JLabel jLabel2;
    private JPanel jPanel1;
    private JScrollPane jScrollPane1;
    private JSeparator jSeparator1;

    public QuickSearchComboBar(KeyStroke keyStroke) {
        this.keyStroke = keyStroke;
        this.initComponents();
        this.setShowHint(true);
        this.command.getDocument().addDocumentListener(new DocumentListener(){

            public void insertUpdate(DocumentEvent documentEvent) {
                this.textChanged();
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                this.textChanged();
            }

            public void changedUpdate(DocumentEvent documentEvent) {
                this.textChanged();
            }

            private void textChanged() {
                if (QuickSearchComboBar.this.command.isFocusOwner()) {
                    QuickSearchComboBar.this.displayer.maybeEvaluate(QuickSearchComboBar.this.command.getText());
                }
            }
        });
    }

    KeyStroke getKeyStroke() {
        return this.keyStroke;
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.jLabel2 = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.command = new DynamicWidthTA();
        this.jSeparator1 = new JSeparator();
        this.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.setMaximumSize(new Dimension(200, Integer.MAX_VALUE));
        this.setName("Form");
        this.setOpaque(false);
        this.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent focusEvent) {
                QuickSearchComboBar.this.formFocusLost(focusEvent);
            }
        });
        this.setLayout(new FlowLayout(1, 0, 0));
        this.jPanel1.setBackground(QuickSearchComboBar.getTextBackground());
        this.jPanel1.setBorder(BorderFactory.createLineBorder(QuickSearchComboBar.getComboBorderColor()));
        this.jPanel1.setName("jPanel1");
        this.jPanel1.setLayout(new GridBagLayout());
        this.jLabel2.setIcon(new ImageIcon(this.getClass().getResource("/org/netbeans/modules/quicksearch/resources/find.png")));
        this.jLabel2.setToolTipText(NbBundle.getMessage(QuickSearchComboBar.class, (String)"QuickSearchComboBar.jLabel2.toolTipText"));
        this.jLabel2.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.jLabel2.setName("jLabel2");
        this.jLabel2.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                QuickSearchComboBar.this.jLabel2MousePressed(mouseEvent);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(1, 2, 1, 1);
        this.jPanel1.add((Component)this.jLabel2, gridBagConstraints);
        this.jScrollPane1.setBorder(null);
        this.jScrollPane1.setHorizontalScrollBarPolicy(31);
        this.jScrollPane1.setVerticalScrollBarPolicy(21);
        this.jScrollPane1.setViewportBorder(null);
        this.jScrollPane1.setMinimumSize(new Dimension(2, 18));
        this.jScrollPane1.setName("jScrollPane1");
        this.command.setRows(1);
        this.command.setToolTipText(NbBundle.getMessage(QuickSearchComboBar.class, (String)"QuickSearchComboBar.command.toolTipText", (Object[])new Object[]{"(" + SearchResultRender.getKeyStrokeAsText(this.keyStroke) + ")"}));
        this.command.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.command.setName("command");
        this.command.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent focusEvent) {
                QuickSearchComboBar.this.commandFocusGained(focusEvent);
            }

            public void focusLost(FocusEvent focusEvent) {
                QuickSearchComboBar.this.commandFocusLost(focusEvent);
            }
        });
        this.command.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                QuickSearchComboBar.this.commandKeyPressed(keyEvent);
            }
        });
        this.jScrollPane1.setViewportView(this.command);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 2);
        this.jPanel1.add((Component)this.jScrollPane1, gridBagConstraints);
        this.jSeparator1.setOrientation(1);
        this.jSeparator1.setName("jSeparator1");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 3;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(3, 0, 3, 3);
        this.jPanel1.add((Component)this.jSeparator1, gridBagConstraints);
        this.add(this.jPanel1);
    }

    private void formFocusLost(FocusEvent focusEvent) {
        this.displayer.setVisible(false);
    }

    private void commandKeyPressed(KeyEvent keyEvent) {
        if (keyEvent.getKeyCode() == 40) {
            this.displayer.selectNext();
            keyEvent.consume();
        } else if (keyEvent.getKeyCode() == 38) {
            this.displayer.selectPrev();
            keyEvent.consume();
        } else if (keyEvent.getKeyCode() == 10) {
            keyEvent.consume();
            this.invokeSelectedItem();
        } else if (keyEvent.getKeyCode() == 27) {
            this.returnFocus();
            this.displayer.clearModel();
        } else if (keyEvent.getKeyCode() == 121 && keyEvent.isShiftDown()) {
            this.maybeShowPopup(null);
        }
    }

    private void jLabel2MousePressed(MouseEvent mouseEvent) {
        this.maybeShowPopup(mouseEvent);
    }

    public void invokeSelectedItem() {
        Runnable runnable;
        JList jList = this.displayer.getList();
        ResultsModel.ItemResult itemResult = (ResultsModel.ItemResult)jList.getSelectedValue();
        if (itemResult != null && (runnable = itemResult.getAction()) instanceof CategoryResult) {
            CategoryResult categoryResult = (CategoryResult)runnable;
            this.evaluateCategory(categoryResult.getCategory(), true);
            return;
        }
        if (jList.getModel().getSize() > 0) {
            this.returnFocus();
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    QuickSearchComboBar.this.displayer.invoke();
                }
            });
        }
    }

    private void returnFocus() {
        TopComponent topComponent;
        this.displayer.setVisible(false);
        if (this.caller != null && (topComponent = (TopComponent)this.caller.get()) != null) {
            topComponent.requestActive();
            topComponent.requestFocus();
        }
    }

    private void commandFocusLost(FocusEvent focusEvent) {
        this.displayer.setVisible(false);
        this.setShowHint(true);
    }

    private void commandFocusGained(FocusEvent focusEvent) {
        this.setShowHint(false);
        if (CommandEvaluator.isCatTemporary()) {
            CommandEvaluator.setCatTemporary(false);
            CommandEvaluator.setEvalCat(null);
        }
    }

    private void maybeShowPopup(MouseEvent mouseEvent) {
        if (mouseEvent != null && !SwingUtilities.isLeftMouseButton(mouseEvent)) {
            return;
        }
        JPopupMenu jPopupMenu = new JPopupMenu();
        ProviderModel.Category category = null;
        if (!CommandEvaluator.isCatTemporary()) {
            category = CommandEvaluator.getEvalCat();
        }
        JRadioButtonMenuItem jRadioButtonMenuItem = new JRadioButtonMenuItem(NbBundle.getMessage(this.getClass(), (String)"LBL_AllCategories"), category == null);
        jRadioButtonMenuItem.addActionListener(this);
        jPopupMenu.add(jRadioButtonMenuItem);
        for (ProviderModel.Category category2 : ProviderModel.getInstance().getCategories()) {
            if ("Recent".equals(category2.getName())) continue;
            JRadioButtonMenuItem jRadioButtonMenuItem2 = new JRadioButtonMenuItem(category2.getDisplayName(), category2 == category);
            jRadioButtonMenuItem2.putClientProperty(CATEGORY, category2);
            jRadioButtonMenuItem2.addActionListener(this);
            jPopupMenu.add(jRadioButtonMenuItem2);
        }
        jPopupMenu.show(this.jPanel1, 0, this.jPanel1.getHeight() - 1);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        JRadioButtonMenuItem jRadioButtonMenuItem = (JRadioButtonMenuItem)actionEvent.getSource();
        CommandEvaluator.setEvalCat((ProviderModel.Category)jRadioButtonMenuItem.getClientProperty(CATEGORY));
        CommandEvaluator.setCatTemporary(false);
        this.setShowHint(!this.command.isFocusOwner());
    }

    public void evaluateCategory(ProviderModel.Category category, boolean bl) {
        CommandEvaluator.setEvalCat(category);
        CommandEvaluator.setCatTemporary(bl);
        this.displayer.maybeEvaluate(this.command.getText());
    }

    public void setNoResults(boolean bl) {
        if (this.command == null || this.origForeground == null) {
            return;
        }
        if (this.command.getForeground().equals(this.command.getDisabledTextColor())) {
            return;
        }
        this.command.setForeground(bl ? Color.RED : this.origForeground);
    }

    private void setShowHint(boolean bl) {
        if (this.origForeground == null) {
            this.origForeground = this.command.getForeground();
        }
        if (bl) {
            this.command.setForeground(this.command.getDisabledTextColor());
            ProviderModel.Category category = CommandEvaluator.getEvalCat();
            if (category != null && !CommandEvaluator.isCatTemporary()) {
                this.command.setText(this.getHintText(category));
            } else {
                this.command.setText(this.getHintText(null));
            }
        } else {
            this.command.setForeground(this.origForeground);
            this.command.setText("");
        }
    }

    private String getHintText(ProviderModel.Category category) {
        StringBuilder stringBuilder = new StringBuilder();
        if (category != null) {
            stringBuilder.append(NbBundle.getMessage(QuickSearchComboBar.class, (String)"MSG_DiscoverabilityHint2", (Object)category.getDisplayName()));
        } else {
            stringBuilder.append(NbBundle.getMessage(QuickSearchComboBar.class, (String)"MSG_DiscoverabilityHint"));
        }
        stringBuilder.append(" (");
        stringBuilder.append(SearchResultRender.getKeyStrokeAsText(this.keyStroke));
        stringBuilder.append(")");
        return stringBuilder.toString();
    }

    public void requestFocus() {
        this.caller = new WeakReference<TopComponent>(TopComponent.getRegistry().getActivated());
        super.requestFocus();
        this.command.requestFocus();
    }

    JTextArea getCommand() {
        return this.command;
    }

    int getBottomLineY() {
        return this.jPanel1.getY() + this.jPanel1.getHeight();
    }

    static Color getComboBorderColor() {
        Color color = UIManager.getColor(Utilities.isWindows() ? "Nb.ScrollPane.Border.color" : "TextField.shadow");
        return color != null ? color : QuickSearchComboBar.getPopupBorderColor();
    }

    static Color getPopupBorderColor() {
        Color color = UIManager.getColor("controlShadow");
        return color != null ? color : Color.GRAY;
    }

    static Color getTextBackground() {
        Color color = UIManager.getColor("TextPane.background");
        return color != null ? color : Color.WHITE;
    }

    static Color getResultBackground() {
        return QuickSearchComboBar.getTextBackground();
    }

    static Color getCategoryTextColor() {
        Color color = UIManager.getColor("textInactiveText");
        return color != null ? color : Color.DARK_GRAY;
    }

    private int computePrefWidth() {
        FontMetrics fontMetrics = this.command.getFontMetrics(this.command.getFont());
        ProviderModel providerModel = ProviderModel.getInstance();
        int n = 0;
        for (ProviderModel.Category category : providerModel.getCategories()) {
            if ("Recent".equals(category.getName())) continue;
            n = Math.max(n, fontMetrics.stringWidth(this.getHintText(category)));
        }
        return Math.min(350, n);
    }

    private final class DynamicWidthTA
    extends JTextArea {
        private Dimension prefWidth;

        private DynamicWidthTA() {
        }

        public Dimension getPreferredSize() {
            if (this.prefWidth == null) {
                Dimension dimension = super.getPreferredSize();
                this.prefWidth = new Dimension(QuickSearchComboBar.this.computePrefWidth(), dimension.height);
            }
            return this.prefWidth;
        }
    }
}

