/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.quicksearch;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Date;
import java.util.List;
import javax.swing.AbstractListModel;
import javax.swing.KeyStroke;
import javax.swing.Timer;
import org.netbeans.modules.quicksearch.CategoryResult;
import org.netbeans.spi.quicksearch.SearchRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ResultsModel
extends AbstractListModel
implements ActionListener {
    private static ResultsModel instance;
    private List<? extends CategoryResult> results;
    private Timer fireTimer;
    static final int COALESCE_TIME = 200;

    private ResultsModel() {
    }

    public static ResultsModel getInstance() {
        if (instance == null) {
            instance = new ResultsModel();
        }
        return instance;
    }

    public void setContent(List<? extends CategoryResult> list) {
        List<? extends CategoryResult> list2 = this.results;
        this.results = list;
        if (list2 != null) {
            for (CategoryResult categoryResult : list2) {
                categoryResult.setObsolete(true);
            }
        }
        this.maybeFireChanges();
    }

    public List<? extends CategoryResult> getContent() {
        return this.results;
    }

    @Override
    public int getSize() {
        if (this.results == null) {
            return 0;
        }
        int n = 0;
        for (CategoryResult categoryResult : this.results) {
            n += categoryResult.getItems().size();
        }
        return n;
    }

    @Override
    public Object getElementAt(int n) {
        if (this.results == null) {
            return null;
        }
        int n2 = n;
        int n3 = 0;
        List<ItemResult> list = null;
        for (CategoryResult categoryResult : this.results) {
            list = categoryResult.getItems();
            n3 = list.size();
            if (n2 < n3) {
                return n2 >= 0 ? list.get(n2) : null;
            }
            n2 -= n3;
        }
        return null;
    }

    void categoryChanged(CategoryResult categoryResult) {
        if (this.results != null && this.results.contains(categoryResult)) {
            this.maybeFireChanges();
        }
    }

    private void maybeFireChanges() {
        if (this.fireTimer == null) {
            this.fireTimer = new Timer(200, this);
        }
        if (!this.fireTimer.isRunning()) {
            this.fireTimer.start();
        } else {
            this.fireTimer.restart();
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        this.fireTimer.stop();
        this.fireContentsChanged(this, 0, this.getSize());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class ItemResult {
        private static final String HTML = "<html>";
        private CategoryResult category;
        private Runnable action;
        private String displayName;
        private List<? extends KeyStroke> shortcut;
        private String displayHint;
        private Date date;

        public ItemResult(CategoryResult categoryResult, SearchRequest searchRequest, Runnable runnable, String string) {
            this(categoryResult, searchRequest, runnable, string, null, null);
        }

        public ItemResult(CategoryResult categoryResult, Runnable runnable, String string, Date date) {
            this(categoryResult, null, runnable, string, null, null);
            this.date = date;
        }

        public ItemResult(CategoryResult categoryResult, SearchRequest searchRequest, Runnable runnable, String string, List<? extends KeyStroke> list, String string2) {
            this.category = categoryResult;
            this.action = runnable;
            this.displayName = searchRequest != null ? this.highlightSubstring(string, searchRequest) : string;
            this.shortcut = list;
            this.displayHint = string2;
        }

        public Runnable getAction() {
            return this.action;
        }

        public Date getDate() {
            return this.date;
        }

        public void setDate(Date date) {
            this.date = date;
        }

        public String getDisplayName() {
            return this.displayName;
        }

        public String getDisplayHint() {
            return this.displayHint;
        }

        public List<? extends KeyStroke> getShortcut() {
            return this.shortcut;
        }

        public CategoryResult getCategory() {
            return this.category;
        }

        private String highlightSubstring(String string, SearchRequest searchRequest) {
            if (string.startsWith(HTML)) {
                return string;
            }
            String string2 = searchRequest.getText();
            int n = string.toLowerCase().indexOf(string2.toLowerCase());
            if (n == -1) {
                return string;
            }
            int n2 = n + string2.length();
            StringBuilder stringBuilder = new StringBuilder(HTML);
            if (n > 0) {
                stringBuilder.append(string.substring(0, n));
            }
            stringBuilder.append("<b>");
            stringBuilder.append(string.substring(n, n2));
            stringBuilder.append("</b>");
            if (n2 < string.length()) {
                stringBuilder.append(string.substring(n2, string.length()));
            }
            return stringBuilder.toString();
        }
    }
}

