/*
 * Decompiled with CFR 0.152.
 */
package ca.odell.glazedlists.swing;

import ca.odell.glazedlists.calculation.Calculation;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.Format;
import javax.swing.JLabel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SwingCalculations {
    private SwingCalculations() {
    }

    public static void bind(JLabel label, Calculation calculation) {
        SwingCalculations.bind(label, calculation, null);
    }

    public static void bind(JLabel label, Calculation<? extends Number> calculation, Format formatter) {
        calculation.addPropertyChangeListener(new CalculationToLabelBinder(label, formatter, calculation.getValue()));
    }

    private static final class CalculationToLabelBinder
    implements PropertyChangeListener {
        private final JLabel label;
        private final Format formatter;

        private CalculationToLabelBinder(JLabel label, Format formatter, Number initialValue) {
            this.label = label;
            this.formatter = formatter;
            this.update(initialValue);
        }

        private void update(Number value) {
            String text = this.formatter == null ? (CalculationToLabelBinder.isNumberFormattable(value) ? String.valueOf(value) : "") : this.formatter.format(value);
            this.label.setText(text);
        }

        private static boolean isNumberFormattable(Number n) {
            return n != null && !n.equals(new Float(Float.NaN)) && !n.equals(new Double(Double.NaN));
        }

        public void propertyChange(PropertyChangeEvent evt) {
            this.update((Number)evt.getNewValue());
        }
    }
}

