/*
 * Decompiled with CFR 0.152.
 */
package org.openide.explorer.view;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.WeakHashMap;
import javax.swing.event.TableModelEvent;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.netbeans.swing.outline.Outline;
import org.netbeans.swing.outline.RowModel;
import org.openide.ErrorManager;
import org.openide.explorer.view.Visualizer;
import org.openide.nodes.Node;
import org.openide.util.WeakListeners;

class PropertiesRowModel
implements RowModel {
    private Node.Property[] prop = new Node.Property[0];
    private Outline outline;
    private WeakHashMap nodesListenersCache = new WeakHashMap();
    private PropertyChangeListener pcl = new PropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            int n = PropertiesRowModel.this.rowForNode((Node)propertyChangeEvent.getSource());
            if (n == -1) {
                return;
            }
            int n2 = PropertiesRowModel.this.columnForProperty(propertyChangeEvent.getPropertyName());
            if (n2 == -1) {
                PropertiesRowModel.this.outline.tableChanged(new TableModelEvent(PropertiesRowModel.this.outline.getModel(), n, n, -1, 0));
            } else {
                PropertiesRowModel.this.outline.tableChanged(new TableModelEvent(PropertiesRowModel.this.outline.getModel(), n, n, n2 + 1, 0));
            }
        }
    };

    public void setOutline(Outline outline) {
        this.outline = outline;
    }

    private int rowForNode(Node node) {
        TreeNode treeNode = Visualizer.findVisualizer(node);
        if (treeNode != null) {
            ArrayList<TreeNode> arrayList = new ArrayList<TreeNode>();
            while (treeNode != null) {
                arrayList.add(treeNode);
                treeNode = treeNode.getParent();
            }
            Collections.reverse(arrayList);
            TreePath treePath = new TreePath(arrayList.toArray());
            int n = this.outline.getLayoutCache().getRowForPath(treePath);
            return n;
        }
        return -1;
    }

    public Class getColumnClass(int n) {
        return Node.Property.class;
    }

    public int getColumnCount() {
        return this.prop.length;
    }

    public String getColumnName(int n) {
        return this.prop[n].getDisplayName();
    }

    public Object getValueFor(Object object, int n) {
        PropertyChangeListener propertyChangeListener;
        Node node = Visualizer.findNode(object);
        if (node == null) {
            throw new IllegalStateException("TreeNode must be VisualizerNode but was: " + object + " of class " + object.getClass().getName());
        }
        PropertyChangeListener propertyChangeListener2 = (PropertyChangeListener)this.nodesListenersCache.get(node);
        if (propertyChangeListener2 == null) {
            propertyChangeListener = WeakListeners.propertyChange((PropertyChangeListener)this.pcl, (Object)node);
            this.nodesListenersCache.put(node, propertyChangeListener);
            node.addPropertyChangeListener(propertyChangeListener);
        }
        propertyChangeListener = this.getPropertyFor(node, this.prop[n]);
        return propertyChangeListener;
    }

    public boolean isCellEditable(Object object, int n) {
        Node node = Visualizer.findNode(object);
        if (node == null) {
            throw new IllegalStateException("TreeNode must be VisualizerNode but was: " + object + " of class " + object.getClass().getName());
        }
        Node.Property property = this.getPropertyFor(node, this.prop[n]);
        if (property != null) {
            return property.canWrite();
        }
        return false;
    }

    protected Node.Property getPropertyFor(Node node, Node.Property property) {
        Node.PropertySet[] propertySetArray = node.getPropertySets();
        for (int i = 0; i < propertySetArray.length; ++i) {
            Node.Property[] propertyArray = propertySetArray[i].getProperties();
            for (int j = 0; j < propertyArray.length; ++j) {
                if (!property.equals((Object)propertyArray[j])) continue;
                return propertyArray[j];
            }
        }
        return null;
    }

    public void setValueFor(Object object, int n, Object object2) {
    }

    public void setProperties(Node.Property[] propertyArray) {
        this.prop = propertyArray;
    }

    public static Object getValueFromProperty(Object object) {
        if (object instanceof Node.Property) {
            Node.Property property = (Node.Property)object;
            try {
                return property.getValue();
            }
            catch (Exception exception) {
                ErrorManager.getDefault().getInstance(PropertiesRowModel.class.getName()).notify(1, (Throwable)exception);
            }
        }
        return null;
    }

    private int columnForProperty(String string) {
        for (int i = 0; i < this.prop.length; ++i) {
            if (!this.prop[i].getName().equals(string)) continue;
            return i;
        }
        return -1;
    }

    public static void toggleBooleanProperty(Node.Property property) {
        if (property.getValueType() == Boolean.class || property.getValueType() == Boolean.TYPE) {
            if (!property.canWrite()) {
                return;
            }
            try {
                Boolean bl = (Boolean)property.getValue();
                if (Boolean.FALSE.equals(bl)) {
                    property.setValue((Object)Boolean.TRUE);
                } else {
                    property.setValue((Object)Boolean.FALSE);
                }
            }
            catch (Exception exception) {
                ErrorManager.getDefault().notify(16, (Throwable)exception);
            }
        }
    }
}

