/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.beaninfo.editors;

import java.awt.Color;
import java.awt.Component;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.UIManager;
import org.openide.explorer.propertysheet.PropertyEnv;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class IntegerCustomEditor
extends JPanel
implements PropertyChangeListener,
KeyListener {
    private static final String ERROR_FOREGROUND = "nb.errorForeground";
    private JPanel myPanel;
    private PropertyEnv myEnv;
    private HashMap<JTextField, JLabel> myLabelMap = new HashMap();

    public IntegerCustomEditor(PropertyEnv propertyEnv) {
        this.myEnv = propertyEnv;
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
        if (this.checkValues()) {
            this.updateValues();
        }
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
    }

    protected abstract void updateValues();

    protected void setPanel(JPanel jPanel) {
        this.myPanel = jPanel;
    }

    protected HashMap<JTextField, JLabel> getMap() {
        return this.myLabelMap;
    }

    protected boolean validFor(JTextField jTextField) {
        String string = jTextField.getText().trim();
        try {
            Integer.parseInt(string);
            this.handleValid(jTextField);
            return true;
        }
        catch (NumberFormatException numberFormatException) {
            this.handleInvalid(jTextField);
            return false;
        }
    }

    protected void handleValid(JTextField jTextField) {
        jTextField.setForeground(this.getForeground());
        this.getMap().get(jTextField).setForeground(this.getForeground());
    }

    protected void handleInvalid(JTextField jTextField) {
        jTextField.setForeground(this.getErrorColor());
        this.getMap().get(jTextField).setForeground(this.getErrorColor());
    }

    private Color getErrorColor() {
        Color color = UIManager.getColor(ERROR_FOREGROUND);
        if (color == null) {
            color = Color.RED;
        }
        return color;
    }

    private PropertyEnv getEnv() {
        return this.myEnv;
    }

    private boolean checkValues() {
        Component[] componentArray = this.myPanel.getComponents();
        boolean bl = true;
        for (int i = 0; i < componentArray.length; ++i) {
            if (!(componentArray[i] instanceof JTextField)) continue;
            bl &= this.validFor((JTextField)componentArray[i]);
        }
        if (this.getEnv() != null) {
            this.getEnv().setState(bl ? PropertyEnv.STATE_VALID : PropertyEnv.STATE_INVALID);
        }
        return bl;
    }
}

