/*
 * Decompiled with CFR 0.152.
 */
package au.com.trgtd.tr.appl.prefs;

import au.com.trgtd.tr.appl.prefs.ApplicationOptionsPanelController;
import au.com.trgtd.tr.appl.prefs.ApplicationPrefs;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.EmptyBorder;
import net.miginfocom.swing.MigLayout;
import org.openide.util.NbBundle;

final class ApplicationPanel
extends JPanel {
    private final ApplicationOptionsPanelController controller;
    private static final String[] periods = new String[]{ApplicationPanel.loc("CTL_Update_every_startup"), ApplicationPanel.loc("CTL_Update_every_day"), ApplicationPanel.loc("CTL_Update_every_week"), ApplicationPanel.loc("CTL_Update_every_fortnight"), ApplicationPanel.loc("CTL_Update_every_month"), ApplicationPanel.loc("CTL_Update_never")};
    private JComboBox checkPeriodCombo;

    private static String loc(String key) {
        return NbBundle.getMessage(ApplicationPanel.class, (String)key);
    }

    ApplicationPanel(ApplicationOptionsPanelController controller) {
        this.controller = controller;
        this.initForm();
    }

    void load() {
        this.checkPeriodCombo.setSelectedIndex(ApplicationPrefs.getVersionCheckPeriod());
    }

    void store() {
        ApplicationPrefs.setVersionCheckPeriod(this.checkPeriodCombo.getSelectedIndex());
    }

    boolean valid() {
        return true;
    }

    private String getMsg(String key) {
        return NbBundle.getMessage(ApplicationPanel.class, (String)key);
    }

    private void initForm() {
        this.initComponents();
        this.add((Component)this.getView(), "Center");
    }

    private JComponent getView() {
        JLabel checkPeriodLabel = new JLabel(this.getMsg("prefs.version.label"));
        this.checkPeriodCombo = new JComboBox<String>(new DefaultComboBoxModel<String>(periods));
        this.checkPeriodCombo.setMaximumRowCount(periods.length);
        JPanel panel = new JPanel((LayoutManager)new MigLayout("", "0[]4[]0", "0[]0"));
        panel.add((Component)checkPeriodLabel, "align right");
        panel.add((Component)this.checkPeriodCombo, "align left, wrap");
        JScrollPane scrollPane = new JScrollPane(panel);
        scrollPane.setBorder(new EmptyBorder(0, 0, 0, 0));
        return scrollPane;
    }

    private void initComponents() {
        this.setLayout(new BorderLayout());
    }
}

