/*
 * Decompiled with CFR 0.152.
 */
package tr.view.actions.prefs;

import java.util.logging.Logger;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;

public class ActionsPrefs {
    private static final Logger LOG = Logger.getLogger("tr.view.actions.prefs");
    public static final Preferences prefs = Preferences.userRoot().node("ThinkingRock/2.2.1/screens/actions");
    private static final String KEY_REPORT_USE_COLOUR = "report.colour.";
    private static final boolean DEF_REPORT_USE_COLOUR = true;
    private static final String KEY_REPORT_STRIKE_DONE = "report.strike.";
    private static final boolean DEF_REPORT_STRIKE_DONE = true;
    private static final String KEY_REPORT_FONT = "report.font";
    private static final String DEF_REPORT_FONT = "Helvetica";
    private static final String KEY_VIEW_DELAY = "view.delay";
    private static final int DEF_VIEW_DELAY = 200;

    public static final boolean isReportUseColour() {
        return prefs.getBoolean(KEY_REPORT_USE_COLOUR, true);
    }

    public static final void setReportUseColour(boolean value) {
        prefs.putBoolean(KEY_REPORT_USE_COLOUR, value);
        ActionsPrefs.flush();
    }

    public static final boolean isReportStrikeDone() {
        return prefs.getBoolean(KEY_REPORT_STRIKE_DONE, true);
    }

    public static final void setReportStrikeDone(boolean value) {
        prefs.putBoolean(KEY_REPORT_STRIKE_DONE, value);
        ActionsPrefs.flush();
    }

    public static final String getReportFont() {
        return prefs.get(KEY_REPORT_FONT, DEF_REPORT_FONT);
    }

    public static final void setReportFont(String value) {
        prefs.put(KEY_REPORT_FONT, value);
        ActionsPrefs.flush();
    }

    public static final int getViewDelay() {
        return prefs.getInt(KEY_VIEW_DELAY, 200);
    }

    public static final void setViewDelay(int value) {
        prefs.putInt(KEY_VIEW_DELAY, value);
        ActionsPrefs.flush();
    }

    private static void flush() {
        try {
            prefs.flush();
        }
        catch (BackingStoreException ex) {
            LOG.severe("Actions preferences error. " + ex.getMessage());
        }
    }
}

