/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.export.oasis;

import java.io.IOException;
import java.io.Writer;
import net.sf.jasperreports.engine.JRPrintGraphicElement;
import net.sf.jasperreports.engine.JRPrintImage;
import net.sf.jasperreports.engine.export.oasis.Style;
import net.sf.jasperreports.engine.export.oasis.Utility;
import net.sf.jasperreports.engine.util.JRColorUtil;

public class GraphicStyle
extends Style {
    private String backcolor = null;
    private String forecolor = null;
    private String style = null;
    private String width = null;
    private String hAlign = null;
    private String vAlign = null;

    public GraphicStyle(Writer styleWriter, JRPrintGraphicElement element) {
        super(styleWriter);
        if (element.getMode() == 1) {
            this.backcolor = JRColorUtil.getColorHexa(element.getBackcolor());
        }
        this.forecolor = JRColorUtil.getColorHexa(element.getLinePen().getLineColor());
        double doubleWidth = element.getLinePen().getLineWidth().doubleValue();
        if (doubleWidth < 0.0) {
            this.style = "none";
        } else {
            switch (element.getLinePen().getLineStyle()) {
                case 1: 
                case 2: {
                    this.style = "dash";
                    break;
                }
                default: {
                    this.style = "solid";
                }
            }
        }
        this.width = String.valueOf(Utility.translatePixelsToInchesWithNoRoundOff(doubleWidth));
        int horizontalAlignment = 1;
        int verticalAlignment = 1;
        if (element instanceof JRPrintImage) {
            JRPrintImage imageElement = (JRPrintImage)element;
            horizontalAlignment = imageElement.getHorizontalAlignment();
            verticalAlignment = imageElement.getVerticalAlignment();
        }
        switch (horizontalAlignment) {
            case 3: {
                this.hAlign = "right";
                break;
            }
            case 4: {
                this.hAlign = "justified";
                break;
            }
            case 2: {
                this.hAlign = "center";
                break;
            }
            default: {
                this.hAlign = "left";
            }
        }
        switch (verticalAlignment) {
            case 3: {
                this.vAlign = "bottom";
                break;
            }
            case 2: {
                this.vAlign = "middle";
                break;
            }
            default: {
                this.vAlign = "top";
            }
        }
    }

    public String getId() {
        StringBuffer id = new StringBuffer();
        id.append(this.backcolor);
        id.append("|");
        id.append(this.forecolor);
        id.append("|");
        id.append(this.style);
        id.append("|");
        id.append(this.width);
        id.append("|");
        id.append(this.hAlign);
        id.append("|");
        id.append(this.vAlign);
        return id.toString();
    }

    public void write(String lineStyleName) throws IOException {
        this.styleWriter.write(" <style:style style:name=\"" + lineStyleName + "\"");
        this.styleWriter.write(" style:family=\"graphic\" style:parent-style-name=\"Graphics\">\n");
        this.styleWriter.write("   <style:graphic-properties");
        this.styleWriter.write(" draw:fill-color=\"#" + this.backcolor + "\"");
        this.styleWriter.write(" style:horizontal-pos=\"" + this.hAlign + "\" style:horizontal-rel=\"paragraph\"");
        this.styleWriter.write(" style:vertical-pos=\"" + this.vAlign + "\" style:vertical-rel=\"paragraph\"");
        this.styleWriter.write(" svg:stroke-color=\"#" + this.forecolor + "\"");
        this.styleWriter.write(" draw:stroke=\"" + this.style + "\"");
        this.styleWriter.write(" draw:stroke-dash=\"Dashed\"");
        this.styleWriter.write(" svg:stroke-width=\"" + this.width + "in\"");
        this.styleWriter.write("/>\n");
        this.styleWriter.write("</style:style>\n");
    }
}

