/*
 * Decompiled with CFR 0.152.
 */
package tr.extract;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.List;
import java.util.logging.Logger;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import tr.extract.Param;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XSL {
    private static final Logger LOG = Logger.getLogger("tr.extract");

    public static void transform(File xml, InputStream xsl, List<Param> params, File out, String encoding, boolean isXML) throws Exception {
        StreamSource xmlStream = new StreamSource(xml);
        StreamSource xslStream = new StreamSource(xsl);
        FileOutputStream outStream = new FileOutputStream(out);
        OutputStreamWriter outStreamWriter = null;
        if (encoding == null) {
            outStreamWriter = new OutputStreamWriter(outStream);
        } else {
            try {
                outStreamWriter = new OutputStreamWriter((OutputStream)outStream, encoding);
            }
            catch (Exception ex) {
                LOG.warning("Encoding " + encoding + " is not supported.");
                encoding = null;
                outStreamWriter = new OutputStreamWriter(outStream);
            }
        }
        StreamResult streamRslt = new StreamResult(new BufferedWriter(outStreamWriter));
        XSL.transform(xmlStream, xslStream, params, streamRslt, encoding, isXML);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void transform(StreamSource xml, StreamSource xslt, List<Param> params, StreamResult out, String encoding, boolean isXML) throws Exception {
        LOG.info("Started XSLT processing");
        try {
            TransformerFactory factory = TransformerFactory.newInstance();
            Transformer transformer = factory.newTransformer(xslt);
            for (Param param : params) {
                transformer.setParameter(param.id, param.getValue());
            }
            if (isXML) {
                transformer.setOutputProperty("method", "xml");
                transformer.setOutputProperty("omit-xml-declaration", "no");
                transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
                transformer.setOutputProperty("indent", "yes");
                if (encoding != null) {
                    transformer.setOutputProperty("encoding", encoding);
                }
            } else {
                transformer.setOutputProperty("method", "text");
                transformer.setOutputProperty("omit-xml-declaration", "yes");
            }
            transformer.transform(xml, out);
            LOG.info("Finished XSLT processing");
        }
        finally {
            try {
                OutputStream outStream;
                Writer writer = out.getWriter();
                if (writer != null) {
                    writer.close();
                }
                if ((outStream = out.getOutputStream()) != null) {
                    outStream.close();
                }
            }
            catch (Exception ex) {}
        }
    }
}

