/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.crypto.mac;

import de.rub.nds.tlsattacker.core.crypto.mac.WrappedMac;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.Mac;
import org.bouncycastle.util.Memoable;

public class ContinuousMac
implements WrappedMac {
    private Mac mac;
    private Memoable underlying;

    public ContinuousMac(Mac mac, Memoable underlying, CipherParameters parameters) {
        this.mac = mac;
        this.underlying = underlying;
        mac.init(parameters);
    }

    public <T extends Mac & Memoable> ContinuousMac(T mac, CipherParameters parameters) {
        this(mac, mac, parameters);
    }

    @Override
    public byte[] calculateMac(byte[] data) {
        this.mac.update(data, 0, data.length);
        Memoable memoable = this.underlying.copy();
        byte[] out = new byte[this.mac.getMacSize()];
        this.mac.doFinal(out, 0);
        this.underlying.reset(memoable);
        return out;
    }

    @Override
    public int getMacLength() {
        return this.mac.getMacSize();
    }
}

