/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.protocol.handler;

import de.rub.nds.tlsattacker.core.constants.ProtocolVersion;
import de.rub.nds.tlsattacker.core.protocol.handler.ProtocolMessageHandler;
import de.rub.nds.tlsattacker.core.protocol.message.ChangeCipherSpecMessage;
import de.rub.nds.tlsattacker.core.protocol.parser.ChangeCipherSpecParser;
import de.rub.nds.tlsattacker.core.protocol.preparator.ChangeCipherSpecPreparator;
import de.rub.nds.tlsattacker.core.protocol.serializer.ChangeCipherSpecSerializer;
import de.rub.nds.tlsattacker.core.state.TlsContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ChangeCipherSpecHandler
extends ProtocolMessageHandler<ChangeCipherSpecMessage> {
    private static final Logger LOGGER = LogManager.getLogger();

    public ChangeCipherSpecHandler(TlsContext tlsContext) {
        super(tlsContext);
    }

    @Override
    public ChangeCipherSpecParser getParser(byte[] message, int pointer) {
        return new ChangeCipherSpecParser(pointer, message, this.tlsContext.getChooser().getLastRecordVersion(), this.tlsContext.getConfig());
    }

    public ChangeCipherSpecPreparator getPreparator(ChangeCipherSpecMessage message) {
        return new ChangeCipherSpecPreparator(this.tlsContext.getChooser(), message);
    }

    public ChangeCipherSpecSerializer getSerializer(ChangeCipherSpecMessage message) {
        return new ChangeCipherSpecSerializer(message, this.tlsContext.getChooser().getSelectedProtocolVersion());
    }

    @Override
    public void adjustTLSContext(ChangeCipherSpecMessage message) {
        if (this.tlsContext.getTalkingConnectionEndType() != this.tlsContext.getChooser().getConnectionEndType() && this.tlsContext.getChooser().getSelectedProtocolVersion() != ProtocolVersion.TLS13) {
            this.tlsContext.getRecordLayer().updateDecryptionCipher();
            this.tlsContext.setReadSequenceNumber(0L);
            this.tlsContext.getRecordLayer().updateDecompressor();
            this.tlsContext.increaseDtlsReadEpoch();
        }
    }

    @Override
    public void adjustTlsContextAfterSerialize(ChangeCipherSpecMessage message) {
        if (this.tlsContext.getTalkingConnectionEndType() == this.tlsContext.getChooser().getConnectionEndType()) {
            this.tlsContext.setWriteSequenceNumber(0L);
            if (!this.tlsContext.getChooser().getSelectedProtocolVersion().isTLS13()) {
                this.tlsContext.getRecordLayer().updateEncryptionCipher();
                this.tlsContext.getRecordLayer().updateCompressor();
                this.tlsContext.increaseDtlsWriteEpoch();
            }
        }
    }
}

