/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.protocol.message;

import de.rub.nds.modifiablevariable.HoldsModifiableVariable;
import de.rub.nds.modifiablevariable.ModifiableVariableFactory;
import de.rub.nds.modifiablevariable.ModifiableVariableProperty;
import de.rub.nds.modifiablevariable.integer.ModifiableInteger;
import de.rub.nds.modifiablevariable.mlong.ModifiableLong;
import de.rub.nds.tlsattacker.core.config.Config;
import de.rub.nds.tlsattacker.core.constants.HandshakeMessageType;
import de.rub.nds.tlsattacker.core.protocol.ModifiableVariableHolder;
import de.rub.nds.tlsattacker.core.protocol.handler.NewSessionTicketHandler;
import de.rub.nds.tlsattacker.core.protocol.handler.ProtocolMessageHandler;
import de.rub.nds.tlsattacker.core.protocol.message.HandshakeMessage;
import de.rub.nds.tlsattacker.core.state.SessionTicket;
import de.rub.nds.tlsattacker.core.state.TlsContext;
import java.util.List;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement
public class NewSessionTicketMessage
extends HandshakeMessage {
    @ModifiableVariableProperty
    private ModifiableLong ticketLifetimeHint;
    @ModifiableVariableProperty
    private ModifiableInteger ticketLength;
    @HoldsModifiableVariable
    private SessionTicket ticket;

    public NewSessionTicketMessage() {
        super(HandshakeMessageType.NEW_SESSION_TICKET);
        this.ticket = new SessionTicket();
    }

    public NewSessionTicketMessage(boolean includeInDigest) {
        super(HandshakeMessageType.NEW_SESSION_TICKET);
        this.IS_INCLUDE_IN_DIGEST_DEFAULT = includeInDigest;
        this.ticket = new SessionTicket();
    }

    public NewSessionTicketMessage(Config tlsConfig) {
        super(tlsConfig, HandshakeMessageType.NEW_SESSION_TICKET);
        this.ticket = new SessionTicket();
    }

    public NewSessionTicketMessage(Config tlsConfig, boolean includeInDigest) {
        super(tlsConfig, HandshakeMessageType.NEW_SESSION_TICKET);
        this.IS_INCLUDE_IN_DIGEST_DEFAULT = includeInDigest;
        this.ticket = new SessionTicket();
    }

    public ModifiableLong getTicketLifetimeHint() {
        return this.ticketLifetimeHint;
    }

    public void setTicketLifetimeHint(ModifiableLong ticketLifetimeHint) {
        this.ticketLifetimeHint = ticketLifetimeHint;
    }

    public void setTicketLifetimeHint(long ticketLifetimeHint) {
        this.ticketLifetimeHint = ModifiableVariableFactory.safelySetValue((ModifiableLong)this.ticketLifetimeHint, (Long)ticketLifetimeHint);
    }

    public SessionTicket getTicket() {
        return this.ticket;
    }

    public void prepareTicket() {
        if (this.ticket == null) {
            this.ticket = new SessionTicket();
        }
    }

    public ModifiableInteger getTicketLength() {
        return this.ticketLength;
    }

    public void setTicketLength(int ticketLength) {
        this.ticketLength = ModifiableVariableFactory.safelySetValue((ModifiableInteger)this.ticketLength, (Integer)ticketLength);
    }

    public void setTicketLength(ModifiableInteger ticketLength) {
        this.ticketLength = ticketLength;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("NewSessionTicketMessage:");
        sb.append("\n  TicketLifeTimeHint: ");
        if (this.ticketLifetimeHint != null && this.ticketLifetimeHint.getValue() != null) {
            sb.append(this.ticketLifetimeHint.getValue());
        } else {
            sb.append("null");
        }
        sb.append("\n  TicketLength: ");
        if (this.ticketLength != null && this.ticketLength.getValue() != null) {
            sb.append(this.ticketLength.getValue());
        } else {
            sb.append("null");
        }
        sb.append("\n  Ticket: ");
        if (this.ticket != null) {
            sb.append(this.ticket.toString());
        } else {
            sb.append("null");
        }
        return sb.toString();
    }

    @Override
    public String toCompactString() {
        return "NewSessionTicket";
    }

    @Override
    public List<ModifiableVariableHolder> getAllModifiableVariableHolders() {
        List<ModifiableVariableHolder> holders = super.getAllModifiableVariableHolders();
        if (this.ticket != null) {
            holders.add(this.ticket);
        }
        return holders;
    }

    @Override
    public ProtocolMessageHandler getHandler(TlsContext context) {
        return new NewSessionTicketHandler(context);
    }
}

