/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.workflow;

import de.rub.nds.tlsattacker.core.connection.AliasedConnection;
import de.rub.nds.tlsattacker.core.state.State;
import de.rub.nds.tlsattacker.core.state.TlsContext;
import de.rub.nds.tlsattacker.core.workflow.DefaultWorkflowExecutor;
import de.rub.nds.tlsattacker.core.workflow.WorkflowExecutor;
import de.rub.nds.tlsattacker.core.workflow.WorkflowTrace;
import de.rub.nds.tlsattacker.transport.TransportHandler;
import de.rub.nds.tlsattacker.transport.tcp.ServerTcpTransportHandler;
import java.io.IOException;
import java.net.Socket;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class WorkflowExecutorRunnable
implements Runnable {
    private static final Logger LOGGER = LogManager.getLogger();
    private final Socket socket;
    private final State globalState;

    public WorkflowExecutorRunnable(State globalState, Socket socket) {
        this.globalState = globalState;
        this.socket = socket;
    }

    @Override
    public void run() {
        ServerTcpTransportHandler th;
        LOGGER.info("Spawning workflow on socket " + this.socket);
        WorkflowTrace localTrace = this.globalState.getWorkflowTraceCopy();
        State state = new State(this.globalState.getConfig(), localTrace);
        TlsContext serverCtx = state.getInboundTlsContexts().get(0);
        AliasedConnection serverCon = serverCtx.getConnection();
        serverCon.setHostname(this.socket.getInetAddress().getHostAddress());
        serverCon.setPort(this.socket.getLocalPort());
        long timeout = new Long(serverCon.getTimeout().intValue());
        try {
            th = new ServerTcpTransportHandler(timeout, this.socket);
        }
        catch (IOException ex) {
            LOGGER.error("Could not prepare TransportHandler for " + this.socket);
            LOGGER.error("Aborting workflow trace execution on " + this.socket);
            return;
        }
        serverCtx.setTransportHandler((TransportHandler)th);
        LOGGER.info("Exectuting workflow for " + this.socket + " (" + serverCtx + ")");
        DefaultWorkflowExecutor workflowExecutor = new DefaultWorkflowExecutor(state);
        ((WorkflowExecutor)workflowExecutor).executeWorkflow();
        LOGGER.info("Workflow execution done on " + this.socket + " (" + serverCtx + ")");
    }
}

