/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.protocol;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import org.traccar.BaseProtocolEncoder;
import org.traccar.Protocol;
import org.traccar.helper.Checksum;
import org.traccar.model.Command;

public class KhdProtocolEncoder
extends BaseProtocolEncoder {
    public static final int MSG_ON_DEMAND_TRACK = 48;
    public static final int MSG_CUT_OIL = 57;
    public static final int MSG_RESUME_OIL = 56;
    public static final int MSG_CHECK_VERSION = 61;
    public static final int MSG_FACTORY_RESET = 195;
    public static final int MSG_SET_OVERSPEED = 63;
    public static final int MSG_DELETE_MILEAGE = 102;

    public KhdProtocolEncoder(Protocol protocol) {
        super(protocol);
    }

    private ByteBuf encodeCommand(int command, String uniqueId, ByteBuf content) {
        ByteBuf buf = Unpooled.buffer();
        buf.writeByte(41);
        buf.writeByte(41);
        buf.writeByte(command);
        int length = 6;
        if (content != null) {
            length += content.readableBytes();
        }
        buf.writeShort(length);
        uniqueId = "00000000".concat(uniqueId);
        uniqueId = uniqueId.substring(uniqueId.length() - 8);
        buf.writeByte(Integer.parseInt(uniqueId.substring(0, 2)));
        buf.writeByte(Integer.parseInt(uniqueId.substring(2, 4)) + 128);
        buf.writeByte(Integer.parseInt(uniqueId.substring(4, 6)) + 128);
        buf.writeByte(Integer.parseInt(uniqueId.substring(6, 8)));
        if (content != null) {
            buf.writeBytes(content);
        }
        buf.writeByte(Checksum.xor(buf.nioBuffer()));
        buf.writeByte(13);
        return buf;
    }

    @Override
    protected Object encodeCommand(Command command) {
        String uniqueId = this.getUniqueId(command.getDeviceId());
        switch (command.getType()) {
            case "engineStop": {
                return this.encodeCommand(57, uniqueId, null);
            }
            case "engineResume": {
                return this.encodeCommand(56, uniqueId, null);
            }
            case "getVersion": {
                return this.encodeCommand(61, uniqueId, null);
            }
            case "factoryReset": {
                return this.encodeCommand(195, uniqueId, null);
            }
            case "setSpeedLimit": {
                ByteBuf content = Unpooled.buffer();
                content.writeByte(Integer.parseInt(command.getString("data")));
                return this.encodeCommand(56, uniqueId, content);
            }
            case "setOdometer": {
                return this.encodeCommand(102, uniqueId, null);
            }
            case "positionSingle": {
                return this.encodeCommand(48, uniqueId, null);
            }
        }
        return null;
    }
}

