/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.protocol;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import java.net.SocketAddress;
import java.nio.charset.StandardCharsets;
import java.util.Calendar;
import org.traccar.BaseProtocolDecoder;
import org.traccar.DeviceSession;
import org.traccar.NetworkMessage;
import org.traccar.Protocol;
import org.traccar.helper.BitUtil;
import org.traccar.helper.DateBuilder;
import org.traccar.model.Position;

public class UuxProtocolDecoder
extends BaseProtocolDecoder {
    public static final int MSG_GENERAL = 144;
    public static final int MSG_IMMOBILIZER = 158;
    public static final int MSG_ACK = 208;
    public static final int MSG_NACK = 240;
    public static final int MSG_KEEPALIVE = 255;

    public UuxProtocolDecoder(Protocol protocol) {
        super(protocol);
    }

    private void sendResponse(Channel channel, int productCode, int protocolVersion, int type) {
        if (channel != null && BitUtil.check(protocolVersion, 7)) {
            ByteBuf response = Unpooled.buffer();
            response.writeShort(productCode);
            response.writeByte(BitUtil.to(protocolVersion, 7));
            response.writeByte(1);
            response.writeByte(type);
            channel.writeAndFlush((Object)new NetworkMessage(response, channel.remoteAddress()));
        }
    }

    private int readInt(ByteBuf buf, int length) {
        return Integer.parseInt(buf.readCharSequence(length, StandardCharsets.US_ASCII).toString());
    }

    private double readDouble(ByteBuf buf, int length) {
        return Double.parseDouble(buf.readCharSequence(length, StandardCharsets.US_ASCII).toString());
    }

    @Override
    protected Object decode(Channel channel, SocketAddress remoteAddress, Object msg) throws Exception {
        ByteBuf buf = (ByteBuf)msg;
        int productCode = buf.readUnsignedShort();
        short protocolVersion = buf.readUnsignedByte();
        buf.readUnsignedByte();
        short type = buf.readUnsignedByte();
        if (type == 255) {
            return null;
        }
        String vehicleId = buf.readCharSequence(10, StandardCharsets.US_ASCII).toString();
        DeviceSession deviceSession = this.getDeviceSession(channel, remoteAddress, vehicleId);
        if (deviceSession == null) {
            this.sendResponse(channel, productCode, protocolVersion, 240);
            return null;
        }
        DateBuilder dateBuilder = new DateBuilder().setDate(Calendar.getInstance().get(1), buf.readUnsignedByte(), buf.readUnsignedByte()).setTime(buf.readUnsignedByte(), buf.readUnsignedByte(), buf.readUnsignedByte());
        if (type == 144) {
            Position position = new Position(this.getProtocolName());
            position.setDeviceId(deviceSession.getDeviceId());
            position.setTime(dateBuilder.getDate());
            buf.skipBytes(10);
            buf.readUnsignedShort();
            buf.readUnsignedByte();
            position.setValid(true);
            position.set("sat", this.readInt(buf, 2));
            double latitude = this.readInt(buf, 2);
            position.setLatitude(buf.readUnsignedByte() == 83 ? -latitude : (latitude += this.readDouble(buf, 7) / 60.0));
            double longitude = this.readInt(buf, 3);
            position.setLongitude(buf.readUnsignedByte() == 87 ? -longitude : (longitude += this.readDouble(buf, 7) / 60.0));
            position.setSpeed(this.readInt(buf, 3));
            position.setCourse(this.readInt(buf, 3));
            this.readInt(buf, 3);
            position.set("odometer", (double)(buf.readUnsignedByte() * 10000 + buf.readUnsignedByte() * 256 + buf.readUnsignedByte()) + (double)buf.readUnsignedByte() * 0.1);
            position.set("hours", buf.readUnsignedInt());
            position.set("rssi", buf.readUnsignedByte());
            position.set("companyId", buf.readCharSequence(6, StandardCharsets.US_ASCII).toString());
            buf.skipBytes(10);
            position.set("tripId", buf.readUnsignedShort());
            return position;
        }
        if (type == 158) {
            Position position = new Position(this.getProtocolName());
            position.setDeviceId(deviceSession.getDeviceId());
            this.getLastLocation(position, dateBuilder.getDate());
            position.set("companyId", buf.readCharSequence(6, StandardCharsets.US_ASCII).toString());
            position.set("tripId", buf.readUnsignedShort());
            return position;
        }
        this.sendResponse(channel, productCode, protocolVersion, 208);
        return null;
    }
}

