/*
 * Decompiled with CFR 0.152.
 */
package edu.umass.cs.benchlab.har;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

public class ISO8601DateFormatter {
    private static final SimpleDateFormat SDF = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ");
    private static final SimpleDateFormat SDFZ = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");

    public static synchronized Date parseDate(String iso8601Str) throws ParseException {
        if ("null".equals(iso8601Str)) {
            return null;
        }
        int cidx = iso8601Str.lastIndexOf(58);
        if (cidx == -1) {
            throw new ParseException("Invalid date format, expected '2011-01-31T17:16:38.500-05:00' instead of " + iso8601Str, 0);
        }
        if (iso8601Str.endsWith("Z")) {
            return SDFZ.parse(iso8601Str);
        }
        if (iso8601Str.endsWith("+0000")) {
            return SDF.parse(iso8601Str);
        }
        if (iso8601Str.length() > 32) {
            int milliSecondPeriod = iso8601Str.lastIndexOf(".");
            int plusSymbol = iso8601Str.lastIndexOf("+");
            String parseStringAs = iso8601Str.substring(0, milliSecondPeriod + 1);
            parseStringAs = parseStringAs + iso8601Str.substring(milliSecondPeriod + 1, milliSecondPeriod + 4);
            parseStringAs = parseStringAs + iso8601Str.substring(plusSymbol);
            cidx = parseStringAs.lastIndexOf(58);
            return SDF.parse(parseStringAs.substring(0, cidx) + parseStringAs.substring(cidx + 1));
        }
        return SDF.parse(iso8601Str.substring(0, cidx) + iso8601Str.substring(cidx + 1));
    }

    public static synchronized String format(Date date) {
        if (date == null) {
            return "null";
        }
        String iso = SDF.format(date);
        return iso.substring(0, iso.length() - 2) + ":" + iso.substring(iso.length() - 2);
    }
}

