/*
 * Decompiled with CFR 0.152.
 */
package org.parosproxy.paros.core.proxy;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.configuration.HierarchicalConfiguration;
import org.apache.log4j.Logger;
import org.parosproxy.paros.common.AbstractParam;
import org.parosproxy.paros.network.SSLConnector;

public class ProxyParam
extends AbstractParam {
    private static final Logger logger = Logger.getLogger(ProxyParam.class);
    private static final String PROXY_BASE_KEY = "proxy";
    private static final String PROXY_IP = "proxy.ip";
    private static final String PROXY_PORT = "proxy.port";
    private static final String USE_REVERSE_PROXY = "proxy.reverseProxy.use";
    private static final String REVERSE_PROXY_IP = "proxy.reverseProxy.ip";
    private static final String REVERSE_PROXY_HTTP_PORT = "proxy.reverseProxy.httpPort";
    private static final String REVERSE_PROXY_HTTPS_PORT = "proxy.reverseProxy.httpsPort";
    private static final String PROXY_BEHIND_NAT = "proxy.behindnat";
    private static final String SECURITY_PROTOCOLS_ENABLED = "proxy.securityProtocolsEnabled";
    private static final String ALL_SECURITY_PROTOCOLS_ENABLED_KEY = "proxy.securityProtocolsEnabled.protocol";
    private static final String REMOVE_UNSUPPORTED_ENCODINGS = "proxy.removeUnsupportedEncodings";
    private static final String ALWAYS_DECODE_GZIP = "proxy.decodeGzip";
    private String proxyIp = "localhost";
    private int proxyPort = 8080;
    private int useReverseProxy = 0;
    private String reverseProxyIp = "localhost";
    private int reverseProxyHttpPort = 80;
    private int reverseProxyHttpsPort = 443;
    private boolean proxyIpAnyLocalAddress;
    private boolean removeUnsupportedEncodings = true;
    private boolean alwaysDecodeGzip = true;
    private boolean behindNat;
    private String[] securityProtocolsEnabled;

    @Override
    protected void parse() {
        this.proxyIp = this.getString(PROXY_IP, "localhost");
        this.determineProxyIpAnyLocalAddress();
        this.proxyPort = this.getInt(PROXY_PORT, 8080);
        this.reverseProxyIp = this.getString(REVERSE_PROXY_IP, "localhost");
        if (this.reverseProxyIp.equalsIgnoreCase("localhost") || this.reverseProxyIp.equalsIgnoreCase("127.0.0.1")) {
            try {
                this.reverseProxyIp = InetAddress.getLocalHost().getHostAddress();
            }
            catch (UnknownHostException e1) {
                logger.error((Object)e1.getMessage(), (Throwable)e1);
            }
        }
        this.reverseProxyHttpPort = this.getInt(REVERSE_PROXY_HTTP_PORT, 80);
        this.reverseProxyHttpsPort = this.getInt(REVERSE_PROXY_HTTPS_PORT, 443);
        this.useReverseProxy = this.getInt(USE_REVERSE_PROXY, 0);
        this.removeUnsupportedEncodings = this.getBoolean(REMOVE_UNSUPPORTED_ENCODINGS, true);
        this.alwaysDecodeGzip = this.getBoolean(ALWAYS_DECODE_GZIP, true);
        this.loadSecurityProtocolsEnabled();
        this.behindNat = this.getBoolean(PROXY_BEHIND_NAT, false);
    }

    public String getProxyIp() {
        if (this.isProxyIpAnyLocalAddress()) {
            try {
                return InetAddress.getLocalHost().getHostAddress();
            }
            catch (UnknownHostException ex) {
                return "localhost";
            }
        }
        return this.proxyIp;
    }

    public String getRawProxyIP() {
        if (this.proxyIp == null || this.proxyIp.length() == 0) {
            return "0.0.0.0";
        }
        return this.proxyIp;
    }

    public void setProxyIp(String proxyIp) {
        if (this.proxyIp.equals(proxyIp)) {
            return;
        }
        this.proxyIp = proxyIp.trim();
        this.getConfig().setProperty(PROXY_IP, (Object)this.proxyIp);
        this.determineProxyIpAnyLocalAddress();
    }

    public int getProxyPort() {
        return this.proxyPort;
    }

    public void setProxyPort(int proxyPort) {
        this.proxyPort = proxyPort;
        this.getConfig().setProperty(PROXY_PORT, (Object)Integer.toString(this.proxyPort));
    }

    public String getReverseProxyIp() {
        return this.reverseProxyIp;
    }

    public void setReverseProxyIp(String reverseProxyIp) {
        this.reverseProxyIp = reverseProxyIp.trim();
        this.getConfig().setProperty(REVERSE_PROXY_IP, (Object)this.reverseProxyIp);
    }

    public int getReverseProxyHttpPort() {
        return this.reverseProxyHttpPort;
    }

    public void setReverseProxyHttpPort(int reverseProxyHttpPort) {
        this.reverseProxyHttpPort = reverseProxyHttpPort;
        this.getConfig().setProperty(REVERSE_PROXY_HTTP_PORT, (Object)Integer.toString(this.reverseProxyHttpPort));
    }

    public int getReverseProxyHttpsPort() {
        return this.reverseProxyHttpsPort;
    }

    public void setReverseProxyHttpsPort(int reverseProxyHttpsPort) {
        this.reverseProxyHttpsPort = reverseProxyHttpsPort;
        this.getConfig().setProperty(REVERSE_PROXY_HTTPS_PORT, (Object)Integer.toString(this.reverseProxyHttpsPort));
    }

    public boolean isUseReverseProxy() {
        return this.useReverseProxy != 0;
    }

    public void setUseReverseProxy(boolean isUse) {
        if (isUse) {
            this.useReverseProxy = 1;
            this.getConfig().setProperty(USE_REVERSE_PROXY, (Object)Integer.toString(this.useReverseProxy));
            return;
        }
        this.useReverseProxy = 0;
        this.getConfig().setProperty(USE_REVERSE_PROXY, (Object)Integer.toString(this.useReverseProxy));
    }

    @Deprecated
    public void setModifyAcceptEncodingHeader(boolean modifyAcceptEncodingHeader) {
        this.setRemoveUnsupportedEncodings(modifyAcceptEncodingHeader);
    }

    @Deprecated
    public boolean isModifyAcceptEncodingHeader() {
        return this.isRemoveUnsupportedEncodings();
    }

    public void setRemoveUnsupportedEncodings(boolean remove) {
        if (this.removeUnsupportedEncodings != remove) {
            this.removeUnsupportedEncodings = remove;
            this.getConfig().setProperty(REMOVE_UNSUPPORTED_ENCODINGS, (Object)this.removeUnsupportedEncodings);
        }
    }

    public boolean isRemoveUnsupportedEncodings() {
        return this.removeUnsupportedEncodings;
    }

    public boolean isAlwaysDecodeGzip() {
        return this.alwaysDecodeGzip;
    }

    public void setAlwaysDecodeGzip(boolean alwaysDecodeGzip) {
        this.alwaysDecodeGzip = alwaysDecodeGzip;
        this.getConfig().setProperty(ALWAYS_DECODE_GZIP, (Object)alwaysDecodeGzip);
    }

    public String[] getSecurityProtocolsEnabled() {
        return Arrays.copyOf(this.securityProtocolsEnabled, this.securityProtocolsEnabled.length);
    }

    public void setSecurityProtocolsEnabled(String[] enabledProtocols) {
        int i;
        if (enabledProtocols == null || enabledProtocols.length == 0) {
            return;
        }
        for (i = 0; i < enabledProtocols.length; ++i) {
            if (enabledProtocols[i] != null && !enabledProtocols[i].isEmpty()) continue;
            throw new IllegalArgumentException("The parameter enabledProtocols must not contain null or empty elements.");
        }
        ((HierarchicalConfiguration)this.getConfig()).clearTree(ALL_SECURITY_PROTOCOLS_ENABLED_KEY);
        for (i = 0; i < enabledProtocols.length; ++i) {
            String elementBaseKey = "proxy.securityProtocolsEnabled.protocol(" + i + ")";
            this.getConfig().setProperty(elementBaseKey, (Object)enabledProtocols[i]);
        }
        this.securityProtocolsEnabled = Arrays.copyOf(enabledProtocols, enabledProtocols.length);
        this.setServerEnabledProtocols();
    }

    private void loadSecurityProtocolsEnabled() {
        List protocols = this.getConfig().getList(ALL_SECURITY_PROTOCOLS_ENABLED_KEY);
        if (protocols.size() != 0) {
            this.securityProtocolsEnabled = new String[protocols.size()];
            this.securityProtocolsEnabled = protocols.toArray(this.securityProtocolsEnabled);
            this.setServerEnabledProtocols();
        } else {
            this.setSecurityProtocolsEnabled(SSLConnector.getServerEnabledProtocols());
        }
    }

    private void setServerEnabledProtocols() {
        try {
            SSLConnector.setServerEnabledProtocols(this.securityProtocolsEnabled);
        }
        catch (IllegalArgumentException e) {
            logger.warn((Object)("Failed to set persisted protocols " + Arrays.toString(this.securityProtocolsEnabled) + " falling back to " + Arrays.toString(SSLConnector.getFailSafeProtocols()) + " caused by: " + e.getMessage()));
            this.securityProtocolsEnabled = SSLConnector.getFailSafeProtocols();
            SSLConnector.setServerEnabledProtocols(this.securityProtocolsEnabled);
        }
    }

    public boolean isProxyIpAnyLocalAddress() {
        return this.proxyIpAnyLocalAddress;
    }

    private void determineProxyIpAnyLocalAddress() {
        try {
            this.proxyIpAnyLocalAddress = this.proxyIp.isEmpty() || InetAddress.getByName(this.proxyIp).isAnyLocalAddress();
        }
        catch (UnknownHostException e) {
            this.proxyIpAnyLocalAddress = false;
        }
    }

    public boolean isBehindNat() {
        return this.behindNat;
    }

    public void setBehindNat(boolean behindNat) {
        this.behindNat = behindNat;
        this.getConfig().setProperty(PROXY_BEHIND_NAT, (Object)behindNat);
    }
}

