/*
 * Decompiled with CFR 0.152.
 */
package org.parosproxy.paros.network;

import java.util.regex.Pattern;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpVersion;
import org.apache.commons.httpclient.URI;
import org.apache.commons.httpclient.URIException;
import org.apache.commons.httpclient.methods.ByteArrayRequestEntity;
import org.apache.commons.httpclient.methods.EntityEnclosingMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.params.HttpMethodParams;
import org.apache.log4j.Logger;
import org.parosproxy.paros.network.GenericMethod;
import org.parosproxy.paros.network.HttpBody;
import org.parosproxy.paros.network.HttpMalformedHeaderException;
import org.parosproxy.paros.network.HttpRequestHeader;
import org.parosproxy.paros.network.HttpResponseHeader;
import org.zaproxy.zap.ZapGetMethod;
import org.zaproxy.zap.network.ZapDeleteMethod;
import org.zaproxy.zap.network.ZapHeadMethod;
import org.zaproxy.zap.network.ZapOptionsMethod;
import org.zaproxy.zap.network.ZapPostMethod;
import org.zaproxy.zap.network.ZapPutMethod;
import org.zaproxy.zap.network.ZapTraceMethod;

public class HttpMethodHelper {
    private static final Logger logger = Logger.getLogger(HttpMethodHelper.class);
    private static final String OPTIONS = "OPTIONS";
    private static final String GET = "GET";
    private static final String HEAD = "HEAD";
    private static final String POST = "POST";
    private static final String PUT = "PUT";
    private static final String DELETE = "DELETE";
    private static final String TRACE = "TRACE";
    private static final String CRLF = "\r\n";
    private static final String LF = "\n";
    private static final Pattern patternCRLF = Pattern.compile("\\r\\n", 8);
    private static final Pattern patternLF = Pattern.compile("\\n", 8);

    public HttpMethod createRequestMethodNew(HttpRequestHeader header, HttpBody body) throws URIException {
        GenericMethod httpMethod = null;
        String method = header.getMethod();
        URI uri = header.getURI();
        String version = header.getVersion();
        httpMethod = new GenericMethod(method);
        httpMethod.setURI(uri);
        HttpMethodParams httpParams = httpMethod.getParams();
        httpParams.setVersion(HttpVersion.HTTP_1_0);
        if (version.equalsIgnoreCase("HTTP/1.1")) {
            httpParams.setVersion(HttpVersion.HTTP_1_1);
        }
        int pos = 0;
        Pattern pattern = patternCRLF;
        String msg = header.getHeadersAsString();
        pos = msg.indexOf(CRLF);
        if (pos < 0) {
            pos = msg.indexOf(LF);
            if (pos < 0) {
                pattern = patternLF;
            }
        } else {
            pattern = patternCRLF;
        }
        String[] split = pattern.split(msg);
        String token = null;
        String name = null;
        String value = null;
        for (int i = 0; i < split.length; ++i) {
            token = split[i];
            if (token.equals("")) continue;
            pos = token.indexOf(":");
            if (pos < 0) {
                return null;
            }
            name = token.substring(0, pos).trim();
            value = token.substring(pos + 1).trim();
            httpMethod.addRequestHeader(name, value);
        }
        if (body != null && body.length() > 0) {
            EntityEnclosingMethod generic = httpMethod;
            generic.setRequestEntity((RequestEntity)new ByteArrayRequestEntity(body.getBytes()));
        }
        httpMethod.setFollowRedirects(false);
        return httpMethod;
    }

    public HttpMethod createRequestMethod(HttpRequestHeader header, HttpBody body) throws URIException {
        return this.createRequestMethod(header, body, null);
    }

    HttpMethod createRequestMethod(HttpRequestHeader header, HttpBody body, HttpMethodParams params) throws URIException {
        Object httpMethod = null;
        String method = header.getMethod();
        URI uri = header.getURI();
        String version = header.getVersion();
        if (method == null || method.trim().length() < 3) {
            throw new URIException("Invalid HTTP method: " + method);
        }
        httpMethod = method.equalsIgnoreCase(GET) ? new ZapGetMethod() : (method.equalsIgnoreCase(POST) ? new ZapPostMethod() : (method.equalsIgnoreCase(DELETE) ? new ZapDeleteMethod() : (method.equalsIgnoreCase(PUT) ? new ZapPutMethod() : (method.equalsIgnoreCase(HEAD) ? new ZapHeadMethod() : (method.equalsIgnoreCase(OPTIONS) ? new ZapOptionsMethod() : (method.equalsIgnoreCase(TRACE) ? new ZapTraceMethod(uri.toString()) : new GenericMethod(method)))))));
        try {
            httpMethod.setURI(uri);
        }
        catch (Exception e1) {
            throw new URIException("Failed to set URI [" + uri + "]: " + e1.getMessage());
        }
        if (params != null) {
            httpMethod.setParams(params);
        }
        HttpMethodParams httpParams = httpMethod.getParams();
        httpParams.setVersion(HttpVersion.HTTP_1_0);
        if (version.equalsIgnoreCase("HTTP/1.1")) {
            httpParams.setVersion(HttpVersion.HTTP_1_1);
        }
        int pos = 0;
        Pattern pattern = patternCRLF;
        String delimiter = header.getLineDelimiter();
        if (delimiter.equals(LF)) {
            delimiter = LF;
            pattern = patternLF;
        }
        String msg = header.getHeadersAsString();
        String[] split = pattern.split(msg);
        String token = null;
        String name = null;
        String value = null;
        for (int i = 0; i < split.length; ++i) {
            token = split[i];
            if (token.equals("")) continue;
            pos = token.indexOf(":");
            if (pos < 0) {
                return null;
            }
            name = token.substring(0, pos).trim();
            value = token.substring(pos + 1).trim();
            httpMethod.addRequestHeader(name, value);
        }
        if (body != null && body.length() > 0 && httpMethod instanceof EntityEnclosingMethod) {
            EntityEnclosingMethod post = httpMethod;
            post.setRequestEntity((RequestEntity)new ByteArrayRequestEntity(body.getBytes()));
        }
        httpMethod.setFollowRedirects(false);
        return httpMethod;
    }

    public static void updateHttpRequestHeaderSent(HttpRequestHeader req, HttpMethod httpMethodSent) {
        if (!httpMethodSent.hasBeenUsed()) {
            return;
        }
        StringBuilder sb = new StringBuilder(200);
        String name = null;
        String value = null;
        sb.append(req.getPrimeHeader()).append(CRLF);
        Header[] header = httpMethodSent.getRequestHeaders();
        for (int i = 0; i < header.length; ++i) {
            name = header[i].getName();
            value = header[i].getValue();
            sb.append(name).append(": ").append(value).append(CRLF);
        }
        sb.append(CRLF);
        try {
            req.setMessage(sb.toString());
        }
        catch (HttpMalformedHeaderException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    private static String getHttpResponseHeaderAsString(HttpMethod httpMethod) {
        StringBuilder sb = new StringBuilder(200);
        String name = null;
        String value = null;
        sb.append(httpMethod.getStatusLine().toString()).append(CRLF);
        Header[] header = httpMethod.getResponseHeaders();
        for (int i = 0; i < header.length; ++i) {
            name = header[i].getName();
            value = header[i].getValue();
            sb.append(name).append(": ").append(value).append(CRLF);
        }
        sb.append(CRLF);
        return sb.toString();
    }

    public static HttpResponseHeader getHttpResponseHeader(HttpMethod httpMethod) throws HttpMalformedHeaderException {
        return new HttpResponseHeader(HttpMethodHelper.getHttpResponseHeaderAsString(httpMethod));
    }
}

