/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.brk;

import java.awt.CardLayout;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.model.OptionsParam;
import org.parosproxy.paros.view.AbstractParamPanel;
import org.zaproxy.zap.extension.brk.BreakpointsParam;
import org.zaproxy.zap.view.LayoutHelper;

public class BreakpointsOptionsPanel
extends AbstractParamPanel {
    private static final long serialVersionUID = 7483614036849207715L;
    private JCheckBox checkBoxConfirmDropMessage = null;
    private JCheckBox checkBoxAlwaysOnTop = null;
    private JCheckBox checkBoxInScopeOnly = null;
    private JComboBox<String> buttonMode = null;

    public BreakpointsOptionsPanel() {
        this.setName(Constant.messages.getString("brk.optionspanel.name"));
        this.setLayout(new CardLayout());
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setBorder(new EmptyBorder(2, 2, 2, 2));
        panel.add((Component)this.getCheckBoxConfirmDropMessage(), LayoutHelper.getGBC(0, 0, 2, 1.0, new Insets(2, 2, 2, 2)));
        panel.add((Component)this.getCheckBoxInScopeOnly(), LayoutHelper.getGBC(0, 1, 2, 1.0, new Insets(2, 2, 2, 2)));
        panel.add((Component)this.getCheckBoxAlwaysOnTop(), LayoutHelper.getGBC(0, 2, 2, 1.0, new Insets(2, 2, 2, 2)));
        JLabel modeLabel = new JLabel(Constant.messages.getString("brk.optionspanel.option.breakmode.label"));
        modeLabel.setLabelFor(this.getButtonMode());
        panel.add((Component)modeLabel, LayoutHelper.getGBC(0, 3, 1, 0.5));
        panel.add(this.getButtonMode(), LayoutHelper.getGBC(1, 3, 1, 0.5));
        panel.add((Component)new JLabel(), LayoutHelper.getGBC(0, 10, 1, 0.5, 1.0));
        this.add(panel);
    }

    private JCheckBox getCheckBoxConfirmDropMessage() {
        if (this.checkBoxConfirmDropMessage == null) {
            this.checkBoxConfirmDropMessage = new JCheckBox(Constant.messages.getString("brk.optionspanel.option.confirmDropMessage.label"));
        }
        return this.checkBoxConfirmDropMessage;
    }

    private JCheckBox getCheckBoxAlwaysOnTop() {
        if (this.checkBoxAlwaysOnTop == null) {
            this.checkBoxAlwaysOnTop = new JCheckBox(Constant.messages.getString("brk.optionspanel.option.alwaysOnTop.label"));
        }
        return this.checkBoxAlwaysOnTop;
    }

    private JCheckBox getCheckBoxInScopeOnly() {
        if (this.checkBoxInScopeOnly == null) {
            this.checkBoxInScopeOnly = new JCheckBox(Constant.messages.getString("brk.optionspanel.option.inScopeOnly.label"));
        }
        return this.checkBoxInScopeOnly;
    }

    private JComboBox<String> getButtonMode() {
        if (this.buttonMode == null) {
            this.buttonMode = new JComboBox();
            this.buttonMode.addItem(Constant.messages.getString("brk.optionspanel.option.breakmode.simple.label"));
            this.buttonMode.addItem(Constant.messages.getString("brk.optionspanel.option.breakmode.dual.label"));
        }
        return this.buttonMode;
    }

    @Override
    public void initParam(Object obj) {
        OptionsParam options = (OptionsParam)obj;
        BreakpointsParam param = options.getParamSet(BreakpointsParam.class);
        this.getCheckBoxConfirmDropMessage().setSelected(param.isConfirmDropMessage());
        this.getCheckBoxAlwaysOnTop().setSelected(param.getAlwaysOnTop() != Boolean.FALSE);
        this.getCheckBoxInScopeOnly().setSelected(param.isInScopeOnly());
        this.getButtonMode().setSelectedIndex(param.getButtonMode() - 1);
    }

    @Override
    public void saveParam(Object obj) throws Exception {
        OptionsParam options = (OptionsParam)obj;
        BreakpointsParam param = options.getParamSet(BreakpointsParam.class);
        param.setConfirmDropMessage(this.getCheckBoxConfirmDropMessage().isSelected());
        if (param.getAlwaysOnTop() != null || !this.getCheckBoxAlwaysOnTop().isSelected()) {
            param.setAlwaysOnTop(this.getCheckBoxAlwaysOnTop().isSelected());
        }
        param.setInScopeOnly(this.getCheckBoxInScopeOnly().isSelected());
        param.setButtonMode(this.getButtonMode().getSelectedIndex() + 1);
    }

    @Override
    public String getHelpIndex() {
        return "ui.dialogs.options.breakpoints";
    }
}

