/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.view.table;

import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.model.HistoryReference;
import org.zaproxy.zap.view.table.AbstractHistoryReferencesTableEntry;
import org.zaproxy.zap.view.table.AlertRiskTableCellItem;
import org.zaproxy.zap.view.table.HistoryReferencesTableModel;

public class DefaultHistoryReferencesTableEntry
extends AbstractHistoryReferencesTableEntry {
    private static final String VALUES_SEPARATOR = Constant.messages.getString("generic.value.text.separator.comma");
    private final Integer historyId;
    private final Integer historyType;
    private final Long sessionId;
    private final String method;
    private final String uri;
    private final Integer statusCode;
    private final String reason;
    private final Date timeSentMillis;
    private final Date timeReceivedMillis;
    private final Integer rtt;
    private final Long messageSize;
    private final Integer requestHeaderSize;
    private final Integer requestBodySize;
    private final Integer responseHeaderSize;
    private final Integer responseBodySize;
    private AlertRiskTableCellItem alertRiskCellItem;
    private final boolean highestAlertColumn;
    private Boolean note;
    private final boolean noteColumn;
    private String tags;
    private final boolean tagsColumn;

    public DefaultHistoryReferencesTableEntry(HistoryReference historyReference, HistoryReferencesTableModel.Column[] columns) {
        super(historyReference);
        HistoryReferencesTableModel.Column[] sortedColumns = Arrays.copyOf(columns, columns.length);
        Arrays.sort((Object[])sortedColumns);
        this.historyId = DefaultHistoryReferencesTableEntry.hasColumn(sortedColumns, HistoryReferencesTableModel.Column.HREF_ID) ? Integer.valueOf(historyReference.getHistoryId()) : null;
        this.historyType = DefaultHistoryReferencesTableEntry.hasColumn(sortedColumns, HistoryReferencesTableModel.Column.HREF_TYPE) ? Integer.valueOf(historyReference.getHistoryType()) : null;
        this.sessionId = DefaultHistoryReferencesTableEntry.hasColumn(sortedColumns, HistoryReferencesTableModel.Column.SESSION_ID) ? Long.valueOf(historyReference.getSessionId()) : null;
        this.method = DefaultHistoryReferencesTableEntry.hasColumn(sortedColumns, HistoryReferencesTableModel.Column.METHOD) ? historyReference.getMethod() : null;
        this.statusCode = DefaultHistoryReferencesTableEntry.hasColumn(sortedColumns, HistoryReferencesTableModel.Column.STATUS_CODE) ? Integer.valueOf(historyReference.getStatusCode()) : null;
        this.reason = DefaultHistoryReferencesTableEntry.hasColumn(sortedColumns, HistoryReferencesTableModel.Column.STATUS_REASON) ? historyReference.getReason() : null;
        this.rtt = DefaultHistoryReferencesTableEntry.hasColumn(sortedColumns, HistoryReferencesTableModel.Column.RTT) ? Integer.valueOf(historyReference.getRtt()) : null;
        this.uri = DefaultHistoryReferencesTableEntry.hasColumn(sortedColumns, HistoryReferencesTableModel.Column.URL) ? historyReference.getURI().toString() : null;
        this.timeSentMillis = DefaultHistoryReferencesTableEntry.hasColumn(sortedColumns, HistoryReferencesTableModel.Column.REQUEST_TIMESTAMP) ? new Date(historyReference.getTimeSentMillis()) : null;
        this.timeReceivedMillis = DefaultHistoryReferencesTableEntry.hasColumn(sortedColumns, HistoryReferencesTableModel.Column.RESPONSE_TIMESTAMP) ? new Date(historyReference.getTimeReceivedMillis()) : null;
        this.requestHeaderSize = DefaultHistoryReferencesTableEntry.hasColumn(sortedColumns, HistoryReferencesTableModel.Column.SIZE_REQUEST_HEADER) ? Integer.valueOf(historyReference.getRequestHeaderLength()) : null;
        this.requestBodySize = DefaultHistoryReferencesTableEntry.hasColumn(sortedColumns, HistoryReferencesTableModel.Column.SIZE_REQUEST_BODY) ? Integer.valueOf(historyReference.getRequestBodyLength()) : null;
        this.responseHeaderSize = DefaultHistoryReferencesTableEntry.hasColumn(sortedColumns, HistoryReferencesTableModel.Column.SIZE_RESPONSE_HEADER) ? Integer.valueOf(historyReference.getResponseHeaderLength()) : null;
        this.responseBodySize = DefaultHistoryReferencesTableEntry.hasColumn(sortedColumns, HistoryReferencesTableModel.Column.SIZE_RESPONSE_BODY) ? Integer.valueOf(historyReference.getResponseBodyLength()) : null;
        this.messageSize = this.extractMessageSize(historyReference, DefaultHistoryReferencesTableEntry.hasColumn(sortedColumns, HistoryReferencesTableModel.Column.SIZE_MESSAGE));
        this.highestAlertColumn = DefaultHistoryReferencesTableEntry.hasColumn(sortedColumns, HistoryReferencesTableModel.Column.HIGHEST_ALERT);
        this.noteColumn = DefaultHistoryReferencesTableEntry.hasColumn(sortedColumns, HistoryReferencesTableModel.Column.NOTE);
        this.tagsColumn = DefaultHistoryReferencesTableEntry.hasColumn(sortedColumns, HistoryReferencesTableModel.Column.TAGS);
        this.alertRiskCellItem = super.getHighestAlert();
        this.refreshCachedValues();
    }

    private Long extractMessageSize(HistoryReference historyReference, boolean required) {
        if (!required) {
            return 0L;
        }
        return historyReference.getRequestHeaderLength() + historyReference.getRequestBodyLength() + historyReference.getResponseHeaderLength() + historyReference.getResponseBodyLength();
    }

    private static boolean hasColumn(HistoryReferencesTableModel.Column[] columns, HistoryReferencesTableModel.Column column) {
        return Arrays.stream(columns).anyMatch(value -> column == value);
    }

    @Override
    public Integer getHistoryId() {
        return this.historyId;
    }

    @Override
    public Integer getHistoryType() {
        return this.historyType;
    }

    @Override
    public Long getSessionId() {
        return this.sessionId;
    }

    @Override
    public String getMethod() {
        return this.method;
    }

    @Override
    public String getUri() {
        return this.uri;
    }

    @Override
    public Integer getStatusCode() {
        return this.statusCode;
    }

    @Override
    public String getReason() {
        return this.reason;
    }

    @Override
    public Date getRequestTimestamp() {
        return this.timeSentMillis;
    }

    @Override
    public Date getResponseTimestamp() {
        return this.timeReceivedMillis;
    }

    @Override
    public Integer getRtt() {
        return this.rtt;
    }

    @Override
    public Long getMessageSize() {
        return this.messageSize;
    }

    @Override
    public Integer getRequestHeaderSize() {
        return this.requestHeaderSize;
    }

    @Override
    public Integer getRequestBodySize() {
        return this.requestBodySize;
    }

    @Override
    public Integer getResponseHeaderSize() {
        return this.responseHeaderSize;
    }

    @Override
    public Integer getResponseBodySize() {
        return this.responseBodySize;
    }

    @Override
    public AlertRiskTableCellItem getHighestAlert() {
        return this.alertRiskCellItem;
    }

    @Override
    public Boolean hasNote() {
        return this.note;
    }

    @Override
    public String getTags() {
        return this.tags;
    }

    public void refreshCachedValues() {
        if (this.noteColumn) {
            this.note = this.getHistoryReference().hasNote();
        }
        if (this.tagsColumn) {
            this.tags = DefaultHistoryReferencesTableEntry.listToCsv(this.getHistoryReference().getTags());
        }
        if (this.highestAlertColumn) {
            this.alertRiskCellItem = AlertRiskTableCellItem.getItemForRisk(this.getHistoryReference().getHighestAlert());
        }
    }

    private static String listToCsv(List<String> list) {
        if (list == null || list.size() == 0) {
            return "";
        }
        if (list.size() == 1) {
            return list.get(0);
        }
        if (list.size() == 2) {
            return MessageFormat.format(VALUES_SEPARATOR, list.get(0), list.get(1));
        }
        String tags = VALUES_SEPARATOR;
        int total = list.size() - 2;
        for (int i = 0; i < total; ++i) {
            tags = MessageFormat.format(tags, list.get(i), VALUES_SEPARATOR);
        }
        tags = MessageFormat.format(tags, list.get(total), list.get(list.size() - 1));
        return tags;
    }
}

