/*
 * Decompiled with CFR 0.152.
 */
package org.armedbear.lisp;

import java.math.BigInteger;
import org.armedbear.lisp.Bignum;
import org.armedbear.lisp.BuiltInClass;
import org.armedbear.lisp.Complex;
import org.armedbear.lisp.Fixnum;
import org.armedbear.lisp.Lisp;
import org.armedbear.lisp.LispObject;
import org.armedbear.lisp.LispThread;
import org.armedbear.lisp.MathFunctions;
import org.armedbear.lisp.Ratio;
import org.armedbear.lisp.SingleFloat;
import org.armedbear.lisp.Symbol;
import org.armedbear.lisp.TypeError;

public final class DoubleFloat
extends LispObject {
    public static final DoubleFloat ZERO = new DoubleFloat(0.0);
    public static final DoubleFloat MINUS_ZERO = new DoubleFloat(-0.0);
    public static final DoubleFloat ONE = new DoubleFloat(1.0);
    public static final DoubleFloat MINUS_ONE = new DoubleFloat(-1.0);
    public static final DoubleFloat DOUBLE_FLOAT_POSITIVE_INFINITY = new DoubleFloat(Double.POSITIVE_INFINITY);
    public static final DoubleFloat DOUBLE_FLOAT_NEGATIVE_INFINITY = new DoubleFloat(Double.NEGATIVE_INFINITY);
    public final double value;

    public static DoubleFloat getInstance(double d) {
        if (d == 0.0) {
            long bits = Double.doubleToRawLongBits(d);
            if (bits < 0L) {
                return MINUS_ZERO;
            }
            return ZERO;
        }
        if (d == 1.0) {
            return ONE;
        }
        if (d == -1.0) {
            return MINUS_ONE;
        }
        return new DoubleFloat(d);
    }

    public DoubleFloat(double value) {
        this.value = value;
    }

    @Override
    public LispObject typeOf() {
        return Symbol.DOUBLE_FLOAT;
    }

    @Override
    public LispObject classOf() {
        return BuiltInClass.DOUBLE_FLOAT;
    }

    @Override
    public LispObject typep(LispObject typeSpecifier) {
        if (typeSpecifier == Symbol.FLOAT) {
            return Lisp.T;
        }
        if (typeSpecifier == Symbol.REAL) {
            return Lisp.T;
        }
        if (typeSpecifier == Symbol.NUMBER) {
            return Lisp.T;
        }
        if (typeSpecifier == Symbol.DOUBLE_FLOAT) {
            return Lisp.T;
        }
        if (typeSpecifier == Symbol.LONG_FLOAT) {
            return Lisp.T;
        }
        if (typeSpecifier == BuiltInClass.FLOAT) {
            return Lisp.T;
        }
        if (typeSpecifier == BuiltInClass.DOUBLE_FLOAT) {
            return Lisp.T;
        }
        return super.typep(typeSpecifier);
    }

    @Override
    public boolean numberp() {
        return true;
    }

    @Override
    public boolean realp() {
        return true;
    }

    @Override
    public boolean eql(LispObject obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof DoubleFloat) {
            if (this.value == 0.0) {
                double d = ((DoubleFloat)obj).value;
                long bits = Double.doubleToRawLongBits(d);
                return bits == Double.doubleToRawLongBits(this.value);
            }
            if (this.value == ((DoubleFloat)obj).value) {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean equal(LispObject obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof DoubleFloat) {
            if (this.value == 0.0) {
                double d = ((DoubleFloat)obj).value;
                long bits = Double.doubleToRawLongBits(d);
                return bits == Double.doubleToRawLongBits(this.value);
            }
            if (this.value == ((DoubleFloat)obj).value) {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean equalp(int n) {
        return this.value == (double)n;
    }

    @Override
    public boolean equalp(LispObject obj) {
        if (obj != null && obj.numberp()) {
            return this.isEqualTo(obj);
        }
        return false;
    }

    @Override
    public LispObject ABS() {
        if (this.value > 0.0) {
            return this;
        }
        if (this.value == 0.0) {
            return ZERO;
        }
        return new DoubleFloat(-this.value);
    }

    @Override
    public boolean plusp() {
        return this.value > 0.0;
    }

    @Override
    public boolean minusp() {
        return this.value < 0.0;
    }

    @Override
    public boolean zerop() {
        return this.value == 0.0;
    }

    @Override
    public boolean floatp() {
        return true;
    }

    public static double getValue(LispObject obj) {
        if (obj instanceof DoubleFloat) {
            return ((DoubleFloat)obj).value;
        }
        Lisp.type_error(obj, Symbol.FLOAT);
        return 0.0;
    }

    public final double getValue() {
        return this.value;
    }

    @Override
    public double doubleValue() {
        return this.value;
    }

    @Override
    public Object javaInstance() {
        return this.value;
    }

    public Object javaInstance(Class c) {
        if (c == Float.class || c == Float.TYPE) {
            return Float.valueOf((float)this.value);
        }
        return this.javaInstance();
    }

    @Override
    public final LispObject incr() {
        return new DoubleFloat(this.value + 1.0);
    }

    @Override
    public final LispObject decr() {
        return new DoubleFloat(this.value - 1.0);
    }

    @Override
    public LispObject negate() {
        if (this.value == 0.0) {
            long bits = Double.doubleToRawLongBits(this.value);
            return bits < 0L ? ZERO : MINUS_ZERO;
        }
        return new DoubleFloat(-this.value);
    }

    @Override
    public LispObject add(LispObject obj) {
        if (obj instanceof Fixnum) {
            return new DoubleFloat(this.value + (double)((Fixnum)obj).value);
        }
        if (obj instanceof SingleFloat) {
            return new DoubleFloat(this.value + (double)((SingleFloat)obj).value);
        }
        if (obj instanceof DoubleFloat) {
            return new DoubleFloat(this.value + ((DoubleFloat)obj).value);
        }
        if (obj instanceof Bignum) {
            return new DoubleFloat(this.value + ((Bignum)obj).doubleValue());
        }
        if (obj instanceof Ratio) {
            return new DoubleFloat(this.value + ((Ratio)obj).doubleValue());
        }
        if (obj instanceof Complex) {
            Complex c = (Complex)obj;
            return Complex.getInstance(this.add(c.getRealPart()), c.getImaginaryPart());
        }
        return Lisp.type_error(obj, Symbol.NUMBER);
    }

    @Override
    public LispObject subtract(LispObject obj) {
        if (obj instanceof Fixnum) {
            return new DoubleFloat(this.value - (double)((Fixnum)obj).value);
        }
        if (obj instanceof SingleFloat) {
            return new DoubleFloat(this.value - (double)((SingleFloat)obj).value);
        }
        if (obj instanceof DoubleFloat) {
            return new DoubleFloat(this.value - ((DoubleFloat)obj).value);
        }
        if (obj instanceof Bignum) {
            return new DoubleFloat(this.value - ((Bignum)obj).doubleValue());
        }
        if (obj instanceof Ratio) {
            return new DoubleFloat(this.value - ((Ratio)obj).doubleValue());
        }
        if (obj instanceof Complex) {
            Complex c = (Complex)obj;
            return Complex.getInstance(this.subtract(c.getRealPart()), ZERO.subtract(c.getImaginaryPart()));
        }
        return Lisp.type_error(obj, Symbol.NUMBER);
    }

    @Override
    public LispObject multiplyBy(LispObject obj) {
        if (obj instanceof Fixnum) {
            return new DoubleFloat(this.value * (double)((Fixnum)obj).value);
        }
        if (obj instanceof SingleFloat) {
            return new DoubleFloat(this.value * (double)((SingleFloat)obj).value);
        }
        if (obj instanceof DoubleFloat) {
            return new DoubleFloat(this.value * ((DoubleFloat)obj).value);
        }
        if (obj instanceof Bignum) {
            return new DoubleFloat(this.value * ((Bignum)obj).doubleValue());
        }
        if (obj instanceof Ratio) {
            return new DoubleFloat(this.value * ((Ratio)obj).doubleValue());
        }
        if (obj instanceof Complex) {
            Complex c = (Complex)obj;
            return Complex.getInstance(this.multiplyBy(c.getRealPart()), this.multiplyBy(c.getImaginaryPart()));
        }
        return Lisp.type_error(obj, Symbol.NUMBER);
    }

    @Override
    public LispObject divideBy(LispObject obj) {
        if (obj instanceof Fixnum) {
            return new DoubleFloat(this.value / (double)((Fixnum)obj).value);
        }
        if (obj instanceof SingleFloat) {
            return new DoubleFloat(this.value / (double)((SingleFloat)obj).value);
        }
        if (obj instanceof DoubleFloat) {
            return new DoubleFloat(this.value / ((DoubleFloat)obj).value);
        }
        if (obj instanceof Bignum) {
            return new DoubleFloat(this.value / ((Bignum)obj).doubleValue());
        }
        if (obj instanceof Ratio) {
            return new DoubleFloat(this.value / ((Ratio)obj).doubleValue());
        }
        if (obj instanceof Complex) {
            Complex c = (Complex)obj;
            LispObject re = c.getRealPart();
            LispObject im = c.getImaginaryPart();
            LispObject denom = re.multiplyBy(re).add(im.multiplyBy(im));
            LispObject resX = this.multiplyBy(re).divideBy(denom);
            LispObject resY = this.multiplyBy(Fixnum.MINUS_ONE).multiplyBy(im).divideBy(denom);
            return Complex.getInstance(resX, resY);
        }
        return Lisp.type_error(obj, Symbol.NUMBER);
    }

    @Override
    public boolean isEqualTo(LispObject obj) {
        if (obj instanceof Fixnum) {
            return this.value == (double)((Fixnum)obj).value;
        }
        if (obj instanceof SingleFloat) {
            return this.value == (double)((SingleFloat)obj).value;
        }
        if (obj instanceof DoubleFloat) {
            return this.value == ((DoubleFloat)obj).value;
        }
        if (obj instanceof Bignum) {
            return this.rational().isEqualTo(obj);
        }
        if (obj instanceof Ratio) {
            return this.rational().isEqualTo(obj);
        }
        if (obj instanceof Complex) {
            return obj.isEqualTo(this);
        }
        Lisp.type_error(obj, Symbol.NUMBER);
        return false;
    }

    @Override
    public boolean isNotEqualTo(LispObject obj) {
        return !this.isEqualTo(obj);
    }

    @Override
    public boolean isLessThan(LispObject obj) {
        if (obj instanceof Fixnum) {
            return this.value < (double)((Fixnum)obj).value;
        }
        if (obj instanceof SingleFloat) {
            return this.value < (double)((SingleFloat)obj).value;
        }
        if (obj instanceof DoubleFloat) {
            return this.value < ((DoubleFloat)obj).value;
        }
        if (obj instanceof Bignum) {
            return this.rational().isLessThan(obj);
        }
        if (obj instanceof Ratio) {
            return this.rational().isLessThan(obj);
        }
        Lisp.type_error(obj, Symbol.REAL);
        return false;
    }

    @Override
    public boolean isGreaterThan(LispObject obj) {
        if (obj instanceof Fixnum) {
            return this.value > (double)((Fixnum)obj).value;
        }
        if (obj instanceof SingleFloat) {
            return this.value > (double)((SingleFloat)obj).value;
        }
        if (obj instanceof DoubleFloat) {
            return this.value > ((DoubleFloat)obj).value;
        }
        if (obj instanceof Bignum) {
            return this.rational().isGreaterThan(obj);
        }
        if (obj instanceof Ratio) {
            return this.rational().isGreaterThan(obj);
        }
        Lisp.type_error(obj, Symbol.REAL);
        return false;
    }

    @Override
    public boolean isLessThanOrEqualTo(LispObject obj) {
        if (obj instanceof Fixnum) {
            return this.value <= (double)((Fixnum)obj).value;
        }
        if (obj instanceof SingleFloat) {
            return this.value <= (double)((SingleFloat)obj).value;
        }
        if (obj instanceof DoubleFloat) {
            return this.value <= ((DoubleFloat)obj).value;
        }
        if (obj instanceof Bignum) {
            return this.rational().isLessThanOrEqualTo(obj);
        }
        if (obj instanceof Ratio) {
            return this.rational().isLessThanOrEqualTo(obj);
        }
        Lisp.type_error(obj, Symbol.REAL);
        return false;
    }

    @Override
    public boolean isGreaterThanOrEqualTo(LispObject obj) {
        if (obj instanceof Fixnum) {
            return this.value >= (double)((Fixnum)obj).value;
        }
        if (obj instanceof SingleFloat) {
            return this.value >= (double)((SingleFloat)obj).value;
        }
        if (obj instanceof DoubleFloat) {
            return this.value >= ((DoubleFloat)obj).value;
        }
        if (obj instanceof Bignum) {
            return this.rational().isGreaterThanOrEqualTo(obj);
        }
        if (obj instanceof Ratio) {
            return this.rational().isGreaterThanOrEqualTo(obj);
        }
        Lisp.type_error(obj, Symbol.REAL);
        return false;
    }

    @Override
    public LispObject truncate(LispObject obj) {
        if (obj instanceof Fixnum) {
            return this.truncate(new DoubleFloat(((Fixnum)obj).value));
        }
        if (obj instanceof Bignum) {
            return this.truncate(new DoubleFloat(((Bignum)obj).doubleValue()));
        }
        if (obj instanceof Ratio) {
            return this.truncate(new DoubleFloat(((Ratio)obj).doubleValue()));
        }
        if (obj instanceof SingleFloat) {
            LispThread thread = LispThread.currentThread();
            double divisor = ((SingleFloat)obj).value;
            double quotient = this.value / divisor;
            if (this.value != 0.0) {
                MathFunctions.OverUnderFlowCheck(quotient);
            }
            if (quotient >= -2.147483648E9 && quotient <= 2.147483647E9) {
                int q = (int)quotient;
                return thread.setValues(Fixnum.getInstance(q), new DoubleFloat(this.value - (double)q * divisor));
            }
            long bits = Double.doubleToRawLongBits(quotient);
            int s = bits >> 63 == 0L ? 1 : -1;
            int e = (int)(bits >> 52 & 0x7FFL);
            long m = e == 0 ? (bits & 0xFFFFFFFFFFFFFL) << 1 : bits & 0xFFFFFFFFFFFFFL | 0x10000000000000L;
            LispObject significand = Lisp.number(m);
            Fixnum exponent = Fixnum.getInstance(e - 1075);
            Fixnum sign = Fixnum.getInstance(s);
            LispObject result = significand;
            result = result.multiplyBy(MathFunctions.EXPT.execute((LispObject)Fixnum.TWO, exponent));
            result = result.multiplyBy(sign);
            LispObject product = result.multiplyBy(obj);
            LispObject remainder = this.subtract(product);
            return thread.setValues(result, remainder);
        }
        if (obj instanceof DoubleFloat) {
            LispThread thread = LispThread.currentThread();
            double divisor = ((DoubleFloat)obj).value;
            double quotient = this.value / divisor;
            if (this.value != 0.0) {
                MathFunctions.OverUnderFlowCheck(quotient);
            }
            if (quotient >= -2.147483648E9 && quotient <= 2.147483647E9) {
                int q = (int)quotient;
                return thread.setValues(Fixnum.getInstance(q), new DoubleFloat(this.value - (double)q * divisor));
            }
            long bits = Double.doubleToRawLongBits(quotient);
            int s = bits >> 63 == 0L ? 1 : -1;
            int e = (int)(bits >> 52 & 0x7FFL);
            long m = e == 0 ? (bits & 0xFFFFFFFFFFFFFL) << 1 : bits & 0xFFFFFFFFFFFFFL | 0x10000000000000L;
            LispObject significand = Lisp.number(m);
            Fixnum exponent = Fixnum.getInstance(e - 1075);
            Fixnum sign = Fixnum.getInstance(s);
            LispObject result = significand;
            result = result.multiplyBy(MathFunctions.EXPT.execute((LispObject)Fixnum.TWO, exponent));
            result = result.truncate(Fixnum.ONE);
            DoubleFloat remainder = DoubleFloat.coerceToFloat(thread._values[1]);
            result = result.multiplyBy(sign);
            return thread.setValues(result, remainder);
        }
        return Lisp.type_error(obj, Symbol.REAL);
    }

    public int hashCode() {
        long bits = Double.doubleToLongBits(this.value);
        return (int)(bits ^ bits >>> 32);
    }

    @Override
    public int psxhash() {
        if (this.value % 1.0 == 0.0) {
            return (int)this.value & Integer.MAX_VALUE;
        }
        return this.hashCode() & Integer.MAX_VALUE;
    }

    @Override
    public String printObject() {
        boolean printReadably;
        if (this.value == Double.POSITIVE_INFINITY) {
            StringBuilder sb = new StringBuilder("#.");
            sb.append(Symbol.DOUBLE_FLOAT_POSITIVE_INFINITY.printObject());
            return sb.toString();
        }
        if (this.value == Double.NEGATIVE_INFINITY) {
            StringBuilder sb = new StringBuilder("#.");
            sb.append(Symbol.DOUBLE_FLOAT_NEGATIVE_INFINITY.printObject());
            return sb.toString();
        }
        LispThread thread = LispThread.currentThread();
        boolean bl = printReadably = Symbol.PRINT_READABLY.symbolValue(thread) != Lisp.NIL;
        if (this.value != this.value) {
            if (printReadably) {
                return "#.(CL:PROGN \"Comment: create a NaN.\" (CL:/ 0.0d0 0.0d0))";
            }
            return this.unreadableString("DOUBLE-FLOAT NaN", false);
        }
        String s1 = String.valueOf(this.value);
        if (printReadably || !Lisp.memq(Symbol.READ_DEFAULT_FLOAT_FORMAT.symbolValue(thread), Lisp.list(Symbol.DOUBLE_FLOAT, Symbol.LONG_FLOAT))) {
            if (s1.indexOf(69) >= 0) {
                return s1.replace('E', 'd');
            }
            return s1.concat("d0");
        }
        return s1;
    }

    public LispObject rational() {
        BigInteger denominator;
        BigInteger numerator;
        int exponent;
        long bits = Double.doubleToRawLongBits(this.value);
        int sign = bits >> 63 == 0L ? 1 : -1;
        int storedExponent = (int)(bits >> 52 & 0x7FFL);
        long mantissa = storedExponent == 0 ? (bits & 0xFFFFFFFFFFFFFL) << 1 : bits & 0xFFFFFFFFFFFFFL | 0x10000000000000L;
        if (mantissa == 0L) {
            return Fixnum.ZERO;
        }
        if (sign < 0) {
            mantissa = -mantissa;
        }
        if ((exponent = storedExponent - 1023) < 0) {
            numerator = BigInteger.valueOf(mantissa);
            denominator = BigInteger.valueOf(1L).shiftLeft(52 - exponent);
        } else {
            numerator = BigInteger.valueOf(mantissa).shiftLeft(exponent);
            denominator = BigInteger.valueOf(0x10000000000000L);
        }
        return Lisp.number(numerator, denominator);
    }

    public static DoubleFloat coerceToFloat(LispObject obj) {
        if (obj instanceof DoubleFloat) {
            return (DoubleFloat)obj;
        }
        if (obj instanceof Fixnum) {
            return new DoubleFloat(((Fixnum)obj).value);
        }
        if (obj instanceof Bignum) {
            return new DoubleFloat(((Bignum)obj).doubleValue());
        }
        if (obj instanceof SingleFloat) {
            return new DoubleFloat(((SingleFloat)obj).value);
        }
        if (obj instanceof Ratio) {
            return new DoubleFloat(((Ratio)obj).doubleValue());
        }
        Lisp.error(new TypeError("The value " + obj.princToString() + " cannot be converted to type DOUBLE-FLOAT."));
        return null;
    }

    static {
        Symbol.DOUBLE_FLOAT_POSITIVE_INFINITY.initializeConstant(DOUBLE_FLOAT_POSITIVE_INFINITY);
        Symbol.DOUBLE_FLOAT_NEGATIVE_INFINITY.initializeConstant(DOUBLE_FLOAT_NEGATIVE_INFINITY);
    }
}

