/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.painless.ir;

import org.elasticsearch.painless.ClassWriter;
import org.elasticsearch.painless.Location;
import org.elasticsearch.painless.MethodWriter;
import org.elasticsearch.painless.WriterConstants;
import org.elasticsearch.painless.ir.ArgumentsNode;
import org.elasticsearch.painless.ir.ExpressionNode;
import org.elasticsearch.painless.lookup.PainlessClassBinding;
import org.elasticsearch.painless.lookup.PainlessInstanceBinding;
import org.elasticsearch.painless.lookup.PainlessMethod;
import org.elasticsearch.painless.phase.IRTreeVisitor;
import org.elasticsearch.painless.symbol.FunctionTable;
import org.elasticsearch.painless.symbol.WriteScope;
import org.objectweb.asm.Label;
import org.objectweb.asm.Type;
import org.objectweb.asm.commons.Method;

public class InvokeCallMemberNode
extends ArgumentsNode {
    private FunctionTable.LocalFunction localFunction;
    private PainlessMethod importedMethod;
    private PainlessClassBinding classBinding;
    private int classBindingOffset;
    private PainlessInstanceBinding instanceBinding;
    private String bindingName;

    public void setLocalFunction(FunctionTable.LocalFunction localFunction) {
        this.localFunction = localFunction;
    }

    public FunctionTable.LocalFunction getLocalFunction() {
        return this.localFunction;
    }

    public void setImportedMethod(PainlessMethod importedMethod) {
        this.importedMethod = importedMethod;
    }

    public PainlessMethod getImportedMethod() {
        return this.importedMethod;
    }

    public void setClassBinding(PainlessClassBinding classBinding) {
        this.classBinding = classBinding;
    }

    public PainlessClassBinding getClassBinding() {
        return this.classBinding;
    }

    public void setClassBindingOffset(int classBindingOffset) {
        this.classBindingOffset = classBindingOffset;
    }

    public int getClassBindingOffset() {
        return this.classBindingOffset;
    }

    public void setInstanceBinding(PainlessInstanceBinding instanceBinding) {
        this.instanceBinding = instanceBinding;
    }

    public PainlessInstanceBinding getInstanceBinding() {
        return this.instanceBinding;
    }

    public void setBindingName(String bindingName) {
        this.bindingName = bindingName;
    }

    public String getBindingName() {
        return this.bindingName;
    }

    @Override
    public <Scope> void visit(IRTreeVisitor<Scope> irTreeVisitor, Scope scope) {
        irTreeVisitor.visitInvokeCallMember(this, scope);
    }

    @Override
    public <Scope> void visitChildren(IRTreeVisitor<Scope> irTreeVisitor, Scope scope) {
        for (ExpressionNode argumentNode : this.getArgumentNodes()) {
            argumentNode.visit(irTreeVisitor, scope);
        }
    }

    public InvokeCallMemberNode(Location location) {
        super(location);
    }

    @Override
    public void write(ClassWriter classWriter, MethodWriter methodWriter, WriteScope writeScope) {
        methodWriter.writeDebugInfo(this.getLocation());
        if (this.localFunction != null) {
            if (!this.localFunction.isStatic()) {
                methodWriter.loadThis();
            }
            for (ExpressionNode argumentNode : this.getArgumentNodes()) {
                argumentNode.write(classWriter, methodWriter, writeScope);
            }
            if (this.localFunction.isStatic()) {
                methodWriter.invokeStatic(WriterConstants.CLASS_TYPE, this.localFunction.getAsmMethod());
            } else {
                methodWriter.invokeVirtual(WriterConstants.CLASS_TYPE, this.localFunction.getAsmMethod());
            }
        } else if (this.importedMethod != null) {
            for (ExpressionNode argumentNode : this.getArgumentNodes()) {
                argumentNode.write(classWriter, methodWriter, writeScope);
            }
            methodWriter.invokeStatic(Type.getType(this.importedMethod.targetClass), new Method(this.importedMethod.javaMethod.getName(), this.importedMethod.methodType.toMethodDescriptorString()));
        } else if (this.classBinding != null) {
            int argument;
            Type type = Type.getType(this.classBinding.javaConstructor.getDeclaringClass());
            int javaConstructorParameterCount = this.classBinding.javaConstructor.getParameterCount() - this.classBindingOffset;
            Label nonNull = new Label();
            methodWriter.loadThis();
            methodWriter.getField(WriterConstants.CLASS_TYPE, this.bindingName, type);
            methodWriter.ifNonNull(nonNull);
            methodWriter.loadThis();
            methodWriter.newInstance(type);
            methodWriter.dup();
            if (this.classBindingOffset == 1) {
                methodWriter.loadThis();
            }
            for (argument = 0; argument < javaConstructorParameterCount; ++argument) {
                this.getArgumentNodes().get(argument).write(classWriter, methodWriter, writeScope);
            }
            methodWriter.invokeConstructor(type, Method.getMethod(this.classBinding.javaConstructor));
            methodWriter.putField(WriterConstants.CLASS_TYPE, this.bindingName, type);
            methodWriter.mark(nonNull);
            methodWriter.loadThis();
            methodWriter.getField(WriterConstants.CLASS_TYPE, this.bindingName, type);
            for (argument = 0; argument < this.classBinding.javaMethod.getParameterCount(); ++argument) {
                this.getArgumentNodes().get(argument + javaConstructorParameterCount).write(classWriter, methodWriter, writeScope);
            }
            methodWriter.invokeVirtual(type, Method.getMethod((java.lang.reflect.Method)this.classBinding.javaMethod));
        } else if (this.instanceBinding != null) {
            Type type = Type.getType(this.instanceBinding.targetInstance.getClass());
            methodWriter.loadThis();
            methodWriter.getStatic(WriterConstants.CLASS_TYPE, this.bindingName, type);
            for (int argument = 0; argument < this.instanceBinding.javaMethod.getParameterCount(); ++argument) {
                this.getArgumentNodes().get(argument).write(classWriter, methodWriter, writeScope);
            }
            methodWriter.invokeVirtual(type, Method.getMethod((java.lang.reflect.Method)this.instanceBinding.javaMethod));
        } else {
            throw new IllegalStateException("invalid unbound call");
        }
    }
}

