/*
 * Decompiled with CFR 0.152.
 */
package gnu.kawa.io;

import gnu.kawa.io.CharArrayInPort;
import gnu.kawa.io.OutPort;
import gnu.kawa.io.Path;
import gnu.lists.Consumer;
import gnu.lists.FString;
import java.io.IOException;

public class CharArrayOutPort
extends OutPort {
    public CharArrayOutPort() {
        super(null, false, CharArrayInPort.stringPath);
    }

    public CharArrayOutPort(boolean printPretty, Path path) {
        super(null, printPretty, false, path);
    }

    public int length() {
        return this.getFillIndex();
    }

    public int size() {
        return this.getFillIndex();
    }

    public void setLength(int length) {
        this.bout.setFillIndex(length);
    }

    public void reset() {
        this.setLength(0);
    }

    public char[] toCharArray() {
        int length = this.getFillIndex();
        char[] result = new char[length];
        System.arraycopy(this.getBuffer(), 0, result, 0, length);
        return result;
    }

    @Override
    public void close() {
        this.flags = 4;
    }

    @Override
    protected boolean closeOnExit() {
        return false;
    }

    @Override
    public void finalize() {
    }

    public String toString() {
        return this.toSubString(0);
    }

    public String toSubString(int beginIndex, int endIndex) {
        if (endIndex > this.getFillIndex()) {
            throw new IndexOutOfBoundsException();
        }
        return new String(this.getBuffer(), beginIndex, endIndex - beginIndex);
    }

    public String toSubString(int beginIndex) {
        return new String(this.getBuffer(), beginIndex, this.getFillIndex() - beginIndex);
    }

    public void writeTo(Appendable out) {
        this.writeTo(0, this.getFillIndex(), out);
    }

    public void writeTo(int start, int count, Appendable out) {
        if (out instanceof Consumer) {
            ((Consumer)out).write(this.getBuffer(), start, count);
        } else {
            try {
                out.append(new FString(this.getBuffer()), start, start + count);
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
        }
    }

    private char[] getBuffer() {
        return this.bout.getBuffer();
    }

    private int getFillIndex() {
        return this.bout.getFillIndex();
    }
}

