--
-- (C) 2013-20 - ntop.org
--

local sonicwall = {}

-- ################################################################################

local type_map = {
   ["1"] = "TIME_STAMP",
   ["2"] = "FLOW_IDENTIFIER",
   ["3"] = "INITIATOR_GW_MAC",
   ["4"] = "RESPONDER_GW_MAC",
   ["5"] = "INITIATOR_IP_ADDR",
   ["6"] = "RESPONDER_IP_ADDR",
   ["7"] = "INITIATOR_GW_IP_ADDR",
   ["8"] = "RESPONDER_GW_IP_ADDR",
   ["9"] = "INITIATOR_IFACE",
   ["10"] = "RESPONDER_IFACE",
   ["11"] = "INITIATOR_PORT",
   ["12"] = "RESPONDER_PORT",
   ["13"] = "INIT_TO_RESP_PKTS",
   ["14"] = "INIT_TO_RESP_OCTETS",
   ["15"] = "RESP_TO_INIT_PKTS",
   ["16"] = "RESP_TO_INIT_OCTETS",
   ["17"] = "FLOW_START_TIME",
   ["18"] = "FLOW_END_TIME",
   ["19"] = "INTERNAL_FLAGS",
   ["20"] = "PROTOCOL_TYPE",
   ["22"] = "FLOW_TO_APPLICATION_ID",
   ["23"] = "FLOW_TO_USER_ID",
   ["25"] = "FLOW_TO_IPS_ID",
   ["26"] = "FLOW_TO_VIRUS_ID",
   ["27"] = "FLOW_TO_SPYWARE_ID",
   ["28"] = "TEMPLATE_IDENTIFIER",
   ["29"] = "TABLE_NAME",
   ["30"] = "COLUMN_IDENTIFIER",
   ["31"] = "COLUMN_NAME",
   ["32"] = "COLUMN_TYPE",
   ["33"] = "COLUMN_STANDARD_IPFIX_ID",
   ["34"] = "SONIC_USER_INDEX",
   ["35"] = "SONIC_USER_NAME",
   ["36"] = "SONIC_USER_ID",
   ["38"] = "USER_AUTH_TYPE",
   ["39"] = "APP_INDEX",
   ["40"] = "APP_ID",
   ["41"] = "APP_NAME",
   ["42"] = "APP_CAT_ID",
   ["43"] = "APP_CAT_NAME",
   ["44"] = "APP_SIG_ID",
   ["45"] = "GAV_INDEX",
   ["46"] = "GAV_NAME",
   ["47"] = "GAV_SIG_ID",
   ["48"] = "IPS_INDEX",
   ["49"] = "IPS_NAME",
   ["50"] = "IPS_CAT_ID",
   ["51"] = "IPS_CAT_NAME",
   ["52"] = "IPS_SIG_ID",
   ["53"] = "ASPY_INDEX",
   ["54"] = "ASPY_NAME",
   ["55"] = "ASPY_PROD_ID",
   ["56"] = "ASPY_PROD_NAME",
   ["57"] = "ASPY_SIG_ID",
   ["59"] = "URL_NAME",
   ["60"] = "URL_IP",
   ["62"] = "RATING_INDEX",
   ["63"] = "RATING_NAME",
   ["64"] = "REGION_ID",
   ["65"] = "COUNTRY_ID",
   ["66"] = "COUNTRY_NAME",
   ["67"] = "REGION_NAME",
   ["68"] = "LOCATION_IP",
   ["69"] = "LOCATION_REGION_ID",
   ["70"] = "LOCATION_DOMAIN_NAME",
   ["101"] = "IF_STAT_IFACE",
   ["102"] = "IF_STAT_IN_PKTS_RATE",
   ["103"] = "IF_STAT_OUT_PKTS_RATE",
   ["104"] = "IF_STAT_IN_OCTETS_RATE",
   ["105"] = "IF_STAT_OUT_OCTETS_RATE",
   ["106"] = "IF_STAT_IN_PKT_SIZE",
   ["107"] = "IF_STAT_OUT_PKT_SIZE",
   ["108"] = "IF_STAT_CONN_RATE",
   ["111"] = "FLOW_INIT_OCTETS_RATE",
   ["112"] = "FLOW_RESP_OCTETS_RATE",
   ["113"] = "FLOW_INIT_PKT_RATE",
   ["114"] = "FLOW_RESP_PKT_RATE",
   ["115"] = "FLOW_INIT_PKT_SIZE",
   ["116"] = "FLOW_RESP_PKT_SIZE",
   ["117"] = "IF_STAT_IF_NAME",
   ["118"] = "IF_STAT_IF_TYPE",
   ["119"] = "IF_STAT_IF_SPEED",
   ["120"] = "IF_STAT_IF_STATE",
   ["121"] = "IF_STAT_IF_MTU",
   ["122"] = "IF_STAT_IF_MODE",
   ["123"] = "URL_FLOW_ID",
   ["124"] = "URL_TIME_ID",
   ["126"] = "CORE_STAT_CORE_ID",
   ["127"] = "CORE_STAT_CORE_UTIL",
   ["128"] = "VOIP_FLOW_ID",
   ["130"] = "VOIP_INIT_CALL_ID",
   ["131"] = "VOIP_RESP_CALL_ID",
   ["132"] = "MEDIA_TYPE",
   ["133"] = "MEDIA_PROTOCOL",
   ["134"] = "SERVICE_NAME",
   ["135"] = "SERVICE_IP_TYPE",
   ["136"] = "SERVICE_PORT_BEGIN",
   ["137"] = "SERVICE_PORT_END",
   ["138"] = "SPAM_SESS_ID",
   ["139"] = "SPAM_FLOW_ID",
   ["140"] = "SPAM_TIME_ID",
   ["141"] = "SPAM_SPAMMER",
   ["142"] = "SPAM_TYPE",
   ["143"] = "SPAM_TO_E_MAIL",
   ["144"] = "SPAM_FROM_E_MAIL",
   ["145"] = "MEM_TOTAL_RAM",
   ["146"] = "MEM_AVAIL_RAM",
   ["147"] = "MEM_USED_RAM",
   ["148"] = "MEM_DB_RAM",
   ["149"] = "MEM_FLOW_COUNT",
   ["150"] = "MEM_PER_FLOW",
   ["151"] = "DEV_IFACE_ID",
   ["152"] = "DEV_IP_ADDR",
   ["153"] = "DEV_MAC_ADDR",
   ["154"] = "DEV_NAME",
   ["155"] = "VPN_IN_SPI_ID",
   ["156"] = "VPN_OUT_SPI_ID",
   ["157"] = "VPN_TUNNEL_NAME",
   ["158"] = "VPN_LOCAL_GW",
   ["159"] = "VPN_REMOTE_GW",
   ["160"] = "VPN_TUNNEL_IFACE_ID",
   ["161"] = "VPN_POLICY_TYPE",
   ["162"] = "VPN_PROTOCOL_TYPE",
   ["163"] = "VPN_ENCRYPTION_TYPE",
   ["164"] = "VPN_AUTHENTICATION_TYPE",
   ["165"] = "VPN_START_TIME",
   ["166"] = "VPN_END_TIME",
   ["167"] = "INIT_VPN_SPI_OUT",
   ["168"] = "RESP_VPN_SPI_OUT",
   ["169"] = "INIT_TO_RESP_DELTA_PKTS",
   ["170"] = "INIT_TO_RESP_DELTA_OCTETS",
   ["171"] = "RESP_TO_INIT_DELTA_PKTS",
   ["172"] = "RESP_TO_INIT_DELTA_OCTETS",
   ["173"] = "FLOW_BLOCK_REASON",
   ["174"] = "IF_STAT_MAC_ADDRESS",
   ["175"] = "IF_STAT_IP_ADDRESS",
   ["176"] = "IF_STAT_SECURITY_TYPE",
   ["177"] = "IF_STAT_ZONE_NAME",
   ["178"] = "USER_IP_ADDR",
   ["179"] = "URL_RATING_VAL1",
   ["180"] = "URL_RATING_VAL2",
   ["181"] = "URL_RATING_VAL3",
   ["182"] = "URL_RATING_VAL4",
   ["183"] = "APP_BWM_ATTR",
   ["184"] = "VOIP_INIT2RESP_LOST_PKTS",
   ["185"] = "VOIP_RESP2INIT_LOST_PKTS",
   ["186"] = "VOIP_INIT2RESP_AVG_LATENCY",
   ["187"] = "VOIP_INIT2RESP_MAX_LATENCY",
   ["188"] = "VOIP_RESP2INIT_AVG_LATENCY",
   ["189"] = "VOIP_RESP2INIT_MAX_LATENCY",
   ["190"] = "APP_CONTENT_TYPE",
   ["191"] = "SNWL_OPTION",
   ["192"] = "APP_RISK_ATTR",
   ["193"] = "APP_TECH_ATTR",
   ["194"] = "APP_ATTR_BIT_MASK",
   ["195"] = "TOP_APPS_SIGID",
   ["196"] = "TOP_APPS_APPNAME",
   ["197"] = "TOP_APPS_RATE",
}

local type_value_map = {
   ["22"] = { -- EField = 22, Field bytes = 4, EntId = 8741, type = unsigned int-32bits, name=flow to application id
      ["1"] = "Skype",
      ["3"] = "Winny",
      ["4"] = "eMule",
      ["5"] = "Encrypted Key Exchange",
      ["6"] = "Non-SSL traffic over SSL port",
      ["7"] = "Encrypted Key Exchange",
      ["58"] = "Flash Video (FLV)",
      ["59"] = "Flash Video (FLV)",
      ["63"] = "BitTorrent Protocol",
      ["66"] = "BitTorrent Protocol",
      ["69"] = "Tlen",
      ["70"] = "Tlen",
      ["74"] = "Microsoft MSN Messenger",
      ["76"] = "Microsoft MSN Messenger",
      ["77"] = "Hotspot Shield VPN",
      ["78"] = "Flash Video (FLV)",
      ["79"] = "Xunlei Thunder",
      ["84"] = "QQDownload",
      ["87"] = "ICQ",
      ["89"] = "QQDownload",
      ["94"] = "Microsoft MSN Messenger",
      ["95"] = "IRC",
      ["100"] = "IRC",
      ["101"] = "IRC",
      ["102"] = "AIM",
      ["103"] = "AIM",
      ["104"] = "AIM",
      ["107"] = "NomaDesk",
      ["108"] = "NomaDesk",
      ["110"] = "NomaDesk",
      ["112"] = "NewsStand",
      ["113"] = "Netlog",
      ["118"] = "QQDownload",
      ["119"] = "The Motley Fool",
      ["120"] = "Morningstar",
      ["121"] = "AIM/ICQ",
      ["123"] = "Microsoft Silverlight",
      ["127"] = "QQDownload",
      ["128"] = "PPStream",
      ["129"] = "PPStream",
      ["130"] = "PPStream",
      ["133"] = "Telnet",
      ["135"] = "GOGOBOX",
      ["136"] = "Morningstar",
      ["137"] = "Morningstar",
      ["138"] = "Oracle",
      ["139"] = "Kerberos v5",
      ["140"] = "TeamViewer",
      ["141"] = "AIM",
      ["143"] = "AIM",
      ["144"] = "Shutterfly",
      ["145"] = "Mop BBS",
      ["147"] = "Mixi",
      ["148"] = "Shockwave Flash (SWF)",
      ["150"] = "Freegate",
      ["152"] = "LogMeIn Hamachi",
      ["153"] = "LogMeIn Hamachi",
      ["154"] = "LogMeIn Hamachi",
      ["158"] = "TeamViewer",
      ["159"] = "TeamViewer",
      ["160"] = "Telnet",
      ["163"] = "Google Earth",
      ["164"] = "Windows Media",
      ["165"] = "JAP",
      ["166"] = "JAP",
      ["167"] = "Folding@Home",
      ["168"] = "Folding@Home",
      ["169"] = "HTTP-Tunnel",
      ["170"] = "MegaUpload",
      ["171"] = "MegaUpload",
      ["172"] = "Xunlei Thunder",
      ["173"] = "Microsoft MSN Messenger",
      ["175"] = "Windows Media",
      ["177"] = "Windows Media Player",
      ["178"] = "IDrive",
      ["179"] = "IDrive",
      ["181"] = "PPStream",
      ["182"] = "PPLive (PPTV)",
      ["183"] = "PPLive (PPTV)",
      ["184"] = "VNC (Remote Frame Buffer)",
      ["186"] = "Subversion",
      ["187"] = "Subversion",
      ["188"] = "Subversion",
      ["189"] = "MediaFire",
      ["191"] = "Xunlei Thunder",
      ["192"] = "Xunlei Thunder",
      ["193"] = "Xunlei Thunder",
      ["194"] = "Xunlei Thunder",
      ["195"] = "Xunlei Thunder",
      ["196"] = "Xunlei Thunder",
      ["197"] = "IBM DB2",
      ["198"] = "Oracle",
      ["201"] = "FileMaker Server",
      ["205"] = "Xunlei Thunder",
      ["206"] = "Microsoft SQL Server",
      ["207"] = "MediaFire",
      ["210"] = "GNUTella",
      ["211"] = "LimeWire",
      ["215"] = "Hulu",
      ["216"] = "Trend Micro",
      ["217"] = "Trend Micro",
      ["219"] = "Shockwave Flash (SWF)",
      ["220"] = "Microsoft Windows Updates",
      ["223"] = "Microsoft Windows Updates",
      ["224"] = "TeamViewer",
      ["233"] = "NinjaCloak",
      ["234"] = "NinjaCloak",
      ["240"] = "BeInSync",
      ["244"] = "SopCast",
      ["246"] = "TVU Networks",
      ["247"] = "Bing Maps",
      ["249"] = "CrossLoop",
      ["250"] = "CrossLoop",
      ["251"] = "CrossLoop",
      ["252"] = "FastViewer",
      ["254"] = "UUSee",
      ["255"] = "RAdmin",
      ["256"] = "Shutterfly",
      ["257"] = "SmugMug",
      ["258"] = "SIP",
      ["262"] = "Veetle",
      ["263"] = "Perforce",
      ["264"] = "SIP",
      ["265"] = "SIP",
      ["266"] = "SIP",
      ["267"] = "Perforce",
      ["268"] = "SmugMug",
      ["269"] = "MyHeritage",
      ["270"] = "MyHeritage",
      ["271"] = "NetMeeting",
      ["283"] = "IBM Informix",
      ["284"] = "Lulu",
      ["287"] = "TeamSpeak",
      ["288"] = "Lulu",
      ["289"] = "Sybase Anywhere",
      ["295"] = "Yoics",
      ["297"] = "Ventrilo",
      ["298"] = "Topix",
      ["299"] = "Apple Updates",
      ["300"] = "Apple Updates",
      ["305"] = "Bing Maps",
      ["306"] = "Bing Maps",
      ["311"] = "Kaixin001",
      ["313"] = "VSee",
      ["315"] = "WebSense",
      ["317"] = "Acresso",
      ["322"] = "SOAP",
      ["324"] = "Topix",
      ["326"] = "DistCC",
      ["327"] = "Oracle Java",
      ["328"] = "Jiayuan",
      ["329"] = "Jiayuan",
      ["330"] = "Jianghai Zhengquan",
      ["332"] = "Jira",
      ["336"] = "TeamSpeak",
      ["338"] = "Tokbox",
      ["339"] = "Tokbox",
      ["340"] = "Xunlei Thunder",
      ["341"] = "Xunlei Thunder",
      ["342"] = "RPC Portmapper",
      ["343"] = "RPC Portmapper",
      ["349"] = "Spotify",
      ["350"] = "Spotify",
      ["351"] = "Spotify",
      ["353"] = "AIM",
      ["355"] = "AIM",
      ["359"] = "AIM",
      ["360"] = "AIM",
      ["366"] = "Microsoft MSN Messenger",
      ["378"] = "Camfrog",
      ["383"] = "Camfrog",
      ["389"] = "Camfrog",
      ["390"] = "Camfrog",
      ["392"] = "Camfrog",
      ["393"] = "Imeem",
      ["395"] = "Camfrog",
      ["404"] = "Tonghuashun",
      ["405"] = "AIM",
      ["406"] = "Autobahn",
      ["410"] = "SIP",
      ["412"] = "SIP",
      ["413"] = "Ventrilo",
      ["414"] = "Vimeo",
      ["416"] = "Vimeo",
      ["417"] = "VSee",
      ["418"] = "PCAnywhere",
      ["419"] = "VSee",
      ["420"] = "SIP",
      ["421"] = "SIP",
      ["424"] = "Comcast",
      ["425"] = "Cox",
      ["426"] = "Microsoft",
      ["427"] = "Hushmail",
      ["431"] = "Trillian",
      ["435"] = "Microsoft Remote Desktop",
      ["436"] = "Microsoft Remote Desktop",
      ["439"] = "Yahoo!",
      ["440"] = "Yahoo! Messenger",
      ["441"] = "SOAP",
      ["442"] = "CBS Radio Player",
      ["446"] = "SSH Protocol",
      ["447"] = "Hi5",
      ["448"] = "Hi5",
      ["449"] = "Zimbra",
      ["450"] = "Blog Flux",
      ["451"] = "Zimbra",
      ["452"] = "Blog Flux",
      ["455"] = "Horde",
      ["456"] = "Quicktime",
      ["457"] = "Windows Media",
      ["458"] = "Windows Media",
      ["459"] = "SHOUTcast",
      ["460"] = "Icecast",
      ["461"] = "Upcoming",
      ["462"] = "IlohaMail",
      ["466"] = "Hexungudao",
      ["467"] = "Habbo",
      ["469"] = "Mail.com",
      ["470"] = "Mail.ru",
      ["471"] = "Gabbly",
      ["472"] = "Gabbly",
      ["473"] = "Gabbly",
      ["474"] = "Friendster",
      ["475"] = "SMB",
      ["476"] = "SMB",
      ["477"] = "Microsoft RPC End Point Mapper",
      ["481"] = "FriendFeed",
      ["484"] = "Twig",
      ["486"] = "SquirrelMail",
      ["491"] = "Mobilatory",
      ["494"] = "PPLive (PPTV)",
      ["496"] = "RoundCube",
      ["497"] = "PodOmatic",
      ["498"] = "QQ Mail",
      ["499"] = "Optimum Webmail",
      ["500"] = "OpenWebMail",
      ["501"] = "OpenWebMail",
      ["504"] = "Noteworthy Webmail",
      ["506"] = "MGCP",
      ["507"] = "PodOmatic",
      ["508"] = "X11",
      ["509"] = "X11",
      ["510"] = "Telnet",
      ["511"] = "Telnet",
      ["512"] = "X Font Server",
      ["513"] = "X Font Server",
      ["514"] = "Rlogin",
      ["515"] = "Rlogin",
      ["516"] = "Vedivi Wallcooler",
      ["517"] = "RSH",
      ["518"] = "RSH",
      ["520"] = "PCAnywhere",
      ["522"] = "Sensepost ReDuh",
      ["525"] = "GBridge",
      ["527"] = "GBridge",
      ["529"] = "Google Calendar",
      ["533"] = "CUPS",
      ["536"] = "IPSec PGPNet",
      ["537"] = "ShowMyPC",
      ["539"] = "ShowMyPC",
      ["541"] = "ShowMyPC",
      ["545"] = "Flixster",
      ["546"] = "Feedreader",
      ["547"] = "FeedBlitz",
      ["548"] = "FC2 Blog",
      ["549"] = "eSnips",
      ["550"] = "eBay",
      ["551"] = "EatLime",
      ["554"] = "FeedBlitz",
      ["555"] = "Meeting Maker",
      ["556"] = "Geni",
      ["564"] = "37signals Basecamp",
      ["565"] = "37signals Basecamp",
      ["566"] = "Zoho",
      ["567"] = "Carbonite Online Backup",
      ["568"] = "Apple iCloud",
      ["569"] = "IBackup",
      ["570"] = "IBackup",
      ["571"] = "Mozy Online Backup",
      ["572"] = "Internet Printing Protocol",
      ["573"] = "Internet Printing Protocol",
      ["574"] = "MP3",
      ["575"] = "Shockwave Flash (SWF)",
      ["578"] = "Microsoft Active Directory",
      ["581"] = "Microsoft Distributed Transaction Coord",
      ["582"] = "Microsoft File Replication",
      ["583"] = "Microsoft File Replication",
      ["584"] = "Microsoft File Replication",
      ["585"] = "Microsoft IIS",
      ["594"] = "MPEG",
      ["595"] = "Microsoft Messenger",
      ["596"] = "Microsoft Messenger",
      ["597"] = "Microsoft Message Queue",
      ["598"] = "Microsoft Message Queue",
      ["599"] = "Microsoft Message Queue",
      ["600"] = "Microsoft Message Queue",
      ["601"] = "Microsoft Message Queue",
      ["602"] = "Microsoft Netlogon",
      ["603"] = "Microsoft Task Scheduler",
      ["604"] = "Microsoft Task Scheduler",
      ["605"] = "Microsoft Task Scheduler",
      ["606"] = "Microsoft DNS",
      ["607"] = "Microsoft WINS",
      ["608"] = "Microsoft WINS",
      ["609"] = "Microsoft Exchange",
      ["610"] = "Microsoft Exchange",
      ["612"] = "Microsoft Exchange",
      ["613"] = "Microsoft Exchange",
      ["615"] = "Microsoft Exchange",
      ["616"] = "Microsoft Exchange",
      ["617"] = "Microsoft Exchange",
      ["618"] = "Microsoft Exchange",
      ["620"] = "Microsoft Exchange",
      ["621"] = "Microsoft Exchange",
      ["622"] = "Microsoft Exchange",
      ["625"] = "Microsoft Exchange",
      ["626"] = "Microsoft Exchange",
      ["627"] = "Microsoft Exchange",
      ["628"] = "QuakeLive",
      ["629"] = "Eachnet",
      ["630"] = "Eachnet",
      ["632"] = "CVSup",
      ["633"] = "163.com Webmail",
      ["634"] = "Trend Micro",
      ["635"] = "163.com Webmail",
      ["638"] = "Geni",
      ["639"] = "Gnolia",
      ["640"] = "NetFlow v9",
      ["641"] = "NetFlow v9",
      ["642"] = "Gaia Online",
      ["643"] = "Gaia Online",
      ["644"] = "Microsoft SQL Server",
      ["645"] = "Clarizen",
      ["654"] = "Nagios",
      ["655"] = "Nagios",
      ["656"] = "Nagios",
      ["657"] = "Nagios",
      ["658"] = "Kerberos v5",
      ["661"] = "Kerberos v5",
      ["663"] = "Kerberos v5",
      ["666"] = "LDAP v3",
      ["667"] = "LDAP v3",
      ["668"] = "LDAP v3",
      ["669"] = "LDAP v3",
      ["670"] = "Radius",
      ["671"] = "Radius",
      ["672"] = "TACACS Plus",
      ["673"] = "TACACS Plus",
      ["674"] = "TACACS Plus",
      ["675"] = "TACACS Plus",
      ["676"] = "Spotify",
      ["677"] = "Spotify",
      ["678"] = "Spotify",
      ["680"] = "Blackboard",
      ["682"] = "Blackboard",
      ["685"] = "RSS",
      ["686"] = "RSS",
      ["688"] = "Atom Syndication",
      ["690"] = "BitTorrent Protocol",
      ["691"] = "Kuwo",
      ["698"] = "Dealio Toolbar",
      ["699"] = "eBay API",
      ["700"] = "Finger",
      ["701"] = "Finger",
      ["704"] = "Google Analytics",
      ["705"] = "Google Toolbar",
      ["706"] = "Google Toolbar",
      ["707"] = "Google Safe Browsing",
      ["708"] = "Google Safe Browsing",
      ["711"] = "MSN Toolbar",
      ["712"] = "MSN Toolbar",
      ["713"] = "NNTP",
      ["715"] = "NNTP",
      ["718"] = "UPnP",
      ["723"] = "Microsoft Silverlight",
      ["724"] = "Microsoft Silverlight",
      ["726"] = "Whois",
      ["731"] = "CDDB",
      ["734"] = "Nico Nico Douga",
      ["735"] = "Ooyala",
      ["736"] = "Salesforce",
      ["738"] = "SugarCRM",
      ["739"] = "SugarCRM",
      ["740"] = "Bebo Mail",
      ["742"] = "Bebo Mail",
      ["743"] = "Yandex.ru Webmail",
      ["744"] = "Yandex.ru Webmail",
      ["745"] = "37signals Campfire",
      ["746"] = "37signals",
      ["747"] = "Adobe Acrobat",
      ["748"] = "SNMP",
      ["749"] = "SNMP",
      ["750"] = "SNMP",
      ["751"] = "Elluminate",
      ["752"] = "Elluminate",
      ["753"] = "eRoom.net",
      ["754"] = "GoToMeeting",
      ["755"] = "Premiere Global Services",
      ["757"] = "Vyew",
      ["759"] = "Vyew",
      ["760"] = "Yugma",
      ["761"] = "WebEx WebOffice",
      ["762"] = "Metacafe",
      ["763"] = "Metacafe",
      ["765"] = "BitComet",
      ["766"] = "BitComet",
      ["772"] = "WebCrawler",
      ["773"] = "Modbus",
      ["774"] = "Modbus",
      ["782"] = "Ubuntu APT",
      ["783"] = "Xdebug",
      ["784"] = "Xdebug",
      ["785"] = "BitDefender",
      ["788"] = "BitDefender",
      ["789"] = "AVG",
      ["790"] = "Rising Antivirus",
      ["791"] = "Rising Antivirus",
      ["792"] = "Avira",
      ["793"] = "Firefox",
      ["794"] = "Firefox",
      ["795"] = "Tortoise SVN",
      ["796"] = "RealNetworks",
      ["800"] = "VMware",
      ["801"] = "Opera",
      ["802"] = "Google Software",
      ["803"] = "JPDA",
      ["804"] = "JPDA",
      ["805"] = "Microsoft Visual Studio",
      ["806"] = "Microsoft Visual Studio",
      ["807"] = "Debian APT",
      ["808"] = "Yum",
      ["814"] = "ZYpp",
      ["815"] = "VirusTotal",
      ["816"] = "VirusTotal",
      ["817"] = "RSYNC",
      ["819"] = "RSYNC",
      ["820"] = "SOS Online Backup",
      ["821"] = "BOINC",
      ["822"] = "TD Ameritrade",
      ["823"] = "Thinkorswim",
      ["826"] = "Sina",
      ["829"] = "ALTools",
      ["830"] = "ALTools",
      ["831"] = "ESET",
      ["832"] = "Sophos",
      ["835"] = "Sina",
      ["836"] = "Sina",
      ["839"] = "Microsoft SQL Server",
      ["844"] = "Charles Schwab",
      ["845"] = "Scottrade",
      ["852"] = "RapidShare",
      ["857"] = "Blizzard Entertainment",
      ["858"] = "Blizzard Entertainment",
      ["861"] = "eBuddy",
      ["862"] = "Baidu Hi",
      ["869"] = "Serv-U FTP Server",
      ["870"] = "Serv-U FTP Server",
      ["872"] = "Pure-FTPd FTP Server",
      ["873"] = "Pure-FTPd FTP Server",
      ["874"] = "QQGame",
      ["875"] = "STUN",
      ["876"] = "QQMusic",
      ["878"] = "QQMusic",
      ["879"] = "QQMusic",
      ["880"] = "PCast",
      ["883"] = "WS_FTP Server",
      ["884"] = "WS_FTP Server",
      ["885"] = "QQLive",
      ["893"] = "PokerStars",
      ["894"] = "PokerStars",
      ["895"] = "Bwin Interactive",
      ["899"] = "EuroPoker",
      ["900"] = "PartyGaming",
      ["901"] = "PartyGaming",
      ["902"] = "Zynga Texas Holdem",
      ["904"] = "Baidu",
      ["906"] = "QQGame",
      ["908"] = "Chikka Messenger",
      ["909"] = "Chikka Messenger",
      ["912"] = "Daum",
      ["916"] = "AOL",
      ["917"] = "ILoveIM",
      ["919"] = "IMVU",
      ["920"] = "Instan-t",
      ["922"] = "Instan-t",
      ["926"] = "Google Talk",
      ["928"] = "Google Chat",
      ["930"] = "Lava Lava",
      ["931"] = "Lava Lava",
      ["932"] = "Lava Lava",
      ["933"] = "Dianji DNA",
      ["940"] = "NateOn",
      ["941"] = "NateOn",
      ["945"] = "NetEase PoPo",
      ["947"] = "PalTalk",
      ["948"] = "PalTalk",
      ["949"] = "PalTalk Express",
      ["955"] = "Spotify",
      ["956"] = "Spotify",
      ["957"] = "Namipan",
      ["961"] = "BitSpirit",
      ["963"] = "Xfire",
      ["965"] = "Xfire",
      ["966"] = "Twitter",
      ["967"] = "Twitter",
      ["969"] = "Newegg",
      ["970"] = "Newegg",
      ["971"] = "LiveJournal",
      ["972"] = "LiveJournal",
      ["973"] = "Awareness Technologies",
      ["974"] = "Sonar Central",
      ["975"] = "WebWatcher",
      ["976"] = "LinkedIn",
      ["977"] = "LinkedIn",
      ["980"] = "ZhanZuo",
      ["982"] = "Yahoo!",
      ["983"] = "Yahoo!",
      ["984"] = "YaCy",
      ["985"] = "Xobni",
      ["989"] = "Yahoo! Groups",
      ["990"] = "Yahoo! Games",
      ["992"] = "Yahoo! Finance",
      ["993"] = "Yahoo! Finance",
      ["994"] = "Xinhuanet Forum",
      ["995"] = "XING",
      ["996"] = "Xilu Forums",
      ["997"] = "Xici",
      ["1016"] = "VoipBuster",
      ["1018"] = "Kontiki",
      ["1019"] = "Kontiki",
      ["1020"] = "QQDownload",
      ["1021"] = "Google Crawler",
      ["1026"] = "Doodle",
      ["1028"] = "Doodle",
      ["1031"] = "Docstoc",
      ["1034"] = "BitTorrent Protocol",
      ["1035"] = "Dict.cn",
      ["1036"] = "eMule",
      ["1037"] = "Dict.cn",
      ["1039"] = "eMule",
      ["1042"] = "DepositFiles",
      ["1047"] = "RTSP",
      ["1050"] = "RTSP",
      ["1052"] = "VoipBuster",
      ["1055"] = "DepositFiles",
      ["1058"] = "163.com FlashMail",
      ["1063"] = "Coremail",
      ["1066"] = "TOM Online",
      ["1070"] = "Sohu",
      ["1076"] = "Eastday",
      ["1077"] = "Sina",
      ["1078"] = "Sina",
      ["1086"] = "163.com Alumni",
      ["1087"] = "163.com BBS",
      ["1089"] = "18900.com",
      ["1090"] = "18900.com",
      ["1093"] = "JD.com",
      ["1094"] = "JD.com",
      ["1097"] = "4Shared",
      ["1098"] = "51.com Games",
      ["1101"] = "51.com BBS",
      ["1102"] = "51.com",
      ["1107"] = "5460.net",
      ["1108"] = "55BBS",
      ["1110"] = "55BBS",
      ["1115"] = "800Buy",
      ["1118"] = "Alibaba.com",
      ["1119"] = "Alibaba.cn",
      ["1120"] = "Amazon.cn",
      ["1122"] = "Apple Store",
      ["1124"] = "Baidu Tieba",
      ["1127"] = "Cat898 Club",
      ["1128"] = "ChinaRen Club",
      ["1129"] = "ChinaRen Class",
      ["1131"] = "ChinaRen Class",
      ["1133"] = "Gracenote",
      ["1136"] = "Freedb",
      ["1137"] = "Classmates",
      ["1138"] = "Jive Software",
      ["1139"] = "Citrix",
      ["1141"] = "Citrix",
      ["1151"] = "Cyworld",
      ["1155"] = "D1",
      ["1156"] = "D1",
      ["1157"] = "DangDang",
      ["1159"] = "DangDang",
      ["1162"] = "BitTorrent Protocol",
      ["1166"] = "Second Life",
      ["1171"] = "Dazhihui",
      ["1173"] = "Dazhihui",
      ["1176"] = "RemotelyAnywhere",
      ["1177"] = "RemotelyAnywhere",
      ["1180"] = "RemotelyAnywhere",
      ["1182"] = "RemotelyAnywhere",
      ["1183"] = "RemotelyAnywhere",
      ["1191"] = "Microsoft Media Server (MMS)",
      ["1193"] = "MagicJack",
      ["1197"] = "360Safe",
      ["1198"] = "CVS",
      ["1199"] = "360Safe",
      ["1200"] = "360Safe",
      ["1201"] = "360Safe",
      ["1202"] = "360Safe",
      ["1203"] = "360Safe",
      ["1204"] = "360Safe",
      ["1205"] = "Kingsoft DuBa",
      ["1206"] = "MySQL Server",
      ["1207"] = "Kingsoft DuBa",
      ["1208"] = "MySQL Server",
      ["1211"] = "Adobe",
      ["1212"] = "Google Picasa",
      ["1214"] = "Google Picasa",
      ["1215"] = "PostgreSQL Server",
      ["1217"] = "Google Picasa",
      ["1219"] = "Google Picasa",
      ["1220"] = "ALYac",
      ["1221"] = "PostgreSQL Server",
      ["1222"] = "ALTools",
      ["1224"] = "Symantec Live Update",
      ["1225"] = "Symantec Live Update",
      ["1234"] = "Symantec Live Update",
      ["1235"] = "Totorosa JJAM",
      ["1236"] = "ToTo Browser",
      ["1238"] = "TVU Networks",
      ["1241"] = "Soulseek",
      ["1242"] = "Odeo",
      ["1243"] = "SinaTV",
      ["1244"] = "SinaTV",
      ["1246"] = "iDisk",
      ["1257"] = "Odeo",
      ["1264"] = "LimeWire",
      ["1277"] = "Dealio Toolbar",
      ["1279"] = "WidgiToolbar",
      ["1281"] = "SearchSettings Toolbar",
      ["1282"] = "eMule",
      ["1302"] = "RaySource",
      ["1304"] = "RaySource",
      ["1306"] = "RaySource",
      ["1311"] = "Cisco WebEx",
      ["1312"] = "QQLive",
      ["1314"] = "QQLive",
      ["1315"] = "QQLive",
      ["1321"] = "QQDownload",
      ["1324"] = "QQDownload",
      ["1329"] = "Poco",
      ["1330"] = "Poco",
      ["1339"] = "Nullsoft Winamp",
      ["1342"] = "Experience Project",
      ["1372"] = "Slingbox",
      ["1373"] = "Experience Project",
      ["1378"] = "KKBox",
      ["1384"] = "KKBox",
      ["1387"] = "MeteorNetTV",
      ["1396"] = "DontStayIn",
      ["1400"] = "GNUTella",
      ["1402"] = "GNUTella",
      ["1404"] = "GNUTella",
      ["1409"] = "Veetle",
      ["1412"] = "VeohTV",
      ["1413"] = "VeohTV",
      ["1414"] = "GNUnet",
      ["1416"] = "YouTube",
      ["1431"] = "FastTV",
      ["1434"] = "UUSee",
      ["1437"] = "Blinkx",
      ["1447"] = "Blinkx",
      ["1449"] = "DontStayIn",
      ["1453"] = "Anon.me",
      ["1454"] = "Anon.me",
      ["1479"] = "LogMeIn",
      ["1480"] = "HideMyAss",
      ["1482"] = "HideMyAss",
      ["1484"] = "WPAD",
      ["1486"] = "Club Xcar",
      ["1487"] = "UUSee",
      ["1488"] = "UUSee",
      ["1491"] = "UUSee",
      ["1492"] = "Wikipedia",
      ["1493"] = "Wikispaces",
      ["1494"] = "Wikidot",
      ["1501"] = "UUSee",
      ["1502"] = "UUSee",
      ["1503"] = "UUSee",
      ["1504"] = "UUSee",
      ["1506"] = "UUSee",
      ["1507"] = "UUSee",
      ["1508"] = "VOC BBS",
      ["1509"] = "Viadeo",
      ["1511"] = "Tongdaxin",
      ["1518"] = "TikiWiki",
      ["1519"] = "Tiexue BBS",
      ["1520"] = "Tianya BBS",
      ["1522"] = "Tianya BBS",
      ["1523"] = "Aliwangwang",
      ["1526"] = "Aliwangwang",
      ["1531"] = "Aliwangwang",
      ["1534"] = "Aliwangwang",
      ["1536"] = "Microsoft",
      ["1537"] = "Supei",
      ["1539"] = "Compass.cn",
      ["1544"] = "Soribada",
      ["1548"] = "Club Sohu",
      ["1551"] = "MediaZone",
      ["1558"] = "Download Master",
      ["1559"] = "Speedbit",
      ["1561"] = "Help.com",
      ["1562"] = "Unblocked.org",
      ["1563"] = "Unblocked.org",
      ["1565"] = "Speedbit",
      ["1568"] = "Help.com",
      ["1570"] = "Speedbit",
      ["1571"] = "Speedbit",
      ["1572"] = "DownloadStudio",
      ["1574"] = "FlashGet",
      ["1576"] = "Free Download Manager",
      ["1577"] = "GetRight",
      ["1578"] = "Xunlei Thunder",
      ["1579"] = "Avoidr",
      ["1580"] = "InetURL",
      ["1581"] = "Internet Download Accelerator",
      ["1584"] = "Go!Zilla",
      ["1585"] = "Avoidr",
      ["1587"] = "KProxy",
      ["1588"] = "KProxy",
      ["1589"] = "vsFTPd FTP Server",
      ["1590"] = "vsFTPd FTP Server",
      ["1591"] = "KProxy",
      ["1592"] = "Gaia Community",
      ["1594"] = "JDownloader",
      ["1597"] = "Megaproxy",
      ["1602"] = "MLDonkey",
      ["1603"] = "Shareaza",
      ["1604"] = "Shareaza",
      ["1605"] = "Shareaza",
      ["1606"] = "Gaia Community",
      ["1608"] = "LibraryThing",
      ["1609"] = "LibraryThing",
      ["1611"] = "Shareaza",
      ["1612"] = "wxDownload Fast",
      ["1613"] = "Wget",
      ["1617"] = "SiteScope",
      ["1618"] = "cURL",
      ["1619"] = "Lftp",
      ["1620"] = "Gadu-Gadu",
      ["1621"] = "Surrogafier",
      ["1622"] = "Gadu-Gadu",
      ["1626"] = "Axel",
      ["1628"] = "ConnectFusion",
      ["1630"] = "Skyrock",
      ["1631"] = "Skyrock",
      ["1632"] = "Sina BBS",
      ["1634"] = "SendSpace",
      ["1635"] = "Vtunnel",
      ["1636"] = "Vtunnel",
      ["1637"] = "YouPorn",
      ["1639"] = "SendSpace",
      ["1640"] = "YouPorn",
      ["1641"] = "Youku",
      ["1642"] = "Youku",
      ["1643"] = "Yahoo! Video",
      ["1645"] = "SendSpace",
      ["1646"] = "SendSpace",
      ["1647"] = "Scour",
      ["1648"] = "Scour",
      ["1649"] = "MyLife",
      ["1650"] = "Windows Media Guide",
      ["1651"] = "Rednet BBS",
      ["1652"] = "CarDomain",
      ["1653"] = "Windows Media Guide",
      ["1654"] = "Ragnarok Online",
      ["1655"] = "Ragnarok Online",
      ["1656"] = "Webshots",
      ["1657"] = "Raging Bull",
      ["1658"] = "Webshots",
      ["1659"] = "Veoh",
      ["1660"] = "Veoh",
      ["1666"] = "CarDomain",
      ["1671"] = "Sirius XM",
      ["1672"] = "Sirius XM",
      ["1673"] = "UStream",
      ["1674"] = "Qianlong BBS",
      ["1677"] = "Pioneer StarTech",
      ["1678"] = "Tudou",
      ["1679"] = "Netflix",
      ["1680"] = "QQ Jiaoyou",
      ["1684"] = "Sohu TV",
      ["1688"] = "SinaTV",
      ["1689"] = "RuTube",
      ["1690"] = "Revver",
      ["1693"] = "Revver",
      ["1694"] = "9rules",
      ["1695"] = "9rules",
      ["1696"] = "Pcpop BBS",
      ["1697"] = "Ze Frank",
      ["1699"] = "PBworks",
      ["1700"] = "Qvod",
      ["1701"] = "Paipai",
      ["1702"] = "Qvod",
      ["1708"] = "GNUTella",
      ["1710"] = "Qvod",
      ["1713"] = "Qvod",
      ["1716"] = "Fastrack",
      ["1717"] = "BitTorrent Protocol",
      ["1718"] = "BitTorrent Protocol",
      ["1719"] = "People BBS",
      ["1720"] = "Yahoo! Messenger",
      ["1723"] = "People BBS",
      ["1729"] = "AIM",
      ["1732"] = "Photobucket",
      ["1734"] = "Orkut",
      ["1735"] = "Box",
      ["1736"] = "Dropbox",
      ["1749"] = "Pandora Radio",
      ["1751"] = "Pandora Radio",
      ["1756"] = "eMule",
      ["1758"] = "Filetopia",
      ["1759"] = "WinMX",
      ["1760"] = "MP2P",
      ["1761"] = "MP2P",
      ["1762"] = "Ze Frank",
      ["1763"] = "Ares",
      ["1765"] = "Shockwave Flash (SWF)",
      ["1766"] = "National Public Radio (NPR)",
      ["1767"] = "Livestream",
      ["1768"] = "Shockwave Flash (SWF)",
      ["1771"] = "Kademlia",
      ["1775"] = "SOCKS 5",
      ["1776"] = "SOCKS 4",
      ["1777"] = "eMule",
      ["1780"] = "QQ",
      ["1781"] = "QQ",
      ["1782"] = "QQ Mail",
      ["1786"] = "GoToMyPC",
      ["1787"] = "GoToMyPC",
      ["1788"] = "GoToMyPC",
      ["1789"] = "Bolt.com",
      ["1790"] = "Live365",
      ["1791"] = "6cn",
      ["1794"] = "ABC Streaming Media",
      ["1796"] = "Adobe Media Player",
      ["1799"] = "Blinkx",
      ["1800"] = "Audiogalaxy Rhapsody",
      ["1804"] = "CCTV Box",
      ["1806"] = "Bolt.com",
      ["1808"] = "aNobii",
      ["1809"] = "aNobii",
      ["1811"] = "Dailymotion",
      ["1812"] = "Deezer",
      ["1814"] = "EveryZing",
      ["1815"] = "Flickr",
      ["1816"] = "Gizmoz",
      ["1817"] = "Gougou",
      ["1818"] = "Gougou",
      ["1819"] = "Funshion",
      ["1838"] = "Funshion",
      ["1839"] = "Funshion",
      ["1840"] = "GOM Player",
      ["1841"] = "GOM Player",
      ["1842"] = "aSmallWorld",
      ["1850"] = "GMX",
      ["1851"] = "GMX",
      ["1852"] = "Apple iTunes",
      ["1854"] = "Musicmatch",
      ["1857"] = "aSmallWorld",
      ["1859"] = "Bing",
      ["1860"] = "Bing",
      ["1861"] = "Bing",
      ["1862"] = "Bing",
      ["1864"] = "Google Desktop",
      ["1865"] = "Google Docs",
      ["1866"] = "Google Finance",
      ["1869"] = "Google Groups",
      ["1871"] = "Google Sites",
      ["1872"] = "Google Search",
      ["1874"] = "Blogger.com",
      ["1876"] = "Ask.com Search",
      ["1879"] = "VoipStunt",
      ["1881"] = "VoipStunt",
      ["1883"] = "VoipStunt",
      ["1884"] = "VoipStunt",
      ["1885"] = "TelTel",
      ["1886"] = "Stickam",
      ["1887"] = "Stickam",
      ["1893"] = "IAX2",
      ["1895"] = "H.245 Call Control",
      ["1896"] = "Yahoo! Toolbar",
      ["1898"] = "StumbleUpon",
      ["1899"] = "StumbleUpon",
      ["1900"] = "Icecast",
      ["1901"] = "Windows Media",
      ["1902"] = "StumbleUpon",
      ["1903"] = "Nullsoft Winamp",
      ["1904"] = "RealMedia",
      ["1905"] = "XMMS",
      ["1906"] = "McAfee SiteAdvisor",
      ["1907"] = "eBay API",
      ["1908"] = "Alexa",
      ["1909"] = "Alexa",
      ["1910"] = "AOL Toolbar",
      ["1911"] = "AOL Toolbar",
      ["1912"] = "Microsoft Media Server (MMS)",
      ["1913"] = "AOL Toolbar",
      ["1915"] = "Windows Media",
      ["1917"] = "AOL Toolbar",
      ["1921"] = "eMule",
      ["1922"] = "eMule",
      ["1925"] = "TakingITGlobal",
      ["1926"] = "Syslog",
      ["1927"] = "Yourfilehost",
      ["1929"] = "Yourfilehost",
      ["1930"] = "YouSendIt",
      ["1932"] = "YouSendIt",
      ["1933"] = "Barafranca (Omerta)",
      ["1934"] = "Barafranca (Omerta)",
      ["1949"] = "Chosenspace",
      ["1950"] = "Microsoft MSN Messenger",
      ["1951"] = "Windows Live Messenger File Transfer",
      ["1952"] = "Windows Live Messenger File Transfer",
      ["1953"] = "Microsoft MSN Messenger",
      ["1955"] = "Chosenspace",
      ["1958"] = "Criminal Nations",
      ["1960"] = "AIM",
      ["1963"] = "AIM",
      ["1967"] = "Bigpoint Games",
      ["1968"] = "Bigpoint Games",
      ["1970"] = "DarkOrbit",
      ["1972"] = "TakingITGlobal",
      ["1975"] = "BearShare",
      ["1976"] = "Rappelz",
      ["1977"] = "GPotato",
      ["1985"] = "Blokus Online",
      ["1986"] = "GameABC",
      ["1988"] = "BNB",
      ["1990"] = "Mac OS X",
      ["1994"] = "BitTorrent Protocol",
      ["1996"] = "Evony",
      ["1997"] = "Kazaa",
      ["1998"] = "Evony",
      ["2000"] = "Hotspot Shield VPN",
      ["2001"] = "Hotspot Shield VPN",
      ["2008"] = "Xunlei Thunder",
      ["2012"] = "Hopster",
      ["2026"] = "OpenVPN",
      ["2033"] = "OpenVPN",
      ["2038"] = "ChinaGames",
      ["2041"] = "Dark Age Of Camelot",
      ["2043"] = "Dark Age Of Camelot",
      ["2044"] = "Doof",
      ["2047"] = "Haofang",
      ["2049"] = "Skype",
      ["2052"] = "Skype",
      ["2054"] = "Skype",
      ["2055"] = "Hobowars",
      ["2056"] = "Hobowars",
      ["2058"] = "Blogs.com",
      ["2066"] = "Big Brother",
      ["2068"] = "Executable",
      ["2070"] = "Kaillera",
      ["2071"] = "Kaillera",
      ["2072"] = "Kaillera",
      ["2073"] = "Kaillera",
      ["2082"] = "Blogs.com",
      ["2085"] = "QQMusic",
      ["2090"] = "Ourgame GLWorld",
      ["2091"] = "JinWuTuan",
      ["2093"] = "MoYu",
      ["2094"] = "MoYu",
      ["2097"] = "MoYu",
      ["2101"] = "eMule",
      ["2106"] = "Bebo",
      ["2107"] = "Frappr!",
      ["2110"] = "Faceparty",
      ["2111"] = "Frappr!",
      ["2112"] = "QQMusic",
      ["2114"] = "MiGente",
      ["2115"] = "Oodle",
      ["2117"] = "Oodle",
      ["2126"] = "Hyves",
      ["2128"] = "Hyves",
      ["2129"] = "Direct Connect",
      ["2130"] = "Direct Connect",
      ["2132"] = "MSN Games",
      ["2133"] = "Tiancity Popkart",
      ["2134"] = "163.com Popogame",
      ["2135"] = "QQGame",
      ["2136"] = "QQGame",
      ["2137"] = "RuneScape",
      ["2138"] = "RuneScape",
      ["2139"] = "Samurai Of Legend",
      ["2140"] = "Samurai Of Legend",
      ["2141"] = "iWiW",
      ["2146"] = "CDC Games",
      ["2148"] = "Second Life",
      ["2149"] = "Second Life",
      ["2150"] = "Second Life (Teen)",
      ["2152"] = "Sina Game",
      ["2154"] = "Changyou",
      ["2155"] = "CDC Games",
      ["2158"] = "Changyou Tian Long Ba Bu",
      ["2159"] = "iWiW",
      ["2161"] = "QQMusic",
      ["2165"] = "Changyou Tian Long Ba Bu",
      ["2166"] = "Tibia Game",
      ["2170"] = "Tibia Game",
      ["2171"] = "Tycoon Online",
      ["2172"] = "Tycoon Online",
      ["2173"] = "VSA",
      ["2174"] = "VSA",
      ["2178"] = "VSA",
      ["2179"] = "VSA",
      ["2180"] = "VSA",
      ["2182"] = "GamersFirst",
      ["2183"] = "Blizzard Entertainment",
      ["2184"] = "Kaillera",
      ["2185"] = "Perfect World (Wanmei)",
      ["2186"] = "Searchles",
      ["2188"] = "Perfect World (Wanmei)",
      ["2189"] = "Perfect World (Wanmei)",
      ["2193"] = "Searchles",
      ["2196"] = "MOG",
      ["2199"] = "The Wrestling Game",
      ["2200"] = "MOG",
      ["2202"] = "The Wrestling Game",
      ["2203"] = "163.com XYQ",
      ["2204"] = "YHGame",
      ["2206"] = "QQMusic",
      ["2213"] = "QQMusic",
      ["2214"] = "Advogato",
      ["2217"] = "Advogato",
      ["2219"] = "BlogMarks",
      ["2222"] = "BlogMarks",
      ["2223"] = "QQMusic",
      ["2225"] = "Woophy",
      ["2226"] = "Google Analytics",
      ["2227"] = "Woophy",
      ["2228"] = "Atlas DMT",
      ["2232"] = "Sohu SOQ",
      ["2236"] = "WAYN",
      ["2237"] = "Quantcast",
      ["2238"] = "WAYN",
      ["2240"] = "VOX",
      ["2243"] = "VOX",
      ["2244"] = "Atlas DMT",
      ["2256"] = "Apple iChat",
      ["2260"] = "Zhuxian",
      ["2261"] = "Sina UC",
      ["2263"] = "Sina Weibo",
      ["2266"] = "Piczo",
      ["2272"] = "Rediff BOL",
      ["2273"] = "Phanfare",
      ["2274"] = "Xunlei Thunder",
      ["2276"] = "Rediff BOL",
      ["2277"] = "Phanfare",
      ["2278"] = "Xunlei Thunder",
      ["2279"] = "StudiVZ",
      ["2285"] = "APCUPSd",
      ["2286"] = "Tribe.net",
      ["2288"] = "Tribe.net",
      ["2289"] = "Xunlei Thunder",
      ["2291"] = "Your Freedom",
      ["2293"] = "Laplink Everywhere",
      ["2294"] = "Travellersrpoint",
      ["2296"] = "Travellersrpoint",
      ["2297"] = "Your Freedom",
      ["2298"] = "Your Freedom",
      ["2301"] = "DRDA",
      ["2302"] = "Fastmule",
      ["2303"] = "CouchSurfing",
      ["2305"] = "CouchSurfing",
      ["2307"] = "TravBuddy",
      ["2308"] = "Kuwo",
      ["2310"] = "TravBuddy",
      ["2311"] = "Mafia Wars",
      ["2312"] = "Kuwo",
      ["2313"] = "Kuwo",
      ["2314"] = "Bomgar",
      ["2315"] = "Bomgar",
      ["2316"] = "Student.com",
      ["2317"] = "PPTP",
      ["2318"] = "Student.com",
      ["2319"] = "GDS DB",
      ["2321"] = "SCCP",
      ["2323"] = "SCCP",
      ["2327"] = "SCCP",
      ["2328"] = "Friends Reunited",
      ["2330"] = "JuRen (Huge Man)",
      ["2333"] = "Zelune Proxy",
      ["2336"] = "Glype",
      ["2339"] = "Friends Reunited",
      ["2348"] = "Shelfari",
      ["2350"] = "CGIProxy",
      ["2352"] = "SoftEther PacketiX",
      ["2353"] = "SoftEther PacketiX",
      ["2354"] = "SoftEther PacketiX",
      ["2356"] = "CoralCDN",
      ["2357"] = "CoralCDN",
      ["2358"] = "Shockwave Flash (SWF)",
      ["2361"] = "Shelfari",
      ["2362"] = "VMware Server",
      ["2363"] = "IBM Tivoli Storage Manager",
      ["2364"] = "Teen.com",
      ["2365"] = "CA ARCserve Backup",
      ["2368"] = "Teen.com",
      ["2370"] = "MySpace",
      ["2382"] = "Guotai Junan",
      ["2384"] = "Cafe World",
      ["2385"] = "HP StorageWorks Storage Mirroring",
      ["2386"] = "OkCupid",
      ["2388"] = "SurfingToday Proxy",
      ["2389"] = "OkCupid",
      ["2390"] = "HP StorageWorks Storage Mirroring",
      ["2391"] = "HP StorageWorks Storage Mirroring",
      ["2392"] = "SurfingToday Proxy",
      ["2393"] = "Odnoklassniki",
      ["2395"] = "Odnoklassniki",
      ["2396"] = "Java RMI",
      ["2397"] = "Nexopia",
      ["2398"] = "optionsXpress",
      ["2399"] = "Qianlong",
      ["2400"] = "Rstatd",
      ["2401"] = "AddictingGames",
      ["2402"] = "Nexopia",
      ["2403"] = "NTR Connect",
      ["2407"] = "Fenxijia",
      ["2410"] = "Symantec Antivirus",
      ["2414"] = "File Dropper",
      ["2415"] = "File Dropper",
      ["2417"] = "Google Web Accelerator",
      ["2422"] = "PDBOX",
      ["2423"] = "PDBOX",
      ["2425"] = "PDBOX",
      ["2426"] = "AddictingGames",
      ["2428"] = "RayFile",
      ["2434"] = "JibJab",
      ["2436"] = "Jubii",
      ["2437"] = "Jubii Email",
      ["2440"] = "JumpTV",
      ["2441"] = "JumpTV Latino",
      ["2442"] = "Justin.tv",
      ["2443"] = "Ku6.com",
      ["2449"] = "Ku6.com",
      ["2453"] = "Last.fm",
      ["2455"] = "SageTV",
      ["2459"] = "Zynga Poker",
      ["2460"] = "SageTV",
      ["2461"] = "SageTV",
      ["2462"] = "ISAKMP",
      ["2463"] = "ISAKMP",
      ["2464"] = "BGP",
      ["2465"] = "BOOTP",
      ["2466"] = "CMP",
      ["2468"] = "Hotspot Shield VPN",
      ["2469"] = "Hotspot Shield VPN",
      ["2470"] = "4Shared",
      ["2471"] = "2Shared",
      ["2472"] = "iSCSI",
      ["2479"] = "LDP",
      ["2480"] = "LDP",
      ["2484"] = "NFS",
      ["2491"] = "NDMP",
      ["2492"] = "NDMP",
      ["2493"] = "OpenVPN",
      ["2498"] = "OpenVPN",
      ["2502"] = "RIP",
      ["2503"] = "Vipuls Razor",
      ["2504"] = "Rwho",
      ["2505"] = "Quake III Arena",
      ["2506"] = "Quake III Arena",
      ["2507"] = "SonicWall Unblock Proxy",
      ["2509"] = "RPCAP",
      ["2510"] = "NAT-PMP",
      ["2511"] = "NAT-PMP",
      ["2513"] = "UPnP",
      ["2515"] = "Microsoft CryptoAPI",
      ["2532"] = "Freegate",
      ["2543"] = "Last.fm",
      ["2544"] = "Microsoft WINS",
      ["2547"] = "SonicWall Unblock Proxy",
      ["2549"] = "Game Sites 200",
      ["2550"] = "Game Sites 200",
      ["2560"] = "FortiClient",
      ["2564"] = "YY",
      ["2565"] = "Miniclip",
      ["2572"] = "GOGOBOX",
      ["2573"] = "Digsby",
      ["2574"] = "Digsby",
      ["2576"] = "Digsby",
      ["2577"] = "Digsby",
      ["2578"] = "Digsby",
      ["2579"] = "Digsby",
      ["2581"] = "Baofeng",
      ["2582"] = "Break",
      ["2583"] = "EarthCam",
      ["2584"] = "EarthCam",
      ["2585"] = "Facebook Apps",
      ["2589"] = "Break",
      ["2590"] = "Five.tv",
      ["2591"] = "GOM TV",
      ["2592"] = "GOM TV",
      ["2593"] = "Graboid Video",
      ["2596"] = "Graboid Video",
      ["2597"] = "ITV Video Playback",
      ["2598"] = "Pogo",
      ["2600"] = "Tagoo",
      ["2601"] = "Tagoo",
      ["2608"] = "Willing Webcam",
      ["2610"] = "FONA",
      ["2611"] = "FONA",
      ["2612"] = "Livedoor",
      ["2613"] = "Livedoor",
      ["2614"] = "ESET",
      ["2618"] = "Infoseek",
      ["2619"] = "Game Zone",
      ["2621"] = "Goo Mail",
      ["2622"] = "Yahoo! Search",
      ["2625"] = "HowardForums",
      ["2628"] = "HowardForums",
      ["2633"] = "Techinline Remote Desktop",
      ["2635"] = "SpyAgent",
      ["2640"] = "eBLVD",
      ["2644"] = "QQ",
      ["2645"] = "Baofeng",
      ["2646"] = "Baofeng",
      ["2647"] = "PIPI Player",
      ["2648"] = "PIPI Player",
      ["2659"] = "Hotspot Shield VPN",
      ["2662"] = "MvBoxPlayer",
      ["2668"] = "MvBoxPlayer",
      ["2675"] = "Xunlei XLGame",
      ["2677"] = "Xunlei XLGame",
      ["2678"] = "Xunlei XLGame",
      ["2687"] = "FlashGet",
      ["2688"] = "Sina",
      ["2691"] = "Baidu Hi",
      ["2692"] = "CCTV",
      ["2708"] = "Sina UC",
      ["2709"] = "Hupu.com",
      ["2710"] = "Alicall",
      ["2711"] = "Alicall",
      ["2716"] = "Google Mail (Gmail)",
      ["2717"] = "Yahoo! Mail",
      ["2720"] = "Yahoo! Mail",
      ["2729"] = "Kazaa",
      ["2733"] = "Kugou Music Disk",
      ["2735"] = "Microsoft Remote Desktop",
      ["2742"] = "Microsoft Remote Desktop",
      ["2743"] = "BBC iPlayer",
      ["2745"] = "Smashing Games",
      ["2746"] = "Smashing Games",
      ["2747"] = "Free Online Games",
      ["2748"] = "Flickr",
      ["2752"] = "SpywareBlaster",
      ["2754"] = "Torrent Episode Downloader (ted)",
      ["2756"] = "Free Online Games",
      ["2765"] = "Sogou Musicbox",
      ["2776"] = "Coremail",
      ["2777"] = "163.com FlashMail",
      ["2778"] = "RSS Xpress",
      ["2780"] = "163.com FlashMail",
      ["2782"] = "SharpReader",
      ["2786"] = "Xunlei Thunder",
      ["2787"] = "Frontier Compute Engine",
      ["2789"] = "Xunlei Thunder",
      ["2790"] = "Xunlei XLGame",
      ["2794"] = "Slingbox",
      ["2795"] = "No-IP DUC",
      ["2797"] = "Azureus",
      ["2798"] = "Gambling Sites",
      ["2799"] = "Juice Receiver",
      ["2800"] = "Skype",
      ["2802"] = "Slingbox",
      ["2803"] = "Slingbox",
      ["2805"] = "Slingbox",
      ["2808"] = "BitTorrent Protocol",
      ["2812"] = "DynDNS Updater",
      ["2817"] = "StupidCensorship",
      ["2818"] = "StupidCensorship",
      ["2819"] = "Glype",
      ["2820"] = "NewFastWorkingProxies",
      ["2821"] = "Facebook",
      ["2822"] = "Facebook Inc",
      ["2823"] = "Tagged.com",
      ["2824"] = "Tagged.com",
      ["2825"] = "Ning",
      ["2826"] = "Ning",
      ["2827"] = "43Things",
      ["2828"] = "BlackPlanet",
      ["2829"] = "Broadcaster.com",
      ["2830"] = "Broadcaster.com",
      ["2831"] = "Care2",
      ["2832"] = "Care2",
      ["2833"] = "Espin",
      ["2835"] = "Woot",
      ["2836"] = "Woot",
      ["2837"] = "RedFlagDeals",
      ["2838"] = "Kaboodle",
      ["2841"] = "ThisNext",
      ["2842"] = "Stylehive",
      ["2844"] = "ShopStyle",
      ["2845"] = "Badoo",
      ["2846"] = "TortoiseCVS",
      ["2850"] = "Cisco WebEx",
      ["2851"] = "Cherry Red Casino",
      ["2852"] = "Rushmore Online",
      ["2853"] = "Players Only",
      ["2854"] = "Casino Bodog",
      ["2855"] = "Casino Bodog",
      ["2856"] = "Casino Tropez",
      ["2857"] = "Sports Book",
      ["2858"] = "Sports Book",
      ["2861"] = "1UP",
      ["2862"] = "Games Top 100",
      ["2865"] = "Games Top 100",
      ["2866"] = "Boxee",
      ["2867"] = "Skype",
      ["2871"] = "Xmarks",
      ["2874"] = "Xmarks",
      ["2875"] = "Xunlei Thunder",
      ["2877"] = "Synergy",
      ["2878"] = "Skype",
      ["2881"] = "Nickelodeon Jr Arcade",
      ["2882"] = "BigFish Games",
      ["2886"] = "BigFish Games",
      ["2887"] = "Candystand",
      ["2888"] = "Candystand",
      ["2889"] = "Games.com",
      ["2890"] = "Games.com",
      ["2891"] = "Neopets",
      ["2892"] = "FreshDownload",
      ["2895"] = "Neopets",
      ["2896"] = "CFNetwork",
      ["2898"] = "Vembu StoreGrid",
      ["2902"] = "OnlineGamesNet",
      ["2903"] = "OnlineGamesNet",
      ["2905"] = "Vembu StoreGrid",
      ["2908"] = "Morpheus",
      ["2910"] = "Morpheus",
      ["2912"] = "Played Online",
      ["2913"] = "DriveHQ",
      ["2915"] = "Played Online",
      ["2916"] = "DriveHQ",
      ["2918"] = "PopCap Games",
      ["2919"] = "PopCap Games",
      ["2925"] = "WildTangent ORB",
      ["2926"] = "Viewpoint Toolbar",
      ["2927"] = "Viewpoint Toolbar",
      ["2928"] = "Motorola Timbuktu Pro",
      ["2929"] = "Motorola Timbuktu Pro",
      ["2930"] = "GameSpy",
      ["2931"] = "GameSpy",
      ["2932"] = "GameSpy",
      ["2933"] = "GameSpy",
      ["2934"] = "GameSpy",
      ["2935"] = "GameSpy",
      ["2936"] = "GameSpy",
      ["2937"] = "GameSpy",
      ["2938"] = "Xbox",
      ["2939"] = "Xbox",
      ["2940"] = "Xbox",
      ["2941"] = "Xbox",
      ["2947"] = "Twister MP3",
      ["2951"] = "Twister MP3",
      ["2952"] = "MyOtherDrive",
      ["2953"] = "Microsoft MSN Messenger",
      ["2954"] = "Microsoft MSN Messenger",
      ["2955"] = "SHOUTcast",
      ["2957"] = "BearShare",
      ["2958"] = "BearShare",
      ["2959"] = "Zilla Mp3 Finder",
      ["2960"] = "Microsoft OneDrive",
      ["2961"] = "Microsoft OneDrive",
      ["2962"] = "Microsoft OneDrive",
      ["2963"] = "WeatherBug",
      ["2964"] = "WeatherBug",
      ["2965"] = "WeatherBug",
      ["2966"] = "WeatherBug",
      ["2967"] = "WeatherBug",
      ["2968"] = "Dr. Backup",
      ["2971"] = "WeatherBug",
      ["2976"] = "Elephant Drive",
      ["2978"] = "MapQuest",
      ["2979"] = "MapQuest",
      ["2983"] = "Executable",
      ["2985"] = "Executable",
      ["2986"] = "Executable",
      ["2989"] = "Executable",
      ["2990"] = "Executable",
      ["2991"] = "Image",
      ["2992"] = "Image",
      ["2993"] = "Image",
      ["2994"] = "Image",
      ["2995"] = "Image",
      ["2996"] = "Image",
      ["2999"] = "Image",
      ["3000"] = "Image",
      ["3001"] = "Executable",
      ["3003"] = "Executable",
      ["3004"] = "Executable",
      ["3005"] = "Hotspot Shield VPN",
      ["3006"] = "Executable",
      ["3007"] = "Executable",
      ["3008"] = "Executable",
      ["3010"] = "QQ",
      ["3024"] = "QQ",
      ["3027"] = "Netflix",
      ["3028"] = "SMS Free Sender",
      ["3029"] = "OfficeSMS",
      ["3030"] = "mGinger",
      ["3031"] = "Redux",
      ["3032"] = "Convivea",
      ["3034"] = "Convivea",
      ["3039"] = "Netflix",
      ["3042"] = "Document",
      ["3043"] = "Document",
      ["3046"] = "Document",
      ["3047"] = "Document",
      ["3048"] = "Document",
      ["3049"] = "Document",
      ["3050"] = "1337x",
      ["3052"] = "Archive",
      ["3053"] = "1337x",
      ["3055"] = "Archive",
      ["3056"] = "Archive",
      ["3057"] = "Archive",
      ["3058"] = "Archive",
      ["3059"] = "Archive",
      ["3060"] = "Archive",
      ["3061"] = "Netflix",
      ["3062"] = "Archive",
      ["3063"] = "Archive",
      ["3064"] = "Archive",
      ["3070"] = "QQ",
      ["3072"] = "QQ",
      ["3075"] = "Google",
      ["3076"] = "Archive",
      ["3077"] = "Archive",
      ["3080"] = "Archive",
      ["3081"] = "Archive",
      ["3086"] = "Archive",
      ["3087"] = "Archive",
      ["3088"] = "Archive",
      ["3091"] = "iPROConference",
      ["3093"] = "Webroot",
      ["3094"] = "Webroot",
      ["3096"] = "XMPP (Jabber) Protocol",
      ["3097"] = "XMPP (Jabber) Protocol",
      ["3100"] = "Netflix",
      ["3106"] = "Steganos",
      ["3107"] = "Steganos",
      ["3108"] = "Guardster",
      ["3116"] = "BitTorrent Protocol",
      ["3118"] = "Netflix",
      ["3127"] = "Netflix",
      ["3129"] = "ISL Light",
      ["3131"] = "VeryCD",
      ["3134"] = "VeryCD",
      ["3137"] = "Xunlei Thunder",
      ["3138"] = "DameWare Mini Remote Control",
      ["3140"] = "eMule",
      ["3145"] = "eMule",
      ["3148"] = "NetViewer",
      ["3149"] = "NetViewer",
      ["3150"] = "NetViewer",
      ["3152"] = "AOL Radio",
      ["3154"] = "Tor",
      ["3155"] = "Tor",
      ["3156"] = "Tor",
      ["3158"] = "eMule",
      ["3159"] = "eMule",
      ["3161"] = "eMule",
      ["3165"] = "eMule",
      ["3171"] = "eMule",
      ["3189"] = "eMule",
      ["3191"] = "eMule",
      ["3192"] = "Xunlei Thunder",
      ["3194"] = "Xunlei Thunder",
      ["3195"] = "Xunlei Thunder",
      ["3198"] = "Xunlei Thunder",
      ["3199"] = "Xunlei Thunder",
      ["3200"] = "Xunlei Thunder",
      ["3206"] = "Xunlei Thunder",
      ["3213"] = "Metacafe",
      ["3219"] = "Active WebCam",
      ["3220"] = "Scramby",
      ["3221"] = "Scramby",
      ["3224"] = "Raketu",
      ["3225"] = "Raketu",
      ["3231"] = "Executable",
      ["3233"] = "Executable",
      ["3234"] = "Executable",
      ["3237"] = "Executable",
      ["3238"] = "Executable",
      ["3239"] = "eMule",
      ["3241"] = "eMule",
      ["3243"] = "eMule",
      ["3244"] = "eMule",
      ["3250"] = "Document",
      ["3251"] = "Document",
      ["3252"] = "Document",
      ["3253"] = "Windows Media Player",
      ["3255"] = "Archive",
      ["3256"] = "Archive",
      ["3257"] = "Archive",
      ["3259"] = "Archive",
      ["3260"] = "Archive",
      ["3261"] = "Archive",
      ["3262"] = "Archive",
      ["3263"] = "Archive",
      ["3264"] = "Toonel.net",
      ["3265"] = "Microsoft OneDrive",
      ["3266"] = "Tonido",
      ["3267"] = "Windows Live Messenger File Transfer",
      ["3269"] = "XML",
      ["3270"] = "Microsoft OneDrive",
      ["3271"] = "XML",
      ["3272"] = "XML",
      ["3273"] = "Box",
      ["3274"] = "Box",
      ["3275"] = "Tonido",
      ["3277"] = "Tonido",
      ["3279"] = "Tonido",
      ["3281"] = "ZumoDrive",
      ["3282"] = "Ares",
      ["3283"] = "Ares",
      ["3284"] = "XML",
      ["3285"] = "Livedrive",
      ["3289"] = "DBank",
      ["3291"] = "21CN Webmail",
      ["3295"] = "Tianya Webmail",
      ["3296"] = "Lenovo Data",
      ["3297"] = "Syncplicity",
      ["3303"] = "Windows Live Messenger File Transfer",
      ["3307"] = "JWChat",
      ["3313"] = "Zoho Chat",
      ["3314"] = "CitrixWire",
      ["3315"] = "SpiderOak",
      ["3317"] = "FrostWire",
      ["3318"] = "FrostWire",
      ["3319"] = "Crux P2P",
      ["3321"] = "BT Chat",
      ["3324"] = "WordPress",
      ["3325"] = "BT Chat",
      ["3328"] = "BTMon",
      ["3329"] = "BTMon",
      ["3330"] = "BitTorrent.am",
      ["3331"] = "magicVORTEX",
      ["3333"] = "BitTorrent.am",
      ["3340"] = "Magic MP3 Tagger",
      ["3345"] = "Full DLs",
      ["3348"] = "Full DLs",
      ["3349"] = "H33t",
      ["3350"] = "H33t",
      ["3351"] = "ISO Hunt",
      ["3352"] = "ISO Hunt",
      ["3354"] = "Indy Torrents",
      ["3356"] = "Shufflr",
      ["3359"] = "Mikogo",
      ["3360"] = "GoToMyPC",
      ["3361"] = "GoToMyPC",
      ["3362"] = "GoToMyPC",
      ["3365"] = "QQ",
      ["3369"] = "Mininova",
      ["3370"] = "Mininova",
      ["3371"] = "New Torrents",
      ["3372"] = "New Torrents",
      ["3373"] = "RAR Bg",
      ["3374"] = "RAR Bg",
      ["3375"] = "The Pirate Bay",
      ["3376"] = "The Pirate Bay",
      ["3377"] = "Torrent Box",
      ["3378"] = "Torrent Box",
      ["3380"] = "Ares",
      ["3381"] = "AOL Radio",
      ["3382"] = "Torrent Portal",
      ["3383"] = "Torrent Portal",
      ["3385"] = "Ares",
      ["3386"] = "Torrent Reactor",
      ["3387"] = "Torrent Reactor",
      ["3388"] = "Ammyy Admin",
      ["3389"] = "LogMeIn",
      ["3390"] = "Torrent Zap",
      ["3391"] = "Ammyy Admin",
      ["3392"] = "LogMeIn Hamachi",
      ["3393"] = "Torrent Zap",
      ["3396"] = "Accordiva",
      ["3397"] = "Ammyy Admin",
      ["3409"] = "Viack VIA3",
      ["3410"] = "Windows Live Messenger File Transfer",
      ["3411"] = "Windows Live Messenger File Transfer",
      ["3414"] = "Microsoft SharePoint",
      ["3418"] = "Microsoft OneDrive",
      ["3430"] = "LogMeIn",
      ["3439"] = "Google Mail (Gmail)",
      ["3440"] = "Google Mail (Gmail)",
      ["3441"] = "Google Mail (Gmail)",
      ["3442"] = "Google Talk",
      ["3443"] = "Apple iMessage",
      ["3446"] = "NCAA March Madness",
      ["3449"] = "Moodstream",
      ["3450"] = "X-Lite",
      ["3451"] = "3CX Phone System",
      ["3452"] = "ZoIPer Communicator",
      ["3453"] = "NCAA March Madness",
      ["3456"] = "NCAA March Madness",
      ["3458"] = "NCAA March Madness",
      ["3460"] = "Buzz Softphone",
      ["3463"] = "IAX2",
      ["3465"] = "Sanguo Sha",
      ["3470"] = "Pangolin",
      ["3473"] = "SugarSync",
      ["3476"] = "Vphonet",
      ["3477"] = "Baidu Wenku",
      ["3478"] = "DocIn",
      ["3482"] = "MediaRing Talk",
      ["3483"] = "MediaRing Talk",
      ["3484"] = "Acronis Snap Deploy",
      ["3486"] = "TeamTalk",
      ["3487"] = "Brekeke",
      ["3488"] = "CC File Transfer",
      ["3489"] = "Live365",
      ["3490"] = "CC File Transfer",
      ["3498"] = "iCall",
      ["3499"] = "BeamYourScreen",
      ["3502"] = "BeamYourScreen",
      ["3504"] = "iCall",
      ["3506"] = "Yak Communications",
      ["3507"] = "Delephone",
      ["3508"] = "Delephone",
      ["3509"] = "BeamYourScreen",
      ["3516"] = "TiViPhone",
      ["3517"] = "Buzzfon",
      ["3519"] = "Gadu-Gadu",
      ["3525"] = "SJphone",
      ["3526"] = "Apple Spotlight Suggestions",
      ["3530"] = "Reunion.com",
      ["3535"] = "Techinline",
      ["3536"] = "Jango",
      ["3537"] = "VLC Media Player",
      ["3538"] = "wwiTV",
      ["3539"] = "wwiTV",
      ["3543"] = "Grooveshark",
      ["3544"] = "MizuPhone",
      ["3546"] = "Anyplace Control",
      ["3548"] = "Skype",
      ["3549"] = "Windows Media Player",
      ["3550"] = "SnapStream BeyondTV",
      ["3551"] = "Anyplace Control",
      ["3553"] = "SnapStream BeyondTV",
      ["3554"] = "SnapStream BeyondTV",
      ["3557"] = "Anyplace Control",
      ["3560"] = "Telnet",
      ["3561"] = "Weblin",
      ["3562"] = "Club Cooee",
      ["3563"] = "Club Cooee",
      ["3566"] = "tChat",
      ["3570"] = "Telnet",
      ["3572"] = "AliveChat",
      ["3577"] = "Action Allstars",
      ["3578"] = "Google Mail (Gmail)",
      ["3579"] = "All Girl Arcade",
      ["3583"] = "Nefsis",
      ["3584"] = "Tor",
      ["3586"] = "Deepnet Explorer",
      ["3588"] = "Torrent Reactor",
      ["3589"] = "Torrent Reactor",
      ["3590"] = "Torrent Spy",
      ["3593"] = "Torrent Spy",
      ["3594"] = "Brainshark",
      ["3595"] = "BitLord",
      ["3598"] = "Input Director",
      ["3602"] = "PeerFolders",
      ["3603"] = "BitTornado",
      ["3604"] = "WWW File Share Pro",
      ["3612"] = "Aimini",
      ["3613"] = "Saba Enterprise (SaaS)",
      ["3614"] = "Input Director",
      ["3617"] = "XML",
      ["3618"] = "XMPP (Jabber) Protocol",
      ["3619"] = "Scopia Desktop",
      ["3622"] = "BadBlue",
      ["3624"] = "Be Bratz",
      ["3627"] = "SoonR Desktop Agent",
      ["3629"] = "XML",
      ["3630"] = "XML",
      ["3631"] = "Beanie Babies Online",
      ["3632"] = "AOL Radio",
      ["3633"] = "SoonR Desktop Agent",
      ["3634"] = "AOL Radio",
      ["3635"] = "BadBlue",
      ["3636"] = "SoonR Desktop Agent",
      ["3639"] = "Windows Media Player",
      ["3644"] = "Skype",
      ["3647"] = "Bella Sara Online",
      ["3648"] = "HTTP Proxy",
      ["3650"] = "BoomBang Online",
      ["3651"] = "CackleBerries Online",
      ["3654"] = "Winamp Remote",
      ["3659"] = "Build-A-Bearville Online",
      ["3660"] = "MP3",
      ["3665"] = "BitDefender",
      ["3669"] = "Biennesoft",
      ["3670"] = "iSendr",
      ["3672"] = "ABC (Yet Another Bittorrent Client)",
      ["3679"] = "00unblock",
      ["3683"] = "CCleaner",
      ["3684"] = "AccuConference",
      ["3687"] = "Apple iMessage",
      ["3689"] = "Python urllib",
      ["3693"] = "Dr.Web Anti-Virus",
      ["3694"] = "Dr.Web Anti-Virus",
      ["3702"] = "Panda Security",
      ["3703"] = "Avast! Antivirus",
      ["3712"] = "Microsoft Windows Updates",
      ["3713"] = "Microsoft Windows Updates",
      ["3715"] = "Microsoft Windows Genuine Advantage",
      ["3716"] = "Microsoft Dr.Watson",
      ["3717"] = "Microsoft Dr.Watson",
      ["3721"] = "BeamYourScreen",
      ["3722"] = "Ubuntu APT",
      ["3726"] = "IObit Security 360",
      ["3727"] = "IObit Security 360",
      ["3728"] = "PC Tools Smart Update",
      ["3729"] = "Microsoft MSN Messenger",
      ["3731"] = "PC Tools ThreatFire",
      ["3732"] = "PC Tools ThreatFire",
      ["3733"] = "PC Tools ThreatFire",
      ["3737"] = "Clam AntiVirus (ClamAV)",
      ["3740"] = "Web Conferencing Central",
      ["3742"] = "iLinc",
      ["3746"] = "QQ",
      ["3753"] = "ReadyTalk",
      ["3754"] = "QQ",
      ["3758"] = "ReadyTalk",
      ["3759"] = "ReadyTalk",
      ["3760"] = "VoiceText",
      ["3761"] = "VoiceText",
      ["3763"] = "Chart Beat",
      ["3764"] = "Twiddla",
      ["3767"] = "Chart Beat",
      ["3770"] = "Twiddla",
      ["3789"] = "QQ",
      ["3794"] = "Facebook",
      ["3796"] = "UVC",
      ["3797"] = "Facebook",
      ["3798"] = "Adobe Acrobat Connect",
      ["3801"] = "Facebook",
      ["3802"] = "Facebook",
      ["3810"] = "AT Conference",
      ["3811"] = "AT Conference",
      ["3812"] = "MegaMeeting",
      ["3813"] = "MegaMeeting",
      ["3814"] = "MegaMeeting",
      ["3815"] = "UVC",
      ["3819"] = "GatherPlace",
      ["3820"] = "GatherPlace",
      ["3821"] = "InstantPresenter",
      ["3822"] = "LiveLOOK",
      ["3823"] = "LiveLOOK",
      ["3824"] = "Glance",
      ["3825"] = "Critical Force Critical Ops",
      ["3827"] = "Glance",
      ["3831"] = "QQ",
      ["3833"] = "Glance",
      ["3834"] = "InterCall",
      ["3835"] = "QQ",
      ["3838"] = "Voddler",
      ["3841"] = "InterCall",
      ["3843"] = "InstantService",
      ["3845"] = "VoipWise",
      ["3846"] = "VoipWise",
      ["3847"] = "VoipWise",
      ["3848"] = "VoipWise",
      ["3852"] = "Express Talk",
      ["3853"] = "KoalaDC",
      ["3854"] = "Jaxtr",
      ["3855"] = "Jaxtr",
      ["3856"] = "Plaxo",
      ["3857"] = "Plaxo",
      ["3858"] = "Plaxo",
      ["3859"] = "Delicious",
      ["3860"] = "Delicious",
      ["3861"] = "Delicious",
      ["3862"] = "Fotolog",
      ["3866"] = "Voddler",
      ["3874"] = "Omegle",
      ["3879"] = "Xanga",
      ["3881"] = "Windows Media Player",
      ["3882"] = "Xanga",
      ["3883"] = "Digg",
      ["3884"] = "Digg",
      ["3885"] = "Crackle",
      ["3886"] = "Crackle",
      ["3891"] = "Slide",
      ["3899"] = "Slide",
      ["3904"] = "FeedBurner",
      ["3906"] = "Icecast",
      ["3907"] = "Buzznet",
      ["3908"] = "Buzznet",
      ["3909"] = "Squidoo",
      ["3912"] = "Squidoo",
      ["3918"] = "Fotki",
      ["3935"] = "Fotki",
      ["3942"] = "QQ",
      ["3945"] = "Reddit",
      ["3946"] = "Reddit",
      ["3947"] = "Netvibes",
      ["3950"] = "QQ",
      ["3952"] = "Netvibes",
      ["3953"] = "myYearbook",
      ["3961"] = "myYearbook",
      ["3962"] = "Meetup",
      ["3963"] = "Yahoo! Apps",
      ["3965"] = "Meetup",
      ["3966"] = "Fotolia",
      ["3967"] = "Fotolia",
      ["3968"] = "Yahoo! Apps",
      ["3969"] = "Farmville",
      ["3970"] = "Sony Online Entertainment",
      ["3971"] = "Sony Online Entertainment",
      ["3972"] = "Electronic Arts",
      ["3973"] = "Nexon Games",
      ["3975"] = "Nexon Games",
      ["3979"] = "Nexon Games",
      ["3980"] = "Apple iMessage",
      ["3982"] = "Apple FaceTime",
      ["3983"] = "Twitter",
      ["3986"] = "FooPets",
      ["3989"] = "DoubleClick",
      ["3990"] = "ScoreCard Research",
      ["3991"] = "Google Mail (Gmail)",
      ["3994"] = "FunnelBrain",
      ["3995"] = "urFooz",
      ["3996"] = "MuchGames",
      ["3997"] = "SocialSplash",
      ["4000"] = "Pulse News",
      ["4042"] = "Apple FaceTime",
      ["4054"] = "Twitter",
      ["4056"] = "YouTube",
      ["4058"] = "XML",
      ["4236"] = "Image",
      ["4239"] = "Image",
      ["4243"] = "Image",
      ["4245"] = "Image",
      ["4254"] = "Image",
      ["4261"] = "Image",
      ["4265"] = "Image",
      ["4267"] = "Image",
      ["4273"] = "Image",
      ["4277"] = "Image",
      ["4282"] = "Image",
      ["4284"] = "Image",
      ["4289"] = "Image",
      ["4294"] = "Image",
      ["4295"] = "Image",
      ["4301"] = "Image",
      ["4306"] = "Archive",
      ["4395"] = "DNS Protocol",
      ["4398"] = "DNS Protocol",
      ["4399"] = "DNS Protocol",
      ["4410"] = "IMAP",
      ["4413"] = "POP",
      ["4448"] = "Nimbuzz",
      ["4476"] = "H.225 Call Signaling",
      ["4477"] = "H.225 Call Signaling",
      ["4481"] = "H.245 Call Control",
      ["4489"] = "T.120",
      ["4495"] = "RTCP",
      ["4687"] = "IDM",
      ["4826"] = "Chess.com",
      ["5018"] = "BitCoin Mining Protocol",
      ["5020"] = "BitCoin Mining Protocol",
      ["5140"] = "LogMeIn Hamachi",
      ["5147"] = "HTTP Protocol",
      ["5148"] = "HTTP Protocol",
      ["5149"] = "SMTP",
      ["5151"] = "SMTP",
      ["5153"] = "SSL",
      ["5159"] = "SSL",
      ["5174"] = "IMAP",
      ["5180"] = "POP",
      ["5181"] = "SMB",
      ["5183"] = "DNS Protocol",
      ["5193"] = "ICMP",
      ["5195"] = "ICMP",
      ["5198"] = "ICMP",
      ["5202"] = "ICMP",
      ["5227"] = "War Rock",
      ["5228"] = "Knight Online",
      ["5229"] = "Wolfenstein Enemy Territory",
      ["5230"] = "Steam Software",
      ["5231"] = "Steam Software",
      ["5233"] = "Blizzard Entertainment",
      ["5297"] = "Spore",
      ["5368"] = "Happy Pets",
      ["5386"] = "Google Analytics",
      ["5388"] = "Google Analytics",
      ["5391"] = "Mint.com",
      ["5393"] = "Picnik",
      ["5401"] = "Picnik",
      ["5402"] = "TinyChat",
      ["5403"] = "AllRecipes",
      ["5406"] = "Boing Boing",
      ["5420"] = "CocktailDB",
      ["5421"] = "Epicurious",
      ["5425"] = "FunnyOrDie",
      ["5427"] = "FunnyOrDie",
      ["5429"] = "FunnyOrDie",
      ["5430"] = "Instructables",
      ["5433"] = "The Onion",
      ["5453"] = "Craigslist",
      ["5455"] = "Howcast",
      ["5457"] = "iFixIt",
      ["5458"] = "iFixIt",
      ["5460"] = "IMDb",
      ["5463"] = "Indeed.com",
      ["5464"] = "Kayak.com",
      ["5465"] = "metacritic",
      ["5469"] = "Snopes.com",
      ["5472"] = "Snopes.com",
      ["5473"] = "TED",
      ["5478"] = "Wikipedia",
      ["5480"] = "New York Times Online",
      ["5481"] = "New York Times Online",
      ["5485"] = "Sports Illustrated Online",
      ["5486"] = "Amazon.com",
      ["5487"] = "Consumerist",
      ["5490"] = "Etsy",
      ["5496"] = "Restaurant.com",
      ["5499"] = "Tumblr.com",
      ["5501"] = "Ars Technica",
      ["5502"] = "FileHippo.com",
      ["5505"] = "gdgt",
      ["5517"] = "Apple FaceTime",
      ["5524"] = "Manolito",
      ["5525"] = "Manolito",
      ["5531"] = "AOL Toolbar",
      ["5532"] = "ApacheBenchmark",
      ["5533"] = "AutoIt",
      ["5534"] = "Boitho",
      ["5535"] = "Youngzsoft CCProxy",
      ["5539"] = "CentralOps.net",
      ["5565"] = "Single Click Connect",
      ["5576"] = "Google Talk",
      ["5578"] = "XMPP (Jabber) Protocol",
      ["5579"] = "Google",
      ["5581"] = "AOL Webmail",
      ["5583"] = "AIM",
      ["5584"] = "AOL",
      ["5585"] = "AIM",
      ["5586"] = "Microsoft MSN Messenger",
      ["5596"] = "ScoreCard Research",
      ["5599"] = "Yahoo!",
      ["5600"] = "360Safe",
      ["5601"] = "Yahoo!",
      ["5602"] = "Google",
      ["5604"] = "Facebook",
      ["5606"] = "FeedBurner",
      ["5607"] = "Google Desktop",
      ["5608"] = "Google Docs",
      ["5609"] = "Google Groups",
      ["5610"] = "Google Sites",
      ["5612"] = "Symantec Live Update",
      ["5613"] = "Symantec Live Update",
      ["5614"] = "Bing",
      ["5618"] = "Microsoft Dr.Watson",
      ["5621"] = "Upcoming",
      ["5623"] = "Yahoo! Finance",
      ["5624"] = "Yahoo! Finance",
      ["5625"] = "Yahoo! Video",
      ["5626"] = "Yahoo! Search",
      ["5627"] = "Orkut",
      ["5628"] = "MySpace",
      ["5631"] = "Chatroulette",
      ["5633"] = "4Shared",
      ["5634"] = "NCAA March Madness",
      ["5635"] = "51.com Music",
      ["5636"] = "BigUpload.com",
      ["5637"] = "Tagged.com",
      ["5638"] = "Kaixin001",
      ["5644"] = "WeatherBug",
      ["5645"] = "WeatherBug",
      ["5647"] = "WeatherBug",
      ["5648"] = "WeatherBug",
      ["5649"] = "LinkedIn",
      ["5650"] = "Google Analytics",
      ["5651"] = "Google Mail (Gmail)",
      ["5653"] = "BitDefender",
      ["5654"] = "Yahoo! Toolbar",
      ["5655"] = "Google",
      ["5660"] = "Dropbox",
      ["5666"] = "Microsoft MSN Messenger",
      ["5670"] = "Microsoft Outlook.com (Hotmail)",
      ["5684"] = "The Weather Channel",
      ["5693"] = "POP",
      ["5697"] = "YumSugar",
      ["5698"] = "PerezHilton",
      ["5699"] = "TMZ",
      ["5700"] = "The Superficial",
      ["5701"] = "The Superficial",
      ["5702"] = "WhatWouldTylerDurdenDo",
      ["5703"] = "IDontLikeYouInThatWay",
      ["5704"] = "Dlisted",
      ["5705"] = "Dlisted",
      ["5706"] = "Salesforce",
      ["5715"] = "Last.fm",
      ["5716"] = "Apple iWeb",
      ["5718"] = "Apple iCloud",
      ["5720"] = "AppleTV",
      ["5721"] = "Apple Front Row",
      ["5722"] = "Apple iPhoto",
      ["5727"] = "YouTube",
      ["5738"] = "Transmission",
      ["5741"] = "Cisco WebEx",
      ["5742"] = "Cisco WebEx",
      ["5743"] = "Evernote",
      ["5744"] = "Evernote",
      ["5745"] = "eMule",
      ["5746"] = "Facebook",
      ["5750"] = "eBay",
      ["5754"] = "eBay",
      ["5756"] = "NetNewsWire",
      ["5757"] = "NewsFire",
      ["5758"] = "Google Mail (Gmail)",
      ["5759"] = "Adium",
      ["5760"] = "Skype",
      ["5766"] = "Miro",
      ["5775"] = "PhotoBook",
      ["5778"] = "MediaNet",
      ["5779"] = "BearShare",
      ["5783"] = "Pandora Radio",
      ["5784"] = "The Hype Machine",
      ["5785"] = "The Hype Machine",
      ["5786"] = "Deezer",
      ["5787"] = "iLike",
      ["5789"] = "Musicovery",
      ["5790"] = "Musicovery",
      ["5791"] = "OurStage",
      ["5792"] = "OurStage",
      ["5794"] = "Slacker",
      ["5796"] = "Zune",
      ["5797"] = "Zune",
      ["5798"] = "Zune",
      ["5799"] = "8tracks",
      ["5801"] = "IAX2",
      ["5802"] = "IAX2",
      ["5808"] = "eBay",
      ["5809"] = "Twitter",
      ["5812"] = "Yahoo!",
      ["5814"] = "AOL",
      ["5815"] = "ScoreCard Research",
      ["5816"] = "AOL",
      ["5817"] = "AOL",
      ["5818"] = "AOL Webmail",
      ["5819"] = "AOL Webmail",
      ["5820"] = "AOL Webmail",
      ["5821"] = "AOL",
      ["5824"] = "Trillian",
      ["5825"] = "Trillian",
      ["5826"] = "Trillian",
      ["5841"] = "AOL Webmail",
      ["5842"] = "AOL",
      ["5856"] = "AOL",
      ["5868"] = "Facebook",
      ["5874"] = "Google Analytics",
      ["5901"] = "Wells Fargo Bank",
      ["5902"] = "Chase Bank",
      ["5907"] = "Blippy.com",
      ["5909"] = "Fark.com",
      ["5912"] = "Farmville",
      ["5913"] = "Cafe World",
      ["5921"] = "Zynga Poker",
      ["5930"] = "Teredo",
      ["5938"] = "Zynga Poker",
      ["5939"] = "Mesmo Games",
      ["5940"] = "Facebook Apps",
      ["5942"] = "Slashdot.org",
      ["5946"] = "Playfish",
      ["5947"] = "MindJolt",
      ["5948"] = "PopCap Games",
      ["5960"] = "Arcor",
      ["5964"] = "Freenet.de",
      ["5966"] = "Lavabit",
      ["5967"] = "t-online.de",
      ["5968"] = "web.de",
      ["5972"] = "SAP",
      ["5973"] = "Microsoft MSN Messenger",
      ["5979"] = "Safari Browser",
      ["5981"] = "Apple iTunes",
      ["5982"] = "YouTube",
      ["5984"] = "Wall Street Journal",
      ["5985"] = "ABC Player",
      ["5986"] = "National Public Radio (NPR)",
      ["5987"] = "Zillow",
      ["5988"] = "Dropbox",
      ["5989"] = "FT",
      ["5990"] = "Tonghuashun",
      ["5991"] = "Epicurious",
      ["5992"] = "Craigsphone",
      ["5993"] = "Fandango",
      ["5994"] = "Groupon",
      ["5995"] = "Free Books",
      ["5996"] = "iPDF",
      ["5997"] = "Wired Magazine",
      ["5998"] = "Apple iTunes",
      ["6002"] = "Google",
      ["6003"] = "Apple PubSub",
      ["6004"] = "Google Talk Gadget",
      ["6005"] = "Google Reader",
      ["6007"] = "Xfinity",
      ["6011"] = "Google",
      ["6012"] = "H.248 Protocol",
      ["6013"] = "H.248 Protocol",
      ["6014"] = "H.248 Protocol",
      ["6015"] = "Google",
      ["6016"] = "GMX",
      ["6017"] = "ICCP",
      ["6018"] = "ICCP",
      ["6019"] = "ICCP",
      ["6021"] = "Facebook",
      ["6029"] = "ICCP",
      ["6030"] = "Safari Browser",
      ["6034"] = "ICCP",
      ["6035"] = "DNP3",
      ["6036"] = "DNP3",
      ["6037"] = "DNP3",
      ["6038"] = "DNP3",
      ["6039"] = "DNP3",
      ["6040"] = "DNP3",
      ["6042"] = "AXIS Camera",
      ["6044"] = "AXIS Camera",
      ["6045"] = "Windows Media",
      ["6046"] = "Linksys Webcam",
      ["6047"] = "Totorosa JJAM",
      ["6066"] = "GoToMeeting",
      ["6067"] = "GoToMeeting",
      ["6068"] = "Unica",
      ["6069"] = "GoToMeeting",
      ["6089"] = "Dropbox",
      ["6110"] = "Database File",
      ["6114"] = "QQ File Transfer",
      ["6115"] = "Fetion",
      ["6116"] = "Fetion",
      ["6117"] = "Fetion",
      ["6122"] = "WGCI.com",
      ["6123"] = "WGCI.com",
      ["6124"] = "AOL",
      ["6141"] = "Lotus Notes",
      ["6149"] = "Google Talk",
      ["6157"] = "Facebook",
      ["6158"] = "Facebook",
      ["6159"] = "Microsoft Yammer",
      ["6167"] = "Blizzard Entertainment",
      ["6168"] = "Blizzard Entertainment",
      ["6186"] = "Blizzard Entertainment",
      ["6197"] = "Citrix",
      ["6198"] = "Citrix",
      ["6199"] = "Citrix",
      ["6213"] = "TeamViewer",
      ["6214"] = "TeamViewer",
      ["6215"] = "TeamViewer",
      ["6216"] = "TeamViewer",
      ["6217"] = "TeamViewer",
      ["6222"] = "Google Plus",
      ["6225"] = "SlideRocket",
      ["6231"] = "Shockwave Flash (SWF)",
      ["6232"] = "Shockwave Flash (SWF)",
      ["6233"] = "Shockwave Flash (SWF)",
      ["6234"] = "Shockwave Flash (SWF)",
      ["6235"] = "Shockwave Flash (SWF)",
      ["6236"] = "Shockwave Flash (SWF)",
      ["6237"] = "Google Talk Gadget",
      ["6239"] = "Google Plus",
      ["6244"] = "RenRen",
      ["6245"] = "RenRen",
      ["6247"] = "Facebook",
      ["6255"] = "Yahoo! Mail",
      ["6258"] = "Cybozu",
      ["6259"] = "Cybozu",
      ["6260"] = "Cybozu",
      ["6261"] = "DoubleClick",
      ["6262"] = "BlueLithium",
      ["6263"] = "TurboTax",
      ["6264"] = "TurboTax",
      ["6265"] = "TurboTax",
      ["6266"] = "BayNote",
      ["6267"] = "H&R Block",
      ["6268"] = "Accuen",
      ["6270"] = "eTax.com",
      ["6271"] = "TaxAct",
      ["6274"] = "AIM",
      ["6275"] = "AIM",
      ["6277"] = "DarkOrbit",
      ["6284"] = "Perforce",
      ["6285"] = "Sanguo Sha",
      ["6303"] = "QuakeLive",
      ["6321"] = "OnlineGamblingSites",
      ["6328"] = "Nexon Games",
      ["6332"] = "ANts",
      ["6334"] = "Nexon Games",
      ["6339"] = "Nexon Games",
      ["6341"] = "Nexon Games",
      ["6358"] = "Nexon Games",
      ["6359"] = "NCAA March Madness",
      ["6360"] = "NCAA March Madness",
      ["6361"] = "Nexon Games",
      ["6362"] = "Nexon Games",
      ["6363"] = "Facebook",
      ["6364"] = "163.com Webmail",
      ["6365"] = "163.com Webmail",
      ["6383"] = "Sharebox",
      ["6384"] = "Sharebox",
      ["6385"] = "Sharebox",
      ["6386"] = "Sharebox",
      ["6387"] = "Sharebox",
      ["6388"] = "Sharebox",
      ["6389"] = "Sharebox",
      ["6390"] = "Sharebox",
      ["6397"] = "Micro Focus GroupWise",
      ["6398"] = "Micro Focus GroupWise",
      ["6401"] = "Sharebox",
      ["6403"] = "Micro Focus GroupWise",
      ["6405"] = "Novell Client",
      ["6407"] = "Novell Client",
      ["6410"] = "Novell Messenger",
      ["6411"] = "Novell Messenger",
      ["6413"] = "Sirius XM",
      ["6414"] = "Canada Revenue Agency",
      ["6415"] = "H&R Block",
      ["6416"] = "HMRC.GOV.UK",
      ["6417"] = "Australian Tax Office",
      ["6419"] = "Korea National Tax Service",
      ["6420"] = "Japan National Tax Agency",
      ["6425"] = "IMO IM",
      ["6426"] = "Microsoft Outlook.com (Hotmail)",
      ["6427"] = "OpenSSL Client",
      ["6431"] = "Wells Fargo Bank",
      ["6439"] = "OpenOffice",
      ["6441"] = "Opera",
      ["6445"] = "RemoteView",
      ["6446"] = "RemoteView",
      ["6447"] = "RemoteView",
      ["6448"] = "RemoteView",
      ["6449"] = "RemoteView",
      ["6450"] = "Blinkx.com",
      ["6452"] = "HotBar",
      ["6453"] = "ScanQuery",
      ["6454"] = "Google",
      ["6455"] = "QDown",
      ["6456"] = "QDown",
      ["6457"] = "QDown",
      ["6461"] = "Afreeca",
      ["6462"] = "Afreeca",
      ["6463"] = "Afreeca",
      ["6465"] = "Afreeca",
      ["6466"] = "Afreeca",
      ["6467"] = "Afreeca",
      ["6470"] = "SoftEther PacketiX",
      ["6474"] = "SoftEther PacketiX",
      ["6477"] = "eBuddy",
      ["6478"] = "eBuddy",
      ["6479"] = "eBuddy",
      ["6488"] = "Hangame",
      ["6489"] = "Hangame",
      ["6503"] = "Raptr",
      ["6504"] = "Raptr",
      ["6507"] = "Raptr",
      ["6509"] = "Korea.com",
      ["6510"] = "MPEG",
      ["6511"] = "Shockwave Flash (SWF)",
      ["6512"] = "Mgoon.com",
      ["6513"] = "RealClick",
      ["6514"] = "Pandora.tv",
      ["6521"] = "Nate.com",
      ["6533"] = "Facebook",
      ["6536"] = "2ch",
      ["6537"] = "RTP",
      ["6539"] = "360Safe",
      ["6540"] = "360Safe",
      ["6541"] = "DHCP Protocol",
      ["6542"] = "NTLMSSP",
      ["6543"] = "DCERPC",
      ["6544"] = "DCERPC",
      ["6545"] = "HTTP Protocol",
      ["6546"] = "HTTP Protocol",
      ["6547"] = "AFS",
      ["6549"] = "RTP",
      ["6550"] = "FTP",
      ["6551"] = "AFDM",
      ["6552"] = "LDAP v3",
      ["6553"] = "ADSelfService",
      ["6554"] = "ADSelfService",
      ["6558"] = "ADNStream",
      ["6560"] = "Adobe Acrobat Connect",
      ["6561"] = "RTP",
      ["6562"] = "Adobe Marketing",
      ["6564"] = "Adobe",
      ["6566"] = "Adobe Connect",
      ["6570"] = "Akamai NetSession Interface",
      ["6572"] = "Akamai NetSession Interface",
      ["6573"] = "Akamai NetSession Interface",
      ["6574"] = "Akamai NetSession Interface",
      ["6575"] = "Alisoft",
      ["6578"] = "Jackpot Capital",
      ["6579"] = "Jackpot Capital",
      ["6580"] = "RTP",
      ["6581"] = "RTP",
      ["6582"] = "Jackpot Capital",
      ["6583"] = "Microsoft BITS",
      ["6589"] = "RTP",
      ["6590"] = "RTP",
      ["6593"] = "RTP",
      ["6596"] = "HTTP Protocol",
      ["6597"] = "HTTP Protocol",
      ["6598"] = "RTP",
      ["6601"] = "Hulu",
      ["6602"] = "RTP",
      ["6603"] = "Netflix",
      ["6604"] = "RTP",
      ["6608"] = "RTP",
      ["6617"] = "RTP",
      ["6618"] = "Ultrasurf",
      ["6624"] = "Amazon.com",
      ["6625"] = "Amazon Web Services",
      ["6626"] = "Amazon Web Services",
      ["6627"] = "SoftEther PacketiX",
      ["6628"] = "SoftEther PacketiX",
      ["6643"] = "RTP",
      ["6644"] = "RTP",
      ["6659"] = "Facebook",
      ["6661"] = "RTP",
      ["6663"] = "RTP",
      ["6665"] = "RTP",
      ["6666"] = "RTP",
      ["6668"] = "Facebook",
      ["6672"] = "Facebook",
      ["6673"] = "Facebook",
      ["6674"] = "Facebook",
      ["6675"] = "Facebook",
      ["6676"] = "Facebook",
      ["6679"] = "Facebook",
      ["6689"] = "Facebook",
      ["6692"] = "AIM",
      ["6696"] = "RTP",
      ["6702"] = "filesend.to",
      ["6706"] = "Chess.com",
      ["6732"] = "RTP",
      ["6733"] = "RTP",
      ["6740"] = "Google Chat",
      ["6745"] = "Bypass",
      ["6746"] = "Bypassthat",
      ["6747"] = "MouseMatrix.com",
      ["6754"] = "Google Mail (Gmail)",
      ["6755"] = "filesend.to",
      ["6766"] = "2ch",
      ["6767"] = "Yahoo! Japan",
      ["6768"] = "Yahoo! Japan",
      ["6769"] = "Yahoo! Japan",
      ["6773"] = "2ch",
      ["6783"] = "Blizzard Entertainment",
      ["6787"] = "Google Mail (Gmail)",
      ["6805"] = "Web Conferencing Central",
      ["6806"] = "SoftEther PacketiX",
      ["6807"] = "SoftEther PacketiX",
      ["6810"] = "SoftEther PacketiX",
      ["6812"] = "SoftEther PacketiX",
      ["6813"] = "SoftEther PacketiX",
      ["6817"] = "DNS Protocol",
      ["6818"] = "DNS Protocol",
      ["6819"] = "DNS Protocol",
      ["6820"] = "DNS Protocol",
      ["6821"] = "DNS Protocol",
      ["6822"] = "DNS Protocol",
      ["6823"] = "Digsby",
      ["6824"] = "Digsby",
      ["6825"] = "Digsby",
      ["6826"] = "eMule",
      ["6827"] = "eMule",
      ["6828"] = "eMule",
      ["6842"] = "DNS Protocol",
      ["6846"] = "Ultrasurf",
      ["6860"] = "Habbo",
      ["6862"] = "Meetup",
      ["6863"] = "MyLife",
      ["6864"] = "Flixster",
      ["6866"] = "Skyrock",
      ["6870"] = "Opera Mini",
      ["6871"] = "Opera Mini",
      ["6872"] = "HTTP Protocol",
      ["6874"] = "Tycoon Online",
      ["6876"] = "Steam Software",
      ["6877"] = "Steam Software",
      ["6878"] = "Steam Software",
      ["6880"] = "Steam Software",
      ["6882"] = "Intertops Casino",
      ["6883"] = "Intertops Casino",
      ["6884"] = "Intertops Casino",
      ["6886"] = "Omniture",
      ["6887"] = "Spore",
      ["6888"] = "Spore",
      ["6889"] = "Spore",
      ["6892"] = "JonDo Proxy",
      ["6893"] = "Bigpoint Games",
      ["6894"] = "DarkOrbit",
      ["6896"] = "Baidu",
      ["6897"] = "Baidu",
      ["6908"] = "OCSP",
      ["6911"] = "httptunnel",
      ["6913"] = "httptunnel",
      ["6915"] = "Hopster",
      ["6917"] = "HTTP-Tunnel",
      ["6918"] = "HTTP-Tunnel",
      ["6920"] = "HTTP-Tunnel",
      ["6921"] = "Facebook",
      ["6938"] = "SNMP",
      ["6939"] = "SNMP",
      ["6940"] = "SNMP",
      ["6941"] = "Schoology",
      ["6942"] = "eBay Classifieds",
      ["6943"] = "Cheap Tickets",
      ["6944"] = "Chickipedia",
      ["6945"] = "Mademan",
      ["6946"] = "Douban",
      ["6947"] = "Douban",
      ["6948"] = "Cheap Tickets",
      ["6949"] = "Drupal",
      ["6950"] = "Elluminate",
      ["6951"] = "Blackboard",
      ["6952"] = "37signals Campfire",
      ["6957"] = "Tongdaxin",
      ["6958"] = "Tongdaxin",
      ["6959"] = "Apple Security",
      ["6960"] = "Apple Location Service",
      ["6962"] = "Apple iTunes",
      ["6963"] = "Apple iTunes",
      ["6964"] = "Apple Push Notifications",
      ["6965"] = "Apple Filing Protocol",
      ["6966"] = "Apple Filing Protocol",
      ["6967"] = "Apple Updates",
      ["6968"] = "Apple Bonjour",
      ["6969"] = "Apple Bonjour",
      ["6980"] = "Apple iTunes",
      ["6982"] = "Dongfangcaifutong",
      ["6983"] = "Dongfangcaifutong",
      ["6985"] = "Facebook",
      ["6986"] = "Facebook",
      ["6987"] = "Facebook",
      ["6988"] = "Gree.jp",
      ["6989"] = "Baidu Hi",
      ["6990"] = "Baidu Hi",
      ["6992"] = "IBackup",
      ["6995"] = "56.com",
      ["6997"] = "Yahoo! Mail",
      ["7000"] = "Android Dalvik",
      ["7001"] = "Flurry",
      ["7002"] = "Citrix",
      ["7003"] = "Citrix",
      ["7004"] = "Citrix",
      ["7008"] = "GoToMyPC",
      ["7009"] = "Citrix",
      ["7011"] = "Safari Browser",
      ["7023"] = "IMR Worldwide",
      ["7036"] = "Farmville",
      ["7049"] = "Apple Security",
      ["7050"] = "Apple Updates",
      ["7054"] = "Spotify",
      ["7055"] = "Spotify",
      ["7056"] = "Avocent",
      ["7057"] = "Avocent",
      ["7058"] = "Desknets",
      ["7063"] = "Taobao",
      ["7064"] = "Taobao",
      ["7065"] = "Taobao",
      ["7067"] = "DeskShare",
      ["7071"] = "LogMeIn",
      ["7075"] = "ISL Light",
      ["7076"] = "Jump Desktop",
      ["7077"] = "Jump Desktop",
      ["7078"] = "Jump Desktop",
      ["7079"] = "Jump Desktop",
      ["7080"] = "Jump Desktop",
      ["7082"] = "Jump Desktop",
      ["7083"] = "Google Talk",
      ["7094"] = "MyGreenPC",
      ["7095"] = "MySpace",
      ["7096"] = "MySpace",
      ["7100"] = "Tongdaxin",
      ["7101"] = "Apple iMessage",
      ["7102"] = "Apple iMessage",
      ["7105"] = "Google Mail (Gmail)",
      ["7135"] = "pcvisit Remote",
      ["7139"] = "NetOp Remote Control",
      ["7140"] = "NetOp Remote Control",
      ["7141"] = "NetOp Remote Control",
      ["7142"] = "NetOp Remote Control",
      ["7143"] = "NetOp Remote Control",
      ["7144"] = "NetOp Remote Control",
      ["7145"] = "NetOp Remote Control",
      ["7149"] = "pcvisit Remote",
      ["7150"] = "pcvisit Remote",
      ["7152"] = "Apple Siri",
      ["7153"] = "Apple Siri",
      ["7160"] = "Apple iMessage",
      ["7166"] = "NTRglobal",
      ["7167"] = "PhoneMyPC",
      ["7168"] = "RDM Plus",
      ["7169"] = "RDM Plus",
      ["7170"] = "Splashtop Remote Desktop",
      ["7171"] = "Splashtop Remote Desktop",
      ["7182"] = "Google Crawler",
      ["7185"] = "TweetDeck",
      ["7187"] = "TweetDeck",
      ["7188"] = "TweetDeck",
      ["7189"] = "TweetDeck",
      ["7191"] = "Armagetron",
      ["7194"] = "Armagetron",
      ["7195"] = "Electronic Arts",
      ["7196"] = "Electronic Arts",
      ["7197"] = "Battlefield",
      ["7200"] = "Java RMI",
      ["7201"] = "Battlefield",
      ["7204"] = "Aliwangwang",
      ["7212"] = "Cafe World",
      ["7213"] = "Farmville",
      ["7215"] = "Executable",
      ["7216"] = "Executable",
      ["7217"] = "Executable",
      ["7218"] = "Mob Wars",
      ["7219"] = "Zynga Poker",
      ["7223"] = "Ask.fm",
      ["7244"] = "Executable",
      ["7246"] = "Executable",
      ["7247"] = "Executable",
      ["7248"] = "Executable",
      ["7249"] = "Executable",
      ["7250"] = "Executable",
      ["7251"] = "Document",
      ["7252"] = "Document",
      ["7253"] = "Archive",
      ["7254"] = "Audio Video Stream",
      ["7257"] = "Ask.fm",
      ["7259"] = "Facebook",
      ["7271"] = "QQ Mail",
      ["7281"] = "Lockbox",
      ["7283"] = "Lockbox",
      ["7284"] = "ShareFile",
      ["7285"] = "ShareFile",
      ["7286"] = "Shockwave Flash (SWF)",
      ["7289"] = "Flash Video (FLV)",
      ["7290"] = "Baofeng",
      ["7291"] = "Baofeng",
      ["7294"] = "Baofeng",
      ["7300"] = "HTTP Proxy",
      ["7304"] = "The Weather Channel",
      ["7322"] = "Foursquare",
      ["7324"] = "PCAnywhere",
      ["7325"] = "PCAnywhere",
      ["7328"] = "PCAnywhere",
      ["7331"] = "HonghuiNSD",
      ["7333"] = "Feigechuanshu",
      ["7340"] = "ooVoo",
      ["7341"] = "115Udown",
      ["7342"] = "115Udown",
      ["7344"] = "Tor",
      ["7346"] = "Vuze",
      ["7347"] = "Vuze",
      ["7348"] = "Azureus",
      ["7350"] = "BitTorrent Protocol",
      ["7355"] = "DBank",
      ["7362"] = "Google Voice",
      ["7364"] = "Google Chat",
      ["7373"] = "M1905 Dianyingwang",
      ["7374"] = "M1905 Dianyingwang",
      ["7375"] = "M1905 Dianyingwang",
      ["7426"] = "BitTorrent Protocol",
      ["7432"] = "Azureus",
      ["7434"] = "BitTorrent Protocol",
      ["7437"] = "Azureus",
      ["7438"] = "Azureus",
      ["7441"] = "BitTorrent Protocol",
      ["7442"] = "Google",
      ["7443"] = "XMPP (Jabber) Protocol",
      ["7446"] = "Facebook",
      ["7447"] = "Facebook",
      ["7448"] = "Facebook",
      ["7450"] = "TeamViewer",
      ["7451"] = "TeamViewer",
      ["7452"] = "TeamViewer",
      ["7458"] = "BitTorrent Protocol",
      ["7459"] = "BitTorrent Protocol",
      ["7460"] = "BitTorrent Protocol",
      ["7461"] = "BitTorrent Protocol",
      ["7465"] = "Ultrasurf",
      ["7518"] = "Microsoft SQL Server",
      ["7519"] = "Microsoft SQL Server",
      ["7521"] = "Microsoft Exchange",
      ["7527"] = "NCAA March Madness",
      ["7537"] = "NCAA March Madness",
      ["7538"] = "NCAA March Madness",
      ["7617"] = "Ocarina",
      ["7618"] = "Ocarina",
      ["7619"] = "Microsoft OneDrive",
      ["7620"] = "Facebook",
      ["7624"] = "Google Mail (Gmail)",
      ["7628"] = "Nimbuzz",
      ["7650"] = "Skype",
      ["7651"] = "Skype",
      ["7652"] = "RapidShare",
      ["7653"] = "RapidShare",
      ["7654"] = "RapidShare",
      ["7668"] = "YouTube",
      ["7681"] = "League of Legends",
      ["7682"] = "League of Legends",
      ["7683"] = "League of Legends",
      ["7684"] = "League of Legends",
      ["7691"] = "Daum",
      ["7692"] = "Daum",
      ["7702"] = "Yoono Desktop",
      ["7704"] = "Yoono Desktop",
      ["7713"] = "Instagram",
      ["7714"] = "Instagram",
      ["7715"] = "Instagram",
      ["7716"] = "Instagram",
      ["7720"] = "CloudFile",
      ["7733"] = "ShareFile",
      ["7734"] = "ShareFile",
      ["7735"] = "ShareFile",
      ["7737"] = "Google Drive",
      ["7738"] = "Google Drive",
      ["7739"] = "Apple Core Media",
      ["7751"] = "Dictionary.com",
      ["7753"] = "Dictionary.com",
      ["7758"] = "CricBuzz",
      ["7759"] = "CricBuzz",
      ["7767"] = "Yahoo! Messenger",
      ["7768"] = "K-Meleon Browser",
      ["7777"] = "Opera Mini",
      ["7778"] = "Opera Mini",
      ["7779"] = "eBuddy",
      ["7780"] = "YouTube",
      ["7781"] = "PacketVideo",
      ["7784"] = "Jackpot Capital",
      ["7785"] = "Hulu",
      ["7786"] = "Hulu",
      ["7787"] = "Hulu",
      ["7788"] = "StrongVPN",
      ["7789"] = "StrongVPN",
      ["7790"] = "StrongVPN",
      ["7791"] = "StrongVPN",
      ["7792"] = "StrongVPN",
      ["7793"] = "StrongVPN",
      ["7794"] = "Witopia VPN",
      ["7795"] = "Witopia VPN",
      ["7796"] = "Witopia VPN",
      ["7797"] = "IMO IM",
      ["7798"] = "IMO IM",
      ["7799"] = "Pinterest",
      ["7800"] = "Pinterest",
      ["7801"] = "Pinterest",
      ["7802"] = "Quora",
      ["7803"] = "Quora",
      ["7804"] = "Uber",
      ["7805"] = "Uber",
      ["7806"] = "Uber",
      ["7807"] = "TaskRabbit",
      ["7808"] = "TaskRabbit",
      ["7809"] = "TaskRabbit",
      ["7810"] = "Airbnb",
      ["7811"] = "Airbnb",
      ["7812"] = "Airbnb",
      ["7814"] = "Skillshare",
      ["7815"] = "Skillshare",
      ["7816"] = "Getaround",
      ["7817"] = "Getaround",
      ["7818"] = "Airtime",
      ["7819"] = "Airtime",
      ["7820"] = "Path",
      ["7821"] = "Path",
      ["7822"] = "Path",
      ["7823"] = "Square",
      ["7824"] = "Square",
      ["7825"] = "Square",
      ["7826"] = "Square",
      ["7827"] = "Pinwheel",
      ["7828"] = "Pinwheel",
      ["7829"] = "Pinwheel",
      ["7836"] = "QQ File Transfer",
      ["7837"] = "IMO IM",
      ["7838"] = "IMO IM",
      ["7840"] = "WhatsApp Messenger",
      ["7841"] = "WhatsApp Messenger",
      ["7846"] = "Psiphon",
      ["7853"] = "ISAKMP",
      ["7857"] = "Mail.com",
      ["7858"] = "Mail.com",
      ["7859"] = "Mail.com",
      ["7860"] = "Mail.com",
      ["7861"] = "TVB",
      ["7862"] = "TVB",
      ["7863"] = "EdgeSuite",
      ["7864"] = "Serving-Sys",
      ["7865"] = "Acuity Platform",
      ["7866"] = "Ad Server Plus",
      ["7867"] = "Adsonar",
      ["7868"] = "CPX Interactive",
      ["7869"] = "SayMedia",
      ["7870"] = "Casale Media",
      ["7871"] = "Betr Ad",
      ["7872"] = "Double Verify",
      ["7873"] = "Optimizely",
      ["7874"] = "Optimax Media Delivery",
      ["7875"] = "Atwola",
      ["7876"] = "Admailtiser",
      ["7877"] = "Criteo",
      ["7878"] = "CMP Advisors",
      ["7879"] = "United Internet Media",
      ["7880"] = "eXelate Media",
      ["7881"] = "Adsrvr",
      ["7882"] = "Casale Media",
      ["7883"] = "Site Scout",
      ["7884"] = "RealMedia",
      ["7885"] = "Google Analytics",
      ["7887"] = "AOL Advertising",
      ["7888"] = "eyeReturn Marketing",
      ["7889"] = "Ministerial5",
      ["7890"] = "Super Sonic Ads",
      ["7891"] = "AppNexus",
      ["7892"] = "MediaMath",
      ["7893"] = "Media Innovation Group",
      ["7894"] = "Eq Ads",
      ["7895"] = "BlueKai Research",
      ["7896"] = "BlueKai Research",
      ["7898"] = "AppNexus",
      ["7899"] = "Ministerial5",
      ["7900"] = "DoubleClick",
      ["7901"] = "AdTech",
      ["7902"] = "PointRoll",
      ["7903"] = "ABMR",
      ["7904"] = "Chango Marketing",
      ["7905"] = "ADGRX",
      ["7906"] = "Adnetik",
      ["7907"] = "Aggregrate Knowledge",
      ["7908"] = "Accuen Media",
      ["7909"] = "Turn Advertising",
      ["7910"] = "Adsafe Media",
      ["7911"] = "Media6Degrees",
      ["7912"] = "ooVoo",
      ["7913"] = "ooVoo",
      ["7914"] = "ooVoo",
      ["7926"] = "SSL",
      ["7927"] = "SSL",
      ["7929"] = "ExpatShield",
      ["7930"] = "ExpatShield",
      ["7936"] = "TextPlus",
      ["7937"] = "TextPlus",
      ["7939"] = "ExpatShield",
      ["7940"] = "ExpatShield",
      ["7948"] = "Mozy Online Backup",
      ["7949"] = "Mozy Online Backup",
      ["7950"] = "Mozy Online Backup",
      ["7951"] = "Mozy Online Backup",
      ["7992"] = "Xunlei Thunder",
      ["7999"] = "Xunlei Thunder",
      ["8055"] = "Yahoo! Mail",
      ["8061"] = "The Weather Channel",
      ["8062"] = "The Weather Channel",
      ["8063"] = "Google Translate",
      ["8090"] = "Zinio",
      ["8091"] = "Zinio",
      ["8092"] = "Viber",
      ["8093"] = "Viber",
      ["8094"] = "Shazam",
      ["8104"] = "NateOn",
      ["8105"] = "NateOn",
      ["8137"] = "Blizzard Entertainment",
      ["8138"] = "Blizzard Entertainment",
      ["8168"] = "Banjo",
      ["8178"] = "Banjo",
      ["8179"] = "Banjo",
      ["8190"] = "Zynga With Friends",
      ["8191"] = "Zynga With Friends",
      ["8192"] = "Zynga With Friends",
      ["8193"] = "Words With Friends",
      ["8196"] = "Voxer",
      ["8197"] = "Voxer",
      ["8199"] = "Voxer",
      ["8254"] = "IMDb",
      ["8255"] = "IMDb",
      ["8337"] = "SocialCam",
      ["8338"] = "SocialCam",
      ["8339"] = "Google Analytics",
      ["8343"] = "Olympic Games",
      ["8344"] = "Olympic Games",
      ["8350"] = "Craigslist",
      ["8360"] = "LinkedIn",
      ["8363"] = "SoundHound",
      ["8364"] = "SoundHound",
      ["8366"] = "SoundHound",
      ["8394"] = "Olympic Games",
      ["8395"] = "Olympic Games",
      ["8408"] = "Olympic Games",
      ["8410"] = "Olympic Games",
      ["8411"] = "CNTV",
      ["8412"] = "CNTV",
      ["8413"] = "War Commander",
      ["8415"] = "Olympic Games",
      ["8438"] = "Ammyy Admin",
      ["8445"] = "Audio Video Stream",
      ["8449"] = "TuneIn Radio",
      ["8450"] = "TuneIn Radio",
      ["8451"] = "TuneIn Radio",
      ["8452"] = "TuneIn Radio",
      ["8453"] = "TuneIn Radio",
      ["8454"] = "TuneIn Radio",
      ["8455"] = "TuneIn Radio",
      ["8456"] = "TuneIn Radio",
      ["8458"] = "Amazon.com",
      ["8459"] = "Amazon.com",
      ["8460"] = "Amazon.com",
      ["8462"] = "Tango",
      ["8463"] = "Tango",
      ["8464"] = "Tango",
      ["8465"] = "Tango",
      ["8466"] = "Tango",
      ["8468"] = "Tango",
      ["8469"] = "Tango",
      ["8471"] = "FTP",
      ["8480"] = "Apple iCloud",
      ["8481"] = "Apple iCloud",
      ["8494"] = "Google Maps",
      ["8495"] = "Google Maps",
      ["8496"] = "eBay",
      ["8505"] = "Facebook",
      ["8506"] = "Apple Mac.com",
      ["8507"] = "Apple Mac.com",
      ["8510"] = "WebDAV",
      ["8511"] = "WebDAV",
      ["8512"] = "WebDAV",
      ["8513"] = "WebDAV",
      ["8514"] = "WebDAV",
      ["8515"] = "WebDAV",
      ["8516"] = "WebDAV",
      ["8528"] = "NateOn",
      ["8540"] = "NateOn",
      ["8541"] = "NateOn",
      ["8544"] = "NateOn",
      ["8557"] = "Database File",
      ["8559"] = "Archive",
      ["8560"] = "Audio Video Stream",
      ["8561"] = "Document",
      ["8562"] = "Archive",
      ["8563"] = "Archive",
      ["8564"] = "Archive",
      ["8566"] = "Archive",
      ["8567"] = "Audio Video Stream",
      ["8570"] = "Image",
      ["8571"] = "Archive",
      ["8572"] = "Document",
      ["8573"] = "Image",
      ["8574"] = "Image",
      ["8575"] = "Image",
      ["8576"] = "Image",
      ["8579"] = "Dell Kace",
      ["8580"] = "Dell Kace",
      ["8583"] = "Dell Kace",
      ["8584"] = "LINE",
      ["8585"] = "LINE",
      ["8586"] = "LINE",
      ["8587"] = "The Pirate Bay",
      ["8592"] = "Minecraft",
      ["8593"] = "Minecraft",
      ["8596"] = "FTP",
      ["8597"] = "SMTP",
      ["8598"] = "SMTP",
      ["8599"] = "Google Play",
      ["8600"] = "Google Play",
      ["8601"] = "Google Play",
      ["8602"] = "Google Play",
      ["8603"] = "LinkedIn",
      ["8606"] = "IMAP",
      ["8608"] = "Box",
      ["8609"] = "Box",
      ["8610"] = "Box",
      ["8611"] = "Box",
      ["8617"] = "Tor",
      ["8652"] = "TextMe",
      ["8658"] = "CCTV",
      ["8676"] = "Qvod",
      ["8681"] = "Image",
      ["8682"] = "Image",
      ["8684"] = "Facebook",
      ["8685"] = "Facebook",
      ["8687"] = "DropSend",
      ["8688"] = "DropSend",
      ["8689"] = "DropSend",
      ["8690"] = "DropSend",
      ["8691"] = "YouTube",
      ["8692"] = "YouTube",
      ["8693"] = "LINE",
      ["8694"] = "LINE",
      ["8695"] = "LINE",
      ["8701"] = "TheBestKeylogger.com",
      ["8711"] = "New York Times Online",
      ["8741"] = "Spotflux",
      ["8742"] = "Spotflux",
      ["8756"] = "Spotflux",
      ["8759"] = "Spotflux",
      ["9009"] = "QQ",
      ["9165"] = "QQ File Transfer",
      ["9175"] = "QQ File Transfer",
      ["9192"] = "WhatsApp Messenger",
      ["9193"] = "QQ",
      ["9203"] = "Xunlei Thunder",
      ["9217"] = "QQGame",
      ["9223"] = "Electronic Arts",
      ["9224"] = "Electronic Arts",
      ["9225"] = "Electronic Arts",
      ["9226"] = "Electronic Arts",
      ["9227"] = "Electronic Arts",
      ["9228"] = "Electronic Arts",
      ["9234"] = "Xunlei Thunder",
      ["9235"] = "Xunlei Thunder",
      ["9247"] = "Dell SonicWALL CDP",
      ["9248"] = "Dell SonicWALL CDP",
      ["9249"] = "Dell SonicWALL CDP",
      ["9255"] = "YouTube",
      ["9256"] = "YouTube",
      ["9257"] = "YouTube",
      ["9260"] = "Scotty Transporter",
      ["9262"] = "Sina Weibo",
      ["9263"] = "Tencent Weibo",
      ["9264"] = "Tencent Weibo",
      ["9265"] = "Tianya Weibo",
      ["9266"] = "Tianya Weibo",
      ["9267"] = "Sohu Weibo",
      ["9268"] = "Sohu Weibo",
      ["9270"] = "GAppProxy",
      ["9271"] = "GAppProxy",
      ["9274"] = "PPStream",
      ["9275"] = "PPStream",
      ["9276"] = "PPStream",
      ["9277"] = "PPStream",
      ["9278"] = "PPStream",
      ["9279"] = "GAppProxy",
      ["9280"] = "Win2Day.be",
      ["9281"] = "Win2Day.be",
      ["9282"] = "Win2Day.be",
      ["9283"] = "Xunlei Thunder",
      ["9286"] = "Google Plus",
      ["9288"] = "163.com Webmail",
      ["9290"] = "Facebook",
      ["9327"] = "Executable",
      ["9335"] = "Apple Inc",
      ["9336"] = "Apple Maps",
      ["9338"] = "Dell SonicWALL Endpoint Security",
      ["9343"] = "Single Click Connect",
      ["9344"] = "Single Click Connect",
      ["9369"] = "Zook",
      ["9370"] = "Zook",
      ["9375"] = "Google Talk",
      ["9376"] = "Google Talk",
      ["9377"] = "Google Talk",
      ["9378"] = "Google Talk",
      ["9379"] = "Google",
      ["9380"] = "Google Mail (Gmail)",
      ["9383"] = "Google Docs",
      ["9384"] = "Google Docs",
      ["9388"] = "Document",
      ["9389"] = "Document",
      ["9390"] = "Document",
      ["9391"] = "Document",
      ["9392"] = "Document",
      ["9394"] = "Document",
      ["9395"] = "Executable",
      ["9397"] = "Executable",
      ["9398"] = "Executable",
      ["9400"] = "SMB",
      ["9401"] = "SMB2",
      ["9402"] = "SMB2",
      ["9405"] = "Executable",
      ["9406"] = "Executable",
      ["9407"] = "Executable",
      ["9408"] = "Executable",
      ["9409"] = "Document",
      ["9410"] = "Document",
      ["9411"] = "Document",
      ["9412"] = "Document",
      ["9413"] = "Document",
      ["9414"] = "Document",
      ["9415"] = "Document",
      ["9416"] = "Document",
      ["9417"] = "Document",
      ["9418"] = "Document",
      ["9421"] = "Document",
      ["9422"] = "Document",
      ["9423"] = "Document",
      ["9424"] = "Document",
      ["9425"] = "Document",
      ["9426"] = "Document",
      ["9427"] = "Document",
      ["9428"] = "Document",
      ["9429"] = "Document",
      ["9430"] = "Document",
      ["9432"] = "Document",
      ["9433"] = "Document",
      ["9434"] = "Document",
      ["9435"] = "Document",
      ["9439"] = "Document",
      ["9440"] = "Document",
      ["9443"] = "Document",
      ["9455"] = "Zook",
      ["9459"] = "Alicall",
      ["9460"] = "Alicall",
      ["9461"] = "Alicall",
      ["9462"] = "Alicall",
      ["9463"] = "McAfee",
      ["9464"] = "McAfee",
      ["9475"] = "Puffin Browser",
      ["9476"] = "Microsoft MSN Messenger",
      ["9477"] = "Microsoft MSN Messenger",
      ["9478"] = "Private Internet Access VPN",
      ["9479"] = "Haofang",
      ["9480"] = "Puffin Browser",
      ["9481"] = "Pandora Radio",
      ["9482"] = "Pandora Radio",
      ["9483"] = "Pandora Radio",
      ["9484"] = "Private Internet Access VPN",
      ["9485"] = "Private Internet Access VPN",
      ["9516"] = "Tongchengdapai",
      ["9518"] = "Tongchengdapai",
      ["9521"] = "Qvod",
      ["9522"] = "Qvod",
      ["9530"] = "Qvod",
      ["9534"] = "Liushuitongcheng",
      ["9535"] = "Liushuitongcheng",
      ["9536"] = "Liushuitongcheng",
      ["9537"] = "Qvod",
      ["9539"] = "Qvod",
      ["9553"] = "Tuenti Social Messenger",
      ["9554"] = "Tuenti Social Messenger",
      ["9565"] = "GO SMS",
      ["9566"] = "GO SMS",
      ["9567"] = "GO SMS",
      ["9568"] = "GO SMS",
      ["9572"] = "Baidu Yun",
      ["9573"] = "Baidu Yun",
      ["9577"] = "Sanguolaile",
      ["9578"] = "Sanguolaile",
      ["9624"] = "OpenVPN",
      ["9625"] = "OpenVPN",
      ["9628"] = "OpenVPN",
      ["9672"] = "Facebook",
      ["9678"] = "PC-over-IP Remote Desktop",
      ["9681"] = "PC-over-IP Remote Desktop",
      ["9685"] = "HTTP Proxy",
      ["9686"] = "Ivacy VPN",
      ["9687"] = "SnapChat",
      ["9689"] = "SnapChat",
      ["9690"] = "SnapChat",
      ["9691"] = "IMAP",
      ["9692"] = "IMAP",
      ["9693"] = "SquirrelMail",
      ["9710"] = "Chrome Remote Desktop",
      ["9713"] = "Chrome Remote Desktop",
      ["9714"] = "Chrome Remote Desktop",
      ["9719"] = "Chrome Remote Desktop",
      ["9720"] = "Chrome Remote Desktop",
      ["9721"] = "Chrome Remote Desktop",
      ["9727"] = "RTP",
      ["9772"] = "Giganews",
      ["9773"] = "Giganews",
      ["9808"] = "Google Drive",
      ["9809"] = "Google Drive",
      ["9812"] = "FTP",
      ["9813"] = "H.323 Protocols",
      ["9814"] = "SIP",
      ["9823"] = "Facebook",
      ["9862"] = "Sophos",
      ["9863"] = "Vine",
      ["9864"] = "Vine",
      ["9865"] = "Vine",
      ["9868"] = "KProxy",
      ["9878"] = "SMTP",
      ["9880"] = "IMAP",
      ["9882"] = "IMAP",
      ["9883"] = "POP",
      ["9910"] = "Apple FaceTime",
      ["10000"] = "VMware",
      ["10001"] = "VMware",
      ["10002"] = "GameDay Central",
      ["10003"] = "Yahoo!",
      ["10004"] = "Yahoo! Mail",
      ["10064"] = "Executable",
      ["10065"] = "Executable",
      ["10066"] = "TeamViewer",
      ["10067"] = "OpenDoor",
      ["10072"] = "Mail.ru",
      ["10073"] = "Join Me",
      ["10074"] = "Join Me",
      ["10076"] = "Kaspersky AV",
      ["10077"] = "Kaspersky AV",
      ["10078"] = "Microsoft OneDrive",
      ["10079"] = "Kakao Talk",
      ["10080"] = "iHeartRadio",
      ["10081"] = "iHeartRadio",
      ["10082"] = "iHeartRadio",
      ["10083"] = "iHeartRadio",
      ["10084"] = "iHeartRadio",
      ["10085"] = "iHeartRadio",
      ["10086"] = "iHeartRadio",
      ["10087"] = "iHeartRadio",
      ["10088"] = "iHeartRadio",
      ["10090"] = "Microsoft Skype for Business",
      ["10091"] = "Microsoft Skype for Business",
      ["10092"] = "Bitvise SSH (Tunnelier)",
      ["10093"] = "Bitvise SSH (Tunnelier)",
      ["10094"] = "Kaspersky AV",
      ["10095"] = "Secretbook",
      ["10096"] = "SSH Protocol",
      ["10097"] = "SSH Protocol",
      ["10098"] = "FriendVox",
      ["10099"] = "100Bao",
      ["10100"] = "AbelCam",
      ["10101"] = "AbelCam",
      ["10104"] = "ADrive",
      ["10105"] = "ADrive",
      ["10106"] = "appleJuice",
      ["10107"] = "appleJuice",
      ["10110"] = "Archive",
      ["10111"] = "Archive",
      ["10112"] = "Gladinet",
      ["10113"] = "Gladinet",
      ["10114"] = "Glide",
      ["10115"] = "WeTransfer",
      ["10116"] = "Kakao Talk",
      ["10117"] = "Kakao Talk",
      ["10118"] = "Kik Messenger",
      ["10119"] = "Kik Messenger",
      ["10120"] = "Kik Messenger",
      ["10121"] = "Candy Crush Saga",
      ["10122"] = "Candy Crush Saga",
      ["10123"] = "NFL (National Football League)",
      ["10124"] = "NFL (National Football League)",
      ["10125"] = "NFL (National Football League)",
      ["10126"] = "Samsung SmartTV",
      ["10127"] = "Samsung SmartTV",
      ["10128"] = "Samsung SmartTV",
      ["10129"] = "Amazon Prime Video",
      ["10130"] = "Hulu",
      ["10131"] = "Burp Proxy",
      ["10132"] = "Apple iTunes Radio",
      ["10133"] = "TextMe",
      ["10134"] = "Apple iTunes Radio",
      ["10135"] = "Apple iTunes Radio",
      ["10136"] = "Box",
      ["10137"] = "iQiyi",
      ["10138"] = "iQiyi",
      ["10139"] = "iQiyi",
      ["10140"] = "iQiyi",
      ["10141"] = "LeTV.com",
      ["10142"] = "LeTV.com",
      ["10143"] = "LeTV.com",
      ["10144"] = "LeTV.com",
      ["10145"] = "WeChat",
      ["10146"] = "WeChat",
      ["10147"] = "PPLive (PPTV)",
      ["10148"] = "Onavo VPN",
      ["10149"] = "Onavo VPN",
      ["10150"] = "Tumblr.com",
      ["10151"] = "Tumblr.com",
      ["10152"] = "ZenMate SSLVPN Proxy",
      ["10154"] = "MyPeople Messenger",
      ["10155"] = "MyPeople Messenger",
      ["10156"] = "MyPeople Messenger",
      ["10157"] = "Kakao Talk",
      ["10161"] = "IBVPN",
      ["10162"] = "IBVPN",
      ["10163"] = "IBVPN",
      ["10164"] = "IBVPN",
      ["10165"] = "IBVPN",
      ["10166"] = "Dash VPN",
      ["10167"] = "Dash VPN",
      ["10168"] = "IBVPN",
      ["10177"] = "SnapChat",
      ["10178"] = "AppSpot",
      ["10179"] = "AppSpot",
      ["10180"] = "Audio Video Stream",
      ["10181"] = "Audio Video Stream",
      ["10198"] = "Secret.ly",
      ["10199"] = "Secret.ly",
      ["10201"] = "LinkedIn",
      ["10207"] = "QQ",
      ["10208"] = "QQ",
      ["10209"] = "Apple Daily News",
      ["10210"] = "Apple Daily News",
      ["10211"] = "Apple Daily News",
      ["10212"] = "QQ",
      ["10213"] = "QQ",
      ["10214"] = "QQ",
      ["10215"] = "QQ",
      ["10227"] = "Yik Yak",
      ["10228"] = "Yik Yak",
      ["10230"] = "WebSocket",
      ["10231"] = "Talking Angela",
      ["10232"] = "Talking Angela",
      ["10233"] = "Google Mail (Gmail)",
      ["10234"] = "Google Mail (Gmail)",
      ["10235"] = "Google Chrome Data Compression Proxy",
      ["10236"] = "Google Chrome Data Compression Proxy",
      ["10243"] = "GetPrivate VPN",
      ["10244"] = "GetPrivate VPN",
      ["10245"] = "BeamYourScreen",
      ["10248"] = "Wattpad",
      ["10249"] = "Zoom.us",
      ["10253"] = "YouTube",
      ["10257"] = "SurfEasy",
      ["10261"] = "Octoshape",
      ["10266"] = "Octoshape",
      ["10267"] = "Octoshape",
      ["10268"] = "Octoshape",
      ["10269"] = "Microsoft Internet Explorer",
      ["10270"] = "Microsoft Internet Explorer",
      ["10271"] = "Microsoft Internet Explorer",
      ["10272"] = "Microsoft Internet Explorer",
      ["10273"] = "Microsoft Internet Explorer",
      ["10274"] = "Microsoft Internet Explorer",
      ["10275"] = "Microsoft Internet Explorer",
      ["10281"] = "Blackberry AppWorld",
      ["10282"] = "Blackberry AppWorld",
      ["10283"] = "Blackberry AppWorld",
      ["10284"] = "HTTP User-Agent",
      ["10285"] = "HTTP User-Agent",
      ["10286"] = "HTTP User-Agent",
      ["10287"] = "HTTP User-Agent",
      ["10288"] = "HTTP User-Agent",
      ["10289"] = "HTTP User-Agent",
      ["10290"] = "HTTP User-Agent",
      ["10291"] = "HTTP User-Agent",
      ["10292"] = "HTTP User-Agent",
      ["10293"] = "HTTP User-Agent",
      ["10294"] = "HTTP User-Agent",
      ["10295"] = "HTTP User-Agent",
      ["10297"] = "HTTP User-Agent",
      ["10298"] = "HTTP User-Agent",
      ["10299"] = "HTTP User-Agent",
      ["10300"] = "HTTP User-Agent",
      ["10310"] = "Supercell Games",
      ["10311"] = "Executable",
      ["10312"] = "Executable",
      ["10313"] = "Microsoft App Store",
      ["10314"] = "Microsoft App Store",
      ["10315"] = "Zoho",
      ["10316"] = "HP JetDirect Protocol",
      ["10317"] = "IMVU",
      ["10318"] = "Tor",
      ["10323"] = "Hotspot Shield VPN",
      ["10325"] = "Hotspot Shield VPN",
      ["10326"] = "Hotspot Shield VPN",
      ["10330"] = "Psiphon",
      ["10363"] = "Amazon Cloud Drive",
      ["10364"] = "Amazon Cloud Drive",
      ["10366"] = "Microsoft App Store",
      ["10367"] = "Yahoo! UK EuroSport",
      ["10374"] = "Supercell Games",
      ["10376"] = "Supercell Games",
      ["10377"] = "Supercell Games",
      ["10378"] = "Supercell Games",
      ["10379"] = "Supercell Games",
      ["10380"] = "Xunlei Thunder",
      ["10381"] = "Xunlei Thunder",
      ["10382"] = "Dovecot rfc822_parse_domain Out of B...",
      ["10383"] = "VPN Express",
      ["10384"] = "ExpressVPN",
      ["10388"] = "TVB",
      ["10398"] = "Google Drive",
      ["10400"] = "Microsoft Outlook Web Access",
      ["10403"] = "Google Drive",
      ["10406"] = "Evernote",
      ["10407"] = "Kakao Talk",
      ["10408"] = "Kakao Talk",
      ["10409"] = "Kakao Talk",
      ["10410"] = "Kakao Talk",
      ["10411"] = "Kakao Talk",
      ["10412"] = "Evernote",
      ["10418"] = "Evernote",
      ["10419"] = "Evernote",
      ["10430"] = "TunnelBear VPN",
      ["10431"] = "TunnelBear VPN",
      ["10443"] = "Tor",
      ["10454"] = "Xunlei Thunder",
      ["10464"] = "Ddooo Download",
      ["10473"] = "Ddooo Download",
      ["10481"] = "LINE",
      ["10482"] = "Xunlei Thunder",
      ["10484"] = "BIOS Agent Plus",
      ["10485"] = "CCleaner",
      ["10486"] = "CCleaner",
      ["10487"] = "YouTube Downloader",
      ["10490"] = "Google Talk",
      ["10491"] = "WeChat",
      ["10492"] = "WeChat",
      ["10495"] = "WeChat",
      ["10500"] = "TunnelBear VPN",
      ["10501"] = "Ngrok",
      ["10502"] = "Ngrok",
      ["10503"] = "NTRglobal",
      ["10507"] = "YouTube",
      ["10508"] = "YouTube",
      ["10512"] = "Facebook",
      ["10515"] = "Psiphon",
      ["10517"] = "Psiphon",
      ["10518"] = "Tinder",
      ["10519"] = "Tinder",
      ["10520"] = "Google API",
      ["10521"] = "Google API",
      ["10522"] = "NTRglobal",
      ["10524"] = "PD-Proxy",
      ["10527"] = "GNU Debugger",
      ["10535"] = "Puffin Browser",
      ["10536"] = "Facebook",
      ["10537"] = "Facebook",
      ["10538"] = "Amazon CloudFront",
      ["10539"] = "PD-Proxy",
      ["10553"] = "OpenDoor",
      ["10555"] = "vShare",
      ["10557"] = "Ultrasurf",
      ["10558"] = "QQGame",
      ["10563"] = "Microsoft Office 365",
      ["10564"] = "Microsoft Office 365",
      ["10565"] = "Microsoft Office 365",
      ["10566"] = "Microsoft Office 365",
      ["10568"] = "Yik Yak",
      ["10569"] = "Microsoft Office 365",
      ["10570"] = "Microsoft Office 365",
      ["10571"] = "Microsoft Office 365",
      ["10572"] = "Microsoft Office 365",
      ["10573"] = "Microsoft Office 365",
      ["10574"] = "Yik Yak",
      ["10575"] = "Yik Yak",
      ["10585"] = "QQGame",
      ["10592"] = "Yahoo!",
      ["10604"] = "Browsec",
      ["10609"] = "Bingbot Crawler",
      ["10614"] = "Yik Yak",
      ["10615"] = "Whisper",
      ["10616"] = "Whisper",
      ["10617"] = "Whisper",
      ["10618"] = "Whisper",
      ["10625"] = "Yahoo! Messenger",
      ["10627"] = "Yahoo! Messenger",
      ["10630"] = "Dropbox",
      ["10631"] = "Dropbox",
      ["10632"] = "Flash VPN",
      ["10633"] = "Flash VPN",
      ["10634"] = "Flash VPN",
      ["10637"] = "Spotify",
      ["10638"] = "Spotify",
      ["10639"] = "VPN In Touch",
      ["10640"] = "VPN In Touch",
      ["10641"] = "VPN In Touch",
      ["10642"] = "Hola Free VPN",
      ["10643"] = "Hola Free VPN",
      ["10644"] = "Hideman VPN",
      ["10645"] = "Hideman VPN",
      ["10646"] = "Hideman VPN",
      ["10647"] = "VPN One Click",
      ["10649"] = "VPN One Click",
      ["10651"] = "JonDo Proxy",
      ["10652"] = "JonDo Proxy",
      ["10656"] = "Ahrefs",
      ["10657"] = "Ahrefs",
      ["10660"] = "SEMrush",
      ["10661"] = "SEMrush",
      ["10662"] = "SEMrush",
      ["10663"] = "VPN proXPN",
      ["10664"] = "VPN proXPN",
      ["10665"] = "VPN proXPN",
      ["10669"] = "Browsec",
      ["10670"] = "Backblaze",
      ["10671"] = "After School",
      ["10675"] = "Microsoft OneDrive",
      ["10678"] = "YouTube",
      ["10679"] = "Wickr",
      ["10680"] = "Wickr",
      ["10681"] = "Faceless VPN",
      ["10682"] = "Faceless VPN",
      ["10683"] = "GoBrowse VPN",
      ["10684"] = "GoBrowse VPN",
      ["10685"] = "GoBrowse VPN",
      ["10688"] = "GreenVPN",
      ["10689"] = "GreenVPN",
      ["10690"] = "PureVPN",
      ["10691"] = "PureVPN",
      ["10692"] = "PureVPN",
      ["10693"] = "Astrill VPN",
      ["10694"] = "Astrill VPN",
      ["10697"] = "Younited",
      ["10698"] = "Younited",
      ["10699"] = "Younited",
      ["10700"] = "Psiphon",
      ["10704"] = "HMA VPN",
      ["10705"] = "HMA VPN",
      ["10710"] = "ITV Video Playback",
      ["10711"] = "ITV Video Playback",
      ["10712"] = "VPN Unlimited",
      ["10713"] = "VPN Unlimited",
      ["10714"] = "VPN Unlimited",
      ["10715"] = "OverPlay VPN",
      ["10716"] = "OverPlay VPN",
      ["10721"] = "Akamai CDN",
      ["10722"] = "Akamai CDN",
      ["10723"] = "CloudFlare CDN",
      ["10725"] = "WeChat",
      ["10738"] = "WeChat",
      ["10742"] = "Secret.ly",
      ["10749"] = "MubasherTrade",
      ["10750"] = "MubasherTrade",
      ["10759"] = "DotVPN",
      ["10760"] = "DotVPN",
      ["10761"] = "SSTP VPN",
      ["10763"] = "SSTP VPN",
      ["10764"] = "SSTP VPN",
      ["10765"] = "SSTP VPN",
      ["10767"] = "Soulseek",
      ["10768"] = "Soulseek",
      ["10773"] = "Soulseek",
      ["10774"] = "Soulseek",
      ["10780"] = "Dotloop",
      ["10782"] = "AliveChat",
      ["10796"] = "HBO",
      ["10797"] = "HBO",
      ["10798"] = "HBO",
      ["10799"] = "HBO",
      ["10815"] = "Executable",
      ["10817"] = "I2P",
      ["10820"] = "I2P",
      ["10821"] = "I2P",
      ["10822"] = "Fastly CDN",
      ["10834"] = "Meerkat",
      ["10835"] = "Meerkat",
      ["10836"] = "ClashofClans Game",
      ["10839"] = "Supercell Games",
      ["10840"] = "ClashofClans Game",
      ["10841"] = "ClashofClans Game",
      ["10852"] = "Xunlei Thunder",
      ["10871"] = "Chrome Remote Desktop",
      ["10872"] = "CommVault",
      ["10873"] = "CommVault",
      ["10874"] = "CommVault",
      ["10875"] = "Google QUIC",
      ["10876"] = "Google QUIC",
      ["10879"] = "VPN Defender",
      ["10880"] = "VPN Defender",
      ["10881"] = "VPN Defender",
      ["10882"] = "VPN Defender",
      ["10912"] = "BitTorrent Protocol",
      ["10913"] = "UC Browser",
      ["10914"] = "UC Browser",
      ["10915"] = "UC Browser",
      ["10916"] = "TunnelBear VPN",
      ["10921"] = "UC Browser",
      ["10922"] = "UC Browser",
      ["10938"] = "Google Play",
      ["10939"] = "Google Play",
      ["10942"] = "League of Legends",
      ["10943"] = "League of Legends",
      ["10976"] = "Google Hangouts",
      ["10989"] = "Google Pay",
      ["10990"] = "Google Hangouts",
      ["10991"] = "Dropbox",
      ["10992"] = "iHeartRadio",
      ["10998"] = "Ultrasurf",
      ["10999"] = "Ultrasurf",
      ["11043"] = "Microsoft Outlook.com (Hotmail)",
      ["11046"] = "Microsoft OneDrive",
      ["11051"] = "Facebook",
      ["11052"] = "SSL",
      ["11114"] = "GomVPN",
      ["11115"] = "GomVPN",
      ["11128"] = "DotVPN",
      ["11149"] = "Hotspot Shield VPN",
      ["11152"] = "Psiphon",
      ["11155"] = "skyZIP Proxy",
      ["11183"] = "Crashplan",
      ["11212"] = "Twitter",
      ["11213"] = "Twitter",
      ["11217"] = "Facebook",
      ["11226"] = "Psiphon",
      ["11241"] = "WeChat",
      ["11270"] = "Photon Browser",
      ["11271"] = "Photon Browser",
      ["11272"] = "Photon Browser",
      ["11273"] = "Photon Browser",
      ["11274"] = "HTTP User-Agent",
      ["11275"] = "WeChat",
      ["11280"] = "Malwarebytes",
      ["11281"] = "Malwarebytes",
      ["11294"] = "WordPress",
      ["11296"] = "VK",
      ["11298"] = "Tmall",
      ["11305"] = "After School",
      ["11306"] = "Wish App",
      ["11307"] = "Wish App",
      ["11308"] = "Wish App",
      ["11311"] = "Shockwave Flash (SWF)",
      ["11312"] = "Audio Video Stream",
      ["11313"] = "NetEase PoPo",
      ["11332"] = "The Proxy Bay",
      ["11334"] = "Open Whisper Systems Signal",
      ["11335"] = "Open Whisper Systems Signal",
      ["11336"] = "Open Whisper Systems Signal",
      ["11337"] = "Sunrise Calendar",
      ["11338"] = "Sunrise Calendar",
      ["11340"] = "Feedly",
      ["11341"] = "Telegram Messenger",
      ["11342"] = "Telegram Messenger",
      ["11343"] = "WhatsApp Messenger",
      ["11344"] = "VPN In Touch",
      ["11345"] = "Macroplant DocHub",
      ["11348"] = "360 Yunpan",
      ["11349"] = "360 Yunpan",
      ["11350"] = "360 Yunpan",
      ["11351"] = "360 Yunpan",
      ["11352"] = "360 Yunpan",
      ["11353"] = "QQ Weiyun",
      ["11354"] = "QQ Weiyun",
      ["11355"] = "QQ Weiyun",
      ["11357"] = "Thinfinity Remote Desktop Server",
      ["11359"] = "Hide.me VPN",
      ["11360"] = "Hide.me VPN",
      ["11361"] = "NordVPN",
      ["11362"] = "NordVPN",
      ["11364"] = "Apple Push Notifications",
      ["11365"] = "WeChat",
      ["11366"] = "WeChat",
      ["11367"] = "NordVPN",
      ["11368"] = "NordVPN",
      ["11369"] = "DocuSign",
      ["11374"] = "Tumblr.com",
      ["11403"] = "Flipboard",
      ["11404"] = "Flipboard",
      ["11406"] = "Facebook",
      ["11407"] = "Facebook",
      ["11408"] = "Facebook",
      ["11412"] = "LastPass",
      ["11416"] = "Facebook",
      ["11419"] = "Apple Updates",
      ["11420"] = "Baidu Pan",
      ["11421"] = "Baidu Yun",
      ["11429"] = "Hiworks",
      ["11430"] = "Hiworks",
      ["11433"] = "Daoki",
      ["11434"] = "Daoki",
      ["11437"] = "Baidu Yun",
      ["11438"] = "Baidu Yun",
      ["11440"] = "Baidu Pan",
      ["11441"] = "Baidu Pan",
      ["11442"] = "Psiphon",
      ["11460"] = "BetternetVPN",
      ["11461"] = "BetternetVPN",
      ["11462"] = "BetternetVPN",
      ["11472"] = "BetternetVPN",
      ["11473"] = "Steam Software",
      ["11474"] = "Steam Software",
      ["11482"] = "Ark VPN",
      ["11484"] = "Cloud VPN",
      ["11486"] = "Cloud VPN",
      ["11510"] = "SuperVPN",
      ["11520"] = "OpenVPN",
      ["11521"] = "WorldofTanks",
      ["11522"] = "WorldofTanks",
      ["11526"] = "Boom Beach",
      ["11527"] = "Private Tunnel VPN",
      ["11529"] = "WhatsApp Messenger",
      ["11530"] = "8BallPool",
      ["11531"] = "8BallPool",
      ["11534"] = "EvilApples",
      ["11535"] = "EvilApples",
      ["11537"] = "Blendoku",
      ["11538"] = "Blendoku",
      ["11542"] = "Dirtybit",
      ["11545"] = "Noodlecake",
      ["11561"] = "YouTube Downloader",
      ["11571"] = "Epic Browser Proxy",
      ["11572"] = "Epic Browser Proxy",
      ["11574"] = "QQ",
      ["11577"] = "QQ",
      ["11580"] = "QQ",
      ["11600"] = "Supercell Games",
      ["11601"] = "Supercell Games",
      ["11602"] = "FreeMyBrowser",
      ["11603"] = "SecureVPN",
      ["11604"] = "SecureVPN",
      ["11605"] = "SecureVPN",
      ["11612"] = "Tactile Wars",
      ["11614"] = "Zoom.us",
      ["11616"] = "Zoom.us",
      ["11618"] = "Fields of Battle",
      ["11620"] = "PacMan",
      ["11623"] = "Asphalt8",
      ["11624"] = "Asphalt8",
      ["11625"] = "Twitch",
      ["11639"] = "Dococab",
      ["11643"] = "YouTube",
      ["11644"] = "YouTube",
      ["11646"] = "YouTube",
      ["11649"] = "JustProxy VPN",
      ["11657"] = "Google News",
      ["11666"] = "YouTube Downloader",
      ["11672"] = "Google Drive",
      ["11674"] = "BitTorrent Protocol",
      ["11675"] = "Microsoft Office 365",
      ["11676"] = "BitTorrent Protocol",
      ["11677"] = "BitTorrent Protocol",
      ["11678"] = "BitTorrent Protocol",
      ["11679"] = "BitTorrent Protocol",
      ["11680"] = "Salesforce",
      ["11681"] = "Salesforce",
      ["11687"] = "YouTube Downloader",
      ["11688"] = "YouTube Downloader",
      ["11689"] = "Dococab",
      ["11691"] = "YouTube Downloader",
      ["11693"] = "Microsoft Outlook.com (Hotmail)",
      ["11694"] = "Microsoft Outlook.com (Hotmail)",
      ["11695"] = "Microsoft Outlook.com (Hotmail)",
      ["11696"] = "Microsoft Outlook.com (Hotmail)",
      ["11697"] = "Microsoft Outlook.com (Hotmail)",
      ["11700"] = "iHeartRadio",
      ["11701"] = "iHeartRadio",
      ["11702"] = "iHeartRadio",
      ["11703"] = "HTTP Proxy",
      ["11710"] = "Connectify",
      ["11715"] = "Connectify",
      ["11730"] = "Pokemon Go",
      ["11731"] = "Pokemon Go",
      ["11732"] = "Pokemon Go",
      ["11733"] = "Pokemon Go",
      ["11738"] = "AddThis.com",
      ["11743"] = "Reddit",
      ["11744"] = " AlienBlue",
      ["11750"] = " Jumpshare",
      ["11751"] = " Jumpshare",
      ["11758"] = "Agar.io",
      ["11762"] = "Zoosk",
      ["11763"] = "Zoosk",
      ["11765"] = "IFTTT",
      ["11772"] = "Microsoft Windows Updates",
      ["11803"] = "Mega.nz",
      ["11807"] = "Mega.nz",
      ["11808"] = "Mega.nz",
      ["11809"] = "Mega.nz",
      ["11819"] = "Google Chrome",
      ["11820"] = "GroupMe",
      ["11821"] = "GroupMe",
      ["11826"] = "Hawkeye VPN",
      ["11827"] = "Hawkeye VPN",
      ["11828"] = "Hawkeye VPN",
      ["11829"] = "Opera Free VPN",
      ["11830"] = "Opera Free VPN",
      ["11831"] = "Opera Free VPN",
      ["11832"] = "Opera Free VPN",
      ["11833"] = "Golden Key VPN",
      ["11862"] = "ZeroVPN",
      ["11872"] = "Facebook",
      ["11873"] = "Facebook",
      ["11912"] = "Google Drive",
      ["11913"] = "ISAKMP",
      ["11918"] = "VPN Master",
      ["11924"] = "VPN Master",
      ["11928"] = "Neat Scanner",
      ["11930"] = "Neat Scanner",
      ["11976"] = "ZeroVPN",
      ["11977"] = "ZeroVPN",
      ["11978"] = "ZeroVPN",
      ["11984"] = "ZeroVPN",
      ["11986"] = "ZeroVPN",
      ["11989"] = "VPN Master",
      ["11990"] = "GlobusVPN",
      ["11991"] = "GlobusVPN",
      ["11993"] = "Turbo VPN",
      ["11994"] = "Invisible Net VPN",
      ["11995"] = "Invisible Net VPN",
      ["11996"] = "HotVPN",
      ["11997"] = "FreeVPN",
      ["12000"] = "Walmart",
      ["12501"] = "Walmart",
      ["12503"] = "Cross Web Server",
      ["12550"] = "Yelp",
      ["12551"] = "Yelp",
      ["12552"] = "Yelp",
      ["12553"] = "Lyft",
      ["12554"] = "Lyft",
      ["12572"] = "Ultrahook",
      ["12596"] = "WhatsApp Messenger",
      ["12604"] = "Psiphon",
      ["12636"] = "AnyDesk Remote Desktop",
      ["12640"] = "BitTorrent Protocol",
      ["12645"] = "SetupVPN",
      ["12659"] = "Foxtel",
      ["12661"] = "Foxtel",
      ["12680"] = "ConnectWise Control ScreenConnect",
      ["12681"] = "ConnectWise Control ScreenConnect",
      ["12684"] = "Apple iCloud",
      ["12686"] = "SoundCloud",
      ["12687"] = "SoundCloud",
      ["12695"] = "Confide Messenger",
      ["12734"] = "STUN",
      ["12736"] = "Mastodon",
      ["12746"] = "LeapFILE",
      ["12747"] = "LeapFILE",
      ["12748"] = "Tmall",
      ["12750"] = "Suning.com",
      ["12752"] = "Hupu.com",
      ["12753"] = "Mixi",
      ["12754"] = "Twinavi.jp",
      ["12755"] = "Ameba Pigg",
      ["12756"] = "Ameba Pigg",
      ["12757"] = "Rakuten Ichiba",
      ["12758"] = "Amazon.co.jp",
      ["12759"] = "Amazon.co.jp",
      ["12760"] = "GMarket.co.kr",
      ["12761"] = "11st.co.kr",
      ["12762"] = "11st.co.kr",
      ["12763"] = "GS Shop",
      ["12764"] = "GS Shop",
      ["12819"] = "BetternetVPN",
      ["12824"] = "SnapChat",
      ["12825"] = "SnapChat",
      ["12871"] = "Aspera FASP Protocol",
      ["12872"] = "Aspera FASP Protocol",
      ["12874"] = "Aspera FASP Protocol",
      ["12875"] = "LINE",
      ["12876"] = "LINE",
      ["12894"] = "Signiant",
      ["12922"] = "FTP",
      ["12923"] = "FTP",
      ["12926"] = "Sarahah",
      ["12927"] = "Sarahah",
      ["12931"] = "Hexatech VPN",
      ["12932"] = "Hexatech VPN",
      ["12933"] = "Hexatech VPN",
      ["12939"] = "Archive",
      ["12940"] = "Archive",
      ["12956"] = "Incognito VPN",
      ["12957"] = "Incognito VPN",
      ["12986"] = "HTTP Protocol",
      ["12989"] = "HTTP Protocol",
      ["12990"] = "HTTP Protocol",
      ["12991"] = "HTTP Protocol",
      ["12996"] = "Gracenote",
      ["12997"] = "Plex TV",
      ["12998"] = "WhatsApp Messenger",
      ["12999"] = "WhatsApp Messenger",
      ["13000"] = "Yahoo! Messenger",
      ["13021"] = "QQ",
      ["13026"] = "QQ",
      ["13027"] = "QQ",
      ["13038"] = "QQ",
      ["13039"] = "Dingding",
      ["13040"] = "Dingding",
      ["13042"] = "Dingding",
      ["13053"] = "QQ",
      ["13054"] = "Discord",
      ["13055"] = "Discord",
      ["13077"] = "WhatsApp Messenger",
      ["13078"] = "WhatsApp Messenger",
      ["13079"] = "WhatsApp Messenger",
      ["13081"] = "WhatsApp Messenger",
      ["13082"] = "WhatsApp Messenger",
      ["13083"] = "WhatsApp Messenger",
      ["13086"] = "Telegram Messenger",
      ["13087"] = "QQ",
      ["13098"] = "MinerGate",
      ["13099"] = "SuperVPN",
      ["13100"] = "SuperVPN",
      ["13129"] = "SuperVPN",
      ["13130"] = "SuperVPN",
      ["13131"] = "SuperVPN",
      ["13132"] = "SuperVPN",
      ["13144"] = "BACnet Protocol",
      ["13146"] = "SnapChat",
      ["13150"] = "CODESYS",
      ["13153"] = "WeChat",
      ["13167"] = "SuperVPN",
      ["13168"] = "SuperVPN",
      ["13181"] = "ShareFile",
      ["13183"] = "Coinhive Monero Miner",
      ["13184"] = "Coinhive Monero Miner",
      ["13185"] = "Coinhive Monero Miner",
      ["13186"] = "RingOver",
      ["13195"] = "Hoxx VPN",
      ["13197"] = "Wikipedia",
      ["13198"] = "Executable",
      ["13208"] = "CODESYS",
      ["13209"] = "CODESYS",
      ["13210"] = "CODESYS",
      ["13211"] = "CODESYS",
      ["13212"] = "CODESYS",
      ["13215"] = "Microsoft Windows Updates",
      ["13216"] = "Microsoft Windows Updates",
      ["13217"] = "Amazon Prime Video",
      ["13218"] = "Amazon Prime Video",
      ["13219"] = "Amazon Prime Video",
      ["13220"] = "Amazon Prime Video",
      ["13241"] = "DNP3",
      ["13242"] = "EtherNet/IP",
      ["13243"] = "EtherNet/IP",
      ["13244"] = "EtherNet/IP",
      ["13247"] = "Browsec",
      ["13249"] = "ISAKMP",
      ["13252"] = "SAIA ETHER S-BUS",
      ["13253"] = "ETHERSIO",
      ["13255"] = "OMRON-FINS",
      ["13256"] = "OMRON-FINS",
      ["13259"] = "Hexatech VPN",
      ["13264"] = "iWASEL VPN",
      ["13265"] = "iWASEL VPN",
      ["13267"] = "RingOver",
      ["13268"] = "RingOver",
      ["13269"] = "RingOver",
      ["13278"] = "Google Mail (Gmail)",
      ["13285"] = "EpicGames",
      ["13288"] = "QQ",
      ["13289"] = "QQ",
      ["13290"] = "QQ",
      ["13291"] = "QQ",
      ["13296"] = "HART-IP",
      ["13297"] = "HART-IP",
      ["13298"] = "HART-IP",
      ["13299"] = "WebSocket",
      ["13300"] = "WebSocket",
      ["13302"] = "IEC 61850",
      ["13303"] = "PC_WORX",
      ["13304"] = "ISO-TSAP",
      ["13305"] = "ISO-TSAP",
      ["13306"] = "ISO-TSAP",
      ["13307"] = "S7comm",
      ["13308"] = "S7comm",
      ["13337"] = "Cisco Meeting Server",
      ["13380"] = "Houseparty (LOA)",
      ["13381"] = "Houseparty (LOA)",
      ["13404"] = "PP VPN",
      ["13405"] = "PP VPN",
      ["13438"] = "Executable",
      ["13439"] = "Executable",
      ["13440"] = "Wikipedia",
      ["13441"] = "YouTube",
      ["13445"] = "Alpemix VNC",
      ["13446"] = "Alpemix VNC",
      ["13447"] = "Alpemix VNC",
      ["13450"] = "Alpemix VNC",
      ["13451"] = "Alpemix VNC",
      ["13467"] = "ADP",
      ["13468"] = "American Bar Association Journal",
      ["13469"] = "American Bar Association",
      ["13470"] = "American Express Inc",
      ["13471"] = "American Express Inc",
      ["13472"] = "AutoNews",
      ["13473"] = "BBC",
      ["13475"] = "BerkeleyEdu",
      ["13476"] = "Bank of America",
      ["13477"] = "Bank of America",
      ["13478"] = "Box",
      ["13479"] = "Business Insider",
      ["13480"] = "BusinessWire",
      ["13481"] = "CNBC",
      ["13482"] = "CNBC",
      ["13483"] = "CNBC",
      ["13484"] = "CNBC",
      ["13485"] = "CNN News",
      ["13486"] = "Chase Bank",
      ["13488"] = "Concur Solutions",
      ["13489"] = "Construction Dive",
      ["13490"] = "Dailymotion",
      ["13491"] = "Dailymotion",
      ["13492"] = "Dailymotion",
      ["13493"] = "DocuSign",
      ["13494"] = "DocuSign",
      ["13495"] = "eBay",
      ["13496"] = "eBay",
      ["13497"] = "eBay",
      ["13498"] = "eBay",
      ["13499"] = "EducationNews",
      ["13500"] = "IMDb",
      ["13501"] = "Investopedia",
      ["13502"] = "Instagram",
      ["13503"] = "Light Reading",
      ["13504"] = "Light Reading",
      ["13505"] = "Dow Jones Co",
      ["13506"] = "Dow Jones Co",
      ["13507"] = "Marketwatch",
      ["13509"] = "Wall Street Journal",
      ["13510"] = "Wall Street Journal",
      ["13511"] = "News Corp",
      ["13512"] = "News Corp",
      ["13515"] = "MayoClinic",
      ["13516"] = "Medical News",
      ["13517"] = "Morningstar",
      ["13518"] = "Morningstar",
      ["13519"] = "NOAA",
      ["13520"] = "National Geographic",
      ["13521"] = "National Geographic",
      ["13522"] = "ServiceNow",
      ["13524"] = "Netflix",
      ["13525"] = "Netflix",
      ["13526"] = "Netflix",
      ["13527"] = "Network World",
      ["13528"] = "Microsoft Office 365",
      ["13530"] = "Microsoft Office 365",
      ["13531"] = "Microsoft SharePoint",
      ["13532"] = "Microsoft SharePoint",
      ["13533"] = "Microsoft",
      ["13534"] = "Microsoft",
      ["13535"] = "Reddit",
      ["13536"] = "OneLogin",
      ["13537"] = "Slack",
      ["13538"] = "Slack",
      ["13539"] = "Yelp",
      ["13540"] = "Yelp",
      ["13541"] = "Wikipedia",
      ["13542"] = "Trello",
      ["13543"] = "Tumblr.com",
      ["13544"] = "NOAA",
      ["13545"] = "WebMD",
      ["13546"] = "UCLA",
      ["13547"] = "WhatsApp Messenger",
      ["13548"] = "Vimeo",
      ["13549"] = "Vimeo",
      ["13550"] = "Google",
      ["13551"] = "Taobao",
      ["13552"] = "Tmall",
      ["13553"] = "Amazon.com",
      ["13554"] = "Twitter",
      ["13555"] = "Sohu",
      ["13556"] = "JD.com",
      ["13557"] = "VK",
      ["13558"] = "Sina Weibo",
      ["13559"] = "360 Yunpan",
      ["13560"] = "Google",
      ["13561"] = "Google",
      ["13562"] = "Google",
      ["13563"] = "Google",
      ["13567"] = "BBC iPlayer",
      ["13568"] = "BBC iPlayer",
      ["13569"] = "BBC",
      ["13570"] = "BBC",
      ["13571"] = "XING",
      ["13572"] = "XING",
      ["13573"] = "XING",
      ["13577"] = "BBC iPlayer",
      ["13580"] = "Amazon Prime Music",
      ["13581"] = "Amazon Prime Music",
      ["13582"] = "EpicGames",
      ["13583"] = "EpicGames Fortnite",
      ["13584"] = "EpicGames Fortnite",
      ["13585"] = "EpicGames",
      ["13589"] = "Google Mail (Gmail)",
      ["13590"] = "Google Mail (Gmail)",
      ["13607"] = "Twitch",
      ["13608"] = "Twitch",
      ["13609"] = "Twitch",
      ["13610"] = "Twitch",
      ["13611"] = "Twitch",
      ["13612"] = "Twitch",
      ["13620"] = "Microsoft Store",
      ["13621"] = "Microsoft Store",
      ["13622"] = "Microsoft Store",
      ["13627"] = "X-VPN",
      ["13629"] = "X-VPN",
      ["13645"] = "Coinhive Monero Miner",
      ["13646"] = "Coinhive Monero Miner",
      ["13647"] = "Coinhive Monero Miner",
      ["13853"] = "Microsoft Edge",
      ["13855"] = "Microsoft Office 365",
      ["13856"] = "Microsoft Skype for Business",
      ["13857"] = "Microsoft Office 365",
      ["13859"] = "Microsoft Skype for Business",
      ["13860"] = "Microsoft Skype for Business",
      ["13861"] = "Microsoft Skype for Business",
      ["13862"] = "Microsoft Skype for Business",
      ["13863"] = "Microsoft Skype for Business",
      ["13864"] = "Microsoft Skype for Business",
      ["13865"] = "Microsoft Skype for Business",
      ["13866"] = "Microsoft Office 365",
      ["13867"] = "Microsoft Office 365",
      ["13868"] = "Microsoft Office 365",
      ["13869"] = "Microsoft Office 365",
      ["13870"] = "Microsoft Skype for Business",
      ["13871"] = "Microsoft Skype for Business",
      ["13872"] = "Microsoft Skype for Business",
      ["13873"] = "STUN",
      ["13893"] = "SIP",
      ["13894"] = "Ring Central",
      ["13895"] = "Ring Central",
      ["13896"] = "Ring Central",
      ["13897"] = "Ring Central",
      ["13901"] = "Google Meet",
      ["13902"] = "Google Meet",
      ["13903"] = "Microsoft Teams",
      ["13904"] = "Microsoft Teams",
      ["13905"] = "ServiceNow",
      ["13906"] = "Microsoft OneNote",
      ["13907"] = "Microsoft OneNote",
      ["13908"] = "Microsoft Outlook.com (Hotmail)",
      ["13909"] = "Microsoft Yammer",
      ["13920"] = "Google Translate",
      ["13921"] = "Google Calendar",
      ["13922"] = "Google Photos",
      ["13923"] = "ExpressVPN",
      ["13927"] = "STUN",
      ["13928"] = "STUN",
      ["13942"] = "RTP",
      ["13953"] = "Microsoft Skype for Business",
      ["13969"] = "SIP",
      ["13970"] = "SIP",
      ["13971"] = "SIP",
      ["13972"] = "SIP",
      ["13987"] = "X-VPN",
      ["13988"] = "X-VPN",
      ["13989"] = "X-VPN",
      ["13990"] = "X-VPN",
      ["13991"] = "X-VPN",
      ["13992"] = "Hola Free VPN",
      ["14007"] = "YogaVPN",
      ["14008"] = "YogaVPN",
      ["49152"] = "Firewall management",
      ["49153"] = "General Broadcast",
      ["49154"] = "General Multicast",
      ["49155"] = "General Unicast",
      ["49156"] = "General Subnet broadcast",
      ["49157"] = "General PPTP control",
      ["49158"] = "General PPTP data",
      ["49159"] = "General RAS control",
      ["49160"] = "General RAS data",
      ["49161"] = "General Oracle data",
      ["49162"] = "General Oracle data",
      ["49163"] = "General RT stream",
      ["49164"] = "General SIP stream",
      ["49165"] = "General NETBIOS",
      ["49166"] = "General IKE",
      ["49167"] = "General EMAIL",
      ["49168"] = "General DHCP",
      ["49169"] = "General DNS",
      ["49170"] = "General FTP control",
      ["49171"] = "General FTP data",
      ["49172"] = "General GOPHER",
      ["49173"] = "General H323 control",
      ["49174"] = "General H323 media",
      ["49175"] = "General HTTP",
      ["49176"] = "General HTTP MGMT",
      ["49177"] = "General HTTPS",
      ["49178"] = "General HTTPS MGMT",
      ["49179"] = "General LDAP",
      ["49180"] = "General MSN",
      ["49181"] = "General MSN media",
      ["49182"] = "General NETBIOS",
      ["49183"] = "General NNTP",
      ["49184"] = "General NTP",
      ["49185"] = "General POP3",
      ["49186"] = "General RADIUS",
      ["49187"] = "General RIP",
      ["49188"] = "General RTSP control",
      ["49189"] = "General RTSP media",
      ["49190"] = "General SIP control",
      ["49191"] = "General SIP media",
      ["49192"] = "General SMTP",
      ["49193"] = "General SNMP",
      ["49194"] = "General SNMP Trap",
      ["49195"] = "General SSH",
      ["49196"] = "General SYSLOG",
      ["49197"] = "General Telnet",
      ["49198"] = "General Tftp",
      ["49199"] = "General Tftp data",
      ["49200"] = "General URL",
      ["49201"] = "General TCP",
      ["49202"] = "General UDP",
      ["49203"] = "General ICMP",
      ["49204"] = "General IGMP",
      ["49205"] = "General GRE",
      ["49206"] = "General IPSEC ESP",
      ["49207"] = "General IPSEC AH",
      ["49208"] = "General OSPF",
      ["49209"] = "General PIM SM",
      ["49210"] = "General EIGRP",
      ["49211"] = "General IPCOMP",
      ["49212"] = "General 6to4",
      ["49213"] = "General IPinIP",
      ["49214"] = "General ETHERinIP",
      ["49215"] = "General VRRP",
      ["49216"] = "General L2TP",
      ["49217"] = "General RSVP",
      ["49218"] = "General FiberChannel",
      ["49219"] = "General MPLSinIP",
      ["49220"] = "General LLMNR",
      ["49221"] = "Service HTTP",
      ["49222"] = "Service HTTP Management",
      ["49223"] = "Service HTTPS",
      ["49224"] = "Service HTTPS Management",
      ["49225"] = "Service HTTPS Redirect",
      ["49226"] = "Service RADIUS Accounting",
      ["49227"] = "Service SSO 3rd-Party API",
      ["49228"] = "Service IDENT",
      ["49229"] = "Service IMAP3",
      ["49230"] = "Service IMAP4",
      ["49231"] = "Service ISAKMP",
      ["49232"] = "Service LDAP",
      ["49233"] = "Service LDAP (UDP)",
      ["49234"] = "Service LDAPS",
      ["49235"] = "Service LPR (Unix Printer)",
      ["49236"] = "Service Megaco H.248 TCP",
      ["49237"] = "Service Megaco Text H.248 UDP",
      ["49238"] = "Service Megaco Binary H.248 UDP",
      ["49239"] = "Service MS SQL",
      ["49240"] = "Service NNTP (News)",
      ["49241"] = "Service NTP",
      ["49242"] = "Service POP3 (Retrieve E-Mail)",
      ["49243"] = "Service Terminal Services TCP",
      ["49244"] = "Service Terminal Services UDP",
      ["49245"] = "Service PPTP",
      ["49246"] = "Service SMTP (Send E-Mail)",
      ["49247"] = "Service SNMP",
      ["49248"] = "Service SQL*Net",
      ["49249"] = "Service SSH",
      ["49250"] = "Service Telnet",
      ["49251"] = "Service TFTP",
      ["49252"] = "Service Citrix TCP",
      ["49253"] = "Service Citrix TCP (Session Reliability)",
      ["49254"] = "Service Citrix UDP",
      ["49255"] = "Service IRC (Chat) 194",
      ["49256"] = "Service IRC (Chat) 6666-6670",
      ["49257"] = "Service IRC (Chat) 7000",
      ["49258"] = "Service DNS (Name Service) TCP",
      ["49259"] = "Service DNS (Name Service) UDP",
      ["49260"] = "Service Enhanced TV",
      ["49261"] = "Service ESP (IPSec)",
      ["49262"] = "Service FTP",
      ["49263"] = "Service FTP Data",
      ["49264"] = "Service FTP Control",
      ["49265"] = "Service Gopher",
      ["49266"] = "Service IKE (Key Exchange)",
      ["49267"] = "Service IKE (Traversal)",
      ["49268"] = "Service Lotus Notes",
      ["49269"] = "Service Echo Reply",
      ["49270"] = "Service Destination Unreachable",
      ["49271"] = "Service Source Quench",
      ["49272"] = "Service Redirect",
      ["49273"] = "Service Echo",
      ["49274"] = "Service Router Advertisement",
      ["49275"] = "Service Router Solicitation",
      ["49276"] = "Service Time Exceeded",
      ["49277"] = "Service Ping 0",
      ["49278"] = "Service Ping 8",
      ["49279"] = "Service Kerberos TCP",
      ["49280"] = "Service Kerberos UDP",
      ["49281"] = "Service NetBios NS TCP",
      ["49282"] = "Service NetBios NS UDP",
      ["49283"] = "Service NetBios DGM TCP",
      ["49284"] = "Service NetBios DGM UDP",
      ["49285"] = "Service NetBios SSN TCP",
      ["49286"] = "Service NetBios SSN UDP",
      ["49287"] = "Service SMB",
      ["49288"] = "Service NFS TCP",
      ["49289"] = "Service NFS UDP",
      ["49290"] = "Service Syslog TCP",
      ["49291"] = "Service Syslog UDP",
      ["49292"] = "Service SIP UDP",
      ["49293"] = "Service SIP TCP",
      ["49294"] = "Service H323 Call Signaling",
      ["49295"] = "Service H323 Gatekeeper Discovery",
      ["49296"] = "Service H323 Gatekeeper RAS",
      ["49297"] = "Service MGCP TCP",
      ["49298"] = "Service MGCP UDP",
      ["49299"] = "Service Skinny",
      ["49300"] = "Service T120 (Whiteboard+A43)",
      ["49301"] = "Service PC Anywhere TCP",
      ["49302"] = "Service PC Anywhere UDP",
      ["49303"] = "Service Timbuktu TCP 407",
      ["49304"] = "Service Timbuktu UDP 407",
      ["49305"] = "Service Timbuktu TCP 1417-1420",
      ["49306"] = "Service Timbuktu UDP 1419",
      ["49307"] = "Service RTSP TCP",
      ["49308"] = "Service RTSP UDP",
      ["49309"] = "Service PNA",
      ["49310"] = "Service MMS TCP",
      ["49311"] = "Service MMS UDP",
      ["49312"] = "Service MSN TCP",
      ["49313"] = "Service MSN UDP",
      ["49314"] = "Service Squid",
      ["49315"] = "Service Yahoo Messenger TCP",
      ["49316"] = "Service Yahoo Messenger UDP",
      ["49317"] = "Service VNC 5500",
      ["49318"] = "Service VNC 5800",
      ["49319"] = "Service VNC 5900",
      ["49320"] = "Service Remotely Anywhere",
      ["49321"] = "Service Remotely Possible",
      ["49322"] = "Service Quake",
      ["49323"] = "Service cu-seeme",
      ["49324"] = "Service Edonkey TCP",
      ["49325"] = "Service Edonkey UDP",
      ["49326"] = "Service WinMX TCP 6699",
      ["49327"] = "Service WinMX TCP 7729-7735",
      ["49328"] = "Service WinMX UDP 6257",
      ["49329"] = "Service Kazaa / FastTrack",
      ["49330"] = "Service iMesh",
      ["49331"] = "Service Direct Connect",
      ["49332"] = "Service BearShare",
      ["49333"] = "Service ZebTelnet",
      ["49334"] = "Service Membership Query",
      ["49335"] = "Service V2 Membership Report",
      ["49336"] = "Service Leave Group",
      ["49337"] = "Service V3 Membership Report",
      ["49338"] = "Service GMS HTTPS",
      ["49339"] = "Service Radius",
      ["49340"] = "Service GSCTrace",
      ["49341"] = "Service SSH Management",
      ["49342"] = "Service NT Domain Login Port 1025",
      ["49343"] = "Service DCE EndPoint",
      ["49344"] = "Service External Guest Authentication",
      ["49345"] = "Service ShoreTel Call Control",
      ["49346"] = "Service ShoreTel RTP",
      ["49347"] = "Service ShoreTel IP Phone Control 2427",
      ["49348"] = "Service ShoreTel IP Phone Control 2727",
      ["49349"] = "Service Tivo TCP Beacon",
      ["49350"] = "Service Tivo UDP Beacon",
      ["49351"] = "Service Tivo TCP Data",
      ["49352"] = "Service Tivo TCP Desktop (8101/8102)",
      ["49353"] = "Service Tivo TCP Desktop (8200)",
      ["49354"] = "Service IPcomp",
      ["49355"] = "Service Apple Bonjour",
      ["49356"] = "Service SMTP (Anti-Spam Inbound Port)",
      ["49357"] = "Service SSLVPN",
      ["49358"] = "Service SonicpointN Layer3 Management",
      ["49359"] = "Service SonicWALL Console Proxy",
      ["49360"] = "Service BGP",
      ["49361"] = "Service 6over4",
      ["49362"] = "Service Host Name Server TCP",
      ["49363"] = "Service Host Name Server UDP",
      ["49364"] = "Service NetBios TCP",
      ["49365"] = "Service NetBios UDP",
      ["49366"] = "Service RPC Services",
      ["49367"] = "Service RPC Services (IANA)",
      ["49368"] = "Service DRP",
      ["49369"] = "Service NetFlow / IPFIX",
      ["49370"] = "Service Rip",
      ["49371"] = "Service Destination Unreachable (IPv6)",
      ["49372"] = "Service Packet Too Big",
      ["49373"] = "Service Time Exceeded (IPv6)",
      ["49374"] = "Service Parameter Problem",
      ["49375"] = "Service Echo (IPv6)",
      ["49376"] = "Service Echo Reply (IPv6)",
      ["49377"] = "Service Router Solicitation (IPv6)",
      ["49378"] = "Service Router Advertisement (IPv6)",
      ["49379"] = "Service Neighbor Solicitation",
      ["49380"] = "Service Neighbor Advertisement",
      ["49381"] = "Service Redirect (IPv6)",
      ["49382"] = "Service Ping6 128",
      ["49383"] = "Service Ping6 129",
      ["49384"] = "Service GRE",
      ["49385"] = "Service Comm Dst Host Admin Prohibited",
      ["49386"] = "Service Dst Network Unreachable",
      ["49387"] = "Service Dst Host Unreachable",
      ["49388"] = "Service Communication Admin Prohibited",
      ["49389"] = "Service Redr Datagram for the Host",
      ["49390"] = "Service Redr Datagram for Service and Network",
      ["49391"] = "Service Redr Datagram for Service and Host",
      ["49392"] = "Service Fragment Reassembly Time Exceeded",
      ["49393"] = "Service Parameter Problem(IPv4)",
      ["49394"] = "Service Missing a Required Option",
      ["49395"] = "Service Bad Length",
      ["49396"] = "Service Timestamp",
      ["49397"] = "Service Timestamp Reply",
      ["49398"] = "Service Information Request",
      ["49399"] = "Service Information Reply",
      ["49400"] = "Service Address Mask Request",
      ["49401"] = "Service Address Mask Reply",
      ["49402"] = "Service Traceroute",
      ["49403"] = "Service Datagram Conversion Error",
      ["49404"] = "Service Mobile Host Redirect",
      ["49405"] = "Service Mobile Registration Request",
      ["49406"] = "Service Mobile Registration Reply",
      ["49407"] = "Service Commu Dstination Admin Prohibited",
      ["49408"] = "Service Beyond Scope of Source Address",
      ["49409"] = "Service Address Unreachable",
      ["49410"] = "Service Port Unreachable (IPv6)",
      ["49411"] = "Service Src Address Failed Ingress Egress",
      ["49412"] = "Service Reject Route to Destination",
      ["49413"] = "Service Error in Source Routing Header",
      ["49414"] = "Service Frgm Reassembly Time Exceeded (IPv6)",
      ["49415"] = "Service Unrecg Next Header Type Encount",
      ["49416"] = "Service Unrecg IPv6 Operation Encount",
      ["49417"] = "Service Multicast Listener Query (IPv6)",
      ["49418"] = "Service Multicast Listener Report (IPv6)",
      ["49419"] = "Service Multicast Listener Done (IPv6)",
      ["49420"] = "Service Router Renumbering (IPv6)",
      ["49421"] = "Service Router Renumbering Result (IPv6)",
      ["49422"] = "Service Sequence Number Reset (IPv6)",
      ["49423"] = "Service ICMP Node Information Query (IPv6)",
      ["49424"] = "Service contain empty name (IPv6)",
      ["49425"] = "Service contain IPv4 address (IPv6)",
      ["49426"] = "Service ICMP Node Information Response (IPv6)",
      ["49427"] = "Service Responder refuses (IPv6)",
      ["49428"] = "Service Qtype of the Query is unknown (IPv6)",
      ["49429"] = "Service Inverse Neighbor Discovery Solicitation Message (IPv6)",
      ["49430"] = "Service Inverse Neighbor Discovery Advertisement Message (IPv6)",
      ["49431"] = "Service Version 2 Multicast Listener Report (IPv6)",
      ["49432"] = "Service Home Agent Address Discovery Request Message (IPv6)",
      ["49433"] = "Service Home Agent Address Discovery Reply Message (IPv6)",
      ["49434"] = "Service Mobile Prefix Solicitation (IPv6)",
      ["49435"] = "Service Mobile Prefix Advertisement (IPv6)",
      ["49436"] = "Service Certification Path Solicitation Message (IPv6)",
      ["49437"] = "Service Certification Path Advertisement Msg (IPv6)",
      ["49438"] = "Service ICMP messages utilized (IPv6)",
      ["49439"] = "Service Multicast Router Advertisement (IPv6)",
      ["49440"] = "Service Multicast Router Solicitation (IPv6)",
      ["49441"] = "Service Multicast Router Termination (IPv6)",
      ["49442"] = "Service FMIPv6 Messages (IPv6)",
      ["49443"] = "Service RPL Control Message (IPv6)",
      ["49444"] = "Service Alternative Address for Host",
   }
}

-- ################################################################################

function sonicwall.map_field_value(ifid, field_type, value)
   if type_value_map[field_type] and type_value_map[field_type][value] then
      value = type_value_map[field_type][value]
   end

   if type_map[field_type] then
      field_type = type_map[field_type]
   end

   return field_type, value
end

-- ################################################################################

return sonicwall
