/* [config]
 * expect_result: pass
 * glsl_version: 1.50
 * require_extensions: GL_ARB_gpu_shader_fp64
 * [end config]
 *
 * Check that the following test vectors are constant folded correctly:
 * reflect(dvec2(-0.1lf, -1.2lf), dvec2(-0.08304547985373997lf, -0.9965457582448796lf)) => dvec2(0.09999999999999998lf, 1.1999999999999995lf)
 * reflect(dvec2(-0.1lf, -1.2lf), dvec2(-0.658504607868518lf, 0.7525766947068777lf)) => dvec2(-1.202654867256637lf, 0.06017699115044217lf)
 * reflect(dvec2(-0.42lf, 0.48lf), dvec2(-0.08304547985373997lf, -0.9965457582448796lf)) => dvec2(-0.4936551724137931lf, -0.40386206896551713lf)
 * reflect(dvec2(-0.42lf, 0.48lf), dvec2(-0.658504607868518lf, 0.7525766947068777lf)) => dvec2(0.4199999999999999lf, -0.47999999999999976lf)
 */
#version 150
#extension GL_ARB_gpu_shader_fp64 : require

void main()
{
  double[distance(reflect(dvec2(-0.1lf, -1.2lf), dvec2(-0.08304547985373997lf, -0.9965457582448796lf)), dvec2(0.09999999999999998lf, 1.1999999999999995lf)) <= 1.2041594578792292e-05lf ? 1 : -1] array0;
  double[distance(reflect(dvec2(-0.1lf, -1.2lf), dvec2(-0.658504607868518lf, 0.7525766947068777lf)), dvec2(-1.202654867256637lf, 0.06017699115044217lf)) <= 1.2041594578792296e-05lf ? 1 : -1] array1;
  double[distance(reflect(dvec2(-0.42lf, 0.48lf), dvec2(-0.08304547985373997lf, -0.9965457582448796lf)), dvec2(-0.4936551724137931lf, -0.40386206896551713lf)) <= 6.37808748764079e-06lf ? 1 : -1] array2;
  double[distance(reflect(dvec2(-0.42lf, 0.48lf), dvec2(-0.658504607868518lf, 0.7525766947068777lf)), dvec2(0.4199999999999999lf, -0.47999999999999976lf)) <= 6.378087487640787e-06lf ? 1 : -1] array3;
  gl_Position = vec4(array0.length() + array1.length() + array2.length() + array3.length());
}
