/*
 * Decompiled with CFR 0.152.
 */
package liquibase.util;

import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Enumeration;
import liquibase.Scope;

public class NetUtil {
    private static InetAddress getLocalHost() throws UnknownHostException, SocketException {
        String osName = System.getProperty("os.name");
        if (osName != null && osName.toLowerCase().contains("windows")) {
            return InetAddress.getLocalHost();
        }
        InetAddress loopback = null;
        Enumeration<NetworkInterface> e2 = NetworkInterface.getNetworkInterfaces();
        while (e2.hasMoreElements()) {
            NetworkInterface i2 = e2.nextElement();
            if (!i2.isUp() || i2.isPointToPoint()) continue;
            Enumeration<InetAddress> ie2 = i2.getInetAddresses();
            while (ie2.hasMoreElements()) {
                InetAddress lch = ie2.nextElement();
                if (lch.isLoopbackAddress()) {
                    loopback = lch;
                    continue;
                }
                if (lch.isLinkLocalAddress()) continue;
                return lch;
            }
        }
        return loopback;
    }

    public static String getLocalHostAddress() throws UnknownHostException, SocketException {
        try {
            InetAddress localhost = NetUtil.getLocalHost();
            if (localhost != null) {
                return localhost.getHostAddress();
            }
            Scope.getCurrentScope().getLog(NetUtil.class).fine("Error getting hostname. Unable to determine address for localhost");
            return "unknown";
        }
        catch (Exception e2) {
            Scope.getCurrentScope().getLog(NetUtil.class).fine("Error getting hostname", e2);
            return "unknown";
        }
    }

    public static String getLocalHostName() throws UnknownHostException, SocketException {
        try {
            InetAddress localhost = NetUtil.getLocalHost();
            if (localhost != null) {
                return localhost.getHostName();
            }
            Scope.getCurrentScope().getLog(NetUtil.class).fine("Error getting hostname. Unable to determine address for localhost");
            return "unknown";
        }
        catch (Exception e2) {
            Scope.getCurrentScope().getLog(NetUtil.class).fine("Error getting hostname", e2);
            return "unknown";
        }
    }
}

