/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.geofence;

import java.text.ParseException;
import java.util.ArrayList;
import org.locationtech.spatial4j.context.SpatialContext;
import org.locationtech.spatial4j.context.jts.JtsSpatialContextFactory;
import org.locationtech.spatial4j.shape.ShapeFactory;
import org.locationtech.spatial4j.shape.jts.JtsShapeFactory;
import org.traccar.geofence.GeofenceGeometry;

public class GeofencePolygon
extends GeofenceGeometry {
    private ArrayList<GeofenceGeometry.Coordinate> coordinates;
    private double[] constant;
    private double[] multiple;
    private boolean needNormalize = false;

    public GeofencePolygon() {
    }

    public GeofencePolygon(String wkt) throws ParseException {
        this.fromWkt(wkt);
    }

    private void preCalculate() {
        int i;
        if (this.coordinates == null) {
            return;
        }
        int polyCorners = this.coordinates.size();
        int j = polyCorners - 1;
        if (this.constant != null) {
            this.constant = null;
        }
        if (this.multiple != null) {
            this.multiple = null;
        }
        this.constant = new double[polyCorners];
        this.multiple = new double[polyCorners];
        boolean hasNegative = false;
        boolean hasPositive = false;
        for (i = 0; i < polyCorners; ++i) {
            if (this.coordinates.get(i).getLon() > 90.0) {
                hasPositive = true;
                continue;
            }
            if (!(this.coordinates.get(i).getLon() < -90.0)) continue;
            hasNegative = true;
        }
        this.needNormalize = hasPositive && hasNegative;
        i = 0;
        while (i < polyCorners) {
            if (this.normalizeLon(this.coordinates.get(j).getLon()) == this.normalizeLon(this.coordinates.get(i).getLon())) {
                this.constant[i] = this.coordinates.get(i).getLat();
                this.multiple[i] = 0.0;
            } else {
                this.constant[i] = this.coordinates.get(i).getLat() - this.normalizeLon(this.coordinates.get(i).getLon()) * this.coordinates.get(j).getLat() / (this.normalizeLon(this.coordinates.get(j).getLon()) - this.normalizeLon(this.coordinates.get(i).getLon())) + this.normalizeLon(this.coordinates.get(i).getLon()) * this.coordinates.get(i).getLat() / (this.normalizeLon(this.coordinates.get(j).getLon()) - this.normalizeLon(this.coordinates.get(i).getLon()));
                this.multiple[i] = (this.coordinates.get(j).getLat() - this.coordinates.get(i).getLat()) / (this.normalizeLon(this.coordinates.get(j).getLon()) - this.normalizeLon(this.coordinates.get(i).getLon()));
            }
            j = i++;
        }
    }

    private double normalizeLon(double lon) {
        if (this.needNormalize && lon < -90.0) {
            return lon + 360.0;
        }
        return lon;
    }

    @Override
    public boolean containsPoint(double latitude, double longitude) {
        int polyCorners = this.coordinates.size();
        int j = polyCorners - 1;
        double longitudeNorm = this.normalizeLon(longitude);
        boolean oddNodes = false;
        int i = 0;
        while (i < polyCorners) {
            if (this.normalizeLon(this.coordinates.get(i).getLon()) < longitudeNorm && this.normalizeLon(this.coordinates.get(j).getLon()) >= longitudeNorm || this.normalizeLon(this.coordinates.get(j).getLon()) < longitudeNorm && this.normalizeLon(this.coordinates.get(i).getLon()) >= longitudeNorm) {
                oddNodes ^= longitudeNorm * this.multiple[i] + this.constant[i] < latitude;
            }
            j = i++;
        }
        return oddNodes;
    }

    @Override
    public double calculateArea() {
        JtsShapeFactory jtsShapeFactory = new JtsSpatialContextFactory().newSpatialContext().getShapeFactory();
        ShapeFactory.PolygonBuilder polygonBuilder = jtsShapeFactory.polygon();
        for (GeofenceGeometry.Coordinate coordinate : this.coordinates) {
            polygonBuilder.pointXY(coordinate.getLon(), coordinate.getLat());
        }
        return polygonBuilder.build().getArea(SpatialContext.GEO) * 111.19507973436875 * 111.19507973436875;
    }

    @Override
    public String toWkt() {
        StringBuilder buf = new StringBuilder();
        buf.append("POLYGON ((");
        for (GeofenceGeometry.Coordinate coordinate : this.coordinates) {
            buf.append(coordinate.getLat());
            buf.append(" ");
            buf.append(coordinate.getLon());
            buf.append(", ");
        }
        return buf.substring(0, buf.length() - 2) + "))";
    }

    @Override
    public void fromWkt(String wkt) throws ParseException {
        if (this.coordinates == null) {
            this.coordinates = new ArrayList();
        } else {
            this.coordinates.clear();
        }
        if (!wkt.startsWith("POLYGON")) {
            throw new ParseException("Mismatch geometry type", 0);
        }
        String content = wkt.substring(wkt.indexOf("((") + 2, wkt.indexOf("))"));
        if (content.isEmpty()) {
            throw new ParseException("No content", 0);
        }
        String[] commaTokens = content.split(",");
        if (commaTokens.length < 3) {
            throw new ParseException("Not valid content", 0);
        }
        for (String commaToken : commaTokens) {
            String[] tokens = commaToken.trim().split("\\s");
            if (tokens.length != 2) {
                throw new ParseException("Here must be two coordinates: " + commaToken, 0);
            }
            GeofenceGeometry.Coordinate coordinate = new GeofenceGeometry.Coordinate();
            try {
                coordinate.setLat(Double.parseDouble(tokens[0]));
            }
            catch (NumberFormatException e) {
                throw new ParseException(tokens[0] + " is not a double", 0);
            }
            try {
                coordinate.setLon(Double.parseDouble(tokens[1]));
            }
            catch (NumberFormatException e) {
                throw new ParseException(tokens[1] + " is not a double", 0);
            }
            this.coordinates.add(coordinate);
        }
        this.preCalculate();
    }
}

