/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.protocol;

import io.netty.channel.Channel;
import java.net.SocketAddress;
import java.util.regex.Pattern;
import org.traccar.BaseProtocolDecoder;
import org.traccar.DeviceSession;
import org.traccar.Protocol;
import org.traccar.helper.Parser;
import org.traccar.helper.PatternBuilder;
import org.traccar.helper.UnitsConverter;
import org.traccar.model.Position;

public class SiwiProtocolDecoder
extends BaseProtocolDecoder {
    private static final Pattern PATTERN = new PatternBuilder().text("$").expression("[A-Z]+,").number("(d+),").number("d+,").expression("([A-Z]),").number("d*,").number("[^,]*,").expression("([01]),").expression("[01],").number("d+,").number("[^,]+,").number("(d+),").number("(d+),").number("(d+),").expression("([AV]),").number("(-?d+.d+),").number("(-?d+.d+),").number("(-?d+),").number("(d+),").number("(dd)(dd)(dd),").number("(dd)(dd)(dd),").number("d+,").number("d+,").number("d+,").number("d+,").number("(d+),").number("(d+),").number("(d+),").number("(d+),").number("(d+),").number("(d+),").number("(d+),").expression("([^,]+),").expression("([^,]+),").any().compile();

    public SiwiProtocolDecoder(Protocol protocol) {
        super(protocol);
    }

    @Override
    protected Object decode(Channel channel, SocketAddress remoteAddress, Object msg) throws Exception {
        Parser parser = new Parser(PATTERN, (String)msg);
        if (!parser.matches()) {
            return null;
        }
        DeviceSession deviceSession = this.getDeviceSession(channel, remoteAddress, parser.next());
        if (deviceSession == null) {
            return null;
        }
        Position position = new Position(this.getProtocolName());
        position.setDeviceId(deviceSession.getDeviceId());
        position.set("event", parser.next());
        position.set("ignition", parser.next().equals("1"));
        position.set("odometer", parser.nextInt(0));
        position.setSpeed(UnitsConverter.knotsFromKph(parser.nextInt(0)));
        position.set("sat", parser.nextInt(0));
        position.setValid(parser.next().equals("A"));
        position.setLatitude(parser.nextDouble(0.0));
        position.setLongitude(parser.nextDouble(0.0));
        position.setAltitude(parser.nextDouble(0.0));
        position.setCourse(parser.nextInt(0));
        position.setTime(parser.nextDateTime(Parser.DateTimeFormat.HMS_DMY, "IST"));
        position.set("battery", (double)parser.nextInt().intValue() * 0.001);
        position.set("adc1", (double)parser.nextInt().intValue() * 0.01);
        position.set("input", parser.nextInt());
        for (int i = 1; i <= 4; ++i) {
            int value = parser.nextInt();
            if (value == 0) continue;
            position.set("io" + i, value);
        }
        position.set("versionHw", parser.next());
        position.set("versionFw", parser.next());
        return position;
    }
}

